/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.ScopedArtifact;
import com.android.build.api.dsl.Installation;
import com.android.build.api.variant.ScopedArtifacts;
import com.android.build.gradle.internal.BuildToolsExecutableInput;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.SdkComponentsBuildService;
import com.android.build.gradle.internal.SdkComponentsKt;
import com.android.build.gradle.internal.component.AndroidTestCreationConfig;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.InstrumentedTestCreationConfig;
import com.android.build.gradle.internal.core.dsl.features.AndroidTestOptionsDslInfo;
import com.android.build.gradle.internal.dsl.EmulatorControl;
import com.android.build.gradle.internal.dsl.EmulatorSnapshots;
import com.android.build.gradle.internal.process.GradleProcessExecutor;
import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.tasks.AndroidTestTask;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.Workers;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.test.AbstractTestDataImpl;
import com.android.build.gradle.internal.test.TestsAnalytics;
import com.android.build.gradle.internal.test.report.CompositeTestResults;
import com.android.build.gradle.internal.test.report.ReportType;
import com.android.build.gradle.internal.test.report.TestReport;
import com.android.build.gradle.internal.testing.ConnectedDeviceProvider;
import com.android.build.gradle.internal.testing.StaticTestData;
import com.android.build.gradle.internal.testing.TestData;
import com.android.build.gradle.internal.testing.TestRunner;
import com.android.build.gradle.internal.testing.utp.EmulatorControlConfig;
import com.android.build.gradle.internal.testing.utp.EmulatorControlConfigKt;
import com.android.build.gradle.internal.testing.utp.RetentionConfig;
import com.android.build.gradle.internal.testing.utp.RetentionConfigKt;
import com.android.build.gradle.internal.testing.utp.UtpDependencies;
import com.android.build.gradle.internal.testing.utp.UtpDependencyUtilsKt;
import com.android.build.gradle.internal.testing.utp.UtpTestResultListener;
import com.android.build.gradle.internal.testing.utp.UtpTestRunner;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.IntegerOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.buildanalyzer.common.TaskCategory;
import com.android.builder.core.ComponentType;
import com.android.builder.model.TestOptions;
import com.android.builder.testing.api.DeviceConnector;
import com.android.builder.testing.api.DeviceException;
import com.android.builder.testing.api.DeviceProvider;
import com.android.ide.common.workers.ExecutorServiceAdapter;
import com.android.repository.Revision;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.android.utils.StringHelper;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.options.Option;
import org.gradle.internal.logging.ConsoleRenderer;
import org.gradle.process.ExecOperations;
import org.gradle.work.DisableCachingByDefault;
import org.gradle.workers.WorkerExecutor;

@DisableCachingByDefault
@BuildAnalyzer(primaryTaskCategory=TaskCategory.TEST)
public abstract class DeviceProviderInstrumentTestTask
extends NonIncrementalTask
implements AndroidTestTask {
    private static final Predicate<File> IS_APK = file -> "apk".equals(Files.getFileExtension((String)file.getName()));
    private boolean ignoreFailures;
    private ArtifactCollection dependencies;
    private UtpTestResultListener utpTestResultListener;

    public void setUtpTestResultListener(UtpTestResultListener utpTestResultListener) {
        this.utpTestResultListener = utpTestResultListener;
    }

    @Internal
    public ExecutorServiceAdapter getExecutorServiceAdapter() {
        return Workers.INSTANCE.withThreads(this.getPath(), (AnalyticsService)this.getAnalyticsService().get());
    }

    @Override
    protected void doTaskAction() throws DeviceException, IOException, ExecutionException {
        DeviceProviderInstrumentTestTask.run(this.getDeviceProviderFactory(), this.getBuddyApks().getFiles(), ((Directory)this.getResultsDir().get()).getAsFile(), (Boolean)this.getAdditionalTestOutputEnabled().get(), ((Directory)this.getAdditionalTestOutputDir().get()).getAsFile(), ((Directory)this.getCoverageDirectory().get()).getAsFile(), this.getTestRunnerFactory(), (File)this.getReportsDir().getAsFile().get(), (Boolean)this.getCodeCoverageEnabled().get(), (AnalyticsService)this.getAnalyticsService().get(), this.getIgnoreFailures(), this.getLogger(), (TestData)this.getTestData().get(), this.getTargetSerials(), (String)this.getProjectPath().get(), (List)this.getInstallOptions().getOrElse((Object)ImmutableList.of()), this.testsFound(), this.getWorkerExecutor(), this.getPrivacySandboxSdkApksFiles().getFiles(), this.getExecutorServiceAdapter(), this.utpTestResultListener, this.dependencies);
    }

    static void run(DeviceProviderFactory deviceProviderFactory, Set<File> buddyApkFiles, File resultsOutputDir, Boolean useAdditionalTargetOutputDir, File additionalTestOutputDirFiles, File coverageDir, TestRunnerFactory testRunnerFactory, File reportDir, Boolean enableCoverage, AnalyticsService analyticsService, boolean ignoreFailures, Logger logger, TestData testData, List<String> targetSerials, String projectPath, List<String> installOptions, boolean testsFound, WorkerExecutor workerExecutor, Set<File> privacySandboxSdkApkFiles, ExecutorServiceAdapter executorServiceAdapter, UtpTestResultListener utpTestResultListener, ArtifactCollection dependencies2) throws IOException, ExecutionException, DeviceException {
        boolean success2;
        File additionalTestOutputDir;
        String environmentSerials = targetSerials.isEmpty() ? System.getenv("ANDROID_SERIAL") : null;
        DeviceProvider deviceProvider = deviceProviderFactory.getDeviceProvider(testRunnerFactory.getBuildTools().adbExecutable(), environmentSerials);
        if (!deviceProvider.isConfigured()) {
            return;
        }
        DeviceProviderInstrumentTestTask.checkForNonApks(buddyApkFiles, message2 -> {
            throw new InvalidUserDataException(message2);
        });
        FileUtils.cleanOutputDir((File)resultsOutputDir);
        if (useAdditionalTargetOutputDir.booleanValue()) {
            additionalTestOutputDir = additionalTestOutputDirFiles;
            FileUtils.cleanOutputDir((File)additionalTestOutputDir);
        } else {
            additionalTestOutputDir = null;
        }
        FileUtils.cleanOutputDir((File)coverageDir);
        if (!testsFound) {
            logger.info("No tests found, nothing to do.");
            File emptyCoverageFile = new File(coverageDir, "coverage.ec");
            emptyCoverageFile.createNewFile();
            success2 = true;
        } else {
            TestRunner testRunner = testRunnerFactory.createTestRunner(workerExecutor, executorServiceAdapter, utpTestResultListener);
            success2 = DeviceProviderInstrumentTestTask.runTestsWithTestRunner(testRunner, projectPath, testData.getAsStaticData(), buddyApkFiles, installOptions, resultsOutputDir, additionalTestOutputDir, coverageDir, deviceProvider, analyticsService, logger, useAdditionalTargetOutputDir, enableCoverage, privacySandboxSdkApkFiles, dependencies2, targetSerials, (TestOptions.Execution)testRunnerFactory.getExecutionEnum().get());
        }
        File reportOutDir = reportDir;
        FileUtils.cleanOutputDir((File)reportOutDir);
        TestReport report = new TestReport(ReportType.SINGLE_FLAVOR, resultsOutputDir, reportOutDir);
        CompositeTestResults results = report.generateReport();
        TestsAnalytics.recordOkInstrumentedTestRun(dependencies2, (TestOptions.Execution)testRunnerFactory.getExecutionEnum().get(), (boolean)enableCoverage, results.getTestCount(), analyticsService);
        if (!success2) {
            String reportUrl = new ConsoleRenderer().asClickableFileUrl(new File(reportOutDir, "index.html"));
            String message3 = "There were failing tests. See the report at: " + reportUrl;
            if (ignoreFailures) {
                logger.warn(message3);
            } else {
                throw new GradleException(message3);
            }
        }
    }

    public static Boolean runTestsWithTestRunner(TestRunner testRunner, String projectPath, StaticTestData staticTestData, Set<File> buddyApkFiles, List<String> installOptions, File resultsOutDir, File additionalTestOutputDir, File coverageOutDir, DeviceProvider deviceProvider, AnalyticsService analyticsService, Logger logger, Boolean useAdditionalTargetOutputDir, Boolean enableCoverage, Set<File> privacySandboxSdkApkFiles, ArtifactCollection dependencies2, List<String> targetSerials, TestOptions.Execution execution) throws DeviceException, ExecutionException {
        return (Boolean)deviceProvider.use(() -> {
            try {
                boolean devicesSupportPrivacySandbox = deviceProvider.getDevices().stream().allMatch(DeviceConnector::getSupportsPrivacySandbox);
                return testRunner.runTests(projectPath, staticTestData.getFlavorName(), staticTestData, devicesSupportPrivacySandbox ? privacySandboxSdkApkFiles : Collections.emptySet(), buddyApkFiles, DeviceProviderInstrumentTestTask.getFilteredDevices(deviceProvider, targetSerials), deviceProvider.getTimeoutInMs(), installOptions, resultsOutDir, useAdditionalTargetOutputDir, additionalTestOutputDir, coverageOutDir, new LoggerWrapper(logger));
            }
            catch (Exception e) {
                TestsAnalytics.recordCrashedInstrumentedTestRun(dependencies2, execution, (boolean)enableCoverage, analyticsService);
                throw e;
            }
        });
    }

    public static void checkForNonApks(Collection<File> buddyApksFiles, Consumer<String> errorHandler2) {
        List nonApks = buddyApksFiles.stream().filter(IS_APK.negate()).collect(Collectors.toList());
        if (!nonApks.isEmpty()) {
            Collections.sort(nonApks);
            String message2 = String.format("Not all files in %s configuration are APKs: %s", "androidTestUtil", Joiner.on((char)' ').join(nonApks));
            errorHandler2.accept(message2);
        }
    }

    private static List<? extends DeviceConnector> getFilteredDevices(DeviceProvider deviceProvider, List<String> targetSerials) {
        if (!(deviceProvider instanceof ConnectedDeviceProvider)) {
            boolean validEnvironment;
            String environmentSerials = System.getenv("ANDROID_SERIAL");
            boolean bl = validEnvironment = environmentSerials != null && !environmentSerials.isEmpty();
            if (validEnvironment && !targetSerials.isEmpty()) {
                throw new GradleException("Cannot determine devices to target. For custom device providers either unset the ANDROID_SERIAL environment variable or do remove the --serial command line arguments when running this task");
            }
        }
        List allDevices2 = deviceProvider.getDevices();
        if (targetSerials.isEmpty()) {
            return allDevices2;
        }
        ArrayList targetDevices = Lists.newArrayList();
        for (DeviceConnector device : allDevices2) {
            if (!targetSerials.contains(device.getSerialNumber())) continue;
            targetDevices.add(device);
            targetSerials.remove(device.getSerialNumber());
        }
        if (!targetSerials.isEmpty()) {
            throw new GradleException("Serials specified via command line are not present. Devices have no match for the following serials: " + targetSerials.toString());
        }
        return targetDevices;
    }

    private List<String> getTargetSerials() {
        if (this.getTestRunnerFactory().getDeviceSerialValues().isPresent()) {
            return (List)this.getTestRunnerFactory().getDeviceSerialValues().get();
        }
        return (List)this.getTestRunnerFactory().getConnectedCheckDeviceSerials().getOrElse(Collections.emptyList());
    }

    private boolean testsFound() {
        return (Boolean)((TestData)this.getTestData().get()).hasTests((FileCollection)this.getClasses(), (FileCollection)this.getRClasses(), (FileCollection)this.getBuildConfigClasses()).get();
    }

    @OutputDirectory
    public abstract DirectoryProperty getReportsDir();

    @Override
    @OutputDirectory
    public abstract DirectoryProperty getResultsDir();

    @Optional
    @OutputDirectory
    public abstract DirectoryProperty getAdditionalTestOutputDir();

    @OutputDirectory
    public abstract DirectoryProperty getCoverageDirectory();

    @Input
    public abstract Property<Boolean> getCodeCoverageEnabled();

    @Input
    public abstract Property<Boolean> getAdditionalTestOutputEnabled();

    @Optional
    @Input
    public abstract ListProperty<String> getInstallOptions();

    @Nested
    public abstract Property<TestData> getTestData();

    @Nested
    public abstract TestRunnerFactory getTestRunnerFactory();

    @Nested
    public abstract DeviceProviderFactory getDeviceProviderFactory();

    @Classpath
    @Optional
    public abstract ConfigurableFileCollection getClasses();

    @Classpath
    @Optional
    public abstract ConfigurableFileCollection getBuildConfigClasses();

    @Classpath
    @Optional
    public abstract ConfigurableFileCollection getRClasses();

    @Option(option="serial", description="The serial of the device to test against. This will take precedence over the serials specified in the ANDROID_SERIAL environment variable. In addition, when this argument is specified the test task will fail if it cannot connect to the device. \n\nMultiple devices can be specified by specifying the command multiple times. i.e. myAndroidTestTask --serial deviceSerial1 --serial deviceSerial2")
    public void setSerialOption(List<String> serials) {
        this.getTestRunnerFactory().getDeviceSerialValues().addAll(serials);
    }

    public boolean getIgnoreFailures() {
        return this.ignoreFailures;
    }

    public void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures = ignoreFailures;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract ConfigurableFileCollection getBuddyApks();

    @InputFiles
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @Optional
    public abstract ConfigurableFileCollection getPrivacySandboxSdkApksFiles();

    public static abstract class DeviceProviderFactory {
        private DeviceProvider deviceProvider;

        @Input
        public abstract Property<Integer> getTimeOutInMs();

        public DeviceProvider getDeviceProvider(Provider<RegularFile> adbExecutableProvider2, String environmentSerials) {
            if (this.deviceProvider != null) {
                return this.deviceProvider;
            }
            return new ConnectedDeviceProvider(adbExecutableProvider2, (int)((Integer)this.getTimeOutInMs().get()), (ILogger)LoggerWrapper.getLogger(DeviceProviderInstrumentTestTask.class), environmentSerials);
        }
    }

    public static abstract class TestRunnerFactory {
        @Internal
        public abstract RegularFileProperty getJvmExecutable();

        @Input
        public abstract Property<JavaVersion> getJavaVersion();

        @Internal
        public abstract Property<Boolean> getIsUtpLoggingEnabled();

        @Input
        public abstract Property<Boolean> getUninstallIncompatibleApks();

        @Input
        public abstract Property<TestOptions.Execution> getExecutionEnum();

        @Input
        public abstract Property<EmulatorControlConfig> getEmulatorControlConfig();

        @Input
        public abstract Property<RetentionConfig> getRetentionConfig();

        @Internal
        public abstract Property<SdkComponentsBuildService> getSdkBuildService();

        @Nested
        public abstract UtpDependencies getUtpDependencies();

        @Input
        public abstract Property<Boolean> getTargetIsSplitApk();

        @Input
        public abstract ListProperty<String> getConnectedCheckDeviceSerials();

        @Input
        public abstract ListProperty<String> getDeviceSerialValues();

        @Inject
        public ExecOperations getExecOperations() {
            throw new UnsupportedOperationException("Injected by Gradle.");
        }

        @Nested
        public abstract BuildToolsExecutableInput getBuildTools();

        @Input
        @Optional
        public abstract Property<Integer> getInstallApkTimeout();

        @Input
        @Optional
        public abstract Property<Boolean> getKeepInstalledApks();

        TestRunner createTestRunner(WorkerExecutor workerExecutor, ExecutorServiceAdapter executorServiceAdapter, UtpTestResultListener utpTestResultListener) {
            boolean useOrchestrator = this.getExecutionEnum().get() == TestOptions.Execution.ANDROID_TEST_ORCHESTRATOR || this.getExecutionEnum().get() == TestOptions.Execution.ANDROIDX_TEST_ORCHESTRATOR;
            return new UtpTestRunner((File)this.getBuildTools().splitSelectExecutable().getOrNull(), new GradleProcessExecutor(arg_0 -> ((ExecOperations)this.getExecOperations()).exec(arg_0)), workerExecutor, executorServiceAdapter, ((RegularFile)this.getJvmExecutable().get()).getAsFile(), this.getUtpDependencies(), ((SdkComponentsBuildService)this.getSdkBuildService().get()).sdkLoader((Provider<String>)this.getBuildTools().getCompileSdkVersion(), (Provider<Revision>)this.getBuildTools().getBuildToolsRevision()), (EmulatorControlConfig)this.getEmulatorControlConfig().get(), (RetentionConfig)this.getRetentionConfig().get(), useOrchestrator, (Boolean)this.getUninstallIncompatibleApks().get(), utpTestResultListener, this.utpLoggingLevel(), (Integer)this.getInstallApkTimeout().getOrNull(), (Boolean)this.getTargetIsSplitApk().getOrElse((Object)false), (Boolean)this.getKeepInstalledApks().get() == false);
        }

        private Level utpLoggingLevel() {
            return (Boolean)this.getIsUtpLoggingEnabled().get() != false ? Level.INFO : Level.OFF;
        }
    }

    public static class CreationAction
    extends VariantTaskCreationAction<DeviceProviderInstrumentTestTask, InstrumentedTestCreationConfig> {
        private static final String CONNECTED_DEVICE_PROVIDER = "connected";
        private final String deviceProviderName;
        private final DeviceProvider deviceProvider;
        private final Type type;
        private final AbstractTestDataImpl testData;
        private final Provider<List<String>> connectedCheckTargetSerials;

        public CreationAction(InstrumentedTestCreationConfig creationConfig, AbstractTestDataImpl testData) {
            this(creationConfig, testData, null);
        }

        public CreationAction(InstrumentedTestCreationConfig creationConfig, AbstractTestDataImpl testData, Provider<List<String>> connectedCheckTargetSerials) {
            this(creationConfig, null, CONNECTED_DEVICE_PROVIDER, Type.INTERNAL_CONNECTED_DEVICE_PROVIDER, testData, connectedCheckTargetSerials);
        }

        public CreationAction(InstrumentedTestCreationConfig creationConfig, DeviceProvider deviceProvider, AbstractTestDataImpl testData, Provider<List<String>> connectedCheckTargetSerials) {
            this(creationConfig, deviceProvider, deviceProvider.getName(), Type.CUSTOM_DEVICE_PROVIDER, testData, connectedCheckTargetSerials);
        }

        private CreationAction(InstrumentedTestCreationConfig creationConfig, DeviceProvider deviceProvider, String deviceProviderName, Type type, AbstractTestDataImpl testData, Provider<List<String>> connectedCheckTargetSerials) {
            super(creationConfig);
            this.deviceProvider = deviceProvider;
            this.deviceProviderName = deviceProviderName;
            this.type = type;
            this.testData = testData;
            this.connectedCheckTargetSerials = connectedCheckTargetSerials;
        }

        @Override
        public String getName() {
            return this.computeTaskName(this.deviceProviderName);
        }

        @Override
        public Class<DeviceProviderInstrumentTestTask> getType() {
            return DeviceProviderInstrumentTestTask.class;
        }

        @Override
        public void handleProvider(TaskProvider<DeviceProviderInstrumentTestTask> taskProvider) {
            super.handleProvider(taskProvider);
            boolean isAdditionalAndroidTestOutputEnabled = ((InstrumentedTestCreationConfig)this.creationConfig).getServices().getProjectOptions().get(BooleanOption.ENABLE_ADDITIONAL_ANDROID_TEST_OUTPUT);
            if (this.type == Type.INTERNAL_CONNECTED_DEVICE_PROVIDER) {
                if (isAdditionalAndroidTestOutputEnabled) {
                    ((InstrumentedTestCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, DeviceProviderInstrumentTestTask::getAdditionalTestOutputDir).withName(this.deviceProviderName).on(InternalArtifactType.CONNECTED_ANDROID_TEST_ADDITIONAL_OUTPUT.INSTANCE);
                }
                ((InstrumentedTestCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, DeviceProviderInstrumentTestTask::getCoverageDirectory).withName(this.deviceProviderName).on(InternalArtifactType.CODE_COVERAGE.INSTANCE);
            } else {
                if (isAdditionalAndroidTestOutputEnabled) {
                    ((InstrumentedTestCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, DeviceProviderInstrumentTestTask::getAdditionalTestOutputDir).withName(this.deviceProviderName).on(InternalArtifactType.DEVICE_PROVIDER_ANDROID_TEST_ADDITIONAL_OUTPUT.INSTANCE);
                }
                ((InstrumentedTestCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, DeviceProviderInstrumentTestTask::getCoverageDirectory).withName(this.deviceProviderName).on(InternalArtifactType.DEVICE_PROVIDER_CODE_COVERAGE.INSTANCE);
            }
            if (((InstrumentedTestCreationConfig)this.creationConfig).getComponentType().isForTesting()) {
                if (this.type == Type.INTERNAL_CONNECTED_DEVICE_PROVIDER) {
                    ((InstrumentedTestCreationConfig)this.creationConfig).getTaskContainer().setConnectedTestTask(taskProvider);
                } else {
                    ((InstrumentedTestCreationConfig)this.creationConfig).getTaskContainer().getProviderTestTaskList().add(taskProvider);
                }
            }
        }

        @Override
        public void configure(DeviceProviderInstrumentTestTask task) {
            String variantName;
            super.configure(task);
            Installation installationOptions = ((InstrumentedTestCreationConfig)this.creationConfig).getGlobal().getInstallationOptions();
            AndroidTestOptionsDslInfo testOptions = ((InstrumentedTestCreationConfig)this.creationConfig).getGlobal().getAndroidTestOptions();
            Project project = task.getProject();
            ProjectOptions projectOptions = ((InstrumentedTestCreationConfig)this.creationConfig).getServices().getProjectOptions();
            ComponentCreationConfig testedConfig = null;
            if (this.creationConfig instanceof AndroidTestCreationConfig) {
                testedConfig = ((AndroidTestCreationConfig)this.creationConfig).getMainVariant();
            }
            ComponentType componentType = testedConfig != null ? testedConfig.getComponentType() : ((InstrumentedTestCreationConfig)this.creationConfig).getComponentType();
            String string = variantName = testedConfig != null ? testedConfig.getName() : ((InstrumentedTestCreationConfig)this.creationConfig).getName();
            if (this.type == Type.INTERNAL_CONNECTED_DEVICE_PROVIDER) {
                task.setDescription("Installs and runs the tests for " + variantName + " on connected devices.");
            } else {
                task.setDescription(StringHelper.appendCapitalized((String)("Installs and runs the tests for " + variantName + " using provider: "), (String)this.deviceProviderName));
            }
            task.getAdditionalTestOutputEnabled().set((Object)projectOptions.get(BooleanOption.ENABLE_ADDITIONAL_ANDROID_TEST_OUTPUT));
            task.setGroup("verification");
            task.getTestData().set((Object)this.testData);
            task.getDeviceProviderFactory().getTimeOutInMs().set((Object)installationOptions.getTimeOutInMs());
            if (this.deviceProvider != null) {
                Preconditions.checkState((this.type != Type.INTERNAL_CONNECTED_DEVICE_PROVIDER ? 1 : 0) != 0, (Object)"If using AGP device provider, no device provider should be specified in order to make task compatible with configuration caching (DeviceProvider is not serializable currently).");
                task.getDeviceProviderFactory().deviceProvider = this.deviceProvider;
            }
            task.getInstallOptions().set((Iterable)installationOptions.getInstallOptions());
            task.getTestRunnerFactory().getSdkBuildService().set(BuildServicesKt.getBuildService(((InstrumentedTestCreationConfig)this.creationConfig).getServices().getBuildServiceRegistry(), SdkComponentsBuildService.class));
            SdkComponentsKt.initialize(task.getTestRunnerFactory().getBuildTools(), this.creationConfig);
            task.getTestRunnerFactory().getExecutionEnum().set((Object)((InstrumentedTestCreationConfig)this.creationConfig).getGlobal().getTestOptionExecutionEnum());
            task.getTestRunnerFactory().getJvmExecutable().set(new File(System.getProperty("java.home"), "bin/java"));
            task.getTestRunnerFactory().getJavaVersion().set((Object)JavaVersion.current());
            if (this.connectedCheckTargetSerials != null) {
                task.getTestRunnerFactory().getConnectedCheckDeviceSerials().set(this.connectedCheckTargetSerials);
            }
            if (!projectOptions.get(BooleanOption.ANDROID_TEST_USES_UNIFIED_TEST_PLATFORM)) {
                LoggerWrapper.getLogger(DeviceProviderInstrumentTestTask.class).warning("Implicitly enabling Unified Test Platform because UTP is now the only test runnerPlease remove android.experimental.androidTest.useUnifiedTestPlatform=false from your gradle.properties file.", new Object[0]);
            }
            UtpDependencyUtilsKt.maybeCreateUtpConfigurations(project);
            UtpDependencyUtilsKt.resolveDependencies(task.getTestRunnerFactory().getUtpDependencies(), task.getProject().getConfigurations());
            boolean infoLoggingEnabled = Logging.getLogger(DeviceProviderInstrumentTestTask.class).isInfoEnabled();
            task.getTestRunnerFactory().getIsUtpLoggingEnabled().set((Object)infoLoggingEnabled);
            task.getTestRunnerFactory().getUninstallIncompatibleApks().set((Object)projectOptions.get(BooleanOption.UNINSTALL_INCOMPATIBLE_APKS));
            task.getTestRunnerFactory().getEmulatorControlConfig().set((Object)EmulatorControlConfigKt.createEmulatorControlConfig(projectOptions, (EmulatorControl)testOptions.getEmulatorControl()));
            task.getTestRunnerFactory().getRetentionConfig().set((Object)RetentionConfigKt.createRetentionConfig(projectOptions, (EmulatorSnapshots)testOptions.getEmulatorSnapshots()));
            task.getTestRunnerFactory().getInstallApkTimeout().set(projectOptions.getProvider(IntegerOption.INSTALL_APK_TIMEOUT));
            task.getTestRunnerFactory().getKeepInstalledApks().set(projectOptions.getProvider(BooleanOption.ANDROID_TEST_LEAVE_APKS_INSTALLED_AFTER_RUN));
            task.getTestRunnerFactory().getTargetIsSplitApk().set((Object)(componentType != null && componentType.isDynamicFeature() ? 1 : 0));
            task.getCodeCoverageEnabled().set((Object)((InstrumentedTestCreationConfig)this.creationConfig).isAndroidTestCoverageEnabled());
            boolean useJacocoTransformOutputs = ((InstrumentedTestCreationConfig)this.creationConfig).isAndroidTestCoverageEnabled();
            task.dependencies = ((InstrumentedTestCreationConfig)this.creationConfig).getVariantDependencies().getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.EXTERNAL, useJacocoTransformOutputs ? AndroidArtifacts.ArtifactType.JACOCO_CLASSES_JAR : AndroidArtifacts.ArtifactType.CLASSES_JAR);
            Object flavorFolder = (String)this.testData.getFlavorName().get();
            String buildTarget = "";
            if (!((String)flavorFolder).isEmpty()) {
                buildTarget = variantName.substring(((String)flavorFolder).length()).toLowerCase(Locale.US);
                flavorFolder = "flavors/" + (String)flavorFolder;
            } else {
                buildTarget = variantName;
            }
            String providerFolder = this.type == Type.INTERNAL_CONNECTED_DEVICE_PROVIDER ? CONNECTED_DEVICE_PROVIDER : "device/" + this.deviceProviderName;
            String subFolder = "/" + providerFolder + "/" + buildTarget + "/" + (String)flavorFolder;
            Object rootLocation = testOptions.getResultsDir();
            if (rootLocation == null) {
                rootLocation = project.getBuildDir() + "/outputs/androidTest-results";
            }
            task.getResultsDir().set(new File((String)rootLocation + subFolder));
            rootLocation = testOptions.getReportDir();
            if (rootLocation == null) {
                rootLocation = project.getBuildDir() + "/reports/androidTests";
            }
            task.getReportsDir().set(project.file((Object)((String)rootLocation + subFolder)));
            Configuration androidTestUtil = (Configuration)project.getConfigurations().findByName("androidTestUtil");
            if (androidTestUtil != null) {
                task.getBuddyApks().from(new Object[]{androidTestUtil});
            }
            task.getOutputs().upToDateWhen(it -> false);
            task.getClasses().from(new Object[]{((InstrumentedTestCreationConfig)this.creationConfig).getArtifacts().forScope(ScopedArtifacts.Scope.PROJECT).getFinalArtifacts$gradle_core((ScopedArtifact)ScopedArtifact.CLASSES.INSTANCE)});
            task.getClasses().disallowChanges();
            if (((InstrumentedTestCreationConfig)this.creationConfig).getBuildConfigCreationConfig() != null) {
                task.getBuildConfigClasses().from(new Object[]{((InstrumentedTestCreationConfig)this.creationConfig).getBuildConfigCreationConfig().getCompiledBuildConfig()});
            }
            task.getBuildConfigClasses().disallowChanges();
            if (((InstrumentedTestCreationConfig)this.creationConfig).getAndroidResourcesCreationConfig() != null) {
                task.getRClasses().from(new Object[]{((InstrumentedTestCreationConfig)this.creationConfig).getAndroidResourcesCreationConfig().getCompiledRClasses(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH)});
            }
            task.getRClasses().disallowChanges();
            if (((InstrumentedTestCreationConfig)this.creationConfig).getPrivacySandboxCreationConfig() != null && testedConfig != null) {
                task.getPrivacySandboxSdkApksFiles().setFrom((Iterable)testedConfig.getVariantDependencies().getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.ANDROID_PRIVACY_SANDBOX_SDK_APKS));
            }
            task.getPrivacySandboxSdkApksFiles().disallowChanges();
        }

        public static enum Type {
            INTERNAL_CONNECTED_DEVICE_PROVIDER,
            CUSTOM_DEVICE_PROVIDER;

        }
    }
}

