/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.ScopedArtifact;
import com.android.build.api.dsl.Device;
import com.android.build.api.instrumentation.manageddevice.DeviceTestRunConfigureAction;
import com.android.build.api.instrumentation.manageddevice.DeviceTestRunInput;
import com.android.build.api.instrumentation.manageddevice.DeviceTestRunParameters;
import com.android.build.api.instrumentation.manageddevice.DeviceTestRunTaskAction;
import com.android.build.api.variant.ScopedArtifacts;
import com.android.build.gradle.internal.component.AndroidTestCreationConfig;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.InstrumentedTestCreationConfig;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.component.features.AndroidResourcesCreationConfig;
import com.android.build.gradle.internal.component.features.BuildConfigCreationConfig;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.profile.ProfileAwareWorkAction;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.AndroidTestTask;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.DeviceProviderInstrumentTestTask;
import com.android.build.gradle.internal.tasks.ManagedDeviceTestTask;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.test.AbstractTestDataImpl;
import com.android.build.gradle.internal.test.TestsAnalytics;
import com.android.build.gradle.internal.test.report.CompositeTestResults;
import com.android.build.gradle.internal.test.report.ReportType;
import com.android.build.gradle.internal.test.report.TestReport;
import com.android.build.gradle.internal.testing.StaticTestData;
import com.android.build.gradle.internal.testing.TestData;
import com.android.build.gradle.internal.testing.TestRunData;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.buildanalyzer.common.TaskCategory;
import com.android.builder.model.TestOptions;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.TestLibraries;
import java.io.File;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.logging.ConsoleRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@BuildAnalyzer(primaryTaskCategory=TaskCategory.TEST)
@CacheableTask
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\r\b'\u0018\u00002\u00020\u00012\u00020\u0002:\u0003@ABB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u00105\u001a\u000206H\u0016J\b\u00107\u001a\u00020)H'J\u000e\u00108\u001a\b\u0012\u0004\u0012\u00020-0\u0014H'J\b\u00109\u001a\u00020)H'J\b\u0010:\u001a\u00020-H\u0016J\b\u0010;\u001a\u00020)H'J\b\u0010<\u001a\u00020)H'J\u0010\u0010=\u001a\u0002062\u0006\u0010>\u001a\u00020-H\u0016J\b\u0010?\u001a\u00020-H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R&\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r8G@EX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00148gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0017R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00148gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0017R\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00150\u001f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020#8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0007R\u0014\u0010(\u001a\u00020)8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u000e\u0010,\u001a\u00020-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010.\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u0019000/0\u00148gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u0017R\u001a\u00102\u001a\b\u0012\u0004\u0012\u0002030\u00148gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u0010\u0017\u00a8\u0006C"}, d2={"Lcom/android/build/gradle/internal/tasks/ManagedDeviceTestTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "Lcom/android/build/gradle/internal/tasks/AndroidTestTask;", "()V", "buddyApks", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getBuddyApks", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "buildConfigClasses", "getBuildConfigClasses", "classes", "getClasses", "<set-?>", "Lorg/gradle/api/artifacts/ArtifactCollection;", "dependencies", "getDependencies", "()Lorg/gradle/api/artifacts/ArtifactCollection;", "setDependencies", "(Lorg/gradle/api/artifacts/ArtifactCollection;)V", "deviceDslName", "Lorg/gradle/api/provider/Property;", "", "getDeviceDslName", "()Lorg/gradle/api/provider/Property;", "deviceInput", "Lcom/android/build/api/instrumentation/manageddevice/DeviceTestRunInput;", "getDeviceInput", "executionEnum", "Lcom/android/builder/model/TestOptions$Execution;", "getExecutionEnum", "installOptions", "Lorg/gradle/api/provider/ListProperty;", "getInstallOptions", "()Lorg/gradle/api/provider/ListProperty;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "getObjectFactory", "()Lorg/gradle/api/model/ObjectFactory;", "rClasses", "getRClasses", "setupResult", "Lorg/gradle/api/file/DirectoryProperty;", "getSetupResult", "()Lorg/gradle/api/file/DirectoryProperty;", "shouldIgnore", "", "testAction", "Ljava/lang/Class;", "Lcom/android/build/api/instrumentation/manageddevice/DeviceTestRunTaskAction;", "getTestAction", "testData", "Lcom/android/build/gradle/internal/testing/TestData;", "getTestData", "doTaskAction", "", "getAdditionalTestOutputDir", "getAdditionalTestOutputEnabled", "getCoverageDirectory", "getIgnoreFailures", "getReportsDir", "getResultsDir", "setIgnoreFailures", "ignore", "testsFound", "CreationAction", "ManagedDeviceTestRunnable", "ManagedDeviceTestRunnableParameters", "gradle-core"})
public abstract class ManagedDeviceTestTask
extends NonIncrementalTask
implements AndroidTestTask {
    private boolean shouldIgnore;
    protected ArtifactCollection dependencies;

    @Inject
    @NotNull
    public abstract ObjectFactory getObjectFactory();

    @Input
    @NotNull
    public abstract Property<Class<? extends DeviceTestRunTaskAction<? extends DeviceTestRunInput>>> getTestAction();

    @Nested
    @NotNull
    public abstract Property<DeviceTestRunInput> getDeviceInput();

    @Nested
    @NotNull
    public abstract Property<TestData> getTestData();

    @Input
    @NotNull
    public abstract Property<String> getDeviceDslName();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @Optional
    @NotNull
    public abstract DirectoryProperty getSetupResult();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract ConfigurableFileCollection getBuddyApks();

    @Internal
    @VisibleForTesting
    @NotNull
    public final ArtifactCollection getDependencies() {
        ArtifactCollection artifactCollection = this.dependencies;
        if (artifactCollection != null) {
            return artifactCollection;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"dependencies");
        return null;
    }

    @VisibleForTesting
    protected final void setDependencies(@NotNull ArtifactCollection artifactCollection) {
        Intrinsics.checkNotNullParameter((Object)artifactCollection, (String)"<set-?>");
        this.dependencies = artifactCollection;
    }

    @Classpath
    @Optional
    @NotNull
    public abstract ConfigurableFileCollection getClasses();

    @Classpath
    @Optional
    @NotNull
    public abstract ConfigurableFileCollection getBuildConfigClasses();

    @Classpath
    @Optional
    @NotNull
    public abstract ConfigurableFileCollection getRClasses();

    public boolean getIgnoreFailures() {
        return this.shouldIgnore;
    }

    public void setIgnoreFailures(boolean ignore) {
        this.shouldIgnore = ignore;
    }

    @Override
    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getResultsDir();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getReportsDir();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getCoverageDirectory();

    @Input
    @NotNull
    public abstract Property<Boolean> getAdditionalTestOutputEnabled();

    @Optional
    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getAdditionalTestOutputDir();

    @Optional
    @Input
    @NotNull
    public abstract ListProperty<String> getInstallOptions();

    @Input
    @NotNull
    public abstract Property<TestOptions.Execution> getExecutionEnum();

    @Override
    public void doTaskAction() {
        Directory directory2;
        DeviceProviderInstrumentTestTask.checkForNonApks(this.getBuddyApks().getFiles(), doTaskAction.1.INSTANCE);
        FileUtils.cleanOutputDir((File)((Directory)this.getResultsDir().get()).getAsFile());
        FileUtils.cleanOutputDir((File)((Directory)this.getCoverageDirectory().get()).getAsFile());
        Object object = this.getAdditionalTestOutputEnabled().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getAdditionalTestOutputEnabled().get()");
        if (((Boolean)object).booleanValue()) {
            Object object2 = this.getAdditionalTestOutputDir().get();
            Directory it = (Directory)object2;
            boolean bl = false;
            FileUtils.cleanOutputDir((File)it.getAsFile());
            directory2 = (Directory)object2;
        } else {
            directory2 = null;
        }
        Directory additionalTestOutputDir = directory2;
        this.getWorkerExecutor().noIsolation().submit(ManagedDeviceTestRunnable.class, new Action(this, additionalTestOutputDir){
            final /* synthetic */ ManagedDeviceTestTask this$0;
            final /* synthetic */ Directory $additionalTestOutputDir;
            {
                this.this$0 = $receiver;
                this.$additionalTestOutputDir = $additionalTestOutputDir;
            }

            public final void execute(ManagedDeviceTestRunnableParameters params) {
                Object object = this.this$0.getObjectFactory().newInstance((Class)this.this$0.getTestAction().get(), new Object[0]);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.android.build.api.instrumentation.manageddevice.DeviceTestRunTaskAction<com.android.build.api.instrumentation.manageddevice.DeviceTestRunInput>");
                DeviceTestRunTaskAction testRunTaskAction = (DeviceTestRunTaskAction)object;
                Provider provider2 = (Provider)this.this$0.getProjectPath();
                String string = this.this$0.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path");
                params.initializeWith((Provider<String>)provider2, string, (Provider<AnalyticsService>)((Provider)this.this$0.getAnalyticsService()));
                HasConfigurableValuesKt.setDisallowChanges(params.getTestsFound(), ManagedDeviceTestTask.access$testsFound(this.this$0));
                HasConfigurableValuesKt.setDisallowChanges(params.getDeviceInput(), (Provider)this.this$0.getDeviceInput());
                HasConfigurableValuesKt.setDisallowChanges((Property)params.getSetupResult(), (Provider)this.this$0.getSetupResult());
                HasConfigurableValuesKt.setDisallowChanges(params.getTestData(), ((TestData)this.this$0.getTestData().get()).getAsStaticData());
                HasConfigurableValuesKt.setDisallowChanges(params.getTestRunAction(), testRunTaskAction);
                HasConfigurableValuesKt.setDisallowChanges(params.getPath(), this.this$0.getPath());
                HasConfigurableValuesKt.setDisallowChanges(params.getFlavorName(), ((TestData)this.this$0.getTestData().get()).getFlavorName());
                HasConfigurableValuesKt.setDisallowChanges(params.getDeviceDslName(), (Provider)this.this$0.getDeviceDslName());
                HasConfigurableValuesKt.setDisallowChanges((Property)params.getResultsOutDir(), (Provider)this.this$0.getResultsDir());
                HasConfigurableValuesKt.setDisallowChanges((Property)params.getCodeCoverageOutDir(), (Provider)this.this$0.getCoverageDirectory());
                HasConfigurableValuesKt.setDisallowChanges((Property)params.getAdditionalTestOutputDir(), this.$additionalTestOutputDir);
                HasConfigurableValuesKt.setDisallowChanges((Property)params.getReportsDir(), (Provider)this.this$0.getReportsDir());
                HasConfigurableValuesKt.setDisallowChanges(params.getInstallOptions(), (Provider)this.this$0.getInstallOptions());
                params.getBuddyApks().setFrom((Iterable)this.this$0.getBuddyApks());
                HasConfigurableValuesKt.setDisallowChanges(params.getTestLibraries(), TestsAnalytics.gatherTestLibraries(this.this$0.getDependencies()));
                HasConfigurableValuesKt.setDisallowChanges(params.getIgnoreFailures(), this.this$0.getIgnoreFailures());
                HasConfigurableValuesKt.setDisallowChanges(params.getExecutionEnum(), (Provider)this.this$0.getExecutionEnum());
            }
        });
    }

    private final boolean testsFound() {
        Object object = ((TestData)this.getTestData().get()).hasTests((FileCollection)this.getClasses(), (FileCollection)this.getRClasses(), (FileCollection)this.getBuildConfigClasses()).get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"testData\n            .ge\u2026asses)\n            .get()");
        return (Boolean)object;
    }

    public static final /* synthetic */ boolean access$testsFound(ManagedDeviceTestTask $this) {
        return $this.testsFound();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003B\u0085\u0001\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u0012\u0018\u0010\b\u001a\u0014\u0012\u0010\b\u0001\u0012\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\n0\t\u0012\u0012\u0010\u000b\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\f0\t\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u0012\u0006\u0010\u0012\u001a\u00020\u0010\u0012\u0006\u0010\u0013\u001a\u00020\u0010\u0012\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0015\u0012\b\b\u0002\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0004H\u0016J\u0016\u0010$\u001a\u00020\"2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00040&H\u0016R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0010\b\u0001\u0012\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00040\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006'"}, d2={"Lcom/android/build/gradle/internal/tasks/ManagedDeviceTestTask$CreationAction;", "DeviceT", "Lcom/android/build/api/dsl/Device;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/ManagedDeviceTestTask;", "Lcom/android/build/gradle/internal/component/InstrumentedTestCreationConfig;", "creationConfig", "device", "testRunConfigAction", "Ljava/lang/Class;", "Lcom/android/build/api/instrumentation/manageddevice/DeviceTestRunConfigureAction;", "testRunTaskAction", "Lcom/android/build/api/instrumentation/manageddevice/DeviceTestRunTaskAction;", "testData", "Lcom/android/build/gradle/internal/test/AbstractTestDataImpl;", "testResultOutputDir", "Ljava/io/File;", "testReportOutputDir", "additionalTestOutputDir", "coverageOutputDir", "setupResultDir", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "nameSuffix", "", "(Lcom/android/build/gradle/internal/component/InstrumentedTestCreationConfig;Lcom/android/build/api/dsl/Device;Ljava/lang/Class;Ljava/lang/Class;Lcom/android/build/gradle/internal/test/AbstractTestDataImpl;Ljava/io/File;Ljava/io/File;Ljava/io/File;Ljava/io/File;Lorg/gradle/api/provider/Provider;Ljava/lang/String;)V", "Lcom/android/build/api/dsl/Device;", "name", "getName", "()Ljava/lang/String;", "type", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction<DeviceT extends Device>
    extends VariantTaskCreationAction<ManagedDeviceTestTask, InstrumentedTestCreationConfig> {
        @NotNull
        private final DeviceT device;
        @NotNull
        private final Class<? extends DeviceTestRunConfigureAction<DeviceT, ?>> testRunConfigAction;
        @NotNull
        private final Class<? extends DeviceTestRunTaskAction<?>> testRunTaskAction;
        @NotNull
        private final AbstractTestDataImpl testData;
        @NotNull
        private final File testResultOutputDir;
        @NotNull
        private final File testReportOutputDir;
        @NotNull
        private final File additionalTestOutputDir;
        @NotNull
        private final File coverageOutputDir;
        @Nullable
        private final Provider<Directory> setupResultDir;
        @NotNull
        private final String name;
        @NotNull
        private final Class<ManagedDeviceTestTask> type;

        public CreationAction(@NotNull InstrumentedTestCreationConfig creationConfig, @NotNull DeviceT device, @NotNull Class<? extends DeviceTestRunConfigureAction<DeviceT, ?>> testRunConfigAction, @NotNull Class<? extends DeviceTestRunTaskAction<?>> testRunTaskAction, @NotNull AbstractTestDataImpl testData, @NotNull File testResultOutputDir, @NotNull File testReportOutputDir, @NotNull File additionalTestOutputDir, @NotNull File coverageOutputDir, @Nullable Provider<Directory> setupResultDir, @NotNull String nameSuffix) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            Intrinsics.checkNotNullParameter(device, (String)"device");
            Intrinsics.checkNotNullParameter(testRunConfigAction, (String)"testRunConfigAction");
            Intrinsics.checkNotNullParameter(testRunTaskAction, (String)"testRunTaskAction");
            Intrinsics.checkNotNullParameter((Object)testData, (String)"testData");
            Intrinsics.checkNotNullParameter((Object)testResultOutputDir, (String)"testResultOutputDir");
            Intrinsics.checkNotNullParameter((Object)testReportOutputDir, (String)"testReportOutputDir");
            Intrinsics.checkNotNullParameter((Object)additionalTestOutputDir, (String)"additionalTestOutputDir");
            Intrinsics.checkNotNullParameter((Object)coverageOutputDir, (String)"coverageOutputDir");
            Intrinsics.checkNotNullParameter((Object)nameSuffix, (String)"nameSuffix");
            super((ComponentCreationConfig)creationConfig);
            this.device = device;
            this.testRunConfigAction = testRunConfigAction;
            this.testRunTaskAction = testRunTaskAction;
            this.testData = testData;
            this.testResultOutputDir = testResultOutputDir;
            this.testReportOutputDir = testReportOutputDir;
            this.additionalTestOutputDir = additionalTestOutputDir;
            this.coverageOutputDir = coverageOutputDir;
            this.setupResultDir = setupResultDir;
            this.name = this.computeTaskName(this.device.getName(), nameSuffix);
            this.type = ManagedDeviceTestTask.class;
        }

        public /* synthetic */ CreationAction(InstrumentedTestCreationConfig instrumentedTestCreationConfig, Device device, Class clazz, Class clazz2, AbstractTestDataImpl abstractTestDataImpl, File file, File file2, File file3, File file4, Provider provider2, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x400) != 0) {
                string = "";
            }
            this(instrumentedTestCreationConfig, device, clazz, clazz2, abstractTestDataImpl, file, file2, file3, file4, (Provider<Directory>)provider2, string);
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public Class<ManagedDeviceTestTask> getType() {
            return this.type;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<ManagedDeviceTestTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            ((InstrumentedTestCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, handleProvider.1.INSTANCE).atLocation(this.coverageOutputDir.getAbsolutePath()).on(InternalArtifactType.MANAGED_DEVICE_CODE_COVERAGE.INSTANCE);
            boolean isAdditionalAndroidTestOutputEnabled = ((InstrumentedTestCreationConfig)this.creationConfig).getServices().getProjectOptions().get(BooleanOption.ENABLE_ADDITIONAL_ANDROID_TEST_OUTPUT);
            if (isAdditionalAndroidTestOutputEnabled) {
                ((InstrumentedTestCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, handleProvider.2.INSTANCE).atLocation(this.additionalTestOutputDir.getAbsolutePath()).on(InternalArtifactType.MANAGED_DEVICE_ANDROID_TEST_ADDITIONAL_OUTPUT.INSTANCE);
            }
        }

        @Override
        public void configure(@NotNull ManagedDeviceTestTask task) {
            Object[] objectArray;
            Object it;
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            ProjectOptions projectOptions = ((InstrumentedTestCreationConfig)this.creationConfig).getServices().getProjectOptions();
            Object[] objectArray2 = this.creationConfig;
            AndroidTestCreationConfig androidTestCreationConfig = objectArray2 instanceof AndroidTestCreationConfig ? (AndroidTestCreationConfig)objectArray2 : null;
            VariantCreationConfig testedConfig = androidTestCreationConfig != null ? androidTestCreationConfig.getMainVariant() : null;
            Object object = testedConfig;
            if (object == null || (object = object.getName()) == null) {
                object = ((InstrumentedTestCreationConfig)this.creationConfig).getName();
            }
            Object variantName = object;
            task.setDescription("Installs and runs the test for " + (String)variantName + "  on the managed device " + this.device.getName());
            task.setGroup("verification");
            HasConfigurableValuesKt.setDisallowChanges(task.getTestAction(), this.testRunTaskAction);
            HasConfigurableValuesKt.setDisallowChanges(task.getDeviceInput(), ((DeviceTestRunConfigureAction)task.getObjectFactory().newInstance(this.testRunConfigAction, new Object[0])).configureTaskInput(this.device));
            HasConfigurableValuesKt.setDisallowChanges(task.getTestData(), this.testData);
            HasConfigurableValuesKt.setDisallowChanges(task.getDeviceDslName(), this.device.getName());
            if (this.setupResultDir != null) {
                HasConfigurableValuesKt.setDisallowChanges((Property)task.getSetupResult(), this.setupResultDir);
            }
            task.setDependencies(VariantDependencies.getArtifactCollection$default(((InstrumentedTestCreationConfig)this.creationConfig).getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.EXTERNAL, AndroidArtifacts.ArtifactType.CLASSES_JAR, null, 8, null));
            task.getAdditionalTestOutputEnabled().set((Object)projectOptions.get(BooleanOption.ENABLE_ADDITIONAL_ANDROID_TEST_OUTPUT));
            task.getResultsDir().set(this.testResultOutputDir);
            task.getResultsDir().disallowChanges();
            task.getReportsDir().set(this.testReportOutputDir);
            task.getReportsDir().disallowChanges();
            Configuration configuration = (Configuration)task.getProject().getConfigurations().findByName("androidTestUtil");
            if (configuration != null) {
                it = configuration;
                boolean bl = false;
                objectArray = new Object[]{it};
                task.getBuddyApks().from(objectArray);
            }
            objectArray2 = new Object[]{((InstrumentedTestCreationConfig)this.creationConfig).getArtifacts().forScope(ScopedArtifacts.Scope.PROJECT).getFinalArtifacts$gradle_core((ScopedArtifact)ScopedArtifact.CLASSES.INSTANCE)};
            task.getClasses().from(objectArray2);
            task.getClasses().disallowChanges();
            BuildConfigCreationConfig buildConfigCreationConfig2 = ((InstrumentedTestCreationConfig)this.creationConfig).getBuildConfigCreationConfig();
            if (buildConfigCreationConfig2 != null) {
                it = buildConfigCreationConfig2;
                boolean bl = false;
                objectArray = new Object[]{it.getCompiledBuildConfig()};
                task.getBuildConfigClasses().from(objectArray);
            }
            task.getBuildConfigClasses().disallowChanges();
            AndroidResourcesCreationConfig androidResourcesCreationConfig2 = ((InstrumentedTestCreationConfig)this.creationConfig).getAndroidResourcesCreationConfig();
            if (androidResourcesCreationConfig2 != null) {
                it = androidResourcesCreationConfig2;
                boolean bl = false;
                objectArray = new Object[]{it.getCompiledRClasses(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH)};
                task.getRClasses().from(objectArray);
            }
            task.getRClasses().disallowChanges();
            HasConfigurableValuesKt.setDisallowChanges(task.getExecutionEnum(), ((InstrumentedTestCreationConfig)this.creationConfig).getGlobal().getTestOptionExecutionEnum());
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/android/build/gradle/internal/tasks/ManagedDeviceTestTask$ManagedDeviceTestRunnable;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction;", "Lcom/android/build/gradle/internal/tasks/ManagedDeviceTestTask$ManagedDeviceTestRunnableParameters;", "()V", "logger", "Lorg/gradle/api/logging/Logger;", "getLogger", "()Lorg/gradle/api/logging/Logger;", "run", "", "gradle-core"})
    public static abstract class ManagedDeviceTestRunnable
    extends ProfileAwareWorkAction<ManagedDeviceTestRunnableParameters> {
        @NotNull
        private final Logger logger;

        public ManagedDeviceTestRunnable() {
            Logger logger = Logging.getLogger((String)"ManagedDeviceTestRunnable");
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(\"ManagedDeviceTestRunnable\")");
            this.logger = logger;
        }

        @NotNull
        public final Logger getLogger() {
            return this.logger;
        }

        @Override
        public void run() {
            boolean bl;
            if (!((Boolean)((ManagedDeviceTestRunnableParameters)this.getParameters()).getTestsFound().get()).booleanValue()) {
                this.logger.info("No tests found, nothing to do.");
                bl = true;
            } else {
                boolean testRunParams22;
                try {
                    DeviceTestRunParameters<DeviceTestRunInput> testRunParams22 = new DeviceTestRunParameters<DeviceTestRunInput>(this){
                        private final DeviceTestRunInput deviceInput;
                        @NotNull
                        private final DirectoryProperty setupResult;
                        @NotNull
                        private final TestRunData testRunData;
                        {
                            this.deviceInput = (DeviceTestRunInput)((ManagedDeviceTestRunnableParameters)$receiver.getParameters()).getDeviceInput().get();
                            this.setupResult = ((ManagedDeviceTestRunnableParameters)$receiver.getParameters()).getSetupResult();
                            Object object = ((ManagedDeviceTestRunnableParameters)$receiver.getParameters()).getFlavorName().get();
                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.flavorName.get()");
                            String string = (String)object;
                            Object object2 = ((ManagedDeviceTestRunnableParameters)$receiver.getParameters()).getPath().get();
                            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"parameters.path.get()");
                            String string2 = (String)object2;
                            Object object3 = ((ManagedDeviceTestRunnableParameters)$receiver.getParameters()).getDeviceDslName().get();
                            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"parameters.deviceDslName.get()");
                            String string3 = (String)object3;
                            Object object4 = ((ManagedDeviceTestRunnableParameters)$receiver.getParameters()).getResultsOutDir().get();
                            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"parameters.resultsOutDir.get()");
                            Directory directory2 = (Directory)object4;
                            Object object5 = ((ManagedDeviceTestRunnableParameters)$receiver.getParameters()).getCodeCoverageOutDir().get();
                            Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"parameters.codeCoverageOutDir.get()");
                            Directory directory3 = (Directory)object5;
                            Directory directory4 = (Directory)((ManagedDeviceTestRunnableParameters)$receiver.getParameters()).getAdditionalTestOutputDir().get();
                            Object object6 = ((ManagedDeviceTestRunnableParameters)$receiver.getParameters()).getInstallOptions().getOrElse((Object)CollectionsKt.emptyList());
                            Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"parameters.installOptions.getOrElse(listOf())");
                            List list = (List)object6;
                            Set set = ((ManagedDeviceTestRunnableParameters)$receiver.getParameters()).getBuddyApks().getFiles();
                            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"parameters.buddyApks.files");
                            Object object7 = ((ManagedDeviceTestRunnableParameters)$receiver.getParameters()).getProjectPath().get();
                            Intrinsics.checkNotNullExpressionValue((Object)object7, (String)"parameters.projectPath.get()");
                            String string4 = (String)object7;
                            Object object8 = ((ManagedDeviceTestRunnableParameters)$receiver.getParameters()).getTestData().get();
                            Intrinsics.checkNotNullExpressionValue((Object)object8, (String)"parameters.testData.get()");
                            this.testRunData = new TestRunData(string, string2, string3, directory2, directory3, directory4, list, set, string4, (StaticTestData)object8);
                        }

                        public DeviceTestRunInput getDeviceInput() {
                            return this.deviceInput;
                        }

                        @NotNull
                        public DirectoryProperty getSetupResult() {
                            return this.setupResult;
                        }

                        @NotNull
                        public TestRunData getTestRunData() {
                            return this.testRunData;
                        }
                    };
                    testRunParams22 = ((DeviceTestRunTaskAction)((ManagedDeviceTestRunnableParameters)this.getParameters()).getTestRunAction().get()).runTests((DeviceTestRunParameters)testRunParams22);
                }
                catch (Exception e) {
                    Object object = ((ManagedDeviceTestRunnableParameters)this.getParameters()).getTestLibraries().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.testLibraries.get()");
                    TestLibraries testLibraries = (TestLibraries)object;
                    Object object2 = ((ManagedDeviceTestRunnableParameters)this.getParameters()).getExecutionEnum().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"parameters.executionEnum.get()");
                    TestOptions.Execution execution = (TestOptions.Execution)object2;
                    Object object3 = ((ManagedDeviceTestRunnableParameters)this.getParameters()).getAnalyticsService().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"parameters.analyticsService.get()");
                    TestsAnalytics.recordCrashedInstrumentedTestRun(testLibraries, execution, false, (AnalyticsService)object3);
                    throw e;
                }
                bl = testRunParams22;
            }
            boolean success2 = bl;
            File reportOutDir = ((Directory)((ManagedDeviceTestRunnableParameters)this.getParameters()).getReportsDir().get()).getAsFile();
            FileUtils.cleanOutputDir((File)reportOutDir);
            TestReport report = new TestReport(ReportType.SINGLE_FLAVOR, ((Directory)((ManagedDeviceTestRunnableParameters)this.getParameters()).getResultsOutDir().get()).getAsFile(), reportOutDir);
            CompositeTestResults results = report.generateReport();
            Object object = ((ManagedDeviceTestRunnableParameters)this.getParameters()).getTestLibraries().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.testLibraries.get()");
            TestLibraries testLibraries = (TestLibraries)object;
            Object object4 = ((ManagedDeviceTestRunnableParameters)this.getParameters()).getExecutionEnum().get();
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"parameters.executionEnum.get()");
            TestOptions.Execution execution = (TestOptions.Execution)object4;
            int n = results.getTestCount();
            Object object5 = ((ManagedDeviceTestRunnableParameters)this.getParameters()).getAnalyticsService().get();
            Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"parameters.analyticsService.get()");
            TestsAnalytics.recordOkInstrumentedTestRun(testLibraries, execution, false, n, (AnalyticsService)object5);
            if (!success2) {
                String reportUrl = new ConsoleRenderer().asClickableFileUrl(new File(reportOutDir, "index.html"));
                String message2 = StringsKt.trimIndent((String)("\n                    There were failing tests for Device: " + ((ManagedDeviceTestRunnableParameters)this.getParameters()).getDeviceDslName().get() + ".\n                    See the report at: " + reportUrl + "\n                    "));
                Object object6 = ((ManagedDeviceTestRunnableParameters)this.getParameters()).getIgnoreFailures().get();
                Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"parameters.ignoreFailures.get()");
                if (((Boolean)object6).booleanValue()) {
                    this.logger.warn(message2);
                    return;
                }
                throw new GradleException(message2);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0011R\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0011R\u0018\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0011R\u0018\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0011R\u0018\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0018\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0011R\u0012\u0010#\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0006R\u0012\u0010%\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0006R\u0012\u0010'\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0006R\u0018\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0011R\u0018\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u0011R\u001e\u0010/\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u0013000\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u0011R\u0018\u00102\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u0011\u00a8\u00064"}, d2={"Lcom/android/build/gradle/internal/tasks/ManagedDeviceTestTask$ManagedDeviceTestRunnableParameters;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction$Parameters;", "()V", "additionalTestOutputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getAdditionalTestOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "buddyApks", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getBuddyApks", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "codeCoverageOutDir", "getCodeCoverageOutDir", "deviceDslName", "Lorg/gradle/api/provider/Property;", "", "getDeviceDslName", "()Lorg/gradle/api/provider/Property;", "deviceInput", "Lcom/android/build/api/instrumentation/manageddevice/DeviceTestRunInput;", "getDeviceInput", "executionEnum", "Lcom/android/builder/model/TestOptions$Execution;", "getExecutionEnum", "flavorName", "getFlavorName", "ignoreFailures", "", "getIgnoreFailures", "installOptions", "Lorg/gradle/api/provider/ListProperty;", "getInstallOptions", "()Lorg/gradle/api/provider/ListProperty;", "path", "getPath", "reportsDir", "getReportsDir", "resultsOutDir", "getResultsOutDir", "setupResult", "getSetupResult", "testData", "Lcom/android/build/gradle/internal/testing/StaticTestData;", "getTestData", "testLibraries", "Lcom/google/wireless/android/sdk/stats/TestLibraries;", "getTestLibraries", "testRunAction", "Lcom/android/build/api/instrumentation/manageddevice/DeviceTestRunTaskAction;", "getTestRunAction", "testsFound", "getTestsFound", "gradle-core"})
    public static abstract class ManagedDeviceTestRunnableParameters
    extends ProfileAwareWorkAction.Parameters {
        @NotNull
        public abstract Property<Boolean> getTestsFound();

        @NotNull
        public abstract Property<DeviceTestRunInput> getDeviceInput();

        @NotNull
        public abstract DirectoryProperty getSetupResult();

        @NotNull
        public abstract Property<StaticTestData> getTestData();

        @NotNull
        public abstract Property<DeviceTestRunTaskAction<DeviceTestRunInput>> getTestRunAction();

        @NotNull
        public abstract Property<String> getPath();

        @NotNull
        public abstract Property<String> getFlavorName();

        @NotNull
        public abstract Property<String> getDeviceDslName();

        @NotNull
        public abstract DirectoryProperty getResultsOutDir();

        @NotNull
        public abstract DirectoryProperty getCodeCoverageOutDir();

        @NotNull
        public abstract DirectoryProperty getAdditionalTestOutputDir();

        @NotNull
        public abstract DirectoryProperty getReportsDir();

        @NotNull
        public abstract ListProperty<String> getInstallOptions();

        @NotNull
        public abstract ConfigurableFileCollection getBuddyApks();

        @NotNull
        public abstract Property<TestLibraries> getTestLibraries();

        @NotNull
        public abstract Property<Boolean> getIgnoreFailures();

        @NotNull
        public abstract Property<TestOptions.Execution> getExecutionEnum();
    }
}

