/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.internal.ConfigurationDependencies;
import com.android.build.gradle.internal.dependency.ConfigurationDependencyGraphs;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.ide.ArtifactMetaDataImpl;
import com.android.build.gradle.internal.ide.JavaArtifactImpl;
import com.android.build.gradle.internal.variant.DefaultSourceProviderContainer;
import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.ArtifactMetaData;
import com.android.builder.model.JavaArtifact;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.SourceProviderContainer;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.gradle.api.artifacts.Configuration;

public class ExtraModelInfo {
    private final Map<String, ArtifactMetaData> extraArtifactMap = Maps.newHashMap();
    private final ListMultimap<String, AndroidArtifact> extraAndroidArtifacts = ArrayListMultimap.create();
    private final ListMultimap<String, JavaArtifact> extraJavaArtifacts = ArrayListMultimap.create();
    private final ListMultimap<String, SourceProviderContainer> extraBuildTypeSourceProviders = ArrayListMultimap.create();
    private final ListMultimap<String, SourceProviderContainer> extraProductFlavorSourceProviders = ArrayListMultimap.create();
    private final ListMultimap<String, SourceProviderContainer> extraMultiFlavorSourceProviders = ArrayListMultimap.create();

    public Collection<ArtifactMetaData> getExtraArtifacts() {
        return this.extraArtifactMap.values();
    }

    public Collection<AndroidArtifact> getExtraAndroidArtifacts(String variantName) {
        return this.extraAndroidArtifacts.get((Object)variantName);
    }

    public Collection<JavaArtifact> getExtraJavaArtifacts(String variantName) {
        return this.extraJavaArtifacts.get((Object)variantName);
    }

    public Collection<SourceProviderContainer> getExtraFlavorSourceProviders(String flavorName2) {
        return this.extraProductFlavorSourceProviders.get((Object)flavorName2);
    }

    public Collection<SourceProviderContainer> getExtraBuildTypeSourceProviders(String buildTypeName) {
        return this.extraBuildTypeSourceProviders.get((Object)buildTypeName);
    }

    public void registerArtifactType(String name, boolean isTest, int artifactType) {
        if (this.extraArtifactMap.get(name) != null) {
            throw new IllegalArgumentException(String.format("Artifact with name %1$s already registered.", name));
        }
        this.extraArtifactMap.put(name, new ArtifactMetaDataImpl(name, isTest, artifactType));
    }

    public void registerBuildTypeSourceProvider(String name, BuildType buildType, SourceProvider sourceProvider) {
        if (this.extraArtifactMap.get(name) == null) {
            throw new IllegalArgumentException(String.format("Artifact with name %1$s is not yet registered. Use registerArtifactType()", name));
        }
        this.extraBuildTypeSourceProviders.put((Object)buildType.getName(), (Object)new DefaultSourceProviderContainer(name, sourceProvider));
    }

    public void registerProductFlavorSourceProvider(String name, ProductFlavor productFlavor, SourceProvider sourceProvider) {
        if (this.extraArtifactMap.get(name) == null) {
            throw new IllegalArgumentException(String.format("Artifact with name %1$s is not yet registered. Use registerArtifactType()", name));
        }
        this.extraProductFlavorSourceProviders.put((Object)productFlavor.getName(), (Object)new DefaultSourceProviderContainer(name, sourceProvider));
    }

    public void registerMultiFlavorSourceProvider(String name, String flavorName2, SourceProvider sourceProvider) {
        if (this.extraArtifactMap.get(name) == null) {
            throw new IllegalArgumentException(String.format("Artifact with name %1$s is not yet registered. Use registerArtifactType()", name));
        }
        this.extraMultiFlavorSourceProviders.put((Object)flavorName2, (Object)new DefaultSourceProviderContainer(name, sourceProvider));
    }

    public void registerJavaArtifact(String name, BaseVariant variant, String assembleTaskName, String javaCompileTaskName, Collection<File> generatedSourceFolders, Iterable<String> ideSetupTaskNames, Configuration configuration, File classesFolder, File javaResourcesFolder, SourceProvider sourceProvider) {
        ArtifactMetaData artifactMetaData = this.extraArtifactMap.get(name);
        if (artifactMetaData == null) {
            throw new IllegalArgumentException(String.format("Artifact with name %1$s is not yet registered. Use registerArtifactType()", name));
        }
        if (artifactMetaData.getType() != 2) {
            throw new IllegalArgumentException(String.format("Artifact with name %1$s is not of type JAVA", name));
        }
        JavaArtifactImpl artifact = new JavaArtifactImpl(name, assembleTaskName, javaCompileTaskName, ideSetupTaskNames, generatedSourceFolders, classesFolder, Collections.emptySet(), javaResourcesFolder, null, new ConfigurationDependencies(configuration), new ConfigurationDependencyGraphs(configuration), sourceProvider, null);
        this.extraJavaArtifacts.put((Object)variant.getName(), (Object)artifact);
    }
}

