/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.profile.ProfileAwareWorkAction;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.ExtractProfilerNativeDependenciesTask;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.buildanalyzer.common.TaskCategory;
import com.android.builder.utils.ZipEntryUtils;
import com.android.utils.FileUtils;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault
@BuildAnalyzer(primaryTaskCategory=TaskCategory.MISC, secondaryTaskCategories={TaskCategory.SOURCE_PROCESSING})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001:\u0002\r\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0014R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lcom/android/build/gradle/internal/tasks/ExtractProfilerNativeDependenciesTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "inputJars", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getInputJars", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "outputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "doTaskAction", "", "CreationAction", "ExtractProfilerNativeDepsWorkerAction", "gradle-core"})
public abstract class ExtractProfilerNativeDependenciesTask
extends NonIncrementalTask {
    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputDir();

    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getInputJars();

    @Override
    protected void doTaskAction() {
        this.getWorkerExecutor().noIsolation().submit(ExtractProfilerNativeDepsWorkerAction.class, new Action(this){
            final /* synthetic */ ExtractProfilerNativeDependenciesTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(ExtractProfilerNativeDepsWorkerAction.Parameters it) {
                it.initializeFromAndroidVariantTask(this.this$0);
                Object[] objectArray = new Object[]{this.this$0.getInputJars()};
                it.getInputJars().from(objectArray);
                it.getOutputDir().set((Provider)this.this$0.getOutputDir());
            }
        });
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0016\u0010\u0011\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/tasks/ExtractProfilerNativeDependenciesTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/ExtractProfilerNativeDependenciesTask;", "Lcom/android/build/gradle/internal/component/ApkCreationConfig;", "apkCreationConfig", "(Lcom/android/build/gradle/internal/component/ApkCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<ExtractProfilerNativeDependenciesTask, ApkCreationConfig> {
        public CreationAction(@NotNull ApkCreationConfig apkCreationConfig) {
            Intrinsics.checkNotNullParameter((Object)apkCreationConfig, (String)"apkCreationConfig");
            super((ComponentCreationConfig)apkCreationConfig);
        }

        @Override
        @NotNull
        public String getName() {
            return this.computeTaskName("extract", "ProfilerNativeDependencies");
        }

        @Override
        @NotNull
        public Class<ExtractProfilerNativeDependenciesTask> getType() {
            return ExtractProfilerNativeDependenciesTask.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<ExtractProfilerNativeDependenciesTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            ((ApkCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).withName("out").on(InternalArtifactType.PROFILERS_NATIVE_LIBS.INSTANCE);
        }

        @Override
        public void configure(@NotNull ExtractProfilerNativeDependenciesTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            Object[] objectArray = new Object[]{((ApkCreationConfig)this.creationConfig).getAdvancedProfilingTransforms()};
            task.getInputJars().from(objectArray);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0006\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0003J8\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00050\fH\u0002J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\b\u0010\u0012\u001a\u00020\u0005H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/tasks/ExtractProfilerNativeDependenciesTask$ExtractProfilerNativeDepsWorkerAction;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction;", "Lcom/android/build/gradle/internal/tasks/ExtractProfilerNativeDependenciesTask$ExtractProfilerNativeDepsWorkerAction$Parameters;", "()V", "actOnMatchingZipEntries", "", "zis", "Ljava/util/zip/ZipInputStream;", "predicate", "Ljava/util/function/Predicate;", "", "action", "Lkotlin/Function2;", "Ljava/util/zip/ZipEntry;", "", "extractNativeLibs", "zipInputStream", "extractNestedNativeLibs", "run", "Parameters", "gradle-core"})
    @SourceDebugExtension(value={"SMAP\nExtractProfilerNativeDependenciesTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtractProfilerNativeDependenciesTask.kt\ncom/android/build/gradle/internal/tasks/ExtractProfilerNativeDependenciesTask$ExtractProfilerNativeDepsWorkerAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,172:1\n1855#2:173\n1856#2:175\n1#3:174\n*S KotlinDebug\n*F\n+ 1 ExtractProfilerNativeDependenciesTask.kt\ncom/android/build/gradle/internal/tasks/ExtractProfilerNativeDependenciesTask$ExtractProfilerNativeDepsWorkerAction\n*L\n107#1:173\n107#1:175\n*E\n"})
    public static abstract class ExtractProfilerNativeDepsWorkerAction
    extends ProfileAwareWorkAction<Parameters> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            File outputDir = ((Directory)((Parameters)this.getParameters()).getOutputDir().get()).getAsFile();
            FileUtils.cleanOutputDir((File)outputDir);
            Iterable $this$forEach$iv = (Iterable)((Parameters)this.getParameters()).getInputJars();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File inputJar = (File)element$iv;
                boolean bl = false;
                Closeable closeable = new ZipInputStream(new FileInputStream(inputJar));
                Throwable throwable = null;
                try {
                    ZipInputStream it = (ZipInputStream)closeable;
                    boolean bl2 = false;
                    this.extractNestedNativeLibs(it);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        }

        private final void extractNestedNativeLibs(ZipInputStream zipInputStream) {
            Pattern dependencyJarPattern = Pattern.compile("dependencies/(.*)\\.jar");
            this.actOnMatchingZipEntries(zipInputStream, new Predicate(dependencyJarPattern){
                final /* synthetic */ Pattern $dependencyJarPattern;
                {
                    this.$dependencyJarPattern = $dependencyJarPattern;
                }

                public final boolean test(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.$dependencyJarPattern.matcher(it).matches();
                }
            }, (Function2<? super ZipEntry, ? super byte[], Unit>)((Function2)new Function2<ZipEntry, byte[], Unit>(this){
                final /* synthetic */ ExtractProfilerNativeDepsWorkerAction this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke(@NotNull ZipEntry zipEntry, @NotNull byte[] dependencyJarBytes) {
                    Intrinsics.checkNotNullParameter((Object)zipEntry, (String)"<anonymous parameter 0>");
                    Intrinsics.checkNotNullParameter((Object)dependencyJarBytes, (String)"dependencyJarBytes");
                    Closeable closeable = new ZipInputStream(new ByteArrayInputStream(dependencyJarBytes));
                    ExtractProfilerNativeDepsWorkerAction extractProfilerNativeDepsWorkerAction = this.this$0;
                    Throwable throwable = null;
                    try {
                        ZipInputStream it = (ZipInputStream)closeable;
                        boolean bl = false;
                        ExtractProfilerNativeDepsWorkerAction.access$extractNativeLibs(extractProfilerNativeDepsWorkerAction, it);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
            }));
        }

        private final void extractNativeLibs(ZipInputStream zipInputStream) {
            File outputDir = ((Directory)((Parameters)this.getParameters()).getOutputDir().get()).getAsFile();
            this.actOnMatchingZipEntries(zipInputStream, extractNativeLibs.1.INSTANCE, (Function2<? super ZipEntry, ? super byte[], Unit>)((Function2)new Function2<ZipEntry, byte[], Unit>(outputDir){
                final /* synthetic */ File $outputDir;
                {
                    this.$outputDir = $outputDir;
                    super(2);
                }

                public final void invoke(@NotNull ZipEntry zipEntry, @NotNull byte[] nativeLibBytes) {
                    Intrinsics.checkNotNullParameter((Object)zipEntry, (String)"zipEntry");
                    Intrinsics.checkNotNullParameter((Object)nativeLibBytes, (String)"nativeLibBytes");
                    String string = zipEntry.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"zipEntry.name");
                    String relativePath = StringsKt.substringAfter$default((String)string, (char)'/', null, (int)2, null);
                    String osRelativePath = StringsKt.replace$default((String)relativePath, (char)'/', (char)File.separatorChar, (boolean)false, (int)4, null);
                    String[] stringArray = new String[]{osRelativePath};
                    File outFile = FileUtils.join((File)this.$outputDir, (String[])stringArray);
                    if (outFile.exists()) {
                        throw new RuntimeException("Unexpected duplicate profiler native dependency: " + relativePath);
                    }
                    FileUtils.mkdirs((File)outFile.getParentFile());
                    Intrinsics.checkNotNullExpressionValue((Object)outFile, (String)"outFile");
                    FilesKt.writeBytes((File)outFile, (byte[])nativeLibBytes);
                }
            }));
        }

        private final void actOnMatchingZipEntries(ZipInputStream zis, Predicate<String> predicate2, Function2<? super ZipEntry, ? super byte[], Unit> action) {
            ZipEntry entry2 = zis.getNextEntry();
            while (entry2 != null && ZipEntryUtils.isValidZipEntryName((ZipEntry)entry2)) {
                if (predicate2.test(entry2.getName())) {
                    action.invoke((Object)entry2, (Object)ByteStreamsKt.readBytes((InputStream)zis));
                }
                zis.closeEntry();
                entry2 = zis.getNextEntry();
            }
        }

        public static final /* synthetic */ void access$extractNativeLibs(ExtractProfilerNativeDepsWorkerAction $this, ZipInputStream zipInputStream) {
            $this.extractNativeLibs(zipInputStream);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/android/build/gradle/internal/tasks/ExtractProfilerNativeDependenciesTask$ExtractProfilerNativeDepsWorkerAction$Parameters;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction$Parameters;", "()V", "inputJars", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getInputJars", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "outputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "gradle-core"})
        public static abstract class Parameters
        extends ProfileAwareWorkAction.Parameters {
            @NotNull
            public abstract DirectoryProperty getOutputDir();

            @NotNull
            public abstract ConfigurableFileCollection getInputJars();
        }
    }
}

