/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.shrinker.gatherer;

import com.android.aapt.Resources;
import com.android.build.shrinker.EntryWrapper;
import com.android.build.shrinker.ResourceShrinkerModel;
import com.android.build.shrinker.ResourceTableUtilKt;
import com.android.build.shrinker.gatherer.ResourcesGatherer;
import com.android.ide.common.resources.ResourcesUtil;
import com.android.resources.ResourceType;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/build/shrinker/gatherer/ProtoResourceTableGatherer;", "Lcom/android/build/shrinker/gatherer/ResourcesGatherer;", "resourceTablePath", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "gatherResourceValues", "", "model", "Lcom/android/build/shrinker/ResourceShrinkerModel;", "shrinker"})
@SourceDebugExtension(value={"SMAP\nProtoResourceTableGatherer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtoResourceTableGatherer.kt\ncom/android/build/shrinker/gatherer/ProtoResourceTableGatherer\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,47:1\n1313#2:48\n1314#2:50\n1#3:49\n*S KotlinDebug\n*F\n+ 1 ProtoResourceTableGatherer.kt\ncom/android/build/shrinker/gatherer/ProtoResourceTableGatherer\n*L\n35#1:48\n35#1:50\n*E\n"})
public final class ProtoResourceTableGatherer
implements ResourcesGatherer {
    @NotNull
    private final Path resourceTablePath;

    public ProtoResourceTableGatherer(@NotNull Path resourceTablePath) {
        Intrinsics.checkNotNullParameter((Object)resourceTablePath, (String)"resourceTablePath");
        this.resourceTablePath = resourceTablePath;
    }

    @Override
    public void gatherResourceValues(@NotNull ResourceShrinkerModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Resources.ResourceTable resourceTable = model.readResourceTable(this.resourceTablePath);
        Intrinsics.checkNotNullExpressionValue((Object)resourceTable, (String)"model.readResourceTable(resourceTablePath)");
        Sequence<EntryWrapper> $this$forEach$iv = ResourceTableUtilKt.entriesSequence(resourceTable);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ResourceType resourceType;
            EntryWrapper entryWrapper = (EntryWrapper)element$iv;
            boolean bl = false;
            int id = entryWrapper.component1();
            String packageName = entryWrapper.component2();
            String type = entryWrapper.component3();
            Resources.Entry entry2 = entryWrapper.component4();
            ResourceType resourceType2 = ResourceType.fromClassName((String)type);
            if (resourceType2 == null) continue;
            ResourceType it = resourceType = resourceType2;
            boolean bl2 = false;
            Object object = it != ResourceType.STYLEABLE ? resourceType : null;
            if (object == null) continue;
            it = object;
            boolean bl3 = false;
            String string = entry2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entry.name");
            model.addResource(it, packageName, ResourcesUtil.resourceNameToFieldName((String)string), id);
        }
    }
}

