/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.builder.sdk.SdkLibData;
import com.android.repository.api.Channel;
import com.android.repository.api.ConsoleProgressIndicator;
import com.android.repository.api.Downloader;
import com.android.repository.api.SettingsController;
import com.android.repository.impl.downloader.LocalFileAwareDownloader;
import com.android.sdklib.repository.legacy.LegacyDownloader;
import com.android.utils.ILogger;
import com.google.common.annotations.VisibleForTesting;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.UnknownHostException;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001cB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/build/gradle/internal/SdkLibDataFactory;", "", "enableDownload", "", "androidSdkChannel", "", "logger", "Lcom/android/utils/ILogger;", "prefsLocation", "Ljava/nio/file/Path;", "(ZLjava/lang/Integer;Lcom/android/utils/ILogger;Ljava/nio/file/Path;)V", "Ljava/lang/Integer;", "createAddress", "Ljava/net/InetSocketAddress;", "proxyHost", "", "proxyPort", "createProxy", "Ljava/net/Proxy;", "environment", "Lcom/android/build/gradle/internal/SdkLibDataFactory$Environment;", "getDownloader", "Lcom/android/repository/api/Downloader;", "settingsController", "Lcom/android/repository/api/SettingsController;", "getSdkLibData", "Lcom/android/builder/sdk/SdkLibData;", "getSettingsController", "Environment", "gradle-core"})
public final class SdkLibDataFactory {
    private final boolean enableDownload;
    @Nullable
    private final Integer androidSdkChannel;
    @NotNull
    private final ILogger logger;
    @NotNull
    private final Path prefsLocation;

    public SdkLibDataFactory(boolean enableDownload, @Nullable Integer androidSdkChannel, @NotNull ILogger logger, @NotNull Path prefsLocation) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)prefsLocation, (String)"prefsLocation");
        this.enableDownload = enableDownload;
        this.androidSdkChannel = androidSdkChannel;
        this.logger = logger;
        this.prefsLocation = prefsLocation;
    }

    @NotNull
    public final SdkLibData getSdkLibData(@NotNull Environment environment) {
        SdkLibData sdkLibData;
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        if (this.enableDownload) {
            SettingsController settingsController = this.getSettingsController(environment);
            SdkLibData sdkLibData2 = SdkLibData.download((Downloader)this.getDownloader(settingsController), (SettingsController)settingsController);
            Intrinsics.checkNotNull((Object)sdkLibData2);
            sdkLibData = sdkLibData2;
        } else {
            SdkLibData sdkLibData3 = SdkLibData.dontDownload();
            Intrinsics.checkNotNull((Object)sdkLibData3);
            sdkLibData = sdkLibData3;
        }
        return sdkLibData;
    }

    private final Downloader getDownloader(SettingsController settingsController) {
        return (Downloader)new LocalFileAwareDownloader((Downloader)new LegacyDownloader(settingsController, this.prefsLocation));
    }

    private final SettingsController getSettingsController(Environment environment) {
        Proxy proxy = this.createProxy(environment, this.logger);
        return new SettingsController(this, proxy){
            final /* synthetic */ SdkLibDataFactory this$0;
            final /* synthetic */ Proxy $proxy;
            {
                this.this$0 = $receiver;
                this.$proxy = $proxy;
            }

            public boolean getForceHttp() {
                return false;
            }

            public void setForceHttp(boolean force) {
            }

            @Nullable
            public Channel getChannel() {
                Integer n = SdkLibDataFactory.access$getAndroidSdkChannel$p(this.this$0);
                return Channel.create((int)(n != null ? n : 0));
            }

            @NotNull
            public Proxy getProxy() {
                return this.$proxy;
            }
        };
    }

    @VisibleForTesting
    @NotNull
    public final Proxy createProxy(@NotNull Environment environment, @NotNull ILogger logger) {
        InetSocketAddress proxyAddr;
        String maybePort;
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        String host = environment.getSystemProperty(Environment.SystemProperty.HTTPS_PROXY_HOST);
        int port = 443;
        if (host != null) {
            maybePort = environment.getSystemProperty(Environment.SystemProperty.HTTPS_PROXY_PORT);
            if (maybePort != null) {
                try {
                    port = Integer.parseInt(maybePort);
                }
                catch (NumberFormatException e) {
                    logger.lifecycle("Invalid https.proxyPort '" + maybePort + "', using default 443", new Object[0]);
                }
            }
        } else {
            host = environment.getSystemProperty(Environment.SystemProperty.HTTP_PROXY_HOST);
            if (host != null) {
                port = 80;
                maybePort = environment.getSystemProperty(Environment.SystemProperty.HTTP_PROXY_PORT);
                if (maybePort != null) {
                    try {
                        port = Integer.parseInt(maybePort);
                    }
                    catch (NumberFormatException e) {
                        logger.lifecycle("Invalid http.proxyPort '" + maybePort + "', using default 80", new Object[0]);
                    }
                }
            }
        }
        if (host != null && (proxyAddr = this.createAddress(host, port)) != null) {
            return new Proxy(Proxy.Type.HTTP, proxyAddr);
        }
        Proxy proxy = Proxy.NO_PROXY;
        Intrinsics.checkNotNullExpressionValue((Object)proxy, (String)"NO_PROXY");
        return proxy;
    }

    private final InetSocketAddress createAddress(String proxyHost, int proxyPort) {
        InetSocketAddress inetSocketAddress;
        try {
            InetAddress address = InetAddress.getByName(proxyHost);
            inetSocketAddress = new InetSocketAddress(address, proxyPort);
        }
        catch (UnknownHostException e) {
            new ConsoleProgressIndicator().logWarning("Failed to parse host " + proxyHost);
            inetSocketAddress = null;
        }
        return inetSocketAddress;
    }

    public static final /* synthetic */ Integer access$getAndroidSdkChannel$p(SdkLibDataFactory $this) {
        return $this.androidSdkChannel;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H&\u00a8\u0006\b"}, d2={"Lcom/android/build/gradle/internal/SdkLibDataFactory$Environment;", "", "()V", "getSystemProperty", "", "property", "Lcom/android/build/gradle/internal/SdkLibDataFactory$Environment$SystemProperty;", "SystemProperty", "gradle-core"})
    public static abstract class Environment {
        @Nullable
        public abstract String getSystemProperty(@NotNull SystemProperty var1);

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/android/build/gradle/internal/SdkLibDataFactory$Environment$SystemProperty;", "", "key", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getKey", "()Ljava/lang/String;", "HTTPS_PROXY_HOST", "HTTPS_PROXY_PORT", "HTTP_PROXY_HOST", "HTTP_PROXY_PORT", "gradle-core"})
        public static final class SystemProperty
        extends Enum<SystemProperty> {
            @NotNull
            private final String key;
            public static final /* enum */ SystemProperty HTTPS_PROXY_HOST = new SystemProperty("https.proxyHost");
            public static final /* enum */ SystemProperty HTTPS_PROXY_PORT = new SystemProperty("https.proxyPort");
            public static final /* enum */ SystemProperty HTTP_PROXY_HOST = new SystemProperty("http.proxyHost");
            public static final /* enum */ SystemProperty HTTP_PROXY_PORT = new SystemProperty("http.proxyPort");
            private static final /* synthetic */ SystemProperty[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private SystemProperty(String key) {
                this.key = key;
            }

            @NotNull
            public final String getKey() {
                return this.key;
            }

            public static SystemProperty[] values() {
                return (SystemProperty[])$VALUES.clone();
            }

            public static SystemProperty valueOf(String value) {
                return Enum.valueOf(SystemProperty.class, value);
            }

            @NotNull
            public static EnumEntries<SystemProperty> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = systemPropertyArray = new SystemProperty[]{SystemProperty.HTTPS_PROXY_HOST, SystemProperty.HTTPS_PROXY_PORT, SystemProperty.HTTP_PROXY_HOST, SystemProperty.HTTP_PROXY_PORT};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }
}

