/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.instrumentation.ClassesHierarchyResolver;
import com.android.build.gradle.internal.instrumentation.FixFramesClassWriter;
import com.android.build.gradle.internal.profile.ProfileAwareWorkAction;
import com.android.build.gradle.internal.services.ClassesHierarchyBuildService;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.FixStackFramesDelegate;
import com.android.builder.utils.ZipEntryUtils;
import com.android.utils.FileUtils;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.InvalidPathException;
import java.nio.file.attribute.FileTime;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.work.ChangeType;
import org.gradle.work.FileChange;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 -2\u00020\u0001:\u0005,-./0Ba\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0002\u0010\u0011J\u0006\u0010 \u001a\u00020!J\"\u0010\"\u001a\u00020!2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020%0$J\u001c\u0010'\u001a\u00020!2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020*0)H\u0002J\u001c\u0010+\u001a\u00020!2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020*0)H\u0002R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0015R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0015R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0015R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0013R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u00061"}, d2={"Lcom/android/build/gradle/internal/tasks/FixStackFramesDelegate;", "", "classesDir", "Ljava/io/File;", "jarsDir", "bootClasspath", "", "referencedClasses", "classesOutDir", "jarsOutDir", "workers", "Lorg/gradle/workers/WorkerExecutor;", "task", "Lcom/android/build/gradle/internal/tasks/AndroidVariantTask;", "classesHierarchyBuildServiceProvider", "Lorg/gradle/api/provider/Provider;", "Lcom/android/build/gradle/internal/services/ClassesHierarchyBuildService;", "(Ljava/io/File;Ljava/io/File;Ljava/util/Set;Ljava/util/Set;Ljava/io/File;Ljava/io/File;Lorg/gradle/workers/WorkerExecutor;Lcom/android/build/gradle/internal/tasks/AndroidVariantTask;Lorg/gradle/api/provider/Provider;)V", "getBootClasspath", "()Ljava/util/Set;", "getClassesDir", "()Ljava/io/File;", "getClassesHierarchyBuildServiceProvider", "()Lorg/gradle/api/provider/Provider;", "getClassesOutDir", "getJarsDir", "getJarsOutDir", "getReferencedClasses", "getTask", "()Lcom/android/build/gradle/internal/tasks/AndroidVariantTask;", "getWorkers", "()Lorg/gradle/workers/WorkerExecutor;", "doFullRun", "", "doIncrementalRun", "jarChanges", "", "Lorg/gradle/work/FileChange;", "classesChanges", "processClasses", "changedInput", "", "Lorg/gradle/work/ChangeType;", "processJars", "ClassesParams", "Companion", "FixClassesStackFramesRunnable", "FixJarStackFramesRunnable", "JarParams", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nFixStackFramesDelegate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FixStackFramesDelegate.kt\ncom/android/build/gradle/internal/tasks/FixStackFramesDelegate\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,280:1\n215#2,2:281\n215#2,2:290\n494#3,7:283\n494#3,7:292\n8406#4,2:299\n9088#4,4:301\n1179#5,2:305\n1253#5,4:307\n1179#5,2:311\n1253#5,4:313\n*S KotlinDebug\n*F\n+ 1 FixStackFramesDelegate.kt\ncom/android/build/gradle/internal/tasks/FixStackFramesDelegate\n*L\n136#1:281,2\n167#1:290,2\n167#1:283,7\n171#1:292,7\n200#1:299,2\n200#1:301,4\n210#1:305,2\n210#1:307,4\n211#1:311,2\n211#1:313,4\n*E\n"})
public final class FixStackFramesDelegate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File classesDir;
    @Nullable
    private final File jarsDir;
    @NotNull
    private final Set<File> bootClasspath;
    @NotNull
    private final Set<File> referencedClasses;
    @NotNull
    private final File classesOutDir;
    @NotNull
    private final File jarsOutDir;
    @NotNull
    private final WorkerExecutor workers;
    @NotNull
    private final AndroidVariantTask task;
    @NotNull
    private final Provider<ClassesHierarchyBuildService> classesHierarchyBuildServiceProvider;
    @NotNull
    private static final LoggerWrapper logger;
    @NotNull
    private static final FileTime zeroFileTime;

    public FixStackFramesDelegate(@NotNull File classesDir, @Nullable File jarsDir, @NotNull Set<? extends File> bootClasspath2, @NotNull Set<? extends File> referencedClasses, @NotNull File classesOutDir, @NotNull File jarsOutDir, @NotNull WorkerExecutor workers, @NotNull AndroidVariantTask task, @NotNull Provider<ClassesHierarchyBuildService> classesHierarchyBuildServiceProvider) {
        Intrinsics.checkNotNullParameter((Object)classesDir, (String)"classesDir");
        Intrinsics.checkNotNullParameter(bootClasspath2, (String)"bootClasspath");
        Intrinsics.checkNotNullParameter(referencedClasses, (String)"referencedClasses");
        Intrinsics.checkNotNullParameter((Object)classesOutDir, (String)"classesOutDir");
        Intrinsics.checkNotNullParameter((Object)jarsOutDir, (String)"jarsOutDir");
        Intrinsics.checkNotNullParameter((Object)workers, (String)"workers");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter(classesHierarchyBuildServiceProvider, (String)"classesHierarchyBuildServiceProvider");
        this.classesDir = classesDir;
        this.jarsDir = jarsDir;
        this.bootClasspath = bootClasspath2;
        this.referencedClasses = referencedClasses;
        this.classesOutDir = classesOutDir;
        this.jarsOutDir = jarsOutDir;
        this.workers = workers;
        this.task = task;
        this.classesHierarchyBuildServiceProvider = classesHierarchyBuildServiceProvider;
    }

    @NotNull
    public final File getClassesDir() {
        return this.classesDir;
    }

    @Nullable
    public final File getJarsDir() {
        return this.jarsDir;
    }

    @NotNull
    public final Set<File> getBootClasspath() {
        return this.bootClasspath;
    }

    @NotNull
    public final Set<File> getReferencedClasses() {
        return this.referencedClasses;
    }

    @NotNull
    public final File getClassesOutDir() {
        return this.classesOutDir;
    }

    @NotNull
    public final File getJarsOutDir() {
        return this.jarsOutDir;
    }

    @NotNull
    public final WorkerExecutor getWorkers() {
        return this.workers;
    }

    @NotNull
    public final AndroidVariantTask getTask() {
        return this.task;
    }

    @NotNull
    public final Provider<ClassesHierarchyBuildService> getClassesHierarchyBuildServiceProvider() {
        return this.classesHierarchyBuildServiceProvider;
    }

    private final void processJars(Map<File, ? extends ChangeType> changedInput) {
        Map<File, ? extends ChangeType> $this$forEach$iv = changedInput;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<File, ? extends ChangeType>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<File, ? extends ChangeType> element$iv;
            Map.Entry<File, ? extends ChangeType> entry2 = element$iv = iterator2.next();
            boolean bl = false;
            File inputJar = entry2.getKey();
            ChangeType changeType = entry2.getValue();
            File outputJar = new File(this.jarsOutDir, inputJar.getName());
            FileUtils.deleteIfExists((File)outputJar);
            if (changeType != ChangeType.ADDED && changeType != ChangeType.MODIFIED) continue;
            this.workers.noIsolation().submit(FixJarStackFramesRunnable.class, new Action(this, inputJar, outputJar){
                final /* synthetic */ FixStackFramesDelegate this$0;
                final /* synthetic */ File $inputJar;
                final /* synthetic */ File $outputJar;
                {
                    this.this$0 = $receiver;
                    this.$inputJar = $inputJar;
                    this.$outputJar = $outputJar;
                }

                public final void execute(JarParams params) {
                    params.initializeFromBaseTask(this.this$0.getTask());
                    params.getInputJar().set((Object)this.$inputJar);
                    params.getOutputJar().set((Object)this.$outputJar);
                    params.getClassesHierarchyBuildService().set(this.this$0.getClassesHierarchyBuildServiceProvider());
                    Object object = this.this$0.getJarsDir();
                    if (object == null || (object = object.listFiles()) == null || (object = ArraysKt.toSet((Object[])object)) == null) {
                        object = SetsKt.emptySet();
                    }
                    Object[] jars = object;
                    Object[] objectArray = new Set[]{this.this$0.getBootClasspath(), jars, this.this$0.getReferencedClasses()};
                    params.getClasspath().set((Iterable)CollectionsKt.flatten((Iterable)CollectionsKt.listOf((Object[])objectArray)));
                }
            });
        }
    }

    private final void processClasses(Map<File, ? extends ChangeType> changedInput) {
        Map<File, ? extends ChangeType> $this$filterValues$iv = changedInput;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry<File, ? extends ChangeType> entry$iv : $this$filterValues$iv.entrySet()) {
            ChangeType changeType = entry$iv.getValue();
            boolean bl = false;
            if (!(changeType == ChangeType.REMOVED)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map $this$forEach$iv = result$iv;
        boolean $i$f$forEach = false;
        for (Map.Entry entry2 : $this$forEach$iv.entrySet()) {
            Map.Entry entry3 = entry2;
            boolean bl = false;
            File inputFile = (File)entry3.getKey();
            FileUtils.deleteIfExists((File)FilesKt.resolve((File)this.classesOutDir, (File)FilesKt.relativeTo((File)inputFile, (File)this.classesDir)));
        }
        Map<File, ? extends ChangeType> $this$filterValues$iv2 = changedInput;
        boolean $i$f$filterValues2 = false;
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (Map.Entry entry4 : $this$filterValues$iv2.entrySet()) {
            ChangeType it = (ChangeType)entry4.getValue();
            boolean bl = false;
            if (!(it == ChangeType.ADDED || it == ChangeType.MODIFIED)) continue;
            linkedHashMap.put(entry4.getKey(), entry4.getValue());
        }
        Set filesToProcess = ((Map)linkedHashMap).keySet();
        if (!((Collection)filesToProcess).isEmpty()) {
            this.workers.noIsolation().submit(FixClassesStackFramesRunnable.class, new Action(this, filesToProcess){
                final /* synthetic */ FixStackFramesDelegate this$0;
                final /* synthetic */ Set<File> $filesToProcess;
                {
                    this.this$0 = $receiver;
                    this.$filesToProcess = $filesToProcess;
                }

                public final void execute(ClassesParams params) {
                    params.initializeFromBaseTask(this.this$0.getTask());
                    params.getInputDir().set((Object)this.this$0.getClassesDir());
                    params.getInputFiles().set((Iterable)this.$filesToProcess);
                    params.getOutputDir().set((Object)this.this$0.getClassesOutDir());
                    params.getClassesHierarchyBuildService().set(this.this$0.getClassesHierarchyBuildServiceProvider());
                    Object[] objectArray = new Collection[]{this.this$0.getBootClasspath(), CollectionsKt.listOf((Object)this.this$0.getClassesDir()), this.this$0.getReferencedClasses()};
                    params.getClasspath().set((Iterable)CollectionsKt.flatten((Iterable)CollectionsKt.listOf((Object[])objectArray)));
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void doFullRun() {
        FileUtils.cleanOutputDir((File)this.classesOutDir);
        FileUtils.cleanOutputDir((File)this.jarsOutDir);
        File[] fileArray = this.jarsDir;
        if (this.jarsDir != null && (fileArray = fileArray.listFiles()) != null) {
            void $this$associateTo$iv$iv;
            File[] $this$associate$iv = fileArray;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associate$iv.length), (int)16);
            File[] fileArray2 = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (void element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                void it = element$iv$iv;
                boolean bl = false;
                Pair pair = TuplesKt.to((Object)it, (Object)ChangeType.ADDED);
                map.put(pair.getFirst(), pair.getSecond());
            }
            Map it = destination$iv$iv;
            boolean bl = false;
            this.processJars(it);
        }
        ImmutableMap immutableMap = FileUtils.getAllFiles((File)this.classesDir).toMap((Function)doFullRun.3.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"toMap(...)");
        this.processClasses((Map)immutableMap);
    }

    public final void doIncrementalRun(@NotNull Iterable<? extends FileChange> jarChanges, @NotNull Iterable<? extends FileChange> classesChanges) {
        boolean bl;
        FileChange it;
        Map map;
        Iterable<? extends FileChange> $this$associateTo$iv$iv;
        Iterable<? extends FileChange> $this$associate$iv;
        Intrinsics.checkNotNullParameter(jarChanges, (String)"jarChanges");
        Intrinsics.checkNotNullParameter(classesChanges, (String)"classesChanges");
        Iterable<? extends FileChange> iterable = jarChanges;
        FixStackFramesDelegate fixStackFramesDelegate = this;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var6_7 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object t : $this$associateTo$iv$iv) {
            map = destination$iv$iv;
            it = (FileChange)t;
            bl = false;
            it = TuplesKt.to((Object)it.getFile(), (Object)it.getChangeType());
            map.put(it.getFirst(), it.getSecond());
        }
        fixStackFramesDelegate.processJars(destination$iv$iv);
        $this$associate$iv = classesChanges;
        fixStackFramesDelegate = this;
        $i$f$associate = false;
        capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault($this$associate$iv, (int)10)), (int)16);
        $this$associateTo$iv$iv = $this$associate$iv;
        destination$iv$iv = new LinkedHashMap(capacity$iv);
        $i$f$associateTo = false;
        for (Object object : $this$associateTo$iv$iv) {
            map = destination$iv$iv;
            it = (FileChange)object;
            bl = false;
            Pair pair = TuplesKt.to((Object)it.getFile(), (Object)it.getChangeType());
            map.put(pair.getFirst(), pair.getSecond());
        }
        fixStackFramesDelegate.processClasses(destination$iv$iv);
    }

    static {
        LoggerWrapper loggerWrapper = LoggerWrapper.getLogger(FixStackFramesDelegate.class);
        Intrinsics.checkNotNullExpressionValue((Object)loggerWrapper, (String)"getLogger(...)");
        logger = loggerWrapper;
        FileTime fileTime = FileTime.fromMillis(0L);
        Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"fromMillis(...)");
        zeroFileTime = fileTime;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0007R\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\fR\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/android/build/gradle/internal/tasks/FixStackFramesDelegate$ClassesParams;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction$Parameters;", "()V", "classesHierarchyBuildService", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/gradle/internal/services/ClassesHierarchyBuildService;", "getClassesHierarchyBuildService", "()Lorg/gradle/api/provider/Property;", "classpath", "Lorg/gradle/api/provider/ListProperty;", "Ljava/io/File;", "getClasspath", "()Lorg/gradle/api/provider/ListProperty;", "inputDir", "getInputDir", "inputFiles", "getInputFiles", "outputDir", "getOutputDir", "gradle-core"})
    public static abstract class ClassesParams
    extends ProfileAwareWorkAction.Parameters {
        @NotNull
        public abstract ListProperty<File> getInputFiles();

        @NotNull
        public abstract Property<File> getInputDir();

        @NotNull
        public abstract Property<File> getOutputDir();

        @NotNull
        public abstract Property<ClassesHierarchyBuildService> getClassesHierarchyBuildService();

        @NotNull
        public abstract ListProperty<File> getClasspath();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/build/gradle/internal/tasks/FixStackFramesDelegate$Companion;", "", "()V", "logger", "Lcom/android/build/gradle/internal/LoggerWrapper;", "zeroFileTime", "Ljava/nio/file/attribute/FileTime;", "getFixedClass", "", "originalFile", "Ljava/io/InputStream;", "classesHierarchyResolver", "Lcom/android/build/gradle/internal/instrumentation/ClassesHierarchyResolver;", "transformJar", "", "inputJar", "Ljava/io/File;", "outputJar", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void transformJar(@NotNull File inputJar, @NotNull File outputJar, @NotNull ClassesHierarchyResolver classesHierarchyResolver) {
            Intrinsics.checkNotNullParameter((Object)inputJar, (String)"inputJar");
            Intrinsics.checkNotNullParameter((Object)outputJar, (String)"outputJar");
            Intrinsics.checkNotNullParameter((Object)classesHierarchyResolver, (String)"classesHierarchyResolver");
            Closeable closeable = new ZipFile(inputJar);
            Throwable throwable = null;
            try {
                ZipFile inputZip = (ZipFile)closeable;
                boolean bl = false;
                Closeable closeable2 = new FileOutputStream(outputJar);
                int n = 8192;
                closeable2 = new ZipOutputStream(closeable2 instanceof BufferedOutputStream ? (BufferedOutputStream)closeable2 : new BufferedOutputStream((OutputStream)closeable2, n));
                Throwable throwable2 = null;
                try {
                    ZipOutputStream outputZip = (ZipOutputStream)closeable2;
                    boolean bl2 = false;
                    Enumeration<? extends ZipEntry> inEntries = inputZip.entries();
                    while (inEntries.hasMoreElements()) {
                        byte[] byArray;
                        ZipEntry entry2 = inEntries.nextElement();
                        Intrinsics.checkNotNull((Object)entry2);
                        if (!ZipEntryUtils.isValidZipEntryName((ZipEntry)entry2)) {
                            throw new InvalidPathException(entry2.getName(), "Entry name contains invalid characters");
                        }
                        ZipEntry outEntry = new ZipEntry(entry2.getName());
                        InputStream inputStream = inputZip.getInputStream(entry2);
                        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                        Closeable closeable3 = inputStream;
                        int n2 = 8192;
                        closeable3 = closeable3 instanceof BufferedInputStream ? (BufferedInputStream)closeable3 : new BufferedInputStream((InputStream)closeable3, n2);
                        Throwable throwable3 = null;
                        try {
                            BufferedInputStream it = (BufferedInputStream)closeable3;
                            boolean bl3 = false;
                            String string = entry2.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                            byArray = StringsKt.endsWith$default((String)string, (String)".class", (boolean)false, (int)2, null) ? Companion.getFixedClass(it, classesHierarchyResolver) : ByteStreams.toByteArray((InputStream)it);
                        }
                        catch (Throwable throwable4) {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                        }
                        byte[] newEntryContent = byArray;
                        CRC32 crc32 = new CRC32();
                        crc32.update(newEntryContent);
                        outEntry.setCrc(crc32.getValue());
                        outEntry.setMethod(0);
                        outEntry.setSize(newEntryContent.length);
                        outEntry.setCompressedSize(newEntryContent.length);
                        outEntry.setLastAccessTime(zeroFileTime);
                        outEntry.setLastModifiedTime(zeroFileTime);
                        outEntry.setCreationTime(zeroFileTime);
                        outputZip.putNextEntry(outEntry);
                        outputZip.write(newEntryContent);
                        outputZip.closeEntry();
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        private final byte[] getFixedClass(InputStream originalFile, ClassesHierarchyResolver classesHierarchyResolver) {
            byte[] byArray;
            byte[] bytes2 = ByteStreams.toByteArray((InputStream)originalFile);
            try {
                ClassReader classReader = new ClassReader(bytes2);
                FixFramesClassWriter classWriter = new FixFramesClassWriter(2, classesHierarchyResolver);
                classReader.accept((ClassVisitor)classWriter, 4);
                byArray = classWriter.toByteArray();
                Intrinsics.checkNotNull((Object)byArray);
            }
            catch (Throwable t) {
                LoggerWrapper loggerWrapper = logger;
                String string = t.getMessage();
                Intrinsics.checkNotNull((Object)string);
                loggerWrapper.verbose(string, new Object[0]);
                byte[] byArray2 = bytes2;
                Intrinsics.checkNotNull((Object)byArray2);
                byArray = byArray2;
            }
            return byArray;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/android/build/gradle/internal/tasks/FixStackFramesDelegate$FixClassesStackFramesRunnable;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction;", "Lcom/android/build/gradle/internal/tasks/FixStackFramesDelegate$ClassesParams;", "()V", "run", "", "gradle-core"})
    @SourceDebugExtension(value={"SMAP\nFixStackFramesDelegate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FixStackFramesDelegate.kt\ncom/android/build/gradle/internal/tasks/FixStackFramesDelegate$FixClassesStackFramesRunnable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,280:1\n1855#2,2:281\n*S KotlinDebug\n*F\n+ 1 FixStackFramesDelegate.kt\ncom/android/build/gradle/internal/tasks/FixStackFramesDelegate$FixClassesStackFramesRunnable\n*L\n259#1:281,2\n*E\n"})
    public static abstract class FixClassesStackFramesRunnable
    extends ProfileAwareWorkAction<ClassesParams> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ClassesHierarchyResolver.Builder builder = ((ClassesHierarchyBuildService)((ClassesParams)this.getParameters()).getClassesHierarchyBuildService().get()).getClassesHierarchyResolverBuilder();
            Object object = ((ClassesParams)this.getParameters()).getClasspath().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            ClassesHierarchyResolver classesHierarchyResolver = builder.addDependenciesSources((Iterable)object).build();
            Object object2 = ((ClassesParams)this.getParameters()).getInputFiles().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
            Iterable $this$forEach$iv = (Iterable)object2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File inputFile = (File)element$iv;
                boolean bl = false;
                Object object3 = ((ClassesParams)this.getParameters()).getOutputDir().get();
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
                File file = (File)object3;
                Intrinsics.checkNotNull((Object)inputFile);
                Object object4 = ((ClassesParams)this.getParameters()).getInputDir().get();
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
                File outputFile = FilesKt.resolve((File)file, (File)FilesKt.relativeTo((File)inputFile, (File)((File)object4)));
                FileUtils.deleteIfExists((File)outputFile);
                outputFile.getParentFile().mkdirs();
                String string = inputFile.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (StringsKt.endsWith$default((String)string, (String)".class", (boolean)false, (int)2, null)) {
                    Closeable closeable = new FileOutputStream(outputFile);
                    int n = 8192;
                    closeable = closeable instanceof BufferedOutputStream ? (BufferedOutputStream)closeable : new BufferedOutputStream((OutputStream)closeable, n);
                    Throwable throwable = null;
                    try {
                        BufferedOutputStream outputStream = (BufferedOutputStream)closeable;
                        boolean bl2 = false;
                        Closeable closeable2 = new FileInputStream(inputFile);
                        int n2 = 8192;
                        closeable2 = closeable2 instanceof BufferedInputStream ? (BufferedInputStream)closeable2 : new BufferedInputStream((InputStream)closeable2, n2);
                        Throwable throwable2 = null;
                        try {
                            BufferedInputStream inputStream = (BufferedInputStream)closeable2;
                            boolean bl3 = false;
                            outputStream.write(Companion.getFixedClass(inputStream, classesHierarchyResolver));
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                        }
                        Unit unit = Unit.INSTANCE;
                        continue;
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        continue;
                    }
                }
                FileUtils.copyFile((File)inputFile, (File)outputFile);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/android/build/gradle/internal/tasks/FixStackFramesDelegate$FixJarStackFramesRunnable;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction;", "Lcom/android/build/gradle/internal/tasks/FixStackFramesDelegate$JarParams;", "()V", "run", "", "gradle-core"})
    public static abstract class FixJarStackFramesRunnable
    extends ProfileAwareWorkAction<JarParams> {
        @Override
        public void run() {
            Object object = ((JarParams)this.getParameters()).getInputJar().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            File file = (File)object;
            Object object2 = ((JarParams)this.getParameters()).getOutputJar().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
            File file2 = (File)object2;
            ClassesHierarchyResolver.Builder builder = ((ClassesHierarchyBuildService)((JarParams)this.getParameters()).getClassesHierarchyBuildService().get()).getClassesHierarchyResolverBuilder();
            Object object3 = ((JarParams)this.getParameters()).getClasspath().get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
            Companion.transformJar(file, file2, builder.addDependenciesSources((Iterable)object3).build());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0007R\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/android/build/gradle/internal/tasks/FixStackFramesDelegate$JarParams;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction$Parameters;", "()V", "classesHierarchyBuildService", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/gradle/internal/services/ClassesHierarchyBuildService;", "getClassesHierarchyBuildService", "()Lorg/gradle/api/provider/Property;", "classpath", "Lorg/gradle/api/provider/ListProperty;", "Ljava/io/File;", "getClasspath", "()Lorg/gradle/api/provider/ListProperty;", "inputJar", "getInputJar", "outputJar", "getOutputJar", "gradle-core"})
    public static abstract class JarParams
    extends ProfileAwareWorkAction.Parameters {
        @NotNull
        public abstract Property<File> getInputJar();

        @NotNull
        public abstract Property<File> getOutputJar();

        @NotNull
        public abstract Property<ClassesHierarchyBuildService> getClassesHierarchyBuildService();

        @NotNull
        public abstract ListProperty<File> getClasspath();
    }
}

