/*
 * Decompiled with CFR 0.152.
 */
package com.android.prefs;

import com.android.io.CancellableFileIo;
import com.android.prefs.AbstractAndroidLocations;
import com.android.prefs.AndroidLocationsException;
import com.android.prefs.Global;
import com.android.prefs.PathLocator;
import com.android.utils.EnvironmentProvider;
import com.android.utils.ILogger;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0014J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\bH\u0002J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u0014\u0010\u0010\u001a\u00020\r*\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/prefs/AndroidPathLocator;", "Lcom/android/prefs/PathLocator;", "environmentProvider", "Lcom/android/utils/EnvironmentProvider;", "logger", "Lcom/android/utils/ILogger;", "(Lcom/android/utils/EnvironmentProvider;Lcom/android/utils/ILogger;)V", "handlePath", "Ljava/nio/file/Path;", "globalVar", "Lcom/android/prefs/Global;", "path", "isSdkRootWithoutDotAndroid", "", "folder", "validateAndroidSdkHomeValue", "hasSubFolder", "subFolder", "", "common"})
final class AndroidPathLocator
extends PathLocator {
    @Nullable
    private final ILogger logger;

    public AndroidPathLocator(@NotNull EnvironmentProvider environmentProvider, @Nullable ILogger logger) {
        Intrinsics.checkParameterIsNotNull((Object)environmentProvider, (String)"environmentProvider");
        super(environmentProvider);
        this.logger = logger;
    }

    public /* synthetic */ AndroidPathLocator(EnvironmentProvider environmentProvider, ILogger iLogger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            iLogger = null;
        }
        this(environmentProvider, iLogger);
    }

    @Override
    @Nullable
    protected Path handlePath(@NotNull Global globalVar, @NotNull Path path) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)globalVar), (String)"globalVar");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Path path2 = super.handlePath(globalVar, path);
        if (path2 == null) {
            return null;
        }
        if (globalVar == Global.ANDROID_SDK_HOME && !this.validateAndroidSdkHomeValue(path)) {
            return null;
        }
        return globalVar.getAndroidLeaf() != null ? path.resolve(globalVar.getAndroidLeaf()) : path;
    }

    private final boolean validateAndroidSdkHomeValue(Path path) {
        if (!CancellableFileIo.isDirectory(path, new LinkOption[0])) {
            return false;
        }
        if (this.isSdkRootWithoutDotAndroid(path)) {
            String message2 = StringsKt.trimIndent((String)("\n                        ANDROID_SDK_HOME is set to the root of your SDK: " + path + "\n                        ANDROID_SDK_HOME was meant to be the parent path of the preference folder expected by the Android tools.\n                        It is now deprecated.\n\n                        To set a custom preference folder location, use ANDROID_USER_HOME.\n\n                        It should NOT be set to the same directory as the root of your SDK.\n                        To set a custom SDK location, use ANDROID_HOME.\n                        "));
            if (this.logger != null) {
                this.logger.warning(message2, new Object[0]);
            } else {
                throw new AndroidLocationsException(message2, null, 2, null);
            }
        }
        return true;
    }

    private final boolean isSdkRootWithoutDotAndroid(Path folder) {
        return this.hasSubFolder(folder, "platforms") && this.hasSubFolder(folder, "platform-tools") && !this.hasSubFolder(folder, AbstractAndroidLocations.FOLDER_DOT_ANDROID);
    }

    private final boolean hasSubFolder(Path $this$hasSubFolder, String subFolder) {
        return CancellableFileIo.isDirectory($this$hasSubFolder.resolve(subFolder), new LinkOption[0]);
    }
}

