/*
 * Decompiled with CFR 0.152.
 */
package com.android.prefs;

import com.android.utils.EnvironmentProvider;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.android.utils.StdLogger;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.function.Function;

@Deprecated
public final class AndroidLocation {
    public static final String FOLDER_DOT_ANDROID = ".android";
    public static final String FOLDER_AVD = "avd";
    public static final String ANDROID_PREFS_ROOT = "ANDROID_PREFS_ROOT";
    @VisibleForTesting
    static String sPrefsLocation = null;
    private static String sAvdLocation = null;

    public static String getFolder() throws AndroidLocationException {
        return AndroidLocation.getFolder(EnvironmentProvider.DIRECT, new StdLogger(StdLogger.Level.VERBOSE));
    }

    public static String getFolder(EnvironmentProvider environmentProvider, ILogger logger) throws AndroidLocationException {
        File f;
        if (sPrefsLocation == null) {
            sPrefsLocation = AndroidLocation.findHomeFolder(environmentProvider, logger);
        }
        if (!(f = new File(sPrefsLocation)).exists()) {
            try {
                FileUtils.mkdirs(f);
            }
            catch (SecurityException e) {
                AndroidLocationException e2 = new AndroidLocationException(String.format("Unable to create folder '%1$s'. This is the path of preference folder expected by the Android tools.", sPrefsLocation));
                e2.initCause(e);
                throw e2;
            }
        } else if (f.isFile()) {
            throw new AndroidLocationException(String.format("%1$s is not a directory!\nThis is the path of preference folder expected by the Android tools.", sPrefsLocation));
        }
        return sPrefsLocation;
    }

    public static String getFolderWithoutWrites() {
        if (sPrefsLocation == null) {
            try {
                sPrefsLocation = AndroidLocation.findHomeFolder(EnvironmentProvider.DIRECT, new StdLogger(StdLogger.Level.VERBOSE));
            }
            catch (AndroidLocationException e) {
                return null;
            }
        }
        return sPrefsLocation;
    }

    public static String getAvdFolder() throws AndroidLocationException {
        if (sAvdLocation == null) {
            Object home = AndroidLocation.findValidPath(EnvironmentProvider.DIRECT, new StdLogger(StdLogger.Level.VERBOSE), Global.ANDROID_AVD_HOME);
            if (home == null) {
                home = AndroidLocation.getFolder() + FOLDER_AVD;
            }
            if (!(sAvdLocation = home).endsWith(File.separator)) {
                sAvdLocation = sAvdLocation + File.separator;
            }
        }
        return sAvdLocation;
    }

    public static String getUserHomeFolder() throws AndroidLocationException {
        return AndroidLocation.findValidPath(EnvironmentProvider.DIRECT, new StdLogger(StdLogger.Level.VERBOSE), Global.TEST_TMPDIR, Global.USER_HOME, Global.HOME);
    }

    private static String findHomeFolder(EnvironmentProvider environmentProvider, ILogger logger) throws AndroidLocationException {
        Object home = AndroidLocation.findValidPath(environmentProvider, logger, Global.ANDROID_PREFS_ROOT, Global.TEST_TMPDIR, Global.USER_HOME, Global.HOME);
        if (home == null) {
            throw new AndroidLocationException("prop: " + environmentProvider.getSystemProperty(ANDROID_PREFS_ROOT));
        }
        if (!((String)home).endsWith(File.separator)) {
            home = (String)home + File.separator;
        }
        return (String)home + FOLDER_DOT_ANDROID + File.separator;
    }

    public static void resetFolder() {
        sPrefsLocation = null;
        sAvdLocation = null;
    }

    private static String findValidPath(EnvironmentProvider environmentProvider, ILogger logger, Global ... vars) throws AndroidLocationException {
        for (Global var : vars) {
            String path = var.validatePath(environmentProvider, logger, true);
            if (path == null) continue;
            return path;
        }
        return null;
    }

    public static final class AndroidLocationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public AndroidLocationException(String string) {
            super(string);
        }
    }

    private static enum Global {
        ANDROID_AVD_HOME("ANDROID_AVD_HOME", true, true),
        ANDROID_PREFS_ROOT("ANDROID_PREFS_ROOT", true, true),
        TEST_TMPDIR("TEST_TMPDIR", false, true),
        USER_HOME("user.home", true, false),
        HOME("HOME", false, true);

        final String mName;
        final boolean mIsSysProp;
        final boolean mIsEnvVar;

        private Global(String name, boolean isSysProp, boolean isEnvVar) {
            this.mName = name;
            this.mIsSysProp = isSysProp;
            this.mIsEnvVar = isEnvVar;
        }

        public String validatePath(EnvironmentProvider environmentProvider, ILogger logger, boolean silent) throws AndroidLocationException {
            String path;
            if (this.mIsSysProp) {
                path = this.checkPath(environmentProvider, environmentProvider::getSystemProperty, logger, silent);
                if (path != null) {
                    return path;
                }
            }
            if (this.mIsEnvVar) {
                path = this.checkPath(environmentProvider, environmentProvider::getEnvVariable, logger, silent);
                if (path != null) {
                    return path;
                }
            }
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private String checkPath(EnvironmentProvider environmentProvider, Function<String, String> queryFunction, ILogger logger, boolean silent) throws AndroidLocationException {
            String path = queryFunction.apply(this.mName);
            if (this == ANDROID_PREFS_ROOT) {
                String androidSdkHomePath = queryFunction.apply("ANDROID_SDK_HOME");
                if (path == null) {
                    if (androidSdkHomePath == null) return null;
                    path = Global.validateAndroidSdkHomeValue(environmentProvider, androidSdkHomePath, logger, silent);
                } else if (androidSdkHomePath != null && !path.equals(androidSdkHomePath)) {
                    throw new AndroidLocationException("Both ANDROID_PREFS_ROOT and ANDROID_SDK_HOME are set to different values\nSupport for ANDROID_SDK_HOME is deprecated. Use ANDROID_PREFS_ROOT only.\nCurrent values:\nANDROID_PREFS_ROOT: " + path + "\nANDROID_SDK_HOME: " + androidSdkHomePath);
                }
            }
            if (path == null) {
                return null;
            }
            File file2 = new File(path);
            if (file2.isDirectory()) return path;
            return null;
        }

        private static String validateAndroidSdkHomeValue(EnvironmentProvider environmentProvider, String path, ILogger logger, boolean silent) throws AndroidLocationException {
            File file2 = new File(path);
            if (!file2.isDirectory()) {
                return null;
            }
            if (Global.isSdkRootWithoutDotAndroid(file2)) {
                String message2 = String.format("ANDROID_SDK_HOME is set to the root of your SDK: %1$s\nANDROID_SDK_HOME is meant to be the path of the preference folder expected by the Android tools.\nIt should NOT be set to the same as the root of your SDK.\nTo set a custom SDK Location, use ANDROID_SDK_ROOT.\nIf this is not set we default to: %2$s", path, AndroidLocation.findValidPath(environmentProvider, logger, TEST_TMPDIR, USER_HOME, HOME));
                if (silent) {
                    logger.warning(message2, new Object[0]);
                } else {
                    throw new AndroidLocationException(message2);
                }
            }
            return path;
        }

        private static boolean isSdkRootWithoutDotAndroid(File folder) {
            return Global.subFolderExist(folder, "platforms") && Global.subFolderExist(folder, "platform-tools") && !Global.subFolderExist(folder, AndroidLocation.FOLDER_DOT_ANDROID);
        }

        private static boolean subFolderExist(File folder, String subFolder) {
            return new File(folder, subFolder).isDirectory();
        }
    }
}

