/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium;

import com.applitools.ICheckSettings;
import com.applitools.eyes.AppEnvironment;
import com.applitools.eyes.AppOutput;
import com.applitools.eyes.CoordinatesType;
import com.applitools.eyes.CutProvider;
import com.applitools.eyes.EyesBase;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.IEyesJsExecutor;
import com.applitools.eyes.IRegion;
import com.applitools.eyes.IServerConnector;
import com.applitools.eyes.ImageMatchSettings;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MatchResult;
import com.applitools.eyes.MatchWindowTask;
import com.applitools.eyes.NullCutProvider;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.ScaleProvider;
import com.applitools.eyes.ScaleProviderFactory;
import com.applitools.eyes.ScaleProviderIdentityFactory;
import com.applitools.eyes.TestResults;
import com.applitools.eyes.UserAgent;
import com.applitools.eyes.capture.AppOutputWithScreenshot;
import com.applitools.eyes.capture.EyesScreenshotFactory;
import com.applitools.eyes.capture.ImageProvider;
import com.applitools.eyes.events.ValidationInfo;
import com.applitools.eyes.events.ValidationResult;
import com.applitools.eyes.exceptions.TestFailedException;
import com.applitools.eyes.fluent.GetRegion;
import com.applitools.eyes.fluent.ICheckSettingsInternal;
import com.applitools.eyes.fluent.SimpleRegionByRectangle;
import com.applitools.eyes.positioning.PositionMemento;
import com.applitools.eyes.positioning.PositionProvider;
import com.applitools.eyes.positioning.RegionProvider;
import com.applitools.eyes.scaling.FixedScaleProviderFactory;
import com.applitools.eyes.scaling.NullScaleProvider;
import com.applitools.eyes.selenium.Borders;
import com.applitools.eyes.selenium.ClassicRunner;
import com.applitools.eyes.selenium.ContextBasedScaleProviderFactory;
import com.applitools.eyes.selenium.EyesSeleniumUtils;
import com.applitools.eyes.selenium.IConfigurationGetter;
import com.applitools.eyes.selenium.IConfigurationSetter;
import com.applitools.eyes.selenium.ISeleniumConfigurationProvider;
import com.applitools.eyes.selenium.PositionProviderAndMemento;
import com.applitools.eyes.selenium.SeleniumJavaScriptExecutor;
import com.applitools.eyes.selenium.SizeAndBorders;
import com.applitools.eyes.selenium.StitchMode;
import com.applitools.eyes.selenium.capture.DomCapture;
import com.applitools.eyes.selenium.capture.EyesWebDriverScreenshot;
import com.applitools.eyes.selenium.capture.EyesWebDriverScreenshotFactory;
import com.applitools.eyes.selenium.capture.FullPageCaptureAlgorithm;
import com.applitools.eyes.selenium.capture.ImageProviderFactory;
import com.applitools.eyes.selenium.exceptions.EyesDriverOperationException;
import com.applitools.eyes.selenium.fluent.FrameLocator;
import com.applitools.eyes.selenium.fluent.IScrollRootElementContainer;
import com.applitools.eyes.selenium.fluent.ISeleniumCheckTarget;
import com.applitools.eyes.selenium.fluent.ISeleniumFrameCheckTarget;
import com.applitools.eyes.selenium.fluent.SeleniumCheckSettings;
import com.applitools.eyes.selenium.fluent.SimpleRegionByElement;
import com.applitools.eyes.selenium.fluent.Target;
import com.applitools.eyes.selenium.frames.Frame;
import com.applitools.eyes.selenium.frames.FrameChain;
import com.applitools.eyes.selenium.positioning.CssTranslatePositionProvider;
import com.applitools.eyes.selenium.positioning.ElementPositionProvider;
import com.applitools.eyes.selenium.positioning.ISeleniumPositionProvider;
import com.applitools.eyes.selenium.positioning.ImageRotation;
import com.applitools.eyes.selenium.positioning.RegionPositionCompensation;
import com.applitools.eyes.selenium.positioning.RegionPositionCompensationFactory;
import com.applitools.eyes.selenium.positioning.ScrollPositionProvider;
import com.applitools.eyes.selenium.positioning.ScrollPositionProviderFactory;
import com.applitools.eyes.selenium.regionVisibility.MoveToRegionVisibilityStrategy;
import com.applitools.eyes.selenium.regionVisibility.NopRegionVisibilityStrategy;
import com.applitools.eyes.selenium.regionVisibility.RegionVisibilityStrategy;
import com.applitools.eyes.selenium.wrappers.EyesRemoteWebElement;
import com.applitools.eyes.selenium.wrappers.EyesTargetLocator;
import com.applitools.eyes.selenium.wrappers.EyesWebDriver;
import com.applitools.eyes.triggers.MouseAction;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import com.applitools.utils.ImageUtils;
import com.applitools.utils.PropertyHandler;
import com.applitools.utils.ReadOnlyPropertyHandler;
import com.applitools.utils.SimplePropertyHandler;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;

public class SeleniumEyes
extends EyesBase {
    private FrameChain originalFC;
    private WebElement scrollRootElement;
    private PositionProvider currentFramePositionProvider;
    public static final double UNKNOWN_DEVICE_PIXEL_RATIO = 0.0;
    public static final double DEFAULT_DEVICE_PIXEL_RATIO = 1.0;
    private static final int USE_DEFAULT_MATCH_TIMEOUT = -1;
    private static final int RESPONSE_TIME_DEFAULT_DEADLINE = 10;
    private static final int RESPONSE_TIME_DEFAULT_DIFF_FROM_DEADLINE = 20;
    private EyesWebDriver driver;
    private boolean doNotGetTitle;
    public boolean checkFrameOrElement;
    private Region regionToCheck;
    private String originalOverflow;
    private ImageRotation rotation;
    private double devicePixelRatio;
    private PropertyHandler<RegionVisibilityStrategy> regionVisibilityStrategyHandler;
    private ElementPositionProvider elementPositionProvider;
    private SeleniumJavaScriptExecutor jsExecutor;
    private UserAgent userAgent;
    private ImageProvider imageProvider;
    private RegionPositionCompensation regionPositionCompensation;
    private WebElement targetElement;
    private PositionMemento positionMemento;
    private Region effectiveViewport;
    private EyesScreenshotFactory screenshotFactory;
    private String cachedAUTSessionId;
    private Region fullRegionToCheck;
    private ISeleniumConfigurationProvider configurationProvider;
    private boolean stitchContent;
    private ClassicRunner runner;

    public boolean shouldStitchContent() {
        return this.stitchContent;
    }

    public SeleniumEyes(ISeleniumConfigurationProvider configurationProvider, ClassicRunner runner) {
        this.configurationProvider = configurationProvider;
        this.checkFrameOrElement = false;
        this.doNotGetTitle = false;
        this.devicePixelRatio = 0.0;
        this.regionVisibilityStrategyHandler = new SimplePropertyHandler();
        this.regionVisibilityStrategyHandler.set((Object)new MoveToRegionVisibilityStrategy(this.logger));
        this.runner = runner != null ? runner : new ClassicRunner();
    }

    public String getBaseAgentId() {
        return "eyes.selenium.java/3.157.10";
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    public FrameChain getOriginalFC() {
        return this.originalFC;
    }

    public PositionProvider getCurrentFramePositionProvider() {
        return this.currentFramePositionProvider;
    }

    public Region getRegionToCheck() {
        return this.regionToCheck;
    }

    public void setRegionToCheck(Region regionToCheck) {
        this.regionToCheck = regionToCheck;
    }

    public void setScrollToRegion(boolean shouldScroll) {
        this.regionVisibilityStrategyHandler = shouldScroll ? new ReadOnlyPropertyHandler(this.logger, (Object)new MoveToRegionVisibilityStrategy(this.logger)) : new ReadOnlyPropertyHandler(this.logger, (Object)new NopRegionVisibilityStrategy(this.logger));
    }

    public boolean getScrollToRegion() {
        return !(this.regionVisibilityStrategyHandler.get() instanceof NopRegionVisibilityStrategy);
    }

    public ImageRotation getRotation() {
        return this.rotation;
    }

    public void setRotation(ImageRotation rotation) {
        this.rotation = rotation;
        if (this.driver != null) {
            this.driver.setRotation(rotation);
        }
    }

    public double getDevicePixelRatio() {
        return this.devicePixelRatio;
    }

    protected WebDriver open(WebDriver driver) throws EyesException {
        this.openLogger();
        this.cachedAUTSessionId = null;
        if (this.getIsDisabled()) {
            this.logger.verbose("Ignored");
            return driver;
        }
        this.initDriver(driver);
        this.screenshotFactory = new EyesWebDriverScreenshotFactory(this.logger, this.driver);
        this.ensureViewportSize();
        this.openBase();
        String uaString = this.sessionStartInfo.getEnvironment().getInferred();
        if (uaString != null) {
            if (uaString.startsWith("useragent:")) {
                uaString = uaString.substring(10);
            }
            this.userAgent = UserAgent.ParseUserAgentString((String)uaString, (boolean)true);
        }
        this.imageProvider = ImageProviderFactory.getImageProvider(this.userAgent, this, this.logger, this.driver);
        this.regionPositionCompensation = RegionPositionCompensationFactory.getRegionPositionCompensation(this.userAgent, this, this.logger);
        ArgumentGuard.notNull((Object)driver, (String)"driver");
        this.devicePixelRatio = 0.0;
        this.jsExecutor = new SeleniumJavaScriptExecutor(this.driver);
        this.driver.setRotation(this.rotation);
        return this.driver;
    }

    private void ensureViewportSize() {
        if (this.getConfigGetter().getViewportSize() == null) {
            this.getConfigSetter().setViewportSize(this.driver.getDefaultContentViewportSize());
        }
    }

    private void initDriver(WebDriver driver) {
        if (driver instanceof RemoteWebDriver) {
            this.driver = new EyesWebDriver(this.logger, this, (RemoteWebDriver)driver);
        } else if (driver instanceof EyesWebDriver) {
            this.driver = (EyesWebDriver)driver;
        } else {
            String errMsg = "Driver is not a RemoteWebDriver (" + driver.getClass().getName() + ")";
            this.logger.log(errMsg);
            throw new EyesException(errMsg);
        }
        if (EyesSeleniumUtils.isMobileDevice(driver)) {
            this.regionVisibilityStrategyHandler.set((Object)new NopRegionVisibilityStrategy(this.logger));
        }
    }

    public WebElement getScrollRootElement() {
        if (this.scrollRootElement == null) {
            this.scrollRootElement = this.driver.findElement(By.tagName((String)"html"));
        }
        return this.scrollRootElement;
    }

    private PositionProvider createPositionProvider() {
        return this.createPositionProvider(this.scrollRootElement);
    }

    private PositionProvider createPositionProvider(WebElement scrollRootElement) {
        StitchMode stitchMode = this.getConfigGetter().getStitchMode();
        this.logger.verbose("initializing position provider. stitchMode: " + stitchMode);
        switch (stitchMode) {
            case CSS: {
                return new CssTranslatePositionProvider(this.logger, this.jsExecutor, scrollRootElement);
            }
        }
        return ScrollPositionProviderFactory.getScrollPositionProvider(this.userAgent, this.logger, (IEyesJsExecutor)this.jsExecutor, scrollRootElement);
    }

    public void checkWindow() {
        this.checkWindow(null);
    }

    public void checkWindow(String tag) {
        this.check(tag, (ICheckSettings)Target.window());
    }

    public void checkWindow(int matchTimeout, String tag) {
        this.check(tag, (ICheckSettings)Target.window().timeout(matchTimeout));
    }

    public void check(ICheckSettings ... checkSettings) {
        boolean originalForceFPS;
        if (this.getIsDisabled()) {
            this.logger.log(String.format("check(ICheckSettings[%d]): Ignored", checkSettings.length));
            return;
        }
        Boolean forceFullPageScreenshot = this.getConfigGetter().getForceFullPageScreenshot();
        boolean bl = originalForceFPS = forceFullPageScreenshot == null ? false : forceFullPageScreenshot;
        if (checkSettings.length > 1) {
            this.getConfigSetter().setForceFullPageScreenshot(true);
        }
        this.logger.verbose(this.getConfigGetter().toString());
        Hashtable<Integer, GetRegion> getRegions = new Hashtable<Integer, GetRegion>();
        Hashtable<Integer, ICheckSettingsInternal> checkSettingsInternalDictionary = new Hashtable<Integer, ICheckSettingsInternal>();
        for (int i = 0; i < checkSettings.length; ++i) {
            ISeleniumCheckTarget seleniumCheckTarget;
            ICheckSettings settings = checkSettings[i];
            ICheckSettingsInternal checkSettingsInternal = (ICheckSettingsInternal)settings;
            ((Dictionary)checkSettingsInternalDictionary).put(i, checkSettingsInternal);
            Region targetRegion = checkSettingsInternal.getTargetRegion();
            if (targetRegion != null) {
                ((Dictionary)getRegions).put(i, (GetRegion)new SimpleRegionByRectangle(targetRegion));
                continue;
            }
            ISeleniumCheckTarget iSeleniumCheckTarget = seleniumCheckTarget = settings instanceof ISeleniumCheckTarget ? (ISeleniumCheckTarget)settings : null;
            if (seleniumCheckTarget == null) continue;
            WebElement targetElement = this.getTargetElement(seleniumCheckTarget);
            if (targetElement == null && seleniumCheckTarget.getFrameChain().size() == 1) {
                targetElement = this.getFrameElement(seleniumCheckTarget.getFrameChain().get(0));
            }
            if (targetElement == null) continue;
            ((Dictionary)getRegions).put(i, new SimpleRegionByElement(targetElement));
        }
        this.scrollRootElement = this.getScrollRootElement((IScrollRootElementContainer)checkSettings[0]);
        this.currentFramePositionProvider = null;
        this.setPositionProvider(this.createPositionProvider());
        this.matchRegions(getRegions, checkSettingsInternalDictionary, checkSettings);
        this.getConfigSetter().setForceFullPageScreenshot(originalForceFPS);
    }

    private void matchRegions(Dictionary<Integer, GetRegion> getRegions, Dictionary<Integer, ICheckSettingsInternal> checkSettingsInternalDictionary, ICheckSettings[] checkSettings) {
        boolean hasFrames;
        if (getRegions.size() == 0) {
            return;
        }
        this.originalFC = this.driver.getFrameChain().clone();
        Region bBox = this.findBoundingBox(getRegions, checkSettings);
        MatchWindowTask mwt = new MatchWindowTask(this.logger, this.serverConnector, this.runningSession, this.getConfigGetter().getMatchTimeout(), (EyesBase)this);
        ScaleProviderFactory scaleProviderFactory = this.updateScalingParams();
        FullPageCaptureAlgorithm algo = this.createFullPageCaptureAlgorithm(scaleProviderFactory);
        Object activeElement = null;
        if (this.getConfigGetter().getHideCaret()) {
            try {
                activeElement = this.driver.executeScript("var activeElement = document.activeElement; activeElement && activeElement.blur(); return activeElement;", new Object[0]);
            }
            catch (WebDriverException e) {
                this.logger.verbose("WARNING: Cannot hide caret! " + e.getMessage());
            }
        }
        Region region = Region.EMPTY;
        boolean bl = hasFrames = this.driver.getFrameChain().size() > 0;
        if (hasFrames) {
            region = new Region(bBox.getLocation(), ((EyesRemoteWebElement)this.scrollRootElement).getClientSize());
        } else {
            WebElement documentElement = this.driver.findElement(By.tagName((String)"html"));
            if (!this.scrollRootElement.equals(documentElement)) {
                EyesRemoteWebElement eyesScrollRootElement = this.scrollRootElement instanceof EyesRemoteWebElement ? (EyesRemoteWebElement)this.scrollRootElement : new EyesRemoteWebElement(this.logger, this.driver, this.scrollRootElement);
                Point location = eyesScrollRootElement.getLocation();
                SizeAndBorders sizeAndBorders = eyesScrollRootElement.getSizeAndBorders();
                region = new Region(location.getX() + sizeAndBorders.getBorders().getLeft(), location.getY() + sizeAndBorders.getBorders().getTop(), sizeAndBorders.getSize().getWidth(), sizeAndBorders.getSize().getHeight());
            }
        }
        region.intersect(this.effectiveViewport);
        this.markElementForLayoutRCA(null);
        BufferedImage screenshotImage = algo.getStitchedRegion(region, bBox, (PositionProvider)this.positionProviderHandler.get());
        this.debugScreenshotsProvider.save(screenshotImage, "original");
        EyesWebDriverScreenshot screenshot = new EyesWebDriverScreenshot(this.logger, this.driver, screenshotImage, EyesWebDriverScreenshot.ScreenshotType.VIEWPORT, Location.ZERO);
        for (int i = 0; i < checkSettings.length; ++i) {
            if (!((Hashtable)getRegions).containsKey(i)) continue;
            GetRegion getRegion = getRegions.get(i);
            ICheckSettingsInternal checkSettingsInternal = checkSettingsInternalDictionary.get(i);
            List<EyesScreenshot> subScreenshots = this.getSubScreenshots(hasFrames ? Region.EMPTY : bBox, screenshot, getRegion);
            this.matchRegion(checkSettingsInternal, mwt, subScreenshots);
        }
        if (this.getConfigGetter().getHideCaret() && activeElement != null) {
            try {
                this.driver.executeScript("arguments[0].focus();", activeElement);
            }
            catch (WebDriverException e) {
                this.logger.verbose("WARNING: Could not return focus to active element! " + e.getMessage());
            }
        }
        ((EyesTargetLocator)this.driver.switchTo()).frames(this.originalFC);
    }

    private List<EyesScreenshot> getSubScreenshots(Region bBox, EyesWebDriverScreenshot screenshot, GetRegion getRegion) {
        ArrayList<EyesScreenshot> subScreenshots = new ArrayList<EyesScreenshot>();
        for (Region r : getRegion.getRegions((EyesBase)this, (EyesScreenshot)screenshot)) {
            this.logger.verbose("original sub-region: " + r);
            r = r.offset(-bBox.getLeft(), -bBox.getTop());
            EyesWebDriverScreenshot subScreenshot = screenshot.getSubScreenshotForRegion(r, false);
            subScreenshots.add(subScreenshot);
        }
        return subScreenshots;
    }

    private void matchRegion(ICheckSettingsInternal checkSettingsInternal, MatchWindowTask mwt, List<EyesScreenshot> subScreenshots) {
        String name = checkSettingsInternal.getName();
        String source = this.driver.getCurrentUrl();
        for (EyesScreenshot subScreenshot : subScreenshots) {
            this.debugScreenshotsProvider.save(subScreenshot.getImage(), String.format("subscreenshot_%s", name));
            ImageMatchSettings ims = mwt.createImageMatchSettings(checkSettingsInternal, subScreenshot, (EyesBase)this);
            Location location = subScreenshot.getLocationInScreenshot(Location.ZERO, CoordinatesType.SCREENSHOT_AS_IS);
            AppOutput appOutput = new AppOutput(name, ImageUtils.base64FromImage((BufferedImage)subScreenshot.getImage()), null, null);
            AppOutputWithScreenshot appOutputWithScreenshot = new AppOutputWithScreenshot(appOutput, subScreenshot, location);
            MatchResult matchResult = mwt.performMatch(new ArrayList(), appOutputWithScreenshot, name, false, checkSettingsInternal, ims, (EyesBase)this, source);
            this.logger.verbose("matchResult.asExcepted: " + matchResult.getAsExpected());
        }
    }

    private Region findBoundingBox(Dictionary<Integer, GetRegion> getRegions, ICheckSettings[] checkSettings) {
        RectangleSize rectSize = this.getViewportSize();
        this.logger.verbose("rectSize: " + rectSize);
        EyesWebDriverScreenshot screenshot = new EyesWebDriverScreenshot(this.logger, this.driver, new BufferedImage(rectSize.getWidth(), rectSize.getHeight(), 1));
        return this.findBoundingBox(getRegions, checkSettings, screenshot);
    }

    private Region findBoundingBox(Dictionary<Integer, GetRegion> getRegions, ICheckSettings[] checkSettings, EyesScreenshot screenshot) {
        Region bBox = null;
        for (int i = 0; i < checkSettings.length; ++i) {
            GetRegion getRegion = getRegions.get(i);
            if (getRegion == null) continue;
            List regions = getRegion.getRegions((EyesBase)this, screenshot);
            for (Region region : regions) {
                if (bBox == null) {
                    bBox = new Region((IRegion)region);
                    continue;
                }
                bBox = bBox.expandToContain(region);
            }
        }
        Location offset = screenshot.getLocationInScreenshot(Location.ZERO, CoordinatesType.CONTEXT_AS_IS);
        return bBox.offset(offset.getX(), offset.getY());
    }

    private WebElement getFrameElement(FrameLocator frameLocator) {
        WebElement frameReference = frameLocator.getFrameReference();
        if (frameReference == null) {
            By selector = frameLocator.getFrameSelector();
            List<WebElement> possibleFrames = null;
            if (selector != null) {
                possibleFrames = this.driver.findElements(selector);
            } else {
                Integer frameIndex;
                String nameOrId = frameLocator.getFrameNameOrId();
                if (nameOrId != null && (possibleFrames = this.driver.findElementsById(nameOrId)).size() == 0 && (possibleFrames = this.driver.findElementsByName(nameOrId)).size() == 0 && (frameIndex = frameLocator.getFrameIndex()) != null) {
                    possibleFrames = this.driver.findElements(By.cssSelector((String)String.format("iframe:nth-of-type(%d)", frameIndex)));
                }
            }
            if (possibleFrames != null && possibleFrames.size() > 0) {
                frameReference = possibleFrames.get(0);
            }
        }
        return frameReference;
    }

    private WebElement getTargetElement(ISeleniumCheckTarget seleniumCheckTarget) {
        assert (seleniumCheckTarget != null);
        By targetSelector = seleniumCheckTarget.getTargetSelector();
        Object targetElement = seleniumCheckTarget.getTargetElement();
        if (targetElement == null && targetSelector != null) {
            targetElement = this.driver.findElement(targetSelector);
        } else if (targetElement != null && !(targetElement instanceof EyesRemoteWebElement)) {
            targetElement = new EyesRemoteWebElement(this.logger, this.driver, (WebElement)targetElement);
        }
        return targetElement;
    }

    public void check(String name, ICheckSettings checkSettings) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("check('%s', %s): Ignored", name, checkSettings));
            return;
        }
        ArgumentGuard.notNull((Object)checkSettings, (String)"checkSettings");
        if (name != null) {
            checkSettings = checkSettings.withName(name);
        }
        this.check(checkSettings);
    }

    public void setIsDisabled(boolean disabled) {
        super.setIsDisabled(disabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String tryCaptureDom() {
        String fullWindowDom = "";
        FrameChain fc = this.driver.getFrameChain().clone();
        try {
            Frame frame = fc.peek();
            WebElement scrollRootElement = null;
            if (frame != null) {
                scrollRootElement = frame.getScrollRootElement();
            }
            if (scrollRootElement == null) {
                scrollRootElement = this.driver.findElement(By.tagName((String)"html"));
            }
            ScrollPositionProvider positionProvider = ScrollPositionProviderFactory.getScrollPositionProvider(this.userAgent, this.logger, (IEyesJsExecutor)this.jsExecutor, scrollRootElement);
            DomCapture domCapture = new DomCapture(this);
            fullWindowDom = domCapture.getFullWindowDom(positionProvider);
        }
        catch (Exception e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
        }
        finally {
            ((EyesTargetLocator)this.driver.switchTo()).frames(fc);
        }
        return fullWindowDom;
    }

    public void check(ICheckSettings checkSettings) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("check(%s): Ignored", checkSettings));
            return;
        }
        ArgumentGuard.notNull((Object)checkSettings, (String)"checkSettings");
        ArgumentGuard.notOfType((Object)checkSettings, ISeleniumCheckTarget.class, (String)"checkSettings");
        this.logger.verbose(this.getConfigGetter().toString());
        ICheckSettingsInternal checkSettingsInternal = (ICheckSettingsInternal)checkSettings;
        ISeleniumCheckTarget seleniumCheckTarget = checkSettings instanceof ISeleniumCheckTarget ? (ISeleniumCheckTarget)checkSettings : null;
        String name = checkSettingsInternal.getName();
        this.logger.verbose(String.format("check(\"%s\", checkSettings) - begin", name));
        this.stitchContent = checkSettingsInternal.getStitchContent() == null ? false : checkSettingsInternal.getStitchContent();
        final Region targetRegion = checkSettingsInternal.getTargetRegion();
        this.scrollRootElement = this.getScrollRootElement(seleniumCheckTarget);
        this.currentFramePositionProvider = null;
        this.setPositionProvider(this.createPositionProvider());
        this.originalFC = this.driver.getFrameChain().clone();
        ValidationInfo validationInfo = this.fireValidationWillStartEvent(name);
        if (!EyesSeleniumUtils.isMobileDevice(this.driver)) {
            this.logger.verbose("URL: " + this.driver.getCurrentUrl());
        }
        int switchedToFrameCount = this.switchToFrame(seleniumCheckTarget);
        MatchResult result = null;
        EyesTargetLocator switchTo = null;
        String source = null;
        if (!EyesSeleniumUtils.isMobileDevice(this.driver)) {
            switchTo = (EyesTargetLocator)this.driver.switchTo();
            source = this.driver.getCurrentUrl();
        }
        FrameChain originalFC = this.tryHideScrollbars();
        if (targetRegion != null && switchedToFrameCount == 0) {
            this.logger.verbose("have target region");
            result = this.checkWindowBase(new RegionProvider(){

                public Region getRegion() {
                    return new Region(targetRegion.getLocation(), targetRegion.getSize(), CoordinatesType.CONTEXT_RELATIVE);
                }
            }, name, false, checkSettings, source);
        } else if (seleniumCheckTarget != null) {
            WebElement targetElement = this.getTargetElement(seleniumCheckTarget);
            if (targetElement != null) {
                this.logger.verbose("have target element");
                this.targetElement = targetElement;
                result = this.stitchContent ? this.checkElement(name, checkSettings, source) : this.checkRegion(name, checkSettings, source);
                this.targetElement = null;
            } else if (seleniumCheckTarget.getFrameChain().size() > 0) {
                this.logger.verbose("have frame chain");
                result = this.stitchContent ? this.checkFullFrameOrElement(name, checkSettings, source) : this.checkFrameFluent(name, checkSettings, source);
            } else {
                this.logger.verbose("default case");
                if (!EyesSeleniumUtils.isMobileDevice(this.driver)) {
                    switchTo.defaultContent();
                    this.currentFramePositionProvider = this.createPositionProvider(this.driver.findElement(By.tagName((String)"html")));
                }
                result = this.checkWindowBase(RegionProvider.NULL_INSTANCE, name, false, checkSettings, source);
                if (!EyesSeleniumUtils.isMobileDevice(this.driver)) {
                    switchTo.frames(this.originalFC);
                }
            }
        }
        if (result == null) {
            result = new MatchResult();
        }
        while (switchedToFrameCount > 0) {
            this.driver.switchTo().parentFrame();
            --switchedToFrameCount;
        }
        if (this.positionMemento != null) {
            ((PositionProvider)this.positionProviderHandler.get()).restoreState(this.positionMemento);
            this.positionMemento = null;
        }
        if (!EyesSeleniumUtils.isMobileDevice(this.driver)) {
            switchTo.resetScroll();
            if (originalFC != null) {
                this.tryRestoreScrollbars(originalFC);
            }
            this.trySwitchToFrames(this.driver, switchTo, this.originalFC);
        }
        this.stitchContent = false;
        ValidationResult validationResult = new ValidationResult();
        validationResult.setAsExpected(result.getAsExpected());
        this.getSessionEventHandlers().validationEnded(this.getAUTSessionId(), validationInfo.getValidationId(), validationResult);
        this.logger.verbose("check - done!");
    }

    protected MatchResult checkFrameFluent(String name, ICheckSettings checkSettings, String source) {
        FrameChain frameChain = this.driver.getFrameChain().clone();
        Frame targetFrame = frameChain.pop();
        this.targetElement = targetFrame.getReference();
        EyesTargetLocator switchTo = (EyesTargetLocator)this.driver.switchTo();
        switchTo.framesDoScroll(frameChain);
        MatchResult result = this.checkRegion(name, checkSettings, source);
        this.targetElement = null;
        return result;
    }

    private int switchToFrame(ISeleniumCheckTarget checkTarget) {
        if (checkTarget == null) {
            return 0;
        }
        List<FrameLocator> frameChain = checkTarget.getFrameChain();
        int switchedToFrameCount = 0;
        for (FrameLocator frameLocator : frameChain) {
            if (!this.switchToFrame(frameLocator)) continue;
            ++switchedToFrameCount;
        }
        return switchedToFrameCount;
    }

    private boolean switchToFrame(ISeleniumFrameCheckTarget frameTarget) {
        WebElement frameElement;
        WebDriver.TargetLocator switchTo = this.driver.switchTo();
        if (frameTarget.getFrameIndex() != null) {
            switchTo.frame(frameTarget.getFrameIndex().intValue());
            this.updateFrameScrollRoot(frameTarget);
            return true;
        }
        if (frameTarget.getFrameNameOrId() != null) {
            switchTo.frame(frameTarget.getFrameNameOrId());
            this.updateFrameScrollRoot(frameTarget);
            return true;
        }
        if (frameTarget.getFrameReference() != null) {
            switchTo.frame(frameTarget.getFrameReference());
            this.updateFrameScrollRoot(frameTarget);
            return true;
        }
        if (frameTarget.getFrameSelector() != null && (frameElement = this.driver.findElement(frameTarget.getFrameSelector())) != null) {
            switchTo.frame(frameElement);
            this.updateFrameScrollRoot(frameTarget);
            return true;
        }
        return false;
    }

    private void updateFrameScrollRoot(IScrollRootElementContainer frameTarget) {
        WebElement rootElement = this.getScrollRootElement(frameTarget);
        Frame frame = this.driver.getFrameChain().peek();
        frame.setScrollRootElement(rootElement);
    }

    private MatchResult checkFullFrameOrElement(String name, ICheckSettings checkSettings, String source) {
        this.checkFrameOrElement = true;
        this.logger.verbose("enter");
        MatchResult result = this.checkWindowBase(new RegionProvider(){

            public Region getRegion(ICheckSettingsInternal settings) {
                return SeleniumEyes.this.getFullFrameOrElementRegion(settings);
            }
        }, name, false, checkSettings, source);
        this.checkFrameOrElement = false;
        return result;
    }

    private Region getFullFrameOrElementRegion(ICheckSettingsInternal checkSettingsInternal) {
        Region targetRegion;
        this.logger.verbose("checkFrameOrElement: " + this.checkFrameOrElement);
        if (this.checkFrameOrElement) {
            ArrayList<PositionProviderAndMemento> ppams = new ArrayList<PositionProviderAndMemento>();
            FrameChain fc = this.ensureFrameVisible(ppams);
            ScaleProviderFactory scaleProviderFactory = this.updateScalingParams();
            BufferedImage screenshotImage = this.imageProvider.getImage();
            this.debugScreenshotsProvider.save(screenshotImage, "checkFullFrameOrElement");
            ScaleProvider scaleProvider = scaleProviderFactory.getScaleProvider(screenshotImage.getWidth());
            EyesTargetLocator switchTo = (EyesTargetLocator)this.driver.switchTo();
            switchTo.frames(fc);
            EyesWebDriverScreenshot screenshot = new EyesWebDriverScreenshot(this.logger, this.driver, screenshotImage);
            this.regionToCheck = screenshot.getFrameWindow();
            this.fullRegionToCheck = Region.EMPTY;
        }
        if ((targetRegion = checkSettingsInternal.getTargetRegion()) == null) {
            targetRegion = Region.EMPTY;
        }
        return targetRegion;
    }

    private FrameChain ensureFrameVisible(List<PositionProviderAndMemento> ppams) {
        this.logger.verbose("scrollRootElement_: " + this.scrollRootElement);
        FrameChain currentFC = this.driver.getFrameChain().clone();
        FrameChain fc = this.driver.getFrameChain().clone();
        this.driver.executeScript("window.scrollTo(0,0);", new Object[0]);
        while (fc.size() > 0) {
            this.logger.verbose("fc.Count: " + fc.size());
            EyesTargetLocator.parentFrame(this.logger, this.driver.getRemoteWebDriver().switchTo(), fc);
            this.driver.executeScript("window.scrollTo(0,0);", new Object[0]);
            Frame childFrame = fc.pop();
            Frame parentFrame = fc.peek();
            WebElement scrollRootElement = null;
            if (fc.size() == this.originalFC.size()) {
                this.logger.verbose("PositionProvider: " + this.getPositionProvider());
                this.positionMemento = this.getPositionProvider().getState();
                scrollRootElement = this.scrollRootElement;
                this.logger.verbose("scrollRootElement_:          " + scrollRootElement);
            } else {
                if (parentFrame != null) {
                    scrollRootElement = parentFrame.getScrollRootElement();
                }
                if (scrollRootElement == null) {
                    scrollRootElement = this.driver.findElement(By.tagName((String)"html"));
                }
            }
            if (childFrame != null) {
                this.logger.verbose("childFrame.Reference:         " + childFrame.getLocation());
                if (childFrame.getScrollRootElement() != null) {
                    this.logger.verbose("childFrame.ScrollRootElement: " + childFrame.getScrollRootElement());
                }
            }
            this.logger.verbose("scrollRootElement: " + scrollRootElement);
            PositionProvider positionProvider = this.getElementPositionProvider(scrollRootElement);
            PositionMemento positionMemento = positionProvider.getState();
            PositionProviderAndMemento ppam = new PositionProviderAndMemento(positionProvider, positionMemento, fc);
            ppams.add(ppam);
            positionProvider.setPosition(childFrame.getLocation());
            Region reg = new Region(Location.ZERO, childFrame.getInnerSize());
            this.effectiveViewport.intersect(reg);
        }
        ((EyesTargetLocator)this.driver.switchTo()).frames(currentFC);
        return currentFC;
    }

    private List<PositionProviderAndMemento> ensureElementVisible(WebElement element) {
        ArrayList<PositionProviderAndMemento> ppams = new ArrayList<PositionProviderAndMemento>();
        if (this.targetElement == null || !this.getScrollToRegion()) {
            return ppams;
        }
        if (EyesSeleniumUtils.isMobileDevice((WebDriver)this.driver.getRemoteWebDriver())) {
            this.logger.log("NATIVE context identified, skipping 'ensure element visible'");
            return ppams;
        }
        FrameChain originalFC = this.driver.getFrameChain().clone();
        EyesTargetLocator switchTo = (EyesTargetLocator)this.driver.switchTo();
        EyesRemoteWebElement eyesRemoteWebElement = new EyesRemoteWebElement(this.logger, this.driver, element);
        Region elementBounds = eyesRemoteWebElement.getBounds();
        Location currentFrameOffset = originalFC.getCurrentFrameOffset();
        elementBounds = elementBounds.offset(currentFrameOffset.getX(), currentFrameOffset.getY());
        Region viewportBounds = this.getViewportScrollBounds();
        this.logger.verbose("viewportBounds: " + viewportBounds + " ; elementBounds: " + elementBounds);
        if (!viewportBounds.contains(elementBounds)) {
            WebElement scrollRootElement;
            FrameChain fc;
            this.ensureFrameVisible(ppams);
            Point location = element.getLocation();
            Location elementLocation = new Location(location.getX(), location.getY());
            if (originalFC.size() > 0 && !element.equals(originalFC.peek().getReference())) {
                fc = originalFC;
                switchTo.frames(originalFC);
                scrollRootElement = this.getCurrentFrameScrollRootElement();
            } else {
                fc = this.driver.getFrameChain().clone();
                scrollRootElement = this.scrollRootElement;
            }
            PositionProvider positionProvider = this.getElementPositionProvider(scrollRootElement);
            PositionMemento positionMemento = positionProvider.getState();
            positionProvider.setPosition(elementLocation);
            ppams.add(new PositionProviderAndMemento(positionProvider, positionMemento, fc));
        }
        return ppams;
    }

    private Region getViewportScrollBounds() {
        Location location;
        if (!this.getScrollToRegion()) {
            this.logger.log("WARNING: no region visibility strategy! returning an empty region!");
            return Region.EMPTY;
        }
        FrameChain originalFrameChain = this.driver.getFrameChain().clone();
        EyesTargetLocator switchTo = (EyesTargetLocator)this.driver.switchTo();
        switchTo.frames(this.originalFC);
        ScrollPositionProvider spp = ScrollPositionProviderFactory.getScrollPositionProvider(this.userAgent, this.logger, (IEyesJsExecutor)this.jsExecutor, this.scrollRootElement);
        try {
            location = spp.getCurrentPosition();
        }
        catch (EyesDriverOperationException e) {
            this.logger.log("WARNING: " + e.getMessage());
            this.logger.log("Assuming position is 0,0");
            location = new Location(0, 0);
        }
        Region viewportBounds = new Region(location, this.getViewportSize());
        switchTo.frames(originalFrameChain);
        return viewportBounds;
    }

    private MatchResult checkRegion(String name, ICheckSettings checkSettings, String source) {
        MatchResult result = this.checkWindowBase(new RegionProvider(){

            public Region getRegion(ICheckSettingsInternal settings) {
                Region r;
                EyesRemoteWebElement eyesTargetElement = (EyesRemoteWebElement)SeleniumEyes.this.targetElement;
                Region rect = settings.getTargetRegion();
                if (rect == null) {
                    Rectangle bounds = EyesSeleniumUtils.isMobileDevice(SeleniumEyes.this.driver) ? eyesTargetElement.getRect() : eyesTargetElement.getBoundingClientRect();
                    r = new Region(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight(), CoordinatesType.CONTEXT_RELATIVE);
                } else {
                    SizeAndBorders sizeAndBorders = eyesTargetElement.getSizeAndBorders();
                    RectangleSize s = sizeAndBorders.getSize();
                    Borders b = sizeAndBorders.getBorders();
                    Point p = SeleniumEyes.this.targetElement.getLocation();
                    p = p.moveBy(b.getLeft(), b.getTop());
                    Region r2 = rect;
                    int x = p.getX() + r2.getLeft();
                    int y = p.getY() + r2.getTop();
                    int w = Math.min(p.getX() + s.getWidth(), r2.getRight()) - x;
                    int h = Math.min(p.getY() + s.getHeight(), r2.getBottom()) - y;
                    r = new Region(x, y, w, h, CoordinatesType.CONTEXT_RELATIVE);
                }
                return r;
            }
        }, name, false, checkSettings, source);
        this.logger.verbose("Done! trying to scroll back to original position.");
        return result;
    }

    protected ScaleProviderFactory updateScalingParams() {
        if (this.devicePixelRatio == 0.0 && this.scaleProviderHandler.get() instanceof NullScaleProvider) {
            ScaleProviderFactory factory;
            this.logger.verbose("Trying to extract device pixel ratio...");
            if (!EyesSeleniumUtils.isMobileDevice(this.driver)) {
                try {
                    this.devicePixelRatio = EyesSeleniumUtils.getDevicePixelRatio(this.jsExecutor);
                }
                catch (Exception e) {
                    this.logger.verbose("Failed to extract device pixel ratio! Using default.");
                    this.devicePixelRatio = 1.0;
                }
                this.logger.verbose("Setting web scale provider...");
                factory = this.getScaleProviderFactory();
            } else {
                this.logger.verbose("Native App");
                this.devicePixelRatio = 1.0;
                this.logger.verbose("Setting native app scale provider...");
                factory = new FixedScaleProviderFactory(this.logger, 1.0 / this.devicePixelRatio, this.scaleProviderHandler);
            }
            this.logger.verbose(String.format("Device pixel ratio: %f", this.devicePixelRatio));
            this.logger.verbose("Done!");
            return factory;
        }
        SimplePropertyHandler nullProvider = new SimplePropertyHandler();
        return new ScaleProviderIdentityFactory(this.logger, (ScaleProvider)this.scaleProviderHandler.get(), (PropertyHandler)nullProvider);
    }

    private ScaleProviderFactory getScaleProviderFactory() {
        WebElement element = this.driver.findElement(By.tagName((String)"html"));
        RectangleSize entireSize = EyesSeleniumUtils.getEntireElementSize(this.logger, this.jsExecutor, element);
        return new ContextBasedScaleProviderFactory(this.logger, entireSize, (RectangleSize)this.viewportSizeHandler.get(), this.devicePixelRatio, false, (PropertyHandler<ScaleProvider>)this.scaleProviderHandler);
    }

    public WebElement getCurrentFrameScrollRootElement() {
        FrameChain fc = this.driver.getFrameChain().clone();
        Frame currentFrame = fc.peek();
        WebElement scrollRootElement = null;
        if (currentFrame != null) {
            scrollRootElement = currentFrame.getScrollRootElement();
        }
        if (scrollRootElement == null && !EyesSeleniumUtils.isMobileDevice(this.driver) && (scrollRootElement = this.scrollRootElement) == null) {
            scrollRootElement = this.driver.findElement(By.tagName((String)"html"));
        }
        return scrollRootElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkCurrentFrame(int matchTimeout, String tag, String source) {
        try {
            this.logger.verbose(String.format("CheckCurrentFrame(%d, '%s')", matchTimeout, tag));
            this.checkFrameOrElement = true;
            this.logger.verbose("Getting screenshot as base64..");
            String screenshot64 = (String)this.driver.getScreenshotAs(OutputType.BASE64);
            this.logger.verbose("Done! Creating image object...");
            BufferedImage screenshotImage = ImageUtils.imageFromBase64((String)screenshot64);
            ScaleProvider scaleProvider = this.updateScalingParams().getScaleProvider(screenshotImage.getWidth());
            screenshotImage = ImageUtils.scaleImage((BufferedImage)screenshotImage, (ScaleProvider)scaleProvider);
            this.logger.verbose("Done! Building required object...");
            EyesWebDriverScreenshot screenshot = new EyesWebDriverScreenshot(this.logger, this.driver, screenshotImage);
            this.logger.verbose("Done!");
            this.logger.verbose("replacing regionToCheck");
            this.setRegionToCheck(screenshot.getFrameWindow());
            super.checkWindowBase(RegionProvider.NULL_INSTANCE, tag, false, matchTimeout, source);
        }
        finally {
            this.checkFrameOrElement = false;
            this.regionToCheck = null;
        }
    }

    public void checkFrame(String frameNameOrId) {
        this.check((String)null, (ICheckSettings)Target.frame(frameNameOrId));
    }

    public void checkFrame(String frameNameOrId, String tag) {
        this.check(tag, (ICheckSettings)Target.frame(frameNameOrId).fully());
    }

    public void checkFrame(String frameNameOrId, int matchTimeout, String tag) {
        this.check(tag, (ICheckSettings)Target.frame(frameNameOrId).timeout(matchTimeout).fully());
    }

    public void checkFrame(int frameIndex) {
        this.checkFrame(frameIndex, -1, null);
    }

    public void checkFrame(int frameIndex, String tag) {
        this.checkFrame(frameIndex, -1, tag);
    }

    public void checkFrame(int frameIndex, int matchTimeout, String tag) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("CheckFrame(%d, %d, '%s'): Ignored", frameIndex, matchTimeout, tag));
            return;
        }
        ArgumentGuard.greaterThanOrEqualToZero((long)frameIndex, (String)"frameIndex");
        this.logger.log(String.format("CheckFrame(%d, %d, '%s')", frameIndex, matchTimeout, tag));
        this.check(tag, (ICheckSettings)Target.frame(frameIndex).timeout(matchTimeout).fully());
    }

    public void checkFrame(WebElement frameReference) {
        this.checkFrame(frameReference, -1, null);
    }

    public void checkFrame(WebElement frameReference, String tag) {
        this.checkFrame(frameReference, -1, tag);
    }

    public void checkFrame(WebElement frameReference, int matchTimeout, String tag) {
        this.check(tag, (ICheckSettings)Target.frame(frameReference).timeout(matchTimeout));
    }

    public void checkFrame(String[] framePath, int matchTimeout, String tag) {
        SeleniumCheckSettings settings = Target.frame(framePath[0]);
        for (int i = 1; i < framePath.length; ++i) {
            settings.frame(framePath[i]);
        }
        this.check(tag, (ICheckSettings)settings.timeout(matchTimeout).fully());
    }

    public void checkRegionInFrame(String[] framePath, By selector, int matchTimeout, String tag, boolean stitchContent) {
        SeleniumCheckSettings settings = Target.frame(framePath[0]);
        for (int i = 1; i < framePath.length; ++i) {
            settings = settings.frame(framePath[i]);
        }
        this.check(tag, (ICheckSettings)settings.region(selector).timeout(matchTimeout).fully(stitchContent));
    }

    private MatchResult checkElement(String name, ICheckSettings checkSettings, String source) {
        return this.checkElement(this.targetElement, name, checkSettings, source);
    }

    private MatchResult checkElement(WebElement element, String name, ICheckSettings checkSettings, String source) {
        MatchResult result;
        EyesRemoteWebElement eyesElement = element instanceof EyesRemoteWebElement ? (EyesRemoteWebElement)element : new EyesRemoteWebElement(this.logger, this.driver, element);
        WebElement scrollRootElement = this.getCurrentFrameScrollRootElement();
        PositionProvider positionProvider = this.createPositionProvider(scrollRootElement);
        PositionMemento originalPositionMemento = positionProvider.getState();
        this.regionToCheck = Region.EMPTY;
        this.fullRegionToCheck = Region.EMPTY;
        if (scrollRootElement instanceof EyesRemoteWebElement) {
            EyesRemoteWebElement eyesRemoteWebElement = (EyesRemoteWebElement)scrollRootElement;
            eyesRemoteWebElement.setPositionProvider(positionProvider);
        }
        this.ensureElementVisible(this.targetElement);
        String originalOverflow = null;
        Point pl = eyesElement.getLocation();
        try {
            this.checkFrameOrElement = true;
            String displayStyle = eyesElement.getComputedStyle("display");
            if (this.getConfigGetter().getHideScrollbars()) {
                originalOverflow = eyesElement.getOverflow();
                eyesElement.setOverflow("hidden");
            }
            SizeAndBorders sizeAndBorders = eyesElement.getSizeAndBorders();
            Borders borderWidths = sizeAndBorders.getBorders();
            RectangleSize elementSize = sizeAndBorders.getSize();
            boolean useEntireSize = false;
            if (!"inline".equals(displayStyle) && elementSize.getHeight() <= this.effectiveViewport.getHeight() && elementSize.getWidth() <= this.effectiveViewport.getWidth()) {
                this.elementPositionProvider = new ElementPositionProvider(this.logger, this.driver, (WebElement)eyesElement);
                useEntireSize = true;
            } else {
                this.elementPositionProvider = null;
            }
            Region elementRegion = new Region(pl.getX() + borderWidths.getLeft(), pl.getY() + borderWidths.getTop(), elementSize.getWidth(), elementSize.getHeight(), CoordinatesType.SCREENSHOT_AS_IS);
            this.logger.verbose("Element region: " + elementRegion);
            this.regionToCheck = elementRegion;
            this.fullRegionToCheck = useEntireSize ? new Region(elementRegion.getLocation(), this.elementPositionProvider.getEntireSize()) : new Region(elementRegion.getLeft(), elementRegion.getTop(), elementRegion.getWidth(), elementRegion.getHeight());
            if (!this.effectiveViewport.isSizeEmpty()) {
                this.regionToCheck.intersect(this.effectiveViewport);
            }
            result = this.checkWindowBase(RegionProvider.NULL_INSTANCE, name, false, checkSettings, source);
            if (originalOverflow != null) {
                eyesElement.setOverflow(originalOverflow);
            }
            this.checkFrameOrElement = false;
        }
        catch (Exception ex) {
            try {
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)ex);
                throw ex;
            }
            catch (Throwable throwable) {
                if (originalOverflow != null) {
                    eyesElement.setOverflow(originalOverflow);
                }
                this.checkFrameOrElement = false;
                positionProvider.restoreState(originalPositionMemento);
                this.regionToCheck = null;
                this.elementPositionProvider = null;
                this.fullRegionToCheck = Region.EMPTY;
                throw throwable;
            }
        }
        positionProvider.restoreState(originalPositionMemento);
        this.regionToCheck = null;
        this.elementPositionProvider = null;
        this.fullRegionToCheck = Region.EMPTY;
        return result;
    }

    public void checkElement(WebElement element, int matchTimeout, String tag) {
        this.check(tag, (ICheckSettings)Target.region(element).timeout(matchTimeout).fully());
    }

    public void checkElement(By selector) {
        this.check((String)null, (ICheckSettings)Target.region(selector).fully());
    }

    public void checkElement(By selector, String tag) {
        this.check(tag, (ICheckSettings)Target.region(selector).fully());
    }

    public void checkElement(By selector, int matchTimeout, String tag) {
        this.check(tag, (ICheckSettings)Target.region(selector).timeout(matchTimeout).fully());
    }

    public void addMouseTrigger(MouseAction action, Region control, Location cursor) {
        if (this.getIsDisabled()) {
            this.logger.verbose(String.format("Ignoring %s (disabled)", action));
            return;
        }
        if (this.lastScreenshot == null) {
            this.logger.verbose(String.format("Ignoring %s (no screenshot)", action));
            return;
        }
        if (!FrameChain.isSameFrameChain(this.driver.getFrameChain(), ((EyesWebDriverScreenshot)this.lastScreenshot).getFrameChain())) {
            this.logger.verbose(String.format("Ignoring %s (different frame)", action));
            return;
        }
        this.addMouseTriggerBase(action, control, cursor);
    }

    public void addMouseTrigger(MouseAction action, WebElement element) {
        if (this.getIsDisabled()) {
            this.logger.verbose(String.format("Ignoring %s (disabled)", action));
            return;
        }
        ArgumentGuard.notNull((Object)element, (String)"element");
        Point pl = element.getLocation();
        Dimension ds = element.getSize();
        Region elementRegion = new Region(pl.getX(), pl.getY(), ds.getWidth(), ds.getHeight());
        if (this.lastScreenshot == null) {
            this.logger.verbose(String.format("Ignoring %s (no screenshot)", action));
            return;
        }
        if (!FrameChain.isSameFrameChain(this.driver.getFrameChain(), ((EyesWebDriverScreenshot)this.lastScreenshot).getFrameChain())) {
            this.logger.verbose(String.format("Ignoring %s (different frame)", action));
            return;
        }
        elementRegion = this.lastScreenshot.getIntersectedRegion(elementRegion, CoordinatesType.CONTEXT_RELATIVE);
        this.addMouseTriggerBase(action, elementRegion, elementRegion.getMiddleOffset());
    }

    public void addTextTrigger(Region control, String text) {
        if (this.getIsDisabled()) {
            this.logger.verbose(String.format("Ignoring '%s' (disabled)", text));
            return;
        }
        if (this.lastScreenshot == null) {
            this.logger.verbose(String.format("Ignoring '%s' (no screenshot)", text));
            return;
        }
        if (!FrameChain.isSameFrameChain(this.driver.getFrameChain(), ((EyesWebDriverScreenshot)this.lastScreenshot).getFrameChain())) {
            this.logger.verbose(String.format("Ignoring '%s' (different frame)", text));
            return;
        }
        this.addTextTriggerBase(control, text);
    }

    public void addTextTrigger(WebElement element, String text) {
        if (this.getIsDisabled()) {
            this.logger.verbose(String.format("Ignoring '%s' (disabled)", text));
            return;
        }
        ArgumentGuard.notNull((Object)element, (String)"element");
        Point pl = element.getLocation();
        Dimension ds = element.getSize();
        Region elementRegion = new Region(pl.getX(), pl.getY(), ds.getWidth(), ds.getHeight());
        this.addTextTrigger(elementRegion, text);
    }

    public RectangleSize getViewportSize() {
        RectangleSize viewportSize = (RectangleSize)this.viewportSizeHandler.get();
        if (viewportSize == null) {
            viewportSize = this.driver.getDefaultContentViewportSize();
        }
        return viewportSize;
    }

    static RectangleSize getViewportSize(WebDriver driver) {
        ArgumentGuard.notNull((Object)driver, (String)"driver");
        return EyesSeleniumUtils.getViewportSizeOrDisplaySize(new Logger(), driver);
    }

    protected IConfigurationSetter setViewportSize(RectangleSize size) {
        if (this.viewportSizeHandler instanceof ReadOnlyPropertyHandler) {
            this.logger.verbose("Ignored (viewport size given explicitly)");
            return this.getConfigSetter();
        }
        if (!EyesSeleniumUtils.isMobileDevice(this.driver)) {
            FrameChain originalFrame = this.driver.getFrameChain();
            this.driver.switchTo().defaultContent();
            try {
                EyesSeleniumUtils.setViewportSize(this.logger, this.driver, size);
                this.effectiveViewport = new Region(Location.ZERO, size);
            }
            catch (EyesException e1) {
                ((EyesTargetLocator)this.driver.switchTo()).frames(originalFrame);
                throw new TestFailedException("Failed to set the viewport size", (Throwable)e1);
            }
            ((EyesTargetLocator)this.driver.switchTo()).frames(originalFrame);
        }
        this.viewportSizeHandler.set((Object)new RectangleSize(size.getWidth(), size.getHeight()));
        return this.getConfigSetter();
    }

    static void setViewportSize(WebDriver driver, RectangleSize size) {
        ArgumentGuard.notNull((Object)driver, (String)"driver");
        EyesSeleniumUtils.setViewportSize(new Logger(), driver, size);
    }

    protected void beforeOpen() {
    }

    private void trySwitchToFrames(WebDriver driver, EyesTargetLocator switchTo, FrameChain frames) {
        if (EyesSeleniumUtils.isMobileDevice(driver)) {
            return;
        }
        try {
            switchTo.frames(frames);
        }
        catch (WebDriverException e) {
            this.logger.log("WARNING: Failed to switch to original frame chain! " + e.getMessage());
        }
    }

    private FrameChain tryHideScrollbars() {
        if (EyesSeleniumUtils.isMobileDevice(this.driver)) {
            return new FrameChain(this.logger);
        }
        if (this.getConfigGetter().getHideScrollbars() || this.getConfigGetter().getStitchMode() == StitchMode.CSS && this.stitchContent) {
            FrameChain originalFC = this.driver.getFrameChain().clone();
            FrameChain fc = this.driver.getFrameChain().clone();
            Frame frame = fc.peek();
            if (fc.size() > 0) {
                while (fc.size() > 0) {
                    this.logger.verbose("fc.Count = " + fc.size());
                    if (this.stitchContent || fc.size() != originalFC.size()) {
                        if (frame != null) {
                            frame.hideScrollbars(this.driver);
                        } else {
                            this.logger.verbose("hiding scrollbars of element (1): " + this.scrollRootElement);
                            EyesSeleniumUtils.setOverflow(this.driver, "hidden", this.scrollRootElement);
                        }
                    }
                    this.driver.switchTo().parentFrame();
                    fc.pop();
                    frame = fc.peek();
                }
            } else {
                this.logger.verbose("hiding scrollbars of element (2): " + this.scrollRootElement);
                this.originalOverflow = EyesSeleniumUtils.setOverflow(this.driver, "hidden", this.scrollRootElement);
            }
            this.logger.verbose("switching back to original frame");
            ((EyesTargetLocator)this.driver.switchTo()).frames(originalFC);
            this.logger.verbose("done hiding scrollbars.");
            return originalFC;
        }
        return new FrameChain(this.logger);
    }

    private void tryRestoreScrollbars(FrameChain frameChain) {
        if (EyesSeleniumUtils.isMobileDevice(this.driver)) {
            return;
        }
        if (this.getConfigGetter().getHideScrollbars() || this.getConfigGetter().getStitchMode() == StitchMode.CSS && this.stitchContent) {
            ((EyesTargetLocator)this.driver.switchTo()).frames(frameChain);
            FrameChain originalFC = frameChain.clone();
            FrameChain fc = frameChain.clone();
            if (fc.size() > 0) {
                while (fc.size() > 0) {
                    Frame frame = fc.pop();
                    frame.returnToOriginalOverflow(this.driver);
                    EyesTargetLocator.parentFrame(this.logger, this.driver.getRemoteWebDriver().switchTo(), fc);
                }
            } else {
                this.logger.verbose("returning overflow of element to its original value: " + this.scrollRootElement);
                EyesSeleniumUtils.setOverflow(this.driver, this.originalOverflow, this.scrollRootElement);
            }
            ((EyesTargetLocator)this.driver.switchTo()).frames(originalFC);
            this.logger.verbose("done restoring scrollbars.");
        } else {
            this.logger.verbose("no need to restore scrollbars.");
        }
        this.driver.getFrameChain().clear();
    }

    protected EyesScreenshot getSubScreenshot(EyesScreenshot screenshot, Region region, ICheckSettingsInternal checkSettingsInternal) {
        ISeleniumCheckTarget seleniumCheckTarget = checkSettingsInternal instanceof ISeleniumCheckTarget ? (ISeleniumCheckTarget)checkSettingsInternal : null;
        this.logger.verbose("original region: " + region);
        region = this.regionPositionCompensation.compensateRegionPosition(region, this.devicePixelRatio);
        this.logger.verbose("compensated region: " + region);
        if (seleniumCheckTarget == null) {
            return screenshot.getSubScreenshot(region, false);
        }
        if (seleniumCheckTarget.getFrameChain().size() > 0) {
            return screenshot.getSubScreenshot(region, false);
        }
        return ((EyesWebDriverScreenshot)screenshot).getSubScreenshotForRegion(region, false);
    }

    protected EyesScreenshot getScreenshot(ICheckSettingsInternal checkSettingsInternal) {
        Boolean forceFullPageScreenshot;
        ScaleProviderFactory scaleProviderFactory = this.updateScalingParams();
        FrameChain originalFrameChain = this.driver.getFrameChain().clone();
        PositionProvider positionProvider = (PositionProvider)this.positionProviderHandler.get();
        EyesTargetLocator switchTo = null;
        PositionMemento originalPosition = null;
        boolean isMobileDevice = EyesSeleniumUtils.isMobileDevice(this.driver);
        if (!isMobileDevice) {
            switchTo = (EyesTargetLocator)this.driver.switchTo();
            switchTo.frames(this.originalFC);
            if (positionProvider != null) {
                originalPosition = positionProvider.getState();
            }
            switchTo.frames(originalFrameChain);
        }
        Object activeElement = null;
        if (this.getConfigGetter().getHideCaret() && !isMobileDevice) {
            activeElement = this.driver.executeScript("var activeElement = document.activeElement; activeElement && activeElement.blur(); return activeElement;", new Object[0]);
        }
        if ((forceFullPageScreenshot = this.getConfigGetter().getForceFullPageScreenshot()) == null) {
            forceFullPageScreenshot = false;
        }
        EyesWebDriverScreenshot result = this.checkFrameOrElement && !isMobileDevice ? this.getFrameOrElementScreenshot(scaleProviderFactory, originalFrameChain, switchTo) : ((forceFullPageScreenshot != false || this.stitchContent) && !isMobileDevice ? this.getFullPageScreenshot(scaleProviderFactory, originalFrameChain, switchTo) : this.getElementScreenshot(scaleProviderFactory, switchTo));
        if (this.getConfigGetter().getHideCaret() && activeElement != null) {
            switchTo.frames(originalFrameChain);
            this.driver.executeScript("arguments[0].focus();", activeElement);
        }
        if (!isMobileDevice) {
            result.setDomUrl(this.tryCaptureAndPostDom(checkSettingsInternal));
            switchTo.frames(this.originalFC);
            if (positionProvider != null) {
                positionProvider.restoreState(originalPosition);
            }
            switchTo.frames(originalFrameChain);
        }
        return result;
    }

    private EyesWebDriverScreenshot getFrameOrElementScreenshot(ScaleProviderFactory scaleProviderFactory, FrameChain originalFrameChain, EyesTargetLocator switchTo) {
        FullPageCaptureAlgorithm algo = this.createFullPageCaptureAlgorithm(scaleProviderFactory);
        this.logger.verbose("Check frame/element requested");
        switchTo.frames(originalFrameChain);
        ElementPositionProvider positionProvider = this.elementPositionProvider;
        WebElement scrollRootElement = this.getCurrentFrameScrollRootElement();
        if (positionProvider == null) {
            positionProvider = this.getElementPositionProvider(scrollRootElement);
        }
        if (positionProvider instanceof ISeleniumPositionProvider) {
            this.jsExecutor.executeScript("var e = arguments[0]; if (e != null) e.setAttribute('data-applitools-scroll','true');", ((ISeleniumPositionProvider)positionProvider).getScrolledElement());
        }
        BufferedImage entireFrameOrElement = algo.getStitchedRegion(this.regionToCheck, this.fullRegionToCheck, positionProvider);
        this.logger.verbose("Building screenshot object...");
        RectangleSize size = new RectangleSize(entireFrameOrElement.getWidth(), entireFrameOrElement.getHeight());
        EyesWebDriverScreenshot result = new EyesWebDriverScreenshot(this.logger, this.driver, entireFrameOrElement, size);
        return result;
    }

    private EyesWebDriverScreenshot getFullPageScreenshot(ScaleProviderFactory scaleProviderFactory, FrameChain originalFrameChain, EyesTargetLocator switchTo) {
        this.logger.verbose("ForceFullPageScreenshot || stitchContent_ - enter");
        Location originalFramePosition = originalFrameChain.size() > 0 ? originalFrameChain.getDefaultContentScrollPosition() : Location.ZERO;
        switchTo.frames(this.originalFC);
        FullPageCaptureAlgorithm algo = this.createFullPageCaptureAlgorithm(scaleProviderFactory);
        EyesRemoteWebElement eyesScrollRootElement = this.scrollRootElement instanceof EyesRemoteWebElement ? (EyesRemoteWebElement)this.scrollRootElement : new EyesRemoteWebElement(this.logger, this.driver, this.scrollRootElement);
        WebElement scrollRootElement = this.getCurrentFrameScrollRootElement();
        ScrollPositionProvider originProvider = new ScrollPositionProvider(this.logger, this.jsExecutor, scrollRootElement);
        this.logger.verbose("resetting originProvider location");
        originProvider.setPosition(Location.ZERO);
        Point location = eyesScrollRootElement.getLocation();
        SizeAndBorders sizeAndBorders = eyesScrollRootElement.getSizeAndBorders();
        Region region = new Region(location.getX() + sizeAndBorders.getBorders().getLeft(), location.getY() + sizeAndBorders.getBorders().getTop(), sizeAndBorders.getSize().getWidth(), sizeAndBorders.getSize().getHeight());
        PositionProvider positionProvider = (PositionProvider)this.positionProviderHandler.get();
        if (positionProvider instanceof ISeleniumPositionProvider) {
            this.jsExecutor.executeScript("var e = arguments[0]; if (e != null) e.setAttribute('data-applitools-scroll','true');", ((ISeleniumPositionProvider)positionProvider).getScrolledElement());
        }
        BufferedImage fullPageImage = algo.getStitchedRegion(region, Region.EMPTY, positionProvider);
        switchTo.frames(originalFrameChain);
        EyesWebDriverScreenshot result = new EyesWebDriverScreenshot(this.logger, this.driver, fullPageImage, null, originalFramePosition);
        return result;
    }

    private EyesWebDriverScreenshot getElementScreenshot(ScaleProviderFactory scaleProviderFactory, EyesTargetLocator switchTo) {
        List<PositionProviderAndMemento> ppams = null;
        if (switchTo != null) {
            ppams = this.ensureElementVisible(this.targetElement);
        }
        try {
            Thread.sleep(this.getWaitBeforeScreenshots());
        }
        catch (InterruptedException e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
        }
        EyesWebDriverScreenshot result = this.getScaledAndCroppedScreenshot(scaleProviderFactory);
        if (switchTo != null) {
            for (int i = ppams.size() - 1; i >= 0; --i) {
                PositionProviderAndMemento ppam = ppams.get(i);
                switchTo.frames(ppam.getFrames());
                ppam.restoreState();
            }
        }
        return result;
    }

    private EyesWebDriverScreenshot getScaledAndCroppedScreenshot(ScaleProviderFactory scaleProviderFactory) {
        BufferedImage screenshotImage = this.imageProvider.getImage();
        ScaleProvider scaleProvider = scaleProviderFactory.getScaleProvider(screenshotImage.getWidth());
        CutProvider cutProvider = (CutProvider)this.cutProviderHandler.get();
        if (scaleProvider.getScaleRatio() != 1.0) {
            BufferedImage scaledImage;
            screenshotImage = scaledImage = ImageUtils.scaleImage((BufferedImage)screenshotImage, (ScaleProvider)scaleProvider);
            this.debugScreenshotsProvider.save(screenshotImage, "scaled");
            cutProvider.scale(scaleProvider.getScaleRatio());
        }
        if (!(cutProvider instanceof NullCutProvider)) {
            BufferedImage croppedImage;
            screenshotImage = croppedImage = cutProvider.cut(screenshotImage);
            this.debugScreenshotsProvider.save(screenshotImage, "cut");
        }
        EyesWebDriverScreenshot result = new EyesWebDriverScreenshot(this.logger, this.driver, screenshotImage);
        return result;
    }

    private long getWaitBeforeScreenshots() {
        return this.getConfigGetter().getWaitBeforeScreenshots();
    }

    private void markElementForLayoutRCA(PositionProvider elemPositionProvider) {
        ISeleniumPositionProvider positionProvider = elemPositionProvider != null ? (ISeleniumPositionProvider)elemPositionProvider : (ISeleniumPositionProvider)this.getPositionProvider();
        WebElement scrolledElement = positionProvider.getScrolledElement();
        if (scrolledElement != null) {
            try {
                this.jsExecutor.executeScript("var e = arguments[0]; if (e != null) e.setAttribute('data-applitools-scroll','true');", scrolledElement);
            }
            catch (Exception e) {
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
            }
        }
    }

    private FullPageCaptureAlgorithm createFullPageCaptureAlgorithm(ScaleProviderFactory scaleProviderFactory) {
        WebElement scrollRootElement = this.getCurrentFrameScrollRootElement();
        ScrollPositionProvider originProvider = ScrollPositionProviderFactory.getScrollPositionProvider(this.userAgent, this.logger, (IEyesJsExecutor)this.jsExecutor, scrollRootElement);
        return new FullPageCaptureAlgorithm(this.logger, this.regionPositionCompensation, this.getConfigGetter().getWaitBeforeScreenshots(), this.debugScreenshotsProvider, this.screenshotFactory, originProvider, scaleProviderFactory, (CutProvider)this.cutProviderHandler.get(), this.getConfigGetter().getStitchOverlap(), this.imageProvider);
    }

    protected String getTitle() {
        if (!this.doNotGetTitle && !EyesSeleniumUtils.isMobileDevice(this.driver)) {
            try {
                return this.driver.getTitle();
            }
            catch (Exception ex) {
                this.logger.verbose("failed (" + ex.getMessage() + ")");
                this.doNotGetTitle = true;
            }
        }
        return "";
    }

    protected String getInferredEnvironment() {
        String userAgent = this.driver.getUserAgent();
        if (userAgent != null) {
            return "useragent:" + userAgent;
        }
        return null;
    }

    protected AppEnvironment getAppEnvironment() {
        AppEnvironment appEnv = super.getAppEnvironment();
        RemoteWebDriver underlyingDriver = this.driver.getRemoteWebDriver();
        if (appEnv.getOs() == null) {
            this.logger.log("No OS set, checking for mobile OS...");
            if (EyesSeleniumUtils.isMobileDevice((WebDriver)underlyingDriver)) {
                String platformName = null;
                this.logger.log("Mobile device detected! Checking device type..");
                if (EyesSeleniumUtils.isAndroid((WebDriver)underlyingDriver)) {
                    this.logger.log("Android detected.");
                    platformName = "Android";
                } else if (EyesSeleniumUtils.isIOS((WebDriver)underlyingDriver)) {
                    this.logger.log("iOS detected.");
                    platformName = "iOS";
                } else {
                    this.logger.log("Unknown device type.");
                }
                if (platformName != null) {
                    String majorVersion;
                    String os = platformName;
                    String platformVersion = EyesSeleniumUtils.getPlatformVersion((HasCapabilities)underlyingDriver);
                    if (platformVersion != null && !(majorVersion = platformVersion.split("\\.", 2)[0]).isEmpty()) {
                        os = os + " " + majorVersion;
                    }
                    this.logger.verbose("Setting OS: " + os);
                    appEnv.setOs(os);
                }
            } else {
                this.logger.log("No mobile OS detected.");
            }
        }
        this.logger.log("Done!");
        return appEnv;
    }

    private WebElement getScrollRootElement(IScrollRootElementContainer scrollRootElementContainer) {
        WebElement scrollRootElement = null;
        if (!EyesSeleniumUtils.isMobileDevice(this.driver)) {
            if (scrollRootElementContainer == null) {
                scrollRootElement = this.driver.findElement(By.tagName((String)"html"));
            } else {
                scrollRootElement = scrollRootElementContainer.getScrollRootElement();
                if (scrollRootElement == null) {
                    By scrollRootSelector = scrollRootElementContainer.getScrollRootSelector();
                    scrollRootElement = this.driver.findElement(scrollRootSelector != null ? scrollRootSelector : By.tagName((String)"html"));
                }
            }
        }
        return scrollRootElement;
    }

    private PositionProvider getElementPositionProvider(WebElement scrollRootElement) {
        PositionProvider positionProvider = ((EyesRemoteWebElement)scrollRootElement).getPositionProvider();
        if (positionProvider == null) {
            positionProvider = this.createPositionProvider(scrollRootElement);
            ((EyesRemoteWebElement)scrollRootElement).setPositionProvider(positionProvider);
        }
        this.logger.verbose("position provider: " + positionProvider);
        this.currentFramePositionProvider = positionProvider;
        return positionProvider;
    }

    protected String getAUTSessionId() {
        try {
            if (this.cachedAUTSessionId == null) {
                this.cachedAUTSessionId = this.driver.getRemoteWebDriver().getSessionId().toString();
            }
            return this.cachedAUTSessionId;
        }
        catch (Exception e) {
            this.logger.log("WARNING: Failed to get AUT session ID! (maybe driver is not available?). Error: " + e.getMessage());
            return "";
        }
    }

    public TestResults close(boolean throwEx) {
        TestResults results;
        block5: {
            results = null;
            try {
                results = super.close(throwEx);
            }
            finally {
                if (this.runner != null) {
                }
                break block5;
            }
            this.runner.aggregateResult(results);
        }
        this.cachedAUTSessionId = null;
        return results;
    }

    public Object getAgentSetup() {
        return new EyesSeleniumAgentSetup();
    }

    public IServerConnector getServerConnector() {
        return this.serverConnector;
    }

    public Boolean isSendDom() {
        return !EyesSeleniumUtils.isMobileDevice(this.driver) && super.isSendDom() != false;
    }

    public IConfigurationGetter getConfigGetter() {
        return this.configurationProvider.get();
    }

    protected IConfigurationSetter getConfigSetter() {
        return this.configurationProvider.set();
    }

    class EyesSeleniumAgentSetup {
        private RemoteWebDriver remoteWebDriver;

        public EyesSeleniumAgentSetup() {
            this.remoteWebDriver = SeleniumEyes.this.driver.getRemoteWebDriver();
        }

        public String getSeleniumSessionId() {
            return this.remoteWebDriver.getSessionId().toString();
        }

        public WebDriverInfo getWebDriver() {
            return new WebDriverInfo();
        }

        public double getDevicePixelRatio() {
            return SeleniumEyes.this.getDevicePixelRatio();
        }

        public String getCutProvider() {
            return ((CutProvider)SeleniumEyes.this.cutProviderHandler.get()).getClass().getName();
        }

        public String getScaleProvider() {
            return ((ScaleProvider)SeleniumEyes.this.scaleProviderHandler.get()).getClass().getName();
        }

        public StitchMode getStitchMode() {
            return SeleniumEyes.this.getConfigGetter().getStitchMode();
        }

        public boolean getHideScrollbars() {
            return SeleniumEyes.this.getConfigGetter().getHideScrollbars();
        }

        public boolean getForceFullPageScreenshot() {
            Boolean forceFullPageScreenshot = SeleniumEyes.this.getConfigGetter().getForceFullPageScreenshot();
            if (forceFullPageScreenshot == null) {
                return false;
            }
            return forceFullPageScreenshot;
        }

        class WebDriverInfo {
            WebDriverInfo() {
            }

            public String getName() {
                return EyesSeleniumAgentSetup.this.remoteWebDriver.getClass().getName();
            }

            public Capabilities getCapabilities() {
                return EyesSeleniumAgentSetup.this.remoteWebDriver.getCapabilities();
            }
        }
    }

    public static interface WebDriverAction {
        public void drive(WebDriver var1);
    }
}

