/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.capture;

import com.applitools.eyes.CoordinatesType;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.IEyesJsExecutor;
import com.applitools.eyes.IRegion;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.OutOfBoundsException;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.exceptions.CoordinatesTypeConversionException;
import com.applitools.eyes.positioning.PositionProvider;
import com.applitools.eyes.selenium.EyesSeleniumUtils;
import com.applitools.eyes.selenium.SeleniumEyes;
import com.applitools.eyes.selenium.SeleniumJavaScriptExecutor;
import com.applitools.eyes.selenium.frames.Frame;
import com.applitools.eyes.selenium.frames.FrameChain;
import com.applitools.eyes.selenium.positioning.ScrollPositionProvider;
import com.applitools.eyes.selenium.positioning.ScrollPositionProviderFactory;
import com.applitools.eyes.selenium.wrappers.EyesTargetLocator;
import com.applitools.eyes.selenium.wrappers.EyesWebDriver;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.ImageUtils;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebElement;

public class EyesWebDriverScreenshot
extends EyesScreenshot {
    private final EyesWebDriver driver;
    private final FrameChain frameChain;
    private final Location currentFrameScrollPosition;
    private final ScreenshotType screenshotType;
    private Location frameLocationInScreenshot;
    private final Region frameWindow;

    private static Location getDefaultContentScrollPosition(Logger logger, FrameChain currentFrames, EyesWebDriver driver) {
        Location defaultContentScrollPosition;
        SeleniumJavaScriptExecutor jsExecutor = new SeleniumJavaScriptExecutor(driver);
        if (currentFrames.size() == 0) {
            defaultContentScrollPosition = EyesWebDriverScreenshot.getDefaultContentScrollPosition(logger, driver, jsExecutor);
        } else {
            FrameChain originalFC = new FrameChain(logger, currentFrames);
            EyesTargetLocator switchTo = (EyesTargetLocator)driver.switchTo();
            FrameChain currentFC = driver.getEyes().getOriginalFC();
            switchTo.frames(currentFC);
            defaultContentScrollPosition = EyesWebDriverScreenshot.getDefaultContentScrollPosition(logger, driver, jsExecutor);
            switchTo.frames(originalFC);
        }
        return defaultContentScrollPosition;
    }

    private static Location getDefaultContentScrollPosition(Logger logger, EyesWebDriver driver, IEyesJsExecutor jsExecutor) {
        WebElement scrollRootElement = driver.getEyes().getCurrentFrameScrollRootElement();
        ScrollPositionProvider positionProvider = ScrollPositionProviderFactory.getScrollPositionProvider(driver.getUserAgent(), logger, jsExecutor, scrollRootElement);
        return positionProvider.getCurrentPosition();
    }

    public static Location calcFrameLocationInScreenshot(Logger logger, EyesWebDriver driver, FrameChain frameChain, ScreenshotType screenshotType) {
        Location windowScroll = EyesWebDriverScreenshot.getDefaultContentScrollPosition(logger, frameChain, driver);
        logger.verbose("windowScroll: " + windowScroll);
        logger.verbose("Getting first frame...");
        Iterator<Frame> frameIterator = frameChain.iterator();
        Frame firstFrame = frameIterator.next();
        Location locationInScreenshot = new Location(firstFrame.getLocation());
        logger.verbose("Done! locationInScreenshot: " + locationInScreenshot);
        if (screenshotType == ScreenshotType.VIEWPORT) {
            locationInScreenshot = locationInScreenshot.offset(-windowScroll.getX(), -windowScroll.getY());
            logger.verbose("updated locationInScreenshot: " + locationInScreenshot);
        }
        logger.verbose("Iterating over frames...");
        while (frameIterator.hasNext()) {
            logger.verbose("Getting next frame...");
            Frame frame = frameIterator.next();
            logger.verbose("Done!");
            Location frameLocation = frame.getLocation();
            Location frameOriginalLocation = frame.getOriginalLocation();
            logger.verbose("Done! frameLocation: " + frameLocation + " ; frameOriginalLocation: " + frameOriginalLocation);
            locationInScreenshot = locationInScreenshot.offset(frameLocation.getX() - frameOriginalLocation.getX(), frameLocation.getY() - frameOriginalLocation.getY());
            logger.verbose("updated locationInScreenshot: " + locationInScreenshot);
        }
        logger.verbose("Done! final locationInScreenshot: " + locationInScreenshot);
        return locationInScreenshot;
    }

    public EyesWebDriverScreenshot(Logger logger, EyesWebDriver driver, BufferedImage image, ScreenshotType screenshotType, Location frameLocationInScreenshot) {
        super(logger, image);
        PositionProvider positionProvider;
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        ArgumentGuard.notNull((Object)driver, (String)"driver");
        this.driver = driver;
        logger.verbose("enter");
        this.screenshotType = this.updateScreenshotType(screenshotType, image);
        SeleniumEyes eyes = driver.getEyes();
        PositionProvider currentFramePositionProvider = eyes.getCurrentFramePositionProvider();
        if (frameLocationInScreenshot != null && eyes.checkFrameOrElement) {
            positionProvider = eyes.getCurrentFramePositionProvider();
            logger.verbose("position provider: using the current frame scroll root element's position provider: " + positionProvider);
        } else if (currentFramePositionProvider != null) {
            positionProvider = currentFramePositionProvider;
            logger.verbose("position provider: using CurrentFramePositionProvider: " + positionProvider);
        } else {
            positionProvider = eyes.getPositionProvider();
            logger.verbose("position provider: using PositionProvider: " + positionProvider);
        }
        if (!EyesSeleniumUtils.isMobileDevice(driver)) {
            this.frameChain = driver.getFrameChain();
            RectangleSize frameSize = this.getFrameSize(positionProvider);
            this.currentFrameScrollPosition = EyesWebDriverScreenshot.getUpdatedScrollPosition(positionProvider);
            this.updateFrameLocationInScreenshot(frameLocationInScreenshot);
            logger.verbose("Calculating frame window...");
            this.frameWindow = new Region(this.frameLocationInScreenshot, frameSize);
        } else {
            this.frameChain = new FrameChain(logger);
            this.currentFrameScrollPosition = new Location(0, 0);
            this.frameLocationInScreenshot = new Location(0, 0);
            this.frameWindow = new Region(this.frameLocationInScreenshot, new RectangleSize(image.getWidth(), image.getHeight()));
        }
        Region imageSizeAsRegion = new Region(0, 0, image.getWidth(), image.getHeight());
        logger.verbose("this.frameWindow: " + this.frameWindow + " ; imageSizeAsRegion: " + imageSizeAsRegion);
        this.frameWindow.intersect(imageSizeAsRegion);
        logger.verbose("updated frameWindow: " + this.frameWindow);
        if (this.frameWindow.getWidth() <= 0 || this.frameWindow.getHeight() <= 0) {
            throw new EyesException("Got empty frame window for screenshot!");
        }
        logger.verbose("Done!");
    }

    private void updateFrameLocationInScreenshot(Location location) {
        this.frameLocationInScreenshot = location == null ? (this.frameChain.size() > 0 ? EyesWebDriverScreenshot.calcFrameLocationInScreenshot(this.logger, this.driver, this.frameChain, this.screenshotType) : new Location(0, 0)) : location;
    }

    private static Location getUpdatedScrollPosition(PositionProvider positionProvider) {
        Location sp;
        try {
            sp = positionProvider.getCurrentPosition();
            if (sp == null) {
                sp = new Location(0, 0);
            }
        }
        catch (Exception e) {
            sp = new Location(0, 0);
        }
        return sp;
    }

    private RectangleSize getFrameSize(PositionProvider positionProvider) {
        RectangleSize frameSize = this.frameChain.size() != 0 ? this.frameChain.getCurrentFrameInnerSize() : (!EyesSeleniumUtils.isMobileDevice(this.driver) ? positionProvider.getEntireSize() : this.driver.getDefaultContentViewportSize());
        return frameSize;
    }

    private ScreenshotType updateScreenshotType(ScreenshotType screenshotType, BufferedImage image) {
        if (screenshotType == null) {
            RectangleSize viewportSize = this.driver.getEyes().getViewportSize();
            boolean scaleViewport = this.driver.getEyes().shouldStitchContent();
            if (scaleViewport) {
                double pixelRatio = this.driver.getEyes().getDevicePixelRatio();
                viewportSize = viewportSize.scale(pixelRatio);
            }
            screenshotType = image.getWidth() <= viewportSize.getWidth() && image.getHeight() <= viewportSize.getHeight() ? ScreenshotType.VIEWPORT : ScreenshotType.ENTIRE_FRAME;
        }
        return screenshotType;
    }

    public EyesWebDriverScreenshot(Logger logger, EyesWebDriver driver, BufferedImage image) {
        this(logger, driver, image, ScreenshotType.VIEWPORT, null);
    }

    public EyesWebDriverScreenshot(Logger logger, EyesWebDriver driver, BufferedImage image, Region screenshotRegion) {
        super(logger, image);
        ArgumentGuard.notNull((Object)driver, (String)"driver");
        ArgumentGuard.notNull((Object)screenshotRegion, (String)"screenshotRegion");
        this.driver = driver;
        this.frameChain = driver.getFrameChain();
        this.screenshotType = ScreenshotType.ENTIRE_FRAME;
        this.currentFrameScrollPosition = new Location(0, 0);
        this.frameLocationInScreenshot = new Location(0, 0);
        this.frameWindow = new Region(new Location(0, 0), screenshotRegion.getSize());
    }

    public EyesWebDriverScreenshot(Logger logger, EyesWebDriver driver, BufferedImage image, RectangleSize entireFrameSize) {
        super(logger, image);
        ArgumentGuard.notNull((Object)driver, (String)"driver");
        ArgumentGuard.notNull((Object)entireFrameSize, (String)"entireFrameSize");
        this.driver = driver;
        this.frameChain = driver.getFrameChain();
        this.screenshotType = ScreenshotType.ENTIRE_FRAME;
        this.currentFrameScrollPosition = new Location(0, 0);
        this.frameLocationInScreenshot = new Location(0, 0);
        this.frameWindow = new Region(new Location(0, 0), entireFrameSize);
    }

    public Region getFrameWindow() {
        return this.frameWindow;
    }

    public FrameChain getFrameChain() {
        return new FrameChain(this.logger, this.frameChain);
    }

    public EyesWebDriverScreenshot getSubScreenshot(Region region, boolean throwIfClipped) {
        this.logger.verbose(String.format("getSubScreenshot([%s], %b)", region, throwIfClipped));
        ArgumentGuard.notNull((Object)region, (String)"region");
        Region asIsSubScreenshotRegion = this.getIntersectedRegion(region, CoordinatesType.SCREENSHOT_AS_IS);
        if (asIsSubScreenshotRegion.isSizeEmpty() || throwIfClipped && !asIsSubScreenshotRegion.getSize().equals((Object)region.getSize())) {
            throw new OutOfBoundsException(String.format("Region [%s] is out of screenshot bounds [%s]", region, this.frameWindow));
        }
        BufferedImage subScreenshotImage = ImageUtils.getImagePart((BufferedImage)this.image, (Region)asIsSubScreenshotRegion);
        EyesWebDriverScreenshot result = new EyesWebDriverScreenshot(this.logger, this.driver, subScreenshotImage, new Region(region.getLeft(), region.getTop(), subScreenshotImage.getWidth(), subScreenshotImage.getHeight()));
        result.updateFrameLocationInScreenshot(new Location(-region.getLeft(), -region.getTop()));
        result.setDomUrl(this.domUrl);
        this.logger.verbose("Done!");
        return result;
    }

    public EyesWebDriverScreenshot getSubScreenshotForRegion(Region region, boolean throwIfClipped) {
        this.logger.verbose(String.format("getSubScreenshot([%s], %b)", region, throwIfClipped));
        ArgumentGuard.notNull((Object)region, (String)"region");
        Region asIsSubScreenshotRegion = this.getIntersectedRegion(region, CoordinatesType.SCREENSHOT_AS_IS);
        if (asIsSubScreenshotRegion.isEmpty() || throwIfClipped && !asIsSubScreenshotRegion.getSize().equals((Object)region.getSize())) {
            throw new OutOfBoundsException(String.format("Region [%s] is out of screenshot bounds [%s]", region, this.frameWindow));
        }
        BufferedImage subScreenshotImage = ImageUtils.getImagePart((BufferedImage)this.image, (Region)asIsSubScreenshotRegion);
        EyesWebDriverScreenshot result = new EyesWebDriverScreenshot(this.logger, this.driver, subScreenshotImage, new Region(region.getLocation(), new RectangleSize(subScreenshotImage.getWidth(), subScreenshotImage.getHeight())));
        this.logger.verbose("Done!");
        return result;
    }

    public Location convertLocation(Location location, CoordinatesType from, CoordinatesType to) {
        ArgumentGuard.notNull((Object)location, (String)"location");
        ArgumentGuard.notNull((Object)from, (String)"from");
        ArgumentGuard.notNull((Object)to, (String)"to");
        Location result = new Location(location);
        if (from == to) {
            return result;
        }
        if (this.frameChain.size() == 0 && this.screenshotType == ScreenshotType.ENTIRE_FRAME) {
            if ((from == CoordinatesType.CONTEXT_RELATIVE || from == CoordinatesType.CONTEXT_AS_IS) && to == CoordinatesType.SCREENSHOT_AS_IS) {
                result = result.offset(this.frameLocationInScreenshot.getX(), this.frameLocationInScreenshot.getY());
            } else if (from == CoordinatesType.SCREENSHOT_AS_IS && (to == CoordinatesType.CONTEXT_RELATIVE || to == CoordinatesType.CONTEXT_AS_IS)) {
                result = result.offset(-this.frameLocationInScreenshot.getX(), -this.frameLocationInScreenshot.getY());
            }
            return result;
        }
        block0 : switch (from) {
            case CONTEXT_AS_IS: {
                switch (to) {
                    case CONTEXT_RELATIVE: {
                        result = result.offset(this.currentFrameScrollPosition.getX(), this.currentFrameScrollPosition.getY());
                        break block0;
                    }
                    case SCREENSHOT_AS_IS: {
                        result = result.offset(this.frameLocationInScreenshot.getX(), this.frameLocationInScreenshot.getY());
                        break block0;
                    }
                }
                throw new CoordinatesTypeConversionException(from, to);
            }
            case CONTEXT_RELATIVE: {
                switch (to) {
                    case SCREENSHOT_AS_IS: {
                        result = result.offset(-this.currentFrameScrollPosition.getX(), -this.currentFrameScrollPosition.getY());
                        result = result.offset(this.frameLocationInScreenshot.getX(), this.frameLocationInScreenshot.getY());
                        break block0;
                    }
                    case CONTEXT_AS_IS: {
                        result = result.offset(-this.currentFrameScrollPosition.getX(), -this.currentFrameScrollPosition.getY());
                        break block0;
                    }
                }
                throw new CoordinatesTypeConversionException(from, to);
            }
            case SCREENSHOT_AS_IS: {
                switch (to) {
                    case CONTEXT_RELATIVE: {
                        result = result.offset(-this.frameLocationInScreenshot.getX(), -this.frameLocationInScreenshot.getY());
                        result = result.offset(this.currentFrameScrollPosition.getX(), this.currentFrameScrollPosition.getY());
                        break block0;
                    }
                    case CONTEXT_AS_IS: {
                        result = result.offset(-this.frameLocationInScreenshot.getX(), -this.frameLocationInScreenshot.getY());
                        break block0;
                    }
                }
                throw new CoordinatesTypeConversionException(from, to);
            }
            default: {
                throw new CoordinatesTypeConversionException(from, to);
            }
        }
        return result;
    }

    public Location getLocationInScreenshot(Location location, CoordinatesType coordinatesType) throws OutOfBoundsException {
        if (!this.frameWindow.contains(location = this.convertLocation(location, coordinatesType, CoordinatesType.SCREENSHOT_AS_IS))) {
            throw new OutOfBoundsException(String.format("Location %s ('%s') is not visible in screenshot!", location, coordinatesType));
        }
        return location;
    }

    public Region getIntersectedRegion(Region region, CoordinatesType resultCoordinatesType) {
        if (region.isSizeEmpty()) {
            return new Region((IRegion)region);
        }
        CoordinatesType originalCoordinatesType = region.getCoordinatesType();
        Region intersectedRegion = this.convertRegionLocation(region, originalCoordinatesType, CoordinatesType.SCREENSHOT_AS_IS);
        switch (originalCoordinatesType) {
            case CONTEXT_RELATIVE: 
            case CONTEXT_AS_IS: {
                intersectedRegion.intersect(this.frameWindow);
                break;
            }
            case SCREENSHOT_AS_IS: {
                intersectedRegion.intersect(new Region(0, 0, this.image.getWidth(), this.image.getHeight()));
                break;
            }
            default: {
                throw new CoordinatesTypeConversionException(String.format("Unknown coordinates type: '%s'", originalCoordinatesType));
            }
        }
        if (intersectedRegion.isSizeEmpty()) {
            return intersectedRegion;
        }
        intersectedRegion = this.convertRegionLocation(intersectedRegion, CoordinatesType.SCREENSHOT_AS_IS, resultCoordinatesType);
        return intersectedRegion;
    }

    public Region getIntersectedRegion(WebElement element) {
        ArgumentGuard.notNull((Object)element, (String)"element");
        Point pl = element.getLocation();
        Dimension ds = element.getSize();
        Region elementRegion = new Region(pl.getX(), pl.getY(), ds.getWidth(), ds.getHeight());
        elementRegion = this.getIntersectedRegion(elementRegion, CoordinatesType.CONTEXT_RELATIVE);
        if (!elementRegion.isSizeEmpty()) {
            elementRegion = this.convertRegionLocation(elementRegion, CoordinatesType.CONTEXT_RELATIVE, CoordinatesType.SCREENSHOT_AS_IS);
        }
        return elementRegion;
    }

    public static enum ScreenshotType {
        VIEWPORT,
        ENTIRE_FRAME;

    }
}

