/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.capture;

import com.applitools.eyes.CoordinatesType;
import com.applitools.eyes.CutProvider;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.NullCutProvider;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.ScaleProvider;
import com.applitools.eyes.ScaleProviderFactory;
import com.applitools.eyes.SubregionForStitching;
import com.applitools.eyes.capture.EyesScreenshotFactory;
import com.applitools.eyes.capture.ImageProvider;
import com.applitools.eyes.debug.DebugScreenshotsProvider;
import com.applitools.eyes.positioning.PositionMemento;
import com.applitools.eyes.positioning.PositionProvider;
import com.applitools.eyes.selenium.positioning.NullRegionPositionCompensation;
import com.applitools.eyes.selenium.positioning.RegionPositionCompensation;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import com.applitools.utils.ImageUtils;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

public class FullPageCaptureAlgorithm {
    private static final int MIN_SCREENSHOT_PART_SIZE = 10;
    private final Logger logger;
    private final RegionPositionCompensation regionPositionCompensation;
    private final int waitBeforeScreenshots;
    private final DebugScreenshotsProvider debugScreenshotsProvider;
    private final EyesScreenshotFactory screenshotFactory;
    private final PositionProvider originProvider;
    private final ScaleProviderFactory scaleProviderFactory;
    private final CutProvider cutProvider;
    private final int stitchingOverlap;
    private final ImageProvider imageProvider;

    public FullPageCaptureAlgorithm(Logger logger, RegionPositionCompensation regionPositionCompensation, int waitBeforeScreenshots, DebugScreenshotsProvider debugScreenshotsProvider, EyesScreenshotFactory screenshotFactory, PositionProvider originProvider, ScaleProviderFactory scaleProviderFactory, CutProvider cutProvider, int stitchingOverlap, ImageProvider imageProvider) {
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        this.logger = logger;
        this.waitBeforeScreenshots = waitBeforeScreenshots;
        this.debugScreenshotsProvider = debugScreenshotsProvider;
        this.screenshotFactory = screenshotFactory;
        this.originProvider = originProvider;
        this.scaleProviderFactory = scaleProviderFactory;
        this.cutProvider = cutProvider;
        this.stitchingOverlap = stitchingOverlap;
        this.imageProvider = imageProvider;
        this.regionPositionCompensation = regionPositionCompensation != null ? regionPositionCompensation : new NullRegionPositionCompensation();
    }

    private void saveDebugScreenshotPart(BufferedImage image, Region region, String name) {
        String suffix = String.format("part-%s-%d_%d_%dx%d", name, region.getLeft(), region.getTop(), region.getWidth(), region.getHeight());
        this.debugScreenshotsProvider.save(image, suffix);
    }

    public BufferedImage getStitchedRegion(Region region, Region fullArea, PositionProvider positionProvider) {
        Region rectInScreenshot;
        Region sourceRegion;
        ArgumentGuard.notNull((Object)region, (String)"region");
        ArgumentGuard.notNull((Object)positionProvider, (String)"positionProvider");
        this.logger.verbose(String.format("region: %s ; fullArea: %s ; positionProvider: %s", region, fullArea, positionProvider.getClass().getName()));
        PositionMemento originalPosition = this.originProvider.getState();
        if (!positionProvider.equals(this.originProvider)) {
            this.originProvider.setPosition(Location.ZERO);
        }
        PositionMemento originalStitchedState = positionProvider.getState();
        this.logger.verbose("region size: " + region);
        try {
            Thread.sleep(this.waitBeforeScreenshots);
        }
        catch (InterruptedException e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
        }
        BufferedImage initialScreenshot = this.imageProvider.getImage();
        RectangleSize initialSize = new RectangleSize(initialScreenshot.getWidth(), initialScreenshot.getHeight());
        this.saveDebugScreenshotPart(initialScreenshot, region, "initial");
        ScaleProvider scaleProvider = this.scaleProviderFactory.getScaleProvider(initialScreenshot.getWidth());
        double pixelRatio = 1.0 / scaleProvider.getScaleRatio();
        CutProvider scaledCutProvider = this.cutProvider.scale(pixelRatio);
        if (pixelRatio != 1.0 && !(scaledCutProvider instanceof NullCutProvider)) {
            initialScreenshot = this.cutProvider.cut(initialScreenshot);
            this.debugScreenshotsProvider.save(initialScreenshot, "original-cut");
        }
        EyesScreenshot screenshot = this.screenshotFactory.makeScreenshot(initialScreenshot);
        Region regionInScreenshot = this.getRegionInScreenshot(region, initialScreenshot, pixelRatio);
        BufferedImage croppedInitialScreenshot = this.cropScreenshot(initialScreenshot, regionInScreenshot);
        this.debugScreenshotsProvider.save(croppedInitialScreenshot, "cropped");
        BufferedImage scaledInitialScreenshot = ImageUtils.scaleImage((BufferedImage)croppedInitialScreenshot, (ScaleProvider)scaleProvider);
        if (scaledInitialScreenshot != croppedInitialScreenshot) {
            this.saveDebugScreenshotPart(scaledInitialScreenshot, regionInScreenshot, "scaled");
        }
        if (fullArea.isEmpty()) {
            RectangleSize entireSize;
            try {
                entireSize = positionProvider.getEntireSize();
                this.logger.verbose("Entire size of region context: " + entireSize);
            }
            catch (EyesException e) {
                this.logger.log("WARNING: Failed to extract entire size of region context" + e.getMessage());
                this.logger.log("Using image size instead: " + scaledInitialScreenshot.getWidth() + "x" + scaledInitialScreenshot.getHeight());
                entireSize = new RectangleSize(scaledInitialScreenshot.getWidth(), scaledInitialScreenshot.getHeight());
            }
            if (scaledInitialScreenshot.getWidth() >= entireSize.getWidth() && scaledInitialScreenshot.getHeight() >= entireSize.getHeight()) {
                this.originProvider.restoreState(originalPosition);
                return scaledInitialScreenshot;
            }
            fullArea = new Region(Location.ZERO, entireSize);
        }
        Location scaledCropLocation = fullArea.getLocation();
        Location physicalCropLocation = new Location((int)Math.ceil((double)scaledCropLocation.getX() * pixelRatio), (int)Math.ceil((double)scaledCropLocation.getY() * pixelRatio));
        if (regionInScreenshot.isSizeEmpty()) {
            RectangleSize physicalCropSize = new RectangleSize(initialSize.getWidth() - physicalCropLocation.getX(), initialSize.getHeight() - physicalCropLocation.getY());
            sourceRegion = new Region(physicalCropLocation, physicalCropSize);
        } else {
            sourceRegion = regionInScreenshot;
        }
        Region scaledCroppedSourceRect = this.cutProvider.toRegion(sourceRegion.getSize());
        scaledCroppedSourceRect.offset(sourceRegion.getLeft(), sourceRegion.getTop());
        Rectangle scaledCroppedSourceRegion = new Rectangle((int)Math.ceil((double)scaledCroppedSourceRect.getLeft() / pixelRatio), (int)Math.ceil((double)scaledCroppedSourceRect.getTop() / pixelRatio), (int)Math.ceil((double)scaledCroppedSourceRect.getWidth() / pixelRatio), (int)Math.ceil((double)scaledCroppedSourceRect.getHeight() / pixelRatio));
        Dimension scaledCropSize = scaledCroppedSourceRegion.getSize();
        RectangleSize screenshotPartSize = new RectangleSize(Math.max((int)scaledCropSize.getWidth(), 10), Math.max((int)scaledCropSize.getHeight(), 10));
        this.logger.verbose("Screenshot part size: " + screenshotPartSize);
        if (regionInScreenshot.isSizeEmpty()) {
            int x = Math.max(0, fullArea.getLeft());
            int y = Math.max(0, fullArea.getTop());
            int w = Math.min(fullArea.getWidth(), (int)scaledCropSize.getWidth());
            int h = Math.min(fullArea.getHeight(), (int)scaledCropSize.getHeight());
            rectInScreenshot = new Region((int)Math.round((double)x * pixelRatio), (int)Math.round((double)y * pixelRatio), (int)Math.round((double)w * pixelRatio), (int)Math.round((double)h * pixelRatio));
        } else {
            rectInScreenshot = regionInScreenshot;
        }
        Iterable screenshotParts = fullArea.getSubRegions(screenshotPartSize, this.stitchingOverlap, pixelRatio, rectInScreenshot, this.logger);
        BufferedImage stitchedImage = new BufferedImage(fullArea.getWidth(), fullArea.getHeight(), 6);
        this.stitchScreenshot(originalStitchedState, positionProvider, screenshotParts, stitchedImage, scaleProvider.getScaleRatio(), scaledCutProvider);
        positionProvider.restoreState(originalStitchedState);
        this.originProvider.restoreState(originalPosition);
        return stitchedImage;
    }

    private BufferedImage cropScreenshot(BufferedImage initialScreenshot, Region regionInScreenshot) {
        if (!regionInScreenshot.isSizeEmpty()) {
            BufferedImage croppedInitialScreenshot;
            initialScreenshot = croppedInitialScreenshot = ImageUtils.cropImage((Logger)this.logger, (BufferedImage)initialScreenshot, (Region)regionInScreenshot);
            this.saveDebugScreenshotPart(croppedInitialScreenshot, regionInScreenshot, "cropped");
        }
        return initialScreenshot;
    }

    private void stitchScreenshot(PositionMemento originalStitchedState, PositionProvider stitchProvider, Iterable<SubregionForStitching> screenshotParts, BufferedImage stitchedImage, double scaleRatio, CutProvider scaledCutProvider) {
        int index = 0;
        this.logger.verbose(String.format("enter: originalStitchedState: %s ; scaleRatio: %s", originalStitchedState, scaleRatio));
        for (SubregionForStitching partRegion : screenshotParts) {
            this.logger.verbose("Part: " + partRegion);
            Location partRegionLocation = partRegion.getScrollTo();
            partRegionLocation = partRegionLocation.offset(originalStitchedState.getX(), originalStitchedState.getY());
            Location originPosition = stitchProvider.setPosition(partRegionLocation);
            int dx = partRegionLocation.getX() - originPosition.getX();
            int dy = partRegionLocation.getY() - originPosition.getY();
            Location targetPosition = partRegion.getPastePhysicalLocation();
            targetPosition.offset(dx, dy);
            try {
                Thread.sleep(this.waitBeforeScreenshots);
            }
            catch (InterruptedException e) {
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
            }
            BufferedImage partImage = this.imageProvider.getImage();
            BufferedImage cutPart = scaledCutProvider.cut(partImage);
            Region r = partRegion.getPhysicalCropArea();
            BufferedImage croppedPart = !r.isSizeEmpty() ? ImageUtils.cropImage((Logger)this.logger, (BufferedImage)cutPart, (Region)r) : cutPart;
            Region r2 = partRegion.getLogicalCropArea();
            BufferedImage scaledPartImage = ImageUtils.scaleImage((BufferedImage)croppedPart, (double)scaleRatio);
            BufferedImage scaledCroppedPartImage = ImageUtils.cropImage((Logger)this.logger, (BufferedImage)scaledPartImage, (Region)r2);
            this.debugScreenshotsProvider.save(partImage, "partImage-" + originPosition.getX() + "_" + originPosition.getY());
            this.debugScreenshotsProvider.save(scaledCroppedPartImage, "scaledCroppedPartImage-" + targetPosition.getX() + "_" + targetPosition.getY());
            this.logger.verbose("pasting part at " + targetPosition);
            stitchedImage.getRaster().setRect(targetPosition.getX(), targetPosition.getY(), scaledCroppedPartImage.getData());
            ++index;
        }
        this.debugScreenshotsProvider.save(stitchedImage, "stitched");
    }

    private Region getRegionInScreenshot(Region region, BufferedImage image, double pixelRatio) {
        if (region.isSizeEmpty()) {
            return region;
        }
        this.logger.verbose("Creating screenshot object...");
        EyesScreenshot screenshot = this.screenshotFactory.makeScreenshot(image);
        this.logger.verbose("Getting region in screenshot...");
        Region regionInScreenshot = screenshot.getIntersectedRegion(region, CoordinatesType.SCREENSHOT_AS_IS);
        this.logger.verbose("Region in screenshot: " + regionInScreenshot);
        regionInScreenshot = regionInScreenshot.scale(pixelRatio);
        this.logger.verbose("Scaled region: " + regionInScreenshot);
        regionInScreenshot = this.regionPositionCompensation.compensateRegionPosition(regionInScreenshot, pixelRatio);
        regionInScreenshot.intersect(new Region(0, 0, image.getWidth(), image.getHeight()));
        this.logger.verbose("Region after intersect: " + regionInScreenshot);
        return regionInScreenshot;
    }
}

