/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.fluent;

import com.applitools.eyes.CoordinatesType;
import com.applitools.eyes.EyesBase;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.Location;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.fluent.GetRegion;
import com.applitools.eyes.selenium.SeleniumEyes;
import com.applitools.eyes.selenium.rendering.IGetSeleniumRegion;
import com.applitools.eyes.selenium.wrappers.EyesRemoteWebElement;
import com.applitools.eyes.selenium.wrappers.EyesWebDriver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class SimpleRegionByElement
implements GetRegion,
IGetSeleniumRegion {
    private WebElement element;

    public SimpleRegionByElement(WebElement element) {
        this.element = element;
    }

    public List<Region> getRegions(EyesBase eyesBase, EyesScreenshot screenshot) {
        if (!(this.element instanceof EyesRemoteWebElement) && eyesBase instanceof SeleniumEyes) {
            SeleniumEyes seleniumEyes = (SeleniumEyes)eyesBase;
            this.element = new EyesRemoteWebElement(eyesBase.getLogger(), (EyesWebDriver)seleniumEyes.getDriver(), this.element);
        }
        Point locationAsPoint = this.element.getLocation();
        Dimension size = this.element.getSize();
        Location adjustedLocation = new Location(locationAsPoint.getX(), locationAsPoint.getY());
        if (screenshot != null) {
            adjustedLocation = screenshot.convertLocation(adjustedLocation, CoordinatesType.CONTEXT_RELATIVE, CoordinatesType.SCREENSHOT_AS_IS);
        }
        ArrayList<Region> value = new ArrayList<Region>();
        value.add(new Region(adjustedLocation, new RectangleSize(size.getWidth(), size.getHeight()), CoordinatesType.SCREENSHOT_AS_IS));
        return value;
    }

    @Override
    public List<WebElement> getElements(WebDriver webDriver) {
        return Arrays.asList(this.element);
    }
}

