/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.positioning;

import com.applitools.eyes.EyesException;
import com.applitools.eyes.IEyesJsExecutor;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.positioning.PositionMemento;
import com.applitools.eyes.positioning.PositionProvider;
import com.applitools.eyes.selenium.positioning.ISeleniumPositionProvider;
import com.applitools.eyes.selenium.positioning.ScrollPositionMemento;
import com.applitools.utils.ArgumentGuard;
import org.openqa.selenium.WebElement;

public class ScrollPositionProvider
implements PositionProvider,
ISeleniumPositionProvider {
    protected final Logger logger;
    protected final IEyesJsExecutor executor;
    protected final WebElement scrollRootElement;
    private final String JS_GET_ENTIRE_PAGE_SIZE = "var width = Math.max(arguments[0].clientWidth, arguments[0].scrollWidth);var height = Math.max(arguments[0].clientHeight, arguments[0].scrollHeight);return (width + ',' + height);";

    public ScrollPositionProvider(Logger logger, IEyesJsExecutor executor, WebElement scrollRootElement) {
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        ArgumentGuard.notNull((Object)executor, (String)"executor");
        this.logger = logger;
        this.executor = executor;
        this.scrollRootElement = scrollRootElement;
        logger.verbose("creating ScrollPositionProvider");
    }

    public static Location getCurrentPosition(IEyesJsExecutor executor, WebElement scrollRootElement) {
        Object position = executor.executeScript("return arguments[0].scrollLeft+';'+arguments[0].scrollTop;", new Object[]{scrollRootElement});
        return ScrollPositionProvider.parseLocationString(position);
    }

    public Location getCurrentPosition() {
        return ScrollPositionProvider.getCurrentPosition(this.executor, this.scrollRootElement);
    }

    public Location setPosition(Location location) {
        this.logger.verbose(String.format("setting position of %s to %s", this.scrollRootElement, location));
        Object position = this.executor.executeScript(String.format("arguments[0].scrollLeft=%d; arguments[0].scrollTop=%d; return (arguments[0].scrollLeft+';'+arguments[0].scrollTop);", location.getX(), location.getY()), new Object[]{this.scrollRootElement});
        return ScrollPositionProvider.parseLocationString(position);
    }

    static Location parseLocationString(Object position) {
        String[] xy = position.toString().split(";");
        if (xy.length != 2) {
            throw new EyesException("Could not get scroll position!");
        }
        float x = Float.parseFloat(xy[0]);
        float y = Float.parseFloat(xy[1]);
        return new Location((int)Math.ceil(x), (int)Math.ceil(y));
    }

    public RectangleSize getEntireSize() {
        this.logger.verbose(String.format("enter (scrollRootElement: %s)", this.scrollRootElement));
        String entireSizeStr = (String)this.executor.executeScript("var width = Math.max(arguments[0].clientWidth, arguments[0].scrollWidth);var height = Math.max(arguments[0].clientHeight, arguments[0].scrollHeight);return (width + ',' + height);", new Object[]{this.scrollRootElement});
        String[] wh = entireSizeStr.split(",");
        if (wh.length != 2) {
            throw new EyesException("Could not get entire size!");
        }
        float w = Float.parseFloat(wh[0]);
        float h = Float.parseFloat(wh[1]);
        RectangleSize result = new RectangleSize((int)Math.ceil(w), (int)Math.ceil(h));
        this.logger.verbose("ScrollPositionProvider - Entire size: " + result);
        return result;
    }

    public PositionMemento getState() {
        return new ScrollPositionMemento(this.getCurrentPosition());
    }

    public void restoreState(PositionMemento state) {
        ScrollPositionMemento s = (ScrollPositionMemento)state;
        this.setPosition(new Location(s.getX(), s.getY()));
    }

    @Override
    public WebElement getScrolledElement() {
        return this.scrollRootElement;
    }

    public boolean equals(ScrollPositionProvider other) {
        return this.scrollRootElement.equals(other.scrollRootElement);
    }

    public boolean equals(Object other) {
        if (other instanceof ScrollPositionProvider) {
            return this.equals((ScrollPositionProvider)other);
        }
        return false;
    }

    public int hashCode() {
        if (this.scrollRootElement != null) {
            return this.scrollRootElement.hashCode();
        }
        return 0;
    }
}

