/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.regionVisibility;

import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.positioning.PositionMemento;
import com.applitools.eyes.positioning.PositionProvider;
import com.applitools.eyes.selenium.regionVisibility.RegionVisibilityStrategy;

public class MoveToRegionVisibilityStrategy
implements RegionVisibilityStrategy {
    private static final int VISIBILITY_OFFSET = 100;
    private final Logger logger;
    private PositionMemento originalPosition;

    public MoveToRegionVisibilityStrategy(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void moveToRegion(PositionProvider positionProvider, Location location) {
        this.logger.verbose("Getting current position state..");
        this.originalPosition = positionProvider.getState();
        this.logger.verbose("Done! Setting position..");
        int dstX = location.getX() - 100;
        dstX = dstX < 0 ? 0 : dstX;
        int dstY = location.getY() - 100;
        dstY = dstY < 0 ? 0 : dstY;
        positionProvider.setPosition(new Location(dstX, dstY));
        this.logger.verbose("Done!");
    }

    @Override
    public void returnToOriginalPosition(PositionProvider positionProvider) {
        this.logger.verbose("Returning to original position...");
        positionProvider.restoreState(this.originalPosition);
        this.logger.verbose("Done!");
    }
}

