/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.velocypack;

import java.nio.charset.StandardCharsets;

public class VPackStringSlice
implements Comparable<VPackStringSlice> {
    private final byte[] vpack;
    private final int start;
    private final int length;

    public VPackStringSlice(byte[] vpack, int start, int length) {
        this.vpack = vpack;
        this.start = start;
        this.length = length;
    }

    @Override
    public int compareTo(VPackStringSlice o) {
        return this.compareToBytes(o.vpack, o.start, o.length);
    }

    public int compareToBytes(byte[] other) {
        return this.compareToBytes(other, 0, other.length);
    }

    public int compareToBytes(byte[] other, int off, int oLen) {
        for (int i = 0; i < this.length && i < oLen; ++i) {
            int c = (this.vpack[this.start + i] & 0xFF) - (other[off + i] & 0xFF);
            if (c == 0) continue;
            return c;
        }
        return this.length - oLen;
    }

    public String toString() {
        return new String(this.vpack, this.start, this.length, StandardCharsets.UTF_8);
    }
}

