/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.velocypack.internal.util;

import java.math.BigInteger;

public class NumberUtil {
    private static final int DOUBLE_BYTES = 8;
    private static final int LONG_BYTES = 8;

    private NumberUtil() {
    }

    public static double toDouble(byte[] array, int offset, int length) {
        return Double.longBitsToDouble(NumberUtil.toLong(array, offset, 8));
    }

    public static long toLong(byte[] array, int offset, int length) {
        return NumberUtil.toLong(array, offset, length, false);
    }

    public static long toLong(byte[] array, int offset, int length, boolean fillNegativeBytes) {
        int i;
        long result = 0L;
        if (fillNegativeBytes && length < 8 && array[offset + length - 1] <= -1) {
            for (i = 0; i <= 8 - length; ++i) {
                result <<= 8;
                result |= 0xFFL;
            }
        }
        for (i = offset + length - 1; i >= offset; --i) {
            result <<= 8;
            result |= (long)(array[i] & 0xFF);
        }
        return result;
    }

    public static BigInteger toBigInteger(byte[] array, int offset, int length) {
        BigInteger result = new BigInteger(1, new byte[0]);
        for (int i = offset + length - 1; i >= offset; --i) {
            result = result.shiftLeft(8);
            result = result.or(BigInteger.valueOf(array[i] & 0xFF));
        }
        return result;
    }

    public static long readVariableValueLength(byte[] array, int offset, boolean reverse) {
        byte v;
        long len = 0L;
        long p = 0L;
        int i = offset;
        do {
            v = array[i];
            len += (long)(v & 0x7F) << (int)p;
            p += 7L;
            if (reverse) {
                --i;
                continue;
            }
            ++i;
        } while ((v & 0xFFFFFF80) != 0);
        return len;
    }

    public static long getVariableValueLength(long value) {
        long len = 1L;
        long val = value;
        while (val >= 128L) {
            val >>= 7;
            ++len;
        }
        return len;
    }
}

