/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.font;

import com.aspose.font.EncodingException;
import com.aspose.font.GlyphId;
import com.aspose.font.GlyphUInt32Id;
import com.aspose.font.I1;
import com.aspose.font.IEncodingParameters;
import com.aspose.font.IFontEncoding;
import com.aspose.font.TtfCMapFormatBaseTable;
import com.aspose.font.TtfEncodingParameters;
import com.aspose.font.TtfFont;
import com.aspose.font.internal.l45I.I07;
import java.util.ArrayList;

public class TtfEncoding
implements IFontEncoding {
    private TtfFont lif;
    private char[] ll = null;

    TtfEncoding(TtfFont font) {
        this.lif = font;
    }

    @Override
    public long gidToUnicode(GlyphId glyphId) {
        GlyphUInt32Id glyphUInt32Id = (GlyphUInt32Id)((Object)I07.lif(glyphId, GlyphUInt32Id.class));
        if (glyphUInt32Id != null) {
            String string;
            TtfCMapFormatBaseTable ttfCMapFormatBaseTable = this.lif.getTtfTables().getCMapTable().findUnicodeTable();
            if (ttfCMapFormatBaseTable != null && ((ttfCMapFormatBaseTable.getPlatformId() & 0xFFFF) != 3 || (ttfCMapFormatBaseTable.getPlatformSpecificId() & 0xFFFF) != 0)) {
                if (this.ll == null) {
                    this.ll = new char[this.lif.getTtfTables().getMaxpTable().getNumGlyphs() & 0xFFFF];
                    ArrayList<Long> arrayList = ttfCMapFormatBaseTable.getAllCodes();
                    for (long l : arrayList) {
                        long l2 = ttfCMapFormatBaseTable.getGlyphIndex(I07.l0I(l, 10));
                        if (l2 == 0L) continue;
                        this.ll[(int)l2] = I07.l0I(l, 10);
                    }
                }
                if (glyphUInt32Id.getValue() >= 0L && glyphUInt32Id.getValue() < (long)(this.lif.getTtfTables().getMaxpTable().getNumGlyphs() & 0xFFFF)) {
                    return this.ll[(int)glyphUInt32Id.getValue()];
                }
            } else if (this.lif.getTtfTables().getPostTable() != null && !".notdef".equals(string = this.lif.getTtfTables().getPostTable().getGlyphName(glyphUInt32Id.getValue()))) {
                return (char)I1.lif().ll(string);
            }
        }
        return 0L;
    }

    @Override
    public void encode(long gid, long charCode) {
        this.lif.getTtfTables().getCMapTable().lif(charCode, gid);
    }

    @Override
    public GlyphId unicodeToGid(long unicode) {
        return this.decodeToGid(unicode);
    }

    @Override
    public GlyphId decodeToGid(long unicode) {
        TtfCMapFormatBaseTable ttfCMapFormatBaseTable = null;
        if (this.lif.getTtfTables().getCMapTable() != null) {
            ttfCMapFormatBaseTable = this.lif.getTtfTables().getCMapTable().findUnicodeTable();
        }
        long l = 0L;
        if (ttfCMapFormatBaseTable != null) {
            l = this.lif(ttfCMapFormatBaseTable, unicode);
            return new GlyphUInt32Id(l);
        }
        if (this.lif.getTtfTables().getPostTable() != null) {
            String string = I1.lif().ll(unicode);
            l = this.lif.getTtfTables().getPostTable().getGlyphIndex(string);
            if (l != 0L) {
                return new GlyphUInt32Id(l);
            }
        }
        if (this.lif.getTtfTables().getCMapTable() == null && this.lif.getTtfTables().getPostTable() == null) {
            throw new EncodingException("Font doesn't include tables to decode text");
        }
        return null;
    }

    @Override
    public GlyphId decodeToGidParameterized(IEncodingParameters parameters, long charCode) {
        GlyphUInt32Id glyphUInt32Id = null;
        TtfEncodingParameters ttfEncodingParameters = (TtfEncodingParameters)((Object)I07.lif(parameters, TtfEncodingParameters.class));
        if (ttfEncodingParameters != null) {
            TtfCMapFormatBaseTable[] ttfCMapFormatBaseTableArray = this.lif.getTtfTables().getCMapTable().getPlatformTables(ttfEncodingParameters.getPlatformId(), ttfEncodingParameters.getPlatformSpecificId());
            glyphUInt32Id = new GlyphUInt32Id(ttfCMapFormatBaseTableArray[0].getGlyphIndex(charCode));
        }
        return glyphUInt32Id;
    }

    private long lif(TtfCMapFormatBaseTable ttfCMapFormatBaseTable, long l) {
        long l2 = ttfCMapFormatBaseTable.getGlyphIndex(l);
        if (l2 < (long)this.lif.getNumGlyphs()) {
            if (l2 == 0L && l < 256L) {
                l2 = ttfCMapFormatBaseTable.getGlyphIndex((char)(61440 + (int)l));
            }
        } else {
            l2 = 0L;
        }
        return l2;
    }
}

