/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.font;

import com.aspose.font.FontBBox;
import com.aspose.font.FontMetrics;
import com.aspose.font.GlyphId;
import com.aspose.font.GlyphUInt32Id;
import com.aspose.font.TransformationMatrix;
import com.aspose.font.TtfCMapFormatBaseTable;
import com.aspose.font.TtfFont;
import com.aspose.font.TtfHmtxTable;
import com.aspose.font.TtfTableRepository;
import com.aspose.font.internal.l4.I17l;
import com.aspose.font.internal.l45I.I07;

public class TtfFontMetrics
extends FontMetrics {
    private TtfTableRepository lI;
    private FontBBox l1;
    private TransformationMatrix lIF;
    private Object llf = new Object();
    private Object liF = new Object();
    @Deprecated
    private TtfCMapFormatBaseTable lIf;
    private TtfFont lf;

    TtfFontMetrics(TtfFont owner) {
        TtfCMapFormatBaseTable[] ttfCMapFormatBaseTableArray;
        this.lf = owner;
        this.lI = owner.getTtfTables();
        if (this.lI != null && this.lI.getCMapTable() != null && (ttfCMapFormatBaseTableArray = this.lI.getCMapTable().getPlatformTables(3, 1)) != null && ttfCMapFormatBaseTableArray.length > 0) {
            this.lIf = ttfCMapFormatBaseTableArray[0];
        }
    }

    @Deprecated
    double lif(char c) {
        if (this.lIf == null) {
            return 0.0;
        }
        if (c == '\u0000') {
            return 0.0;
        }
        int n = (int)this.lIf.getGlyphIndex(c);
        TtfHmtxTable.LongHorMetric longHorMetric = this.lI.getHmtxTable().getHMetrics().get(n).clone();
        return (double)(longHorMetric.getAdvanceWidth() & 0xFFFF) / (double)(this.lI.getHeadTable().getUnitsPerEM() & 0xFFFFFFFFL);
    }

    @Override
    public double getGlyphWidth(GlyphId glyphId) {
        GlyphUInt32Id glyphUInt32Id = (GlyphUInt32Id)((Object)I07.lif(glyphId, GlyphUInt32Id.class));
        if (glyphUInt32Id != null) {
            double d = 0.0;
            if (this.lI.getHmtxTable() != null && this.lI.getHmtxTable().getHMetrics().size() == 1) {
                d = this.lI.getHmtxTable().getHMetrics().get(0).getAdvanceWidth() & 0xFFFF;
            } else if (this.lI.getHmtxTable() != null) {
                d = glyphUInt32Id.getValue() <= (long)(this.lI.getHmtxTable().getHMetrics().size() - 1) ? (double)(this.lI.getHmtxTable().getHMetrics().get((int)glyphUInt32Id.getValue()).getAdvanceWidth() & 0xFFFF) : (double)(this.lI.getHmtxTable().getAdditionalAdvanceWidth() & 0xFFFF);
            } else if (this.lI.getHheaTable() != null) {
                d = this.lI.getHheaTable().getAdvanceWidthMax() & 0xFFFF;
            }
            return d;
        }
        return super.getGlyphWidth(glyphId);
    }

    @Override
    public double measureString(String unicode, double fontSize) {
        double d = 0.0;
        if (this.lI.getCMapTable() != null) {
            for (int i = 0; i < unicode.length(); ++i) {
                GlyphId glyphId = this.lf.getEncoding().decodeToGid(unicode.charAt(i));
                if (glyphId == null) continue;
                d += this.getGlyphWidth(glyphId) / (double)this.getUnitsPerEM() * 1000.0;
            }
        }
        return d * fontSize / 1000.0;
    }

    public double measureString(long[] charCodes, double fontSize) {
        double d = 0.0;
        if (this.lI.getCMapTable() == null) {
            return 0.0;
        }
        for (int i = 0; i < charCodes.length; ++i) {
            GlyphId glyphId = this.lf.getEncoding().decodeToGid(charCodes[i]);
            if (glyphId == null) continue;
            d += this.getGlyphWidth(glyphId) / (double)this.getUnitsPerEM();
        }
        return d * fontSize;
    }

    @Override
    public double getAscender() {
        if (this.lI.getHheaTable() != null) {
            return this.lI.getHheaTable().getAscent();
        }
        return 0.0;
    }

    @Override
    public void setAscender(double value) {
        if (this.lI.getHheaTable() != null) {
            this.lI.getHheaTable().l1((short)value);
        }
    }

    @Override
    public double getDescender() {
        if (this.lI.getHheaTable() != null) {
            return this.lI.getHheaTable().getDescent();
        }
        return 0.0;
    }

    @Override
    public void setDescender(double value) {
        if (this.lI.getHheaTable() != null) {
            this.lI.getHheaTable().lIF((short)value);
        }
    }

    @Override
    public double getTypoAscender() {
        if (this.lI.getOs2Table() != null) {
            return this.lI.getOs2Table().getSTypoAscender();
        }
        return this.getAscender();
    }

    @Override
    public void setTypoAscender(double value) {
        if (this.lI.getOs2Table() != null) {
            this.lI.getOs2Table().ll((short)value);
        }
    }

    @Override
    public double getTypoDescender() {
        if (this.lI.getOs2Table() != null) {
            return this.lI.getOs2Table().getSTypoDescender();
        }
        return this.getDescender();
    }

    @Override
    public void setTypoDescender(double value) {
        if (this.lI.getOs2Table() != null) {
            this.lI.getOs2Table().lI((short)value);
        }
    }

    @Override
    public double getLineGap() {
        if (this.lI.getHheaTable() != null) {
            return this.lI.getHheaTable().getLineGap();
        }
        return 0.0;
    }

    @Override
    public double getTypoLineGap() {
        if (this.lI.getOs2Table() != null) {
            return this.lI.getOs2Table().getSTypoLineGap();
        }
        return this.getLineGap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FontBBox getFontBBox() {
        if (this.l1 != null) {
            return this.l1;
        }
        Object object = this.llf;
        synchronized (object) {
            if (this.l1 != null) {
                return this.l1;
            }
            this.l1 = this.lI.getHeadTable() != null ? new FontBBox(this.lI.getHeadTable().getXMin(), this.lI.getHeadTable().getYMin(), this.lI.getHeadTable().getXMax(), this.lI.getHeadTable().getYMax()) : new FontBBox(0.0, 0.0, 0.0, 0.0);
        }
        return this.l1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransformationMatrix getFontMatrix() {
        if (this.lIF == null) {
            Object object = this.liF;
            synchronized (object) {
                if (this.lIF == null) {
                    this.lIF = new TransformationMatrix(new double[]{1.0 / (double)(this.getUnitsPerEM() & 0xFFFFFFFFL), 0.0, 0.0, 1.0 / (double)(this.getUnitsPerEM() & 0xFFFFFFFFL), 0.0, 0.0});
                }
            }
        }
        return this.lIF;
    }

    @Override
    public double getKerningValue(GlyphId prevGlyphId, GlyphId nextGlyphId) {
        if (this.ll.size() > 0) {
            return super.getKerningValue(prevGlyphId, nextGlyphId);
        }
        if (this.lI.lI() != null && this.lI.lI().lI().ll.size() > 0) {
            return this.lI.lI().lI().getKerningValue(prevGlyphId, nextGlyphId);
        }
        return 0.0;
    }

    @Override
    public long getUnitsPerEM() {
        if (this.lI.getHeadTable() == null) {
            return 1000L;
        }
        return this.lI.getHeadTable().getUnitsPerEM();
    }

    @Override
    public void setUnitsPerEM(long value) {
        if (this.lI.getHeadTable() != null) {
            this.lI.getHeadTable().lif(value);
        }
    }

    @Override
    int lif(GlyphId glyphId) {
        GlyphUInt32Id glyphUInt32Id = (GlyphUInt32Id)((Object)I07.lif(glyphId, GlyphUInt32Id.class));
        if (glyphUInt32Id != null) {
            return I17l.lif(glyphUInt32Id.getValue());
        }
        return glyphId.hashCode();
    }
}

