/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.font.internal.l36I;

import com.aspose.font.internal.l23l.I0l;
import com.aspose.font.internal.l23l.I21;
import com.aspose.font.internal.l31I.I71;
import com.aspose.font.internal.l31I.Il;
import com.aspose.font.internal.l354.I34;
import com.aspose.font.internal.l354.I3I;
import com.aspose.font.internal.l36I.I134;
import com.aspose.font.internal.l36I.I1611;
import com.aspose.font.internal.l36I.I51;
import com.aspose.font.internal.l36I.II;
import java.security.InvalidAlgorithmParameterException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertPathValidatorSpi;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.PolicyNode;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

class I131
extends CertPathValidatorSpi {
    private final Provider lif;

    I131(Provider provider) {
        this.lif = provider;
    }

    public CertPathValidatorResult engineValidate(CertPath certPath, CertPathParameters certPathParameters) throws CertPathValidatorException, InvalidAlgorithmParameterException {
        HashSet hashSet;
        PublicKey publicKey;
        X500Principal x500Principal;
        TrustAnchor trustAnchor;
        I34 i34;
        if (certPathParameters instanceof I34) {
            i34 = (I34)certPathParameters;
        } else if (certPathParameters instanceof I3I) {
            i34 = ((I3I)certPathParameters).lif();
        } else if (certPathParameters instanceof PKIXParameters) {
            i34 = new I34.I7((PKIXParameters)certPathParameters).lif();
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be " + PKIXParameters.class.getName() + " or " + I34.class.getName() + " instance.");
        }
        if (i34.lf() == null) {
            throw new InvalidAlgorithmParameterException("trustAnchors is null, this is not allowed for certification path validation.");
        }
        List<? extends Certificate> list = certPath.getCertificates();
        int n = list.size();
        if (list.isEmpty()) {
            throw new CertPathValidatorException("Certification path is empty.", null, certPath, -1);
        }
        Set set = i34.l0if();
        try {
            trustAnchor = I51.lif((X509Certificate)list.get(list.size() - 1), i34.lf(), i34.l0l());
        }
        catch (II iI) {
            throw new CertPathValidatorException(iI.getMessage(), (Throwable)iI, certPath, list.size() - 1);
        }
        if (trustAnchor == null) {
            throw new CertPathValidatorException("Trust anchor for certification path not found.", null, certPath, -1);
        }
        i34 = new I34.I7(i34).lif(trustAnchor).lif();
        int n2 = 0;
        List[] listArray = new ArrayList[n + 1];
        for (int i = 0; i < listArray.length; ++i) {
            listArray[i] = new ArrayList();
        }
        HashSet<String> hashSet2 = new HashSet<String>();
        hashSet2.add("2.5.29.32.0");
        I134 i134 = new I134(new ArrayList(), 0, hashSet2, null, new HashSet(), "2.5.29.32.0", false);
        listArray[0].add(i134);
        I71 i71 = new I71();
        HashSet hashSet3 = new HashSet();
        int n3 = i34.l0I() ? 0 : n + 1;
        int n4 = i34.l01() ? 0 : n + 1;
        int n5 = i34.l0IF() ? 0 : n + 1;
        X509Certificate x509Certificate = trustAnchor.getTrustedCert();
        try {
            if (x509Certificate != null) {
                x500Principal = I51.ll(x509Certificate);
                publicKey = x509Certificate.getPublicKey();
            } else {
                x500Principal = new X500Principal(trustAnchor.getCAName());
                publicKey = trustAnchor.getCAPublicKey();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CertPathValidatorException("Subject of trust anchor could not be (re)encoded.", (Throwable)illegalArgumentException, certPath, -1);
        }
        Il il = null;
        try {
            il = I51.lif(publicKey);
        }
        catch (CertPathValidatorException certPathValidatorException) {
            throw new CertPathValidatorException("Algorithm identifier of public key of trust anchor could not be read.", (Throwable)certPathValidatorException, certPath, -1);
        }
        I21 i21 = il.lif();
        I0l i0l = il.ll();
        int n6 = n;
        if (i34.lIf() != null && !i34.lIf().lif((X509Certificate)list.get(0))) {
            throw new CertPathValidatorException("Target certificate in certification path does not match targetConstraints.", null, certPath, 0);
        }
        List list2 = i34.l0lf();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            ((PKIXCertPathChecker)iterator.next()).init(false);
        }
        X509Certificate x509Certificate2 = null;
        for (n2 = list.size() - 1; n2 >= 0; --n2) {
            boolean bl;
            int n7 = n - n2;
            x509Certificate2 = (X509Certificate)list.get(n2);
            boolean bl2 = bl = n2 == list.size() - 1;
            if (x509Certificate2 == null) {
                throw new CertPathValidatorException("NULL certificate found", null, certPath, n2);
            }
            I1611.lif(certPath, i34, n2, publicKey, bl, x500Principal, x509Certificate, this.lif);
            I1611.lif(certPath, n2, i71);
            i134 = I1611.lif(certPath, n2, hashSet3, i134, listArray, n4);
            i134 = I1611.lif(certPath, n2, i134);
            I1611.lif(certPath, n2, i134, n3);
            if (n7 == n) continue;
            if (x509Certificate2.getVersion() == 1) {
                throw new CertPathValidatorException("Version 1 certificates can't be used as CA ones.", null, certPath, n2);
            }
            I1611.lif(certPath, n2);
            i134 = I1611.lif(certPath, n2, listArray, i134, n5);
            I1611.ll(certPath, n2, i71);
            n3 = I1611.llf(certPath, n2, n3);
            n5 = I1611.liF(certPath, n2, n5);
            n4 = I1611.lIf(certPath, n2, n4);
            n3 = I1611.lif(certPath, n2, n3);
            n5 = I1611.ll(certPath, n2, n5);
            n4 = I1611.lI(certPath, n2, n4);
            I1611.ll(certPath, n2);
            n6 = I1611.l1(certPath, n2, n6);
            n6 = I1611.lIF(certPath, n2, n6);
            I1611.lI(certPath, n2);
            hashSet = x509Certificate2.getCriticalExtensionOIDs();
            if (hashSet != null) {
                hashSet = new HashSet(hashSet);
                hashSet.removeAll(I1611.l0f);
            } else {
                hashSet = new HashSet();
            }
            I1611.lif(certPath, n2, hashSet, list2);
            x509Certificate = x509Certificate2;
            x500Principal = I51.ll(x509Certificate);
            try {
                publicKey = I51.lif(certPath.getCertificates(), n2, this.lif);
            }
            catch (CertPathValidatorException certPathValidatorException) {
                throw new CertPathValidatorException("Next working key could not be retrieved.", (Throwable)certPathValidatorException, certPath, n2);
            }
            il = I51.lif(publicKey);
            i21 = il.lif();
            i0l = il.ll();
        }
        n3 = I1611.lif(n3, x509Certificate2);
        n3 = I1611.lf(certPath, n2 + 1, n3);
        Set<String> set2 = x509Certificate2.getCriticalExtensionOIDs();
        if (set2 != null) {
            set2 = new HashSet<String>(set2);
            set2.removeAll(I1611.l0f);
            set2.remove(com.aspose.font.internal.l31I.I34.l1I.lI());
        } else {
            set2 = new HashSet<String>();
        }
        I1611.lif(certPath, n2 + 1, list2, set2);
        hashSet = I1611.lif(certPath, i34, set, n2 + 1, listArray, i134, hashSet3);
        if (n3 > 0 || hashSet != null) {
            return new PKIXCertPathValidatorResult(trustAnchor, (PolicyNode)((Object)hashSet), x509Certificate2.getPublicKey());
        }
        throw new CertPathValidatorException("Path processing failed on policy.", null, certPath, n2);
    }
}

