/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.font.internal.l36I;

import com.aspose.font.internal.l31I.I34;
import com.aspose.font.internal.l354.I24;
import com.aspose.font.internal.l354.I37;
import com.aspose.font.internal.l354.I3I;
import com.aspose.font.internal.l36I.I131;
import com.aspose.font.internal.l36I.I4l;
import com.aspose.font.internal.l36I.I51;
import com.aspose.font.internal.l36I.I6l;
import com.aspose.font.internal.l36I.II;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

class I13I
extends CertPathBuilderSpi {
    private final I4l lif;
    private II ll;

    I13I(I4l i4l) {
        this.lif = i4l;
    }

    public CertPathBuilderResult engineBuild(CertPathParameters certPathParameters) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        Collection collection;
        I3I i3I = null;
        if (certPathParameters instanceof I3I) {
            i3I = (I3I)certPathParameters;
        } else if (certPathParameters instanceof PKIXBuilderParameters) {
            i3I = new I3I.I7((PKIXBuilderParameters)certPathParameters).lif();
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be an instance of " + PKIXBuilderParameters.class.getName() + " or " + I3I.class.getName() + ".");
        }
        ArrayList arrayList = new ArrayList();
        I37 i37 = i3I.lif().lIf();
        try {
            collection = I51.lif(i37, i3I.lif().lif());
            collection.addAll(I51.lif(i37, i3I.lif().l0iF()));
        }
        catch (II iI) {
            throw new CertPathBuilderException("Error finding target certificate.", iI);
        }
        if (collection.isEmpty()) {
            throw new CertPathBuilderException("No certificate found matching targetContraints.");
        }
        CertPathBuilderResult certPathBuilderResult = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && certPathBuilderResult == null) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            certPathBuilderResult = this.lif(x509Certificate, i3I, arrayList);
        }
        if (certPathBuilderResult == null && this.ll != null) {
            throw new CertPathBuilderException(this.ll.getMessage(), this.ll.getCause());
        }
        if (certPathBuilderResult == null) {
            throw new CertPathBuilderException("Unable to find certificate chain.");
        }
        return certPathBuilderResult;
    }

    protected CertPathBuilderResult lif(X509Certificate x509Certificate, I3I i3I, List list) throws CertPathBuilderException {
        I131 i131;
        I6l i6l;
        if (list.contains(x509Certificate)) {
            return null;
        }
        if (i3I.ll().contains(x509Certificate)) {
            return null;
        }
        if (i3I.lI() != -1 && list.size() - 1 > i3I.lI()) {
            return null;
        }
        list.add(x509Certificate);
        CertPathBuilderResult certPathBuilderResult = null;
        try {
            i6l = new I6l(this.lif);
            i131 = new I131(this.lif);
        }
        catch (Exception exception) {
            throw new CertPathBuilderException("Exception creating support classes: " + exception.getMessage(), exception);
        }
        try {
            if (I51.lif(x509Certificate, i3I.lif().lf(), i3I.lif().l0l()) != null) {
                CertPath certPath = null;
                PKIXCertPathValidatorResult pKIXCertPathValidatorResult = null;
                try {
                    certPath = i6l.engineGenerateCertPath(list);
                }
                catch (Exception exception) {
                    throw new II("Certification path could not be constructed from certificate list.", exception);
                }
                try {
                    pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)i131.engineValidate(certPath, i3I);
                }
                catch (Exception exception) {
                    throw new II("Certification path could not be validated.", exception);
                }
                return new PKIXCertPathBuilderResult(certPath, pKIXCertPathValidatorResult.getTrustAnchor(), pKIXCertPathValidatorResult.getPolicyTree(), pKIXCertPathValidatorResult.getPublicKey());
            }
            ArrayList<I24> arrayList = new ArrayList<I24>();
            arrayList.addAll(i3I.lif().lif());
            try {
                arrayList.addAll(I51.lif(x509Certificate.getExtensionValue(I34.llf.lI()), i3I.lif().ll()));
            }
            catch (CertificateParsingException certificateParsingException) {
                throw new II("No additional X.509 stores can be added from certificate locations.", certificateParsingException);
            }
            HashSet hashSet = new HashSet();
            try {
                hashSet.addAll(I51.lif(x509Certificate, i3I.lif().l0iF(), arrayList));
            }
            catch (II iI) {
                throw new II("Cannot find issuer certificate for certificate in certification path.", iI);
            }
            if (hashSet.isEmpty()) {
                throw new II("No issuer certificate for certificate in certification path found.");
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext() && certPathBuilderResult == null) {
                X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
                certPathBuilderResult = this.lif(x509Certificate2, i3I, list);
            }
        }
        catch (II iI) {
            this.ll = iI;
        }
        if (certPathBuilderResult == null) {
            list.remove(x509Certificate);
        }
        return certPathBuilderResult;
    }
}

