/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.font.internal.l36I;

import com.aspose.font.internal.l23l.I21;
import com.aspose.font.internal.l23l.I24;
import com.aspose.font.internal.l23l.I2I;
import com.aspose.font.internal.l23l.I31;
import com.aspose.font.internal.l304.I7;
import com.aspose.font.internal.l317.I1;
import com.aspose.font.internal.l31I.I107;
import com.aspose.font.internal.l31I.I10I;
import com.aspose.font.internal.l31I.I17;
import com.aspose.font.internal.l31I.I1l;
import com.aspose.font.internal.l31I.I27;
import com.aspose.font.internal.l31I.I34;
import com.aspose.font.internal.l31I.I41;
import com.aspose.font.internal.l31I.I47;
import com.aspose.font.internal.l31I.I54;
import com.aspose.font.internal.l36I.I1611;
import com.aspose.font.internal.l36I.I1624;
import com.aspose.font.internal.l36I.I1631;
import com.aspose.font.internal.l381.I37;
import com.aspose.font.internal.l384.I0I;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

class I1637
extends X509CRL {
    private final Provider lif;
    private final I27 ll;
    private final String lI;
    private final byte[] l1;
    private final boolean lIF;
    private volatile boolean llf = false;
    private volatile int liF;

    static boolean lif(X509CRL x509CRL) throws CRLException {
        try {
            byte[] byArray = x509CRL.getExtensionValue(I34.l01.lI());
            return byArray != null && I54.lif(I24.lif(byArray).lIF()).lI();
        }
        catch (Exception exception) {
            throw new CRLException("Exception reading IssuingDistributionPoint", exception);
        }
    }

    protected I1637(Provider provider, I27 i27) throws CRLException {
        this.lif = provider;
        this.ll = i27;
        try {
            this.lI = I1631.lif(i27.l1());
            this.l1 = (byte[])(i27.l1().ll() != null ? i27.l1().ll().l0l().lif("DER") : null);
            this.lIF = I1637.lif(this);
        }
        catch (Exception exception) {
            throw new CRLException("CRL contents invalid: " + exception);
        }
    }

    public boolean hasUnsupportedCriticalExtension() {
        Set set = this.getCriticalExtensionOIDs();
        if (set == null) {
            return false;
        }
        set.removeAll(I1611.l1if);
        return !set.isEmpty();
    }

    private Set lif(boolean bl) {
        I47 i47;
        if (this.getVersion() == 2 && (i47 = this.ll.lif().lf()) != null) {
            HashSet<String> hashSet = new HashSet<String>();
            Enumeration enumeration = i47.lif();
            while (enumeration.hasMoreElements()) {
                I21 i21 = (I21)enumeration.nextElement();
                I34 i34 = i47.lif(i21);
                if (bl != i34.ll()) continue;
                hashSet.add(i21.lI());
            }
            return hashSet;
        }
        return null;
    }

    public Set getCriticalExtensionOIDs() {
        return this.lif(true);
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.lif(false);
    }

    public byte[] getExtensionValue(String string) {
        I34 i34;
        I47 i47 = this.ll.lif().lf();
        if (i47 != null && (i34 = i47.lif(new I21(string))) != null) {
            try {
                return i34.lI().l0I();
            }
            catch (Exception exception) {
                throw new IllegalStateException("error parsing " + exception.toString());
            }
        }
        return null;
    }

    public byte[] getEncoded() throws CRLException {
        try {
            return this.ll.lif("DER");
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.toString());
        }
    }

    public void verify(PublicKey publicKey) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature;
        try {
            signature = Signature.getInstance(this.getSigAlgName(), this.lif);
        }
        catch (Exception exception) {
            signature = Signature.getInstance(this.getSigAlgName());
        }
        this.lif(publicKey, signature);
    }

    public void verify(PublicKey publicKey, String string) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature = string != null ? Signature.getInstance(this.getSigAlgName(), string) : Signature.getInstance(this.getSigAlgName());
        this.lif(publicKey, signature);
    }

    public void verify(PublicKey publicKey, Provider provider) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature signature = provider != null ? Signature.getInstance(this.getSigAlgName(), provider) : Signature.getInstance(this.getSigAlgName());
        this.lif(publicKey, signature);
    }

    private void lif(PublicKey publicKey, Signature signature) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (!this.ll.l1().equals(this.ll.lif().lI())) {
            throw new CRLException("Signature algorithm on CertificateList does not match TBSCertList.");
        }
        if (this.l1 != null) {
            try {
                I1631.lif(signature, I31.ll(this.l1));
            }
            catch (IOException iOException) {
                throw new SignatureException("cannot decode signature parameters: " + iOException.getMessage());
            }
        }
        signature.initVerify(publicKey);
        signature.update(this.getTBSCertList());
        if (!signature.verify(this.getSignature())) {
            throw new SignatureException("CRL does not verify with supplied public key.");
        }
    }

    public int getVersion() {
        return this.ll.llf();
    }

    public Principal getIssuerDN() {
        return this.getIssuerX500Principal();
    }

    public X500Principal getIssuerX500Principal() {
        try {
            return new X500Principal(this.ll.liF().l0I());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode issuer DN");
        }
    }

    public Date getThisUpdate() {
        return this.ll.lIf().ll();
    }

    public Date getNextUpdate() {
        if (this.ll.lf() != null) {
            return this.ll.lf().ll();
        }
        return null;
    }

    private Set lif() {
        HashSet<I1624> hashSet = new HashSet<I1624>();
        Enumeration enumeration = this.ll.lI();
        I1 i1 = null;
        while (enumeration.hasMoreElements()) {
            I34 i34;
            I107.I7 i7 = (I107.I7)enumeration.nextElement();
            I1624 i1624 = new I1624(i7, this.lIF, i1);
            hashSet.add(i1624);
            if (!this.lIF || !i7.l1() || (i34 = i7.lI().lif(I34.l0IF)) == null) continue;
            i1 = I1.lif(I41.lif(i34.l1()).lif()[0].ll());
        }
        return hashSet;
    }

    public X509CRLEntry getRevokedCertificate(BigInteger bigInteger) {
        Enumeration enumeration = this.ll.lI();
        I1 i1 = null;
        while (enumeration.hasMoreElements()) {
            I34 i34;
            I107.I7 i7 = (I107.I7)enumeration.nextElement();
            if (bigInteger.equals(i7.lif().lI())) {
                return new I1624(i7, this.lIF, i1);
            }
            if (!this.lIF || !i7.l1() || (i34 = i7.lI().lif(I34.l0IF)) == null) continue;
            i1 = I1.lif(I41.lif(i34.l1()).lif()[0].ll());
        }
        return null;
    }

    public Set getRevokedCertificates() {
        Set set = this.lif();
        if (!set.isEmpty()) {
            return Collections.unmodifiableSet(set);
        }
        return null;
    }

    public byte[] getTBSCertList() throws CRLException {
        try {
            return this.ll.lif().lif("DER");
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.toString());
        }
    }

    public byte[] getSignature() {
        return this.ll.lIF().lIF();
    }

    public String getSigAlgName() {
        return this.lI;
    }

    public String getSigAlgOID() {
        return this.ll.l1().lif().lI();
    }

    public byte[] getSigAlgParams() {
        if (this.l1 != null) {
            byte[] byArray = new byte[this.l1.length];
            System.arraycopy(this.l1, 0, byArray, 0, byArray.length);
            return byArray;
        }
        return null;
    }

    public String toString() {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        String string = I37.ll();
        stringBuffer.append("              Version: ").append(this.getVersion()).append(string);
        stringBuffer.append("             IssuerDN: ").append(this.getIssuerDN()).append(string);
        stringBuffer.append("          This update: ").append(this.getThisUpdate()).append(string);
        stringBuffer.append("          Next update: ").append(this.getNextUpdate()).append(string);
        stringBuffer.append("  Signature Algorithm: ").append(this.getSigAlgName()).append(string);
        byte[] byArray = this.getSignature();
        stringBuffer.append("            Signature: ").append(I37.ll(I0I.ll(byArray, 0, 20))).append(string);
        for (int i = 20; i < byArray.length; i += 20) {
            if (i < byArray.length - 20) {
                stringBuffer.append("                       ").append(I37.ll(I0I.ll(byArray, i, 20))).append(string);
                continue;
            }
            stringBuffer.append("                       ").append(I37.ll(I0I.ll(byArray, i, byArray.length - i))).append(string);
        }
        I47 i47 = this.ll.lif().lf();
        if (i47 != null) {
            object2 = i47.lif();
            if (object2.hasMoreElements()) {
                stringBuffer.append("           Extensions: ").append(string);
            }
            while (object2.hasMoreElements()) {
                object = (I21)object2.nextElement();
                I34 i34 = i47.lif((I21)object);
                if (i34.lI() != null) {
                    byte[] byArray2 = i34.lI().lIF();
                    stringBuffer.append("                       critical(").append(i34.ll()).append(") ");
                    try {
                        I31 i31 = I31.ll(byArray2);
                        if (((I31)object).equals(I34.lIf)) {
                            stringBuffer.append(new I1l(com.aspose.font.internal.l23l.I27.lif(i31).l1())).append(string);
                            continue;
                        }
                        if (((I31)object).equals(I34.l0I)) {
                            stringBuffer.append("Base CRL: " + new I1l(com.aspose.font.internal.l23l.I27.lif(i31).l1())).append(string);
                            continue;
                        }
                        if (((I31)object).equals(I34.l01)) {
                            stringBuffer.append(I54.lif(i31)).append(string);
                            continue;
                        }
                        if (((I31)object).equals(I34.l0iF)) {
                            stringBuffer.append(I17.lif(i31)).append(string);
                            continue;
                        }
                        if (((I31)object).equals(I34.l11)) {
                            stringBuffer.append(I17.lif(i31)).append(string);
                            continue;
                        }
                        stringBuffer.append(((I21)object).lI());
                        stringBuffer.append(" value = ").append(I7.lif(i31)).append(string);
                    }
                    catch (Exception exception) {
                        stringBuffer.append(((I21)object).lI());
                        stringBuffer.append(" value = ").append("*****").append(string);
                    }
                    continue;
                }
                stringBuffer.append(string);
            }
        }
        if ((object2 = this.getRevokedCertificates()) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                stringBuffer.append(object.next());
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    public boolean isRevoked(Certificate certificate) {
        if (!certificate.getType().equals("X.509")) {
            throw new IllegalArgumentException("X.509 CRL used with non X.509 Cert");
        }
        Enumeration enumeration = this.ll.lI();
        I1 i1 = this.ll.liF();
        if (enumeration.hasMoreElements()) {
            BigInteger bigInteger = ((X509Certificate)certificate).getSerialNumber();
            while (enumeration.hasMoreElements()) {
                I2I i2I;
                I107.I7 i7 = I107.I7.lif(enumeration.nextElement());
                if (this.lIF && i7.l1() && (i2I = i7.lI().lif(I34.l0IF)) != null) {
                    i1 = I1.lif(I41.lif(i2I.l1()).lif()[0].ll());
                }
                if (!i7.lif().lI().equals(bigInteger)) continue;
                if (certificate instanceof X509Certificate) {
                    i2I = I1.lif(((X509Certificate)certificate).getIssuerX500Principal().getEncoded());
                } else {
                    try {
                        i2I = I10I.lif(certificate.getEncoded()).lIF();
                    }
                    catch (CertificateEncodingException certificateEncodingException) {
                        throw new IllegalArgumentException("Cannot process certificate: " + certificateEncodingException.getMessage(), certificateEncodingException);
                    }
                }
                return i1.equals(i2I);
            }
        }
        return false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof X509CRL)) {
            return false;
        }
        if (object instanceof I1637) {
            boolean bl;
            I1637 i1637 = (I1637)object;
            if (this.llf && (bl = i1637.llf) && i1637.liF != this.liF) {
                return false;
            }
            return this.ll.equals(i1637.ll);
        }
        return super.equals(object);
    }

    public int hashCode() {
        if (!this.llf) {
            this.liF = super.hashCode();
            this.llf = true;
        }
        return this.liF;
    }
}

