/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.font.internal.l36I;

import com.aspose.font.internal.l23l.I107;
import com.aspose.font.internal.l23l.I111;
import com.aspose.font.internal.l23l.I114;
import com.aspose.font.internal.l23l.I12l;
import com.aspose.font.internal.l23l.I21;
import com.aspose.font.internal.l23l.I31;
import com.aspose.font.internal.l23l.I34;
import com.aspose.font.internal.l23l.I3l;
import com.aspose.font.internal.l23l.I5l;
import com.aspose.font.internal.l287.I0l;
import com.aspose.font.internal.l287.I1;
import com.aspose.font.internal.l287.II;
import com.aspose.font.internal.l304.I7;
import com.aspose.font.internal.l31I.I04;
import com.aspose.font.internal.l31I.I14;
import com.aspose.font.internal.l31I.I47;
import com.aspose.font.internal.l31I.I4I;
import com.aspose.font.internal.l31I.I6l;
import com.aspose.font.internal.l31I.Il;
import com.aspose.font.internal.l31l.I4;
import com.aspose.font.internal.l36I.I1611;
import com.aspose.font.internal.l36I.I1631;
import com.aspose.font.internal.l36I.I4l;
import com.aspose.font.internal.l381.I37;
import com.aspose.font.internal.l384.I0I;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

class I163l
extends X509Certificate {
    private final I4l lif;
    private final I14 ll;
    private final I04 lI;
    private final boolean[] l1;
    private volatile PublicKey lIF;
    private volatile boolean llf;
    private volatile int liF;

    public I163l(I4l i4l, I14 i14) throws CertificateParsingException {
        byte[] byArray;
        this.lif = i4l;
        this.ll = i14;
        try {
            byArray = this.lif("2.5.29.19");
            this.lI = byArray != null ? I04.lif(I31.ll(byArray)) : null;
        }
        catch (Exception exception) {
            throw new CertificateParsingException("cannot construct BasicConstraints: " + exception);
        }
        try {
            byArray = this.lif("2.5.29.15");
            if (byArray != null) {
                I107 i107 = I107.lif(I31.ll(byArray));
                int n = (byArray = i107.llf()).length * 8 - i107.liF();
                this.l1 = new boolean[n < 9 ? 9 : n];
                for (int i = 0; i != n; ++i) {
                    this.l1[i] = (byArray[i / 8] & 128 >>> i % 8) != 0;
                }
            } else {
                this.l1 = null;
            }
        }
        catch (Exception exception) {
            throw new CertificateParsingException("cannot construct KeyUsage: " + exception);
        }
    }

    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.checkValidity(new Date());
    }

    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        if (date.getTime() > this.getNotAfter().getTime()) {
            throw new CertificateExpiredException("certificate expired on " + this.ll.liF().lif());
        }
        if (date.getTime() < this.getNotBefore().getTime()) {
            throw new CertificateNotYetValidException("certificate not valid till " + this.ll.llf().lif());
        }
    }

    public int getVersion() {
        return this.ll.lI();
    }

    public BigInteger getSerialNumber() {
        return this.ll.l1().lI();
    }

    public Principal getIssuerDN() {
        return this.getIssuerX500Principal();
    }

    public X500Principal getIssuerX500Principal() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            I3l i3l = new I3l(byteArrayOutputStream);
            i3l.lif(this.ll.lIF());
            return new X500Principal(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode issuer DN: " + iOException.getMessage(), iOException);
        }
    }

    public Principal getSubjectDN() {
        return this.getSubjectX500Principal();
    }

    public X500Principal getSubjectX500Principal() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            I3l i3l = new I3l(byteArrayOutputStream);
            i3l.lif(this.ll.lIf());
            return new X500Principal(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode issuer DN: " + iOException.getMessage(), iOException);
        }
    }

    public Date getNotBefore() {
        return this.ll.llf().ll();
    }

    public Date getNotAfter() {
        return this.ll.liF().ll();
    }

    public byte[] getTBSCertificate() throws CertificateEncodingException {
        try {
            return this.ll.lif().lif("DER");
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(iOException.toString());
        }
    }

    public byte[] getSignature() {
        return this.ll.l01().lIF();
    }

    public String getSigAlgName() {
        Object object;
        I4l i4l = this.lif;
        if (i4l != null && (object = i4l.getProperty("Alg.Alias.Signature." + this.getSigAlgOID())) != null) {
            return object;
        }
        object = Security.getProviders();
        for (int i = 0; i != ((Provider[])object).length; ++i) {
            String string = object[i].getProperty("Alg.Alias.Signature." + this.getSigAlgOID());
            if (string == null) continue;
            return string;
        }
        return this.getSigAlgOID();
    }

    public String getSigAlgOID() {
        return this.ll.l0if().lif().lI();
    }

    public byte[] getSigAlgParams() {
        if (this.ll.l0if().ll() != null) {
            try {
                return this.ll.l0if().ll().l0l().lif("DER");
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return null;
    }

    public boolean[] getIssuerUniqueID() {
        I107 i107 = this.ll.lif().l0if();
        if (i107 != null) {
            byte[] byArray = i107.llf();
            boolean[] blArray = new boolean[byArray.length * 8 - i107.liF()];
            for (int i = 0; i != blArray.length; ++i) {
                blArray[i] = (byArray[i / 8] & 128 >>> i % 8) != 0;
            }
            return blArray;
        }
        return null;
    }

    public boolean[] getSubjectUniqueID() {
        I107 i107 = this.ll.lif().l01();
        if (i107 != null) {
            byte[] byArray = i107.llf();
            boolean[] blArray = new boolean[byArray.length * 8 - i107.liF()];
            for (int i = 0; i != blArray.length; ++i) {
                blArray[i] = (byArray[i / 8] & 128 >>> i % 8) != 0;
            }
            return blArray;
        }
        return null;
    }

    public boolean[] getKeyUsage() {
        return this.l1;
    }

    public List getExtendedKeyUsage() throws CertificateParsingException {
        byte[] byArray = this.lif("2.5.29.37");
        if (byArray != null) {
            try {
                I34 i34 = I34.lif(byArray);
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i != i34.llf(); ++i) {
                    arrayList.add(((I21)i34.lif(i)).lI());
                }
                return Collections.unmodifiableList(arrayList);
            }
            catch (Exception exception) {
                throw new CertificateParsingException("error processing extended key usage extension");
            }
        }
        return null;
    }

    public int getBasicConstraints() {
        if (this.lI != null) {
            if (this.lI.lif()) {
                if (this.lI.ll() == null) {
                    return Integer.MAX_VALUE;
                }
                return this.lI.ll().intValue();
            }
            return -1;
        }
        return -1;
    }

    public Collection getSubjectAlternativeNames() throws CertificateParsingException {
        return I163l.lif(this.lif(com.aspose.font.internal.l31I.I34.lIF.lI()));
    }

    public Collection getIssuerAlternativeNames() throws CertificateParsingException {
        return I163l.lif(this.lif(com.aspose.font.internal.l31I.I34.llf.lI()));
    }

    public Set getCriticalExtensionOIDs() {
        if (this.getVersion() == 3) {
            HashSet<String> hashSet = new HashSet<String>();
            I47 i47 = this.ll.lif().l0IF();
            if (i47 != null) {
                Enumeration enumeration = i47.lif();
                while (enumeration.hasMoreElements()) {
                    I21 i21 = (I21)enumeration.nextElement();
                    com.aspose.font.internal.l31I.I34 i34 = i47.lif(i21);
                    if (!i34.ll()) continue;
                    hashSet.add(i21.lI());
                }
                return hashSet;
            }
        }
        return null;
    }

    private byte[] lif(String string) {
        com.aspose.font.internal.l31I.I34 i34;
        I47 i47 = this.ll.lif().l0IF();
        if (i47 != null && (i34 = i47.lif(new I21(string))) != null) {
            return i34.lI().lIF();
        }
        return null;
    }

    public byte[] getExtensionValue(String string) {
        com.aspose.font.internal.l31I.I34 i34;
        I47 i47 = this.ll.lif().l0IF();
        if (i47 != null && (i34 = i47.lif(new I21(string))) != null) {
            try {
                return i34.lI().l0I();
            }
            catch (Exception exception) {
                throw new IllegalStateException("error parsing " + exception.toString());
            }
        }
        return null;
    }

    public Set getNonCriticalExtensionOIDs() {
        if (this.getVersion() == 3) {
            HashSet<String> hashSet = new HashSet<String>();
            I47 i47 = this.ll.lif().l0IF();
            if (i47 != null) {
                Enumeration enumeration = i47.lif();
                while (enumeration.hasMoreElements()) {
                    I21 i21 = (I21)enumeration.nextElement();
                    com.aspose.font.internal.l31I.I34 i34 = i47.lif(i21);
                    if (i34.ll()) continue;
                    hashSet.add(i21.lI());
                }
                return hashSet;
            }
        }
        return null;
    }

    public boolean hasUnsupportedCriticalExtension() {
        I47 i47;
        if (this.getVersion() == 3 && (i47 = this.ll.lif().l0IF()) != null) {
            Set set = this.getCriticalExtensionOIDs();
            set.removeAll(I1611.l0f);
            return !set.isEmpty();
        }
        return false;
    }

    public PublicKey getPublicKey() {
        try {
            if (this.lIF == null) {
                this.lIF = this.lif.lif(this.ll.lf());
            }
            return this.lIF;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        try {
            return this.ll.lif("DER");
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(iOException.toString());
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof I163l) {
            I163l i163l = (I163l)object;
            if (this.llf && i163l.llf && this.liF != i163l.liF) {
                return false;
            }
            return this.ll.equals(i163l.ll);
        }
        return super.equals(object);
    }

    public int hashCode() {
        if (!this.llf) {
            this.liF = super.hashCode();
            this.llf = true;
        }
        return this.liF;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = I37.ll();
        stringBuffer.append("  [0]         Version: ").append(this.getVersion()).append(string);
        stringBuffer.append("         SerialNumber: ").append(this.getSerialNumber()).append(string);
        stringBuffer.append("             IssuerDN: ").append(this.getIssuerDN()).append(string);
        stringBuffer.append("           Start Date: ").append(this.getNotBefore()).append(string);
        stringBuffer.append("           Final Date: ").append(this.getNotAfter()).append(string);
        stringBuffer.append("            SubjectDN: ").append(this.getSubjectDN()).append(string);
        stringBuffer.append("           Public Key: ").append(this.getPublicKey()).append(string);
        stringBuffer.append("  Signature Algorithm: ").append(this.getSigAlgName()).append(string);
        byte[] byArray = this.getSignature();
        stringBuffer.append("            Signature: ").append(I37.ll(I0I.ll(byArray, 0, 20))).append(string);
        for (int i = 20; i < byArray.length; i += 20) {
            if (i < byArray.length - 20) {
                stringBuffer.append("                       ").append(I37.ll(I0I.ll(byArray, i, 20))).append(string);
                continue;
            }
            stringBuffer.append("                       ").append(I37.ll(I0I.ll(byArray, i, byArray.length - i))).append(string);
        }
        I47 i47 = this.ll.lif().l0IF();
        if (i47 != null) {
            Enumeration enumeration = i47.lif();
            if (enumeration.hasMoreElements()) {
                stringBuffer.append("       Extensions: \n");
            }
            while (enumeration.hasMoreElements()) {
                I21 i21 = (I21)enumeration.nextElement();
                com.aspose.font.internal.l31I.I34 i34 = i47.lif(i21);
                if (i34.lI() != null) {
                    byte[] byArray2 = i34.lI().lIF();
                    stringBuffer.append("                       critical(").append(i34.ll()).append(") ");
                    try {
                        I31 i31 = I31.ll(byArray2);
                        if (i21.equals(com.aspose.font.internal.l31I.I34.liF)) {
                            stringBuffer.append(I04.lif(i31)).append(string);
                            continue;
                        }
                        if (i21.equals(com.aspose.font.internal.l31I.I34.lI)) {
                            stringBuffer.append(I6l.lif(i31)).append(string);
                            continue;
                        }
                        if (i21.equals(II.ll)) {
                            stringBuffer.append(new I1((I107)i31)).append(string);
                            continue;
                        }
                        if (i21.equals(II.l1)) {
                            stringBuffer.append(new com.aspose.font.internal.l287.I4((I111)i31)).append(string);
                            continue;
                        }
                        if (i21.equals(II.l0l)) {
                            stringBuffer.append(new I0l((I111)i31)).append(string);
                            continue;
                        }
                        stringBuffer.append(i21.lI());
                        stringBuffer.append(" value = ").append(I7.lif(i31)).append(string);
                    }
                    catch (Exception exception) {
                        stringBuffer.append(i21.lI());
                        stringBuffer.append(" value = ").append("*****").append(string);
                    }
                    continue;
                }
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    public final void verify(PublicKey publicKey) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        String string = I1631.lif(this.ll.l0if());
        Signature signature = this.lif(this.lif, string);
        this.lif(publicKey, signature);
    }

    public final void verify(PublicKey publicKey, String string) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        String string2 = I1631.lif(this.ll.l0if());
        Signature signature = string != null ? Signature.getInstance(string2, string) : Signature.getInstance(string2);
        this.lif(publicKey, signature);
    }

    public final void verify(PublicKey publicKey, Provider provider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        String string = I1631.lif(this.ll.l0if());
        Signature signature = this.lif(provider, string);
        this.lif(publicKey, signature);
    }

    private Signature lif(Provider provider, String string) throws NoSuchAlgorithmException {
        if (provider != null) {
            try {
                return Signature.getInstance(string, provider);
            }
            catch (Exception exception) {
                return Signature.getInstance(string);
            }
        }
        return Signature.getInstance(string);
    }

    private void lif(PublicKey publicKey, Signature signature) throws CertificateException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        if (!this.lif(this.ll.l0if(), this.ll.lif().l1())) {
            throw new CertificateException("signature algorithm in TBS cert not same as outer cert");
        }
        com.aspose.font.internal.l23l.I0l i0l = this.ll.l0if().ll();
        I1631.lif(signature, i0l);
        signature.initVerify(publicKey);
        signature.update(this.getTBSCertificate());
        if (!signature.verify(this.getSignature())) {
            throw new SignatureException("certificate does not verify with supplied key");
        }
    }

    private boolean lif(Il il, Il il2) {
        if (!il.lif().equals(il2.lif())) {
            return false;
        }
        if (il.ll() == null) {
            return il2.ll() == null || il2.ll().equals(I114.lif);
        }
        if (il2.ll() == null) {
            return il.ll() == null || il.ll().equals(I114.lif);
        }
        return il.ll().equals(il2.ll());
    }

    private static Collection lif(byte[] byArray) throws CertificateParsingException {
        if (byArray == null) {
            return null;
        }
        try {
            ArrayList arrayList = new ArrayList();
            Enumeration enumeration = I34.lif(byArray).l1();
            block11: while (enumeration.hasMoreElements()) {
                I4I i4I = I4I.lif(enumeration.nextElement());
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                arrayList2.add(com.aspose.font.internal.l381.I0I.lif(i4I.lif()));
                switch (i4I.lif()) {
                    case 0: 
                    case 3: 
                    case 5: {
                        arrayList2.add(i4I.l0I());
                        break;
                    }
                    case 4: {
                        arrayList2.add(com.aspose.font.internal.l317.I1.lif(I4.l3If, i4I.ll()).toString());
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 6: {
                        arrayList2.add(((I5l)((Object)i4I.ll())).lI());
                        break;
                    }
                    case 8: {
                        arrayList2.add(I21.lif(i4I.ll()).lI());
                        break;
                    }
                    case 7: {
                        String string;
                        byte[] byArray2 = I12l.lif(i4I.ll()).lIF();
                        try {
                            string = InetAddress.getByAddress(byArray2).getHostAddress();
                        }
                        catch (UnknownHostException unknownHostException) {
                            continue block11;
                        }
                        arrayList2.add(string);
                        break;
                    }
                    default: {
                        throw new IOException("Bad tag number: " + i4I.lif());
                    }
                }
                arrayList.add(Collections.unmodifiableList(arrayList2));
            }
            if (arrayList.size() == 0) {
                return null;
            }
            return Collections.unmodifiableCollection(arrayList);
        }
        catch (Exception exception) {
            throw new CertificateParsingException(exception.getMessage());
        }
    }
}

