/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging;

import com.aspose.imaging.Color;
import com.aspose.imaging.IColorPalette;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.dO.d;
import com.aspose.imaging.internal.dP.g;
import com.aspose.imaging.internal.dP.w;

public final class ColorPalette
implements IColorPalette {
    private int[] a;
    private w b;
    private final boolean c;

    public ColorPalette(int[] argb32Entries, boolean isCompactPalette) {
        if (argb32Entries == null) {
            throw new ArgumentNullException("argb32Entries");
        }
        this.a = argb32Entries;
        this.b = new w(argb32Entries);
        this.c = isCompactPalette;
    }

    public ColorPalette(int[] argb32Entries) {
        this(argb32Entries, false);
    }

    public ColorPalette(Color[] entries, boolean isCompactPalette) {
        this(g.a(entries), isCompactPalette);
    }

    public ColorPalette(Color[] entries) {
        this(entries, false);
    }

    @Override
    public int getEntriesCount() {
        return this.a.length;
    }

    @Override
    public int[] getArgb32Entries() {
        int[] nArray = new int[this.a.length];
        System.arraycopy(this.a, 0, nArray, 0, this.a.length);
        return nArray;
    }

    @Override
    public Color[] getEntries() {
        Color[] colorArray = (Color[])com.aspose.imaging.internal.ap.g.a(com.aspose.imaging.internal.ap.g.a(d.a(Color.class), this.a.length));
        for (int i2 = 0; i2 < colorArray.length; ++i2) {
            Color.fromArgb(this.a[i2]).CloneTo(colorArray[i2]);
        }
        return colorArray;
    }

    @Override
    public boolean isCompactPalette() {
        return this.c;
    }

    public static ColorPalette copyPalette(IColorPalette colorPalette, boolean useCompactPalette) {
        ColorPalette colorPalette2 = null;
        if (colorPalette != null) {
            int[] nArray = new int[colorPalette.getEntriesCount()];
            com.aspose.imaging.internal.ap.g.a((Object)colorPalette.getArgb32Entries()).copyTo(com.aspose.imaging.internal.ap.g.a((Object)nArray), 0);
            colorPalette2 = new ColorPalette(nArray, useCompactPalette);
        }
        return colorPalette2;
    }

    public static ColorPalette copyPalette(IColorPalette colorPalette) {
        return ColorPalette.copyPalette(colorPalette, colorPalette != null ? colorPalette.isCompactPalette() : false);
    }

    @Override
    public int getNearestColorIndex(int argb32Color) {
        return this.b.a(argb32Color);
    }

    @Override
    public int getNearestColorIndex(Color color) {
        return this.b.a(color.toArgb());
    }

    @Override
    public int getArgb32Color(int index) {
        if (index >= this.a.length || index < 0) {
            throw new ArgumentOutOfRangeException("index", "The specified index lies out of the entries length.");
        }
        return this.a[index];
    }

    @Override
    public Color getColor(int index) {
        return Color.fromArgb(this.getArgb32Color(index));
    }
}

