/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging;

import com.aspose.imaging.Color;
import com.aspose.imaging.internal.ap.A;
import com.aspose.imaging.internal.ap.K;
import com.aspose.imaging.internal.ap.aY;
import com.aspose.imaging.internal.ap.ay;

public final class ColorTranslator {
    private ColorTranslator() {
    }

    public static Color fromHtml(String htmlColor) {
        Color color = Color.getEmpty();
        if (htmlColor != null && htmlColor.length() != 0) {
            if (htmlColor.charAt(0) == '#' && (htmlColor.length() == 7 || htmlColor.length() == 4)) {
                if (htmlColor.length() == 7) {
                    Color.fromArgb(K.e(aY.b(htmlColor, 1, 2), 16), K.e(aY.b(htmlColor, 3, 2), 16), K.e(aY.b(htmlColor, 5, 2), 16)).CloneTo(color);
                } else {
                    String string = A.t(htmlColor.charAt(1));
                    String string2 = A.t(htmlColor.charAt(2));
                    String string3 = A.t(htmlColor.charAt(3));
                    Color.fromArgb(K.e(aY.a(new String[]{string, string}), 16), K.e(aY.a(new String[]{string2, string2}), 16), K.e(aY.a(new String[]{string3, string3}), 16)).CloneTo(color);
                }
            }
            if (color.isEmpty() && aY.d(htmlColor, "LightGray", (short)5)) {
                Color.getLightGray().CloneTo(color);
            }
        }
        return color.Clone();
    }

    public static Color fromOle(int oleColor) {
        return Color.fromArgb(oleColor & 0xFF, oleColor >> 8 & 0xFF, oleColor >> 16 & 0xFF);
    }

    public static Color fromWin32(int win32Color) {
        return ColorTranslator.fromOle(win32Color);
    }

    public static String toHtml(Color c2) {
        String string = aY.a;
        if (!c2.isEmpty()) {
            if (c2.isNamedColor()) {
                if (Color.op_Equality(c2, Color.getLightGray())) {
                    return "LightGray";
                }
                return c2.getName();
            }
            int n2 = c2.toArgb();
            int n3 = n2 >> 16 & 0xFF;
            int n4 = n2 >> 8 & 0xFF;
            int n5 = n2 & 0xFF;
            return aY.a("#", ay.a(n3, "X2", null), ay.a(n4, "X2", null), ay.a(n5, "X2", null));
        }
        return string;
    }

    public static int toOle(Color c2) {
        return ColorTranslator.toWin32(c2);
    }

    public static int toWin32(Color c2) {
        int n2 = c2.toArgb();
        int n3 = n2 >> 16 & 0xFF;
        int n4 = n2 >> 8 & 0xFF;
        int n5 = n2 & 0xFF;
        return n3 | n4 << 8 | n5 << 16;
    }
}

