/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging;

import com.aspose.imaging.coreexceptions.FrameworkException;
import com.aspose.imaging.internal.ag.g;
import com.aspose.imaging.x;
import com.aspose.imaging.y;
import com.aspose.imaging.z;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.font.TextAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public final class FontSettings {
    static List<z> gFolders = new ArrayList<z>();
    private static boolean a = true;
    private static Map<Integer, Integer> b = new HashMap<Integer, Integer>();
    private static Map<String, Integer> c = new HashMap<String, Integer>();
    private static Map<Integer, String> d = new HashMap<Integer, String>();
    private static Map<Integer, x> e = new HashMap<Integer, x>();
    private static volatile int f = 0;
    private static Font g = new Font("Default", 0, 10);
    private static AtomicInteger h = new AtomicInteger(0);
    private static final Object i = new Object();

    FontSettings() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFontsFolder(String fontFolder) throws InterruptedException {
        if (gFolders.indexOf(fontFolder) != -1) {
            return;
        }
        String[] stringArray = i;
        synchronized (i) {
            FontSettings.writeLock();
            try {
                new z(fontFolder, true);
                FontSettings.fillFontMatches();
            }
            catch (Exception exception) {
                throw new FrameworkException(exception.getMessage(), exception);
            }
            stringArray = FontSettings.getFontsSources();
            com.aspose.imaging.internal.ag.g.e().a(stringArray, true);
            return;
        }
    }

    public static String[] getFontsSources() throws InterruptedException {
        FontSettings.lockReader();
        String[] stringArray = null;
        try {
            stringArray = new String[gFolders.size()];
            for (int i2 = 0; i2 < gFolders.size(); ++i2) {
                stringArray[i2] = FontSettings.gFolders.get((int)i2).a;
            }
        }
        finally {
            FontSettings.unlockReader();
        }
        return stringArray;
    }

    public static String[] getFontsFolders() {
        return com.aspose.imaging.internal.ag.g.e().b();
    }

    public static String[] getDefaultFontsFolders() {
        return com.aspose.imaging.internal.ag.g.a();
    }

    public static void setFontsFolders(String[] folders) throws InterruptedException {
        FontSettings.setFontsFolders(folders, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFontsFolders(String[] folders, boolean recursive) throws InterruptedException {
        Object object = i;
        synchronized (object) {
            FontSettings.writeLock();
            gFolders.clear();
            for (int i2 = 0; i2 < folders.length; ++i2) {
                try {
                    new z(folders[i2], recursive);
                    continue;
                }
                catch (Exception exception) {
                    throw new FrameworkException(exception.getMessage(), exception);
                }
            }
            FontSettings.fillFontMatches();
        }
        com.aspose.imaging.internal.ag.g.e().a(FontSettings.getFontsSources(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFontsFolder(String folder) throws InterruptedException {
        Object object = i;
        synchronized (object) {
            FontSettings.writeLock();
            try {
                gFolders.clear();
                new z(folder, true);
                FontSettings.fillFontMatches();
            }
            catch (Exception exception) {
                throw new FrameworkException(exception.getMessage(), exception);
            }
        }
        com.aspose.imaging.internal.ag.g.e().a(FontSettings.getFontsSources(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFontsFolder(String folder) throws InterruptedException {
        Object object = i;
        synchronized (object) {
            FontSettings.writeLock();
            int n2 = Collections.binarySearch(gFolders, z.a(folder), new y());
            if (n2 == -1) {
                return;
            }
            gFolders.get(n2).a();
            FontSettings.fillFontMatches();
        }
        com.aspose.imaging.internal.ag.g.e().a(FontSettings.getFontsSources(), false);
    }

    public static void useJavaFontEngine(boolean use) throws InterruptedException {
        a = use;
        if (!use && gFolders.isEmpty()) {
            String string = System.getenv("HOME");
            String string2 = System.getenv("windir");
            String[] stringArray = com.aspose.imaging.internal.ag.g.a();
            int n2 = stringArray.length;
            String[] stringArray2 = new String[n2 + 4];
            System.arraycopy(stringArray, 0, stringArray2, 0, n2);
            stringArray2[n2++] = "/usr/share/fonts";
            stringArray2[n2++] = "/usr/local/share/fonts";
            stringArray2[n2++] = string + "/.fonts";
            stringArray2[n2++] = string2 + "\\fonts";
            FontSettings.setFontsFolders(stringArray2);
        }
    }

    public static boolean isJavaFontEngineUsed() {
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetFontSources() throws InterruptedException {
        Object object = i;
        synchronized (object) {
            FontSettings.writeLock();
            gFolders.clear();
            e.clear();
        }
        com.aspose.imaging.internal.ag.g.e().c();
        FontSettings.useJavaFontEngine(a);
    }

    public static void reset() {
        try {
            FontSettings.resetFontSources();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Font findFont(String fontName, int fontStyle, int fontSize) throws InterruptedException {
        FontSettings.lockReader();
        try {
            Font font;
            if (!gFolders.isEmpty() && fontName != null && !fontName.isEmpty()) {
                Font font2;
                HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>();
                hashMap.put(TextAttribute.FAMILY, fontName);
                hashMap.put(TextAttribute.SIZE, fontSize);
                if ((fontStyle & 2) == 2) {
                    hashMap.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
                } else {
                    hashMap.put(TextAttribute.POSTURE, TextAttribute.POSTURE_REGULAR);
                }
                if ((fontStyle & 1) == 1) {
                    hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
                } else {
                    hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR);
                }
                hashMap.put(TextAttribute.SIZE, fontSize);
                Font font3 = font2 = FontSettings.findFont(hashMap);
                return font3;
            }
            if (a && (font = new Font(fontName, fontStyle, fontSize)).getFamily().equalsIgnoreCase("Dialog") && !font.getFamily().equals(g.getFamily())) {
                Font font4 = g.deriveFont(fontStyle, fontSize);
                return font4;
            }
            font = g.deriveFont(fontStyle, fontSize);
            return font;
        }
        finally {
            FontSettings.unlockReader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getAllFonts() throws InterruptedException {
        String[] stringArray = null;
        FontSettings.lockReader();
        try {
            Integer[] integerArray = e.keySet().toArray(new Integer[0]);
            String[] stringArray2 = a ? GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames() : new String[]{};
            stringArray = new String[integerArray.length + stringArray2.length];
            for (int i2 = 0; i2 < integerArray.length; ++i2) {
                stringArray[i2] = FontSettings.getStringByID(integerArray[i2]);
            }
            System.arraycopy(stringArray2, 0, stringArray, integerArray.length, stringArray2.length);
        }
        finally {
            FontSettings.unlockReader();
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFontSubstitutes(String originalFontName, String[] substituteFontNames) throws InterruptedException {
        Object object = i;
        synchronized (object) {
            FontSettings.writeLock();
            int n2 = FontSettings.getStringID(originalFontName);
            HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
            for (int i2 = 0; i2 < substituteFontNames.length; ++i2) {
                int n3 = FontSettings.getStringID(substituteFontNames[i2]);
                hashMap.put(n3, n2);
            }
            b.putAll(hashMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getFontSubstitutes(String originalFontName) throws InterruptedException {
        FontSettings.lockReader();
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            int n2 = FontSettings.getStringID(originalFontName);
            for (Map.Entry<Integer, Integer> entry : b.entrySet()) {
                if (entry.getValue() != n2) continue;
                arrayList.add(FontSettings.getStringByID(entry.getKey()));
            }
            String[] stringArray = arrayList.toArray(new String[0]);
            return stringArray;
        }
        finally {
            FontSettings.unlockReader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFontSubstitutes(String originalFontName, String[] substituteFontNames) throws InterruptedException {
        Object object = i;
        synchronized (object) {
            FontSettings.writeLock();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            int n2 = FontSettings.getStringID(originalFontName);
            for (Map.Entry<Integer, Integer> entry : b.entrySet()) {
                if (entry.getValue() != n2) continue;
                arrayList.add(entry.getKey());
            }
            while (!arrayList.isEmpty()) {
                b.remove(arrayList.get(0));
                arrayList.remove(0);
            }
        }
        FontSettings.addFontSubstitutes(originalFontName, substituteFontNames);
    }

    public static String getDefaultFontName() {
        return g.getFamily();
    }

    public static void setDefaultFontName(String fontName) throws InterruptedException {
        Font font = FontSettings.findFont(fontName, 0, 10);
        if (font.getFamily().equalsIgnoreCase(g.getFamily())) {
            throw new FrameworkException("Font " + fontName + " is not found!");
        }
        g = font;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Font findFont(Map attributes) throws InterruptedException {
        Map map = null;
        try {
            map = (Map)attributes.getClass().newInstance();
        }
        catch (Exception exception) {
            throw new FrameworkException(exception.getMessage(), exception);
        }
        map.putAll(attributes);
        FontSettings.lockReader();
        attributes = map;
        try {
            Font font = null;
            String string = (String)attributes.get(TextAttribute.FAMILY);
            if (!gFolders.isEmpty() && string != null && !string.isEmpty()) {
                int n2;
                int n3 = FontSettings.getStringID(string);
                int n4 = 0;
                Object object = (Float)attributes.get(TextAttribute.POSTURE);
                if (object != null && object != TextAttribute.POSTURE_REGULAR) {
                    n4 |= 2;
                }
                if ((object = (Float)attributes.get(TextAttribute.WEIGHT)) != null && ((Float)object).floatValue() >= TextAttribute.WEIGHT_BOLD.floatValue()) {
                    n4 |= 1;
                }
                if (e.containsKey(n3)) {
                    font = FontSettings.e.get((Object)Integer.valueOf((int)n3)).a[n4];
                }
                if (font == null && e.containsKey(n2 = FontSettings.getStringID((String)(object = FontSettings.getRealFontName(string))))) {
                    font = FontSettings.e.get((Object)Integer.valueOf((int)n2)).a[n4];
                }
                if (font != null) {
                    attributes.remove(TextAttribute.FAMILY);
                    object = font.deriveFont(attributes);
                    if (object != null) {
                        Object object2 = object;
                        return object2;
                    }
                }
            }
            if (a) {
                Font font2 = new Font(attributes);
                if (font2.getFamily().equalsIgnoreCase("Dialog") && !font2.getFamily().equals(g.getFamily())) {
                    attributes.remove(TextAttribute.FAMILY);
                    Font font3 = g.deriveFont(attributes);
                    return font3;
                }
                Font font4 = font2;
                return font4;
            }
            attributes.remove(TextAttribute.FAMILY);
            Font font5 = g.deriveFont(attributes);
            return font5;
        }
        finally {
            FontSettings.unlockReader();
        }
    }

    static int getFontStyle(Font font) {
        String string = font.getName().trim();
        String[] stringArray = string.split(" ");
        if (stringArray.length < 2) {
            return 0;
        }
        int n2 = 0;
        if (stringArray[stringArray.length - 1].equalsIgnoreCase("Italic")) {
            n2 |= 2;
            if (stringArray[stringArray.length - 2].equalsIgnoreCase("Bold")) {
                n2 |= 1;
            }
        } else if (stringArray[stringArray.length - 1].equalsIgnoreCase("Bold")) {
            n2 |= 1;
        }
        return n2;
    }

    static int getStringID(String txt) {
        if (c.containsKey(txt)) {
            return c.get(txt);
        }
        String string = txt.toLowerCase();
        if (c.containsKey(string)) {
            return c.get(string);
        }
        int n2 = ++f;
        c.put(txt, n2);
        c.put(string, n2);
        d.put(n2, txt);
        return n2;
    }

    static String getStringByID(int id2) {
        if (!d.containsKey(id2)) {
            return new String();
        }
        return d.get(id2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getRealFontName(String aliasName) throws InterruptedException {
        FontSettings.lockReader();
        try {
            int n2 = FontSettings.getStringID(aliasName);
            if (!b.containsKey(n2)) {
                String string = aliasName;
                return string;
            }
            int n3 = b.get(n2);
            String string = FontSettings.getStringByID(n3);
            return string;
        }
        finally {
            FontSettings.unlockReader();
        }
    }

    static void fillFontMatches() {
        Object object;
        e.clear();
        for (int i2 = gFolders.size() - 1; i2 >= 0; --i2) {
            object = FontSettings.gFolders.get((int)i2).b;
            for (int i3 = 0; i3 < object.size(); ++i3) {
                Font font = object.get(i3);
                String string = font.getFamily();
                int n2 = FontSettings.getStringID(string);
                x x2 = null;
                if (!e.containsKey(n2)) {
                    x2 = new x();
                    e.put(n2, x2);
                } else {
                    x2 = e.get(n2);
                }
                int n3 = FontSettings.getFontStyle(font);
                if (x2.a[n3] != null) continue;
                x2.a[n3] = font;
            }
        }
        Iterator<Map.Entry<Integer, x>> iterator = e.entrySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next().getValue();
            if (((x)object).a[3] == null) {
                ((x)object).a[3] = ((x)object).a[1] != null ? ((x)object).a[1] : (((x)object).a[2] != null ? ((x)object).a[2] : ((x)object).a[0]);
            }
            if (((x)object).a[2] == null) {
                ((x)object).a[2] = ((x)object).a[0];
            }
            if (((x)object).a[1] != null) continue;
            ((x)object).a[1] = ((x)object).a[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeLock() throws InterruptedException {
        AtomicInteger atomicInteger = h;
        synchronized (atomicInteger) {
            while (h.intValue() != 0) {
                h.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void lockReader() throws InterruptedException {
        Object object = i;
        synchronized (object) {
            h.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unlockReader() {
        AtomicInteger atomicInteger = h;
        synchronized (atomicInteger) {
            h.decrementAndGet();
            h.notify();
        }
    }
}

