/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging;

import com.aspose.imaging.Brush;
import com.aspose.imaging.Color;
import com.aspose.imaging.Font;
import com.aspose.imaging.GraphicsPath;
import com.aspose.imaging.IPartialArgb32PixelLoader;
import com.aspose.imaging.Image;
import com.aspose.imaging.ImageAttributes;
import com.aspose.imaging.Matrix;
import com.aspose.imaging.Pen;
import com.aspose.imaging.Point;
import com.aspose.imaging.PointF;
import com.aspose.imaging.RasterImage;
import com.aspose.imaging.Rectangle;
import com.aspose.imaging.RectangleF;
import com.aspose.imaging.Region;
import com.aspose.imaging.Size;
import com.aspose.imaging.SizeF;
import com.aspose.imaging.StringFormat;
import com.aspose.imaging.extensions.PointExtensions;
import com.aspose.imaging.internal.Exceptions.ArgumentException;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.Exceptions.OverflowException;
import com.aspose.imaging.internal.ap.g;
import com.aspose.imaging.internal.ax.b;
import com.aspose.imaging.internal.ax.cB;
import com.aspose.imaging.internal.ax.o;
import com.aspose.imaging.internal.ax.w;
import com.aspose.imaging.internal.az.N;
import com.aspose.imaging.internal.dP.R;
import com.aspose.imaging.internal.dP.Z;
import com.aspose.imaging.internal.dP.aE;
import com.aspose.imaging.internal.dP.ak;
import com.aspose.imaging.internal.dP.al;
import com.aspose.imaging.internal.dP.av;
import com.aspose.imaging.internal.dP.bp;
import com.aspose.imaging.internal.dP.h;
import com.aspose.imaging.internal.dW.c;
import com.aspose.imaging.internal.dW.i;
import com.aspose.imaging.internal.dW.j;
import com.aspose.imaging.internal.dW.k;
import com.aspose.imaging.internal.dW.l;
import com.aspose.imaging.internal.dW.m;
import com.aspose.imaging.internal.dW.n;
import com.aspose.imaging.internal.dW.p;
import com.aspose.imaging.internal.dW.q;
import com.aspose.imaging.internal.dW.r;
import com.aspose.imaging.internal.dW.s;
import com.aspose.imaging.internal.dW.t;
import com.aspose.imaging.internal.dW.u;
import com.aspose.imaging.internal.dW.v;
import com.aspose.imaging.internal.eb.d;
import com.aspose.imaging.internal.eb.f;
import com.aspose.imaging.internal.gP.e;
import com.aspose.imaging.system.collections.Generic.List;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Toolkit;

public final class Graphics {
    private final Image a;
    private boolean b;
    private Matrix c;
    private int d = 0;
    private int e = 0;
    private int f = 0;
    private int g = 0;
    private final List<R> h = new List();
    private Region i;
    private int j = 3;
    private float k = 1.0f;

    public Graphics(Image sourceImage) {
        if (sourceImage == null) {
            throw new ArgumentNullException("sourceImage");
        }
        this.a = sourceImage;
        this.i = new Region(new Rectangle(0, 0, this.a.getWidth(), this.a.getHeight()));
    }

    public float getDpiX() {
        float f2 = 96.0f;
        try {
            if (Toolkit.getDefaultToolkit() != null && !GraphicsEnvironment.isHeadless()) {
                f2 = Toolkit.getDefaultToolkit().getScreenResolution();
            }
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
        return f2;
    }

    public float getDpiY() {
        float f2 = 96.0f;
        try {
            if (Toolkit.getDefaultToolkit() != null && !GraphicsEnvironment.isHeadless()) {
                f2 = Toolkit.getDefaultToolkit().getScreenResolution();
            }
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
        return f2;
    }

    public int getPageUnit() {
        return this.j;
    }

    public void setPageUnit(int value) {
        this.j = value;
    }

    public float getPageScale() {
        return this.k;
    }

    public void setPageScale(float value) {
        this.k = value;
    }

    public Region getClip() {
        return this.i;
    }

    public void setClip(Region value) {
        this.i = value;
    }

    public Matrix getTransform() {
        return this.c;
    }

    public void setTransform(Matrix value) {
        this.c = value;
    }

    public boolean isInBeginUpdateCall() {
        return this.b;
    }

    public Image getImage() {
        return this.a;
    }

    public int getCompositingQuality() {
        return this.d;
    }

    public void setCompositingQuality(int value) {
        this.d = value;
    }

    public int getInterpolationMode() {
        return this.e;
    }

    public void setInterpolationMode(int value) {
        this.e = value;
    }

    public int getSmoothingMode() {
        return this.f;
    }

    public void setSmoothingMode(int value) {
        this.f = value;
    }

    public int getTextRenderingHint() {
        return this.g;
    }

    public void setTextRenderingHint(int value) {
        this.g = value;
    }

    public void resetTransform() {
        if (this.c != null) {
            this.c.reset();
        }
    }

    public void multiplyTransform(Matrix matrix) {
        if (this.c != null) {
            this.c.multiply(matrix);
        }
    }

    public void multiplyTransform(Matrix matrix, int order) {
        if (this.c != null) {
            this.c.multiply(matrix, order);
        }
    }

    public void translateTransform(float dx2, float dy2) {
        if (this.c != null) {
            this.c.translate(dx2, dy2);
        }
    }

    public void translateTransform(float dx2, float dy2, int order) {
        if (this.c != null) {
            this.c.translate(dx2, dy2, order);
        }
    }

    public void scaleTransform(float sx, float sy) {
        if (this.c != null) {
            this.c.scale(sx, sy);
        }
    }

    public void scaleTransform(float sx, float sy, int order) {
        if (this.c != null) {
            this.c.scale(sx, sy, order);
        }
    }

    public void rotateTransform(float angle) {
        if (this.c != null) {
            this.c.rotate(angle);
        }
    }

    public void rotateTransform(float angle, int order) {
        if (this.c != null) {
            this.c.rotate(angle, order);
        }
    }

    public void beginUpdate() {
        this.b = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endUpdate() {
        this.b = false;
        if (this.h.size() > 0) {
            try {
                R[] rArray = this.h.toArray((R[])new R[0]);
                for (int i2 = 0; i2 < rArray.length; ++i2) {
                    R r2 = rArray[i2];
                    r2.b(this.d);
                    r2.c(this.e);
                    r2.d(this.g);
                    r2.a(this.c);
                    r2.a(this.f);
                }
                a a2 = new a((RasterImage)((Object)com.aspose.imaging.internal.dO.d.a(this.getImage(), RasterImage.class)), rArray);
                aE.a(this.getImage().getBounds().Clone(), a2);
            }
            finally {
                this.h.clear();
            }
        }
    }

    public void a(R r2) {
        if (r2 == null) {
            throw new ArgumentNullException("effect");
        }
        this.b(r2);
    }

    public void clear(Color color) {
        com.aspose.imaging.internal.dW.a a2 = new com.aspose.imaging.internal.dW.a();
        a2.a(color.Clone());
        this.b(a2);
    }

    public void drawLine(Pen pen, Point point1, Point point2) {
        this.drawLine(pen, Point.to_PointF(point1).Clone(), Point.to_PointF(point2).Clone());
    }

    public void drawLine(Pen pen, PointF point1, PointF point2) {
        if (pen == null) {
            throw new ArgumentNullException("pen");
        }
        k k2 = new k();
        k2.a(point1.Clone());
        k2.b(point2.Clone());
        k2.a(pen);
        this.b(k2);
    }

    public void drawLine(Pen pen, int x1, int y1, int x2, int y2) {
        this.drawLine(pen, new Point(x1, y1), new Point(x2, y2));
    }

    public void drawLine(Pen pen, float x1, float y1, float x2, float y2) {
        this.drawLine(pen, new PointF(x1, y1), new PointF(x2, y2));
    }

    public void drawLines(Pen pen, Point[] points) {
        if (pen == null) {
            throw new ArgumentNullException("pen");
        }
        if (points == null) {
            throw new ArgumentNullException("points");
        }
        if (points.length < 2) {
            throw new ArgumentException("The points array should contain at least 2 elements.");
        }
        for (int i2 = 1; i2 < points.length; ++i2) {
            Point point = points[i2 - 1].Clone();
            Point point2 = points[i2].Clone();
            this.drawLine(pen, point.Clone(), point2.Clone());
        }
    }

    public void drawLines(Pen pen, PointF[] points) {
        if (pen == null) {
            throw new ArgumentNullException("pen");
        }
        if (points == null) {
            throw new ArgumentNullException("points");
        }
        if (points.length < 2) {
            throw new ArgumentException("The points array should contain at least 2 elements.");
        }
        for (int i2 = 1; i2 < points.length; ++i2) {
            PointF pointF = points[i2 - 1].Clone();
            PointF pointF2 = points[i2].Clone();
            this.drawLine(pen, pointF.Clone(), pointF2.Clone());
        }
    }

    public void fillRectangle(Brush brush, Rectangle rect) {
        this.fillRectangle(brush, RectangleF.to_RectangleF(rect).Clone());
    }

    public void fillRectangle(Brush brush, RectangleF rect) {
        if (brush == null) {
            throw new ArgumentNullException("brush");
        }
        v v2 = new v();
        v2.a(brush);
        v2.a(rect.Clone());
        this.b(v2);
    }

    public void fillRectangle(Brush brush, float x2, float y2, float width, float height) {
        this.fillRectangle(brush, new RectangleF(x2, y2, width, height));
    }

    public void fillRectangle(Brush brush, int x2, int y2, int width, int height) {
        this.fillRectangle(brush, new RectangleF(x2, y2, width, height));
    }

    public void fillRectangles(Brush brush, Rectangle[] rects) {
        if (brush == null) {
            throw new ArgumentNullException("brush");
        }
        if (rects == null) {
            throw new ArgumentNullException("rects");
        }
        for (Rectangle rectangle : rects) {
            this.fillRectangle(brush, rectangle.Clone());
        }
    }

    public void fillRectangles(Brush brush, RectangleF[] rects) {
        if (brush == null) {
            throw new ArgumentNullException("brush");
        }
        if (rects == null) {
            throw new ArgumentNullException("rects");
        }
        for (RectangleF rectangleF : rects) {
            this.fillRectangle(brush, rectangleF.Clone());
        }
    }

    public void drawRectangle(Pen pen, RectangleF rect) {
        if (pen == null) {
            throw new ArgumentNullException("pen");
        }
        com.aspose.imaging.internal.dW.o o2 = new com.aspose.imaging.internal.dW.o();
        o2.a(rect.Clone());
        o2.a(pen);
        this.b(o2);
    }

    public void drawRectangle(Pen pen, Rectangle rect) {
        this.drawRectangle(pen, RectangleF.to_RectangleF(rect).Clone());
    }

    public void drawRectangle(Pen pen, float x2, float y2, float width, float height) {
        this.drawRectangle(pen, new RectangleF(x2, y2, width, height));
    }

    public void drawRectangle(Pen pen, int x2, int y2, int width, int height) {
        this.drawRectangle(pen, new RectangleF(x2, y2, width, height));
    }

    public void drawRectangles(Pen pen, RectangleF[] rects) {
        if (pen == null) {
            throw new ArgumentNullException("pen");
        }
        if (rects == null) {
            throw new ArgumentNullException("rects");
        }
        for (int i2 = 0; i2 < rects.length; ++i2) {
            this.drawRectangle(pen, rects[i2].Clone());
        }
    }

    public void drawRectangles(Pen pen, Rectangle[] rects) {
        if (pen == null) {
            throw new ArgumentNullException("pen");
        }
        if (rects == null) {
            throw new ArgumentNullException("rects");
        }
        for (int i2 = 0; i2 < rects.length; ++i2) {
            this.drawRectangle(pen, rects[i2].Clone());
        }
    }

    public void drawEllipse(Pen pen, RectangleF rect) {
        if (pen == null) {
            throw new ArgumentNullException("pen");
        }
        com.aspose.imaging.internal.dW.f f2 = new com.aspose.imaging.internal.dW.f();
        f2.a(pen);
        f2.a(rect.Clone());
        this.b(f2);
    }

    public void drawEllipse(Pen pen, float x2, float y2, float width, float height) {
        this.drawEllipse(pen, new RectangleF(x2, y2, width, height));
    }

    public void drawEllipse(Pen pen, Rectangle rect) {
        this.drawEllipse(pen, RectangleF.to_RectangleF(rect).Clone());
    }

    public void drawEllipse(Pen pen, int x2, int y2, int width, int height) {
        this.drawEllipse(pen, new RectangleF(x2, y2, width, height));
    }

    public void drawPolygon(Pen pen, PointF[] points) {
        if (pen == null) {
            throw new ArgumentNullException("pen");
        }
        if (points == null) {
            throw new ArgumentNullException("points");
        }
        n n2 = new n();
        n2.a(pen);
        n2.a(points);
        this.b(n2);
    }

    public void drawPolygon(Pen pen, Point[] points) {
        this.drawPolygon(pen, PointExtensions.toPointsArray(points));
    }

    public void drawImage(Image sourceImage, PointF point) {
        if (sourceImage == null) {
            throw new ArgumentNullException("sourceImage");
        }
        this.drawImage(sourceImage, new RectangleF(point.Clone(), Size.to_SizeF(sourceImage.getSize()).Clone()));
    }

    public void drawImage(Image sourceImage, float x2, float y2) {
        if (sourceImage == null) {
            throw new ArgumentNullException("sourceImage");
        }
        this.drawImage(sourceImage, new RectangleF(new PointF(x2, y2), Size.to_SizeF(sourceImage.getSize()).Clone()));
    }

    public void drawImage(Image sourceImage, RectangleF rect) {
        this.drawImage(sourceImage, rect.Clone(), 2, null);
    }

    public void drawImage(Image sourceImage, Rectangle rectDestination, int graphicsUnit) {
        this.drawImage(sourceImage, rectDestination.Clone(), graphicsUnit, null);
    }

    public void drawImage(Image sourceImage, RectangleF rectDestination, int graphicsUnit) {
        if (sourceImage == null) {
            throw new ArgumentNullException("sourceImage");
        }
        this.drawImage(sourceImage, new RectangleF(0.0f, 0.0f, sourceImage.getWidth(), sourceImage.getHeight()), rectDestination.Clone(), graphicsUnit, null);
    }

    public void drawImage(Image sourceImage, Rectangle rectDestination, int graphicsUnit, ImageAttributes imageAttributes) {
        if (sourceImage == null) {
            throw new ArgumentNullException("sourceImage");
        }
        this.drawImage(sourceImage, new RectangleF(0.0f, 0.0f, sourceImage.getWidth(), sourceImage.getHeight()), RectangleF.to_RectangleF(rectDestination).Clone(), graphicsUnit, imageAttributes);
    }

    public void drawImage(Image sourceImage, RectangleF rectDestination, int graphicsUnit, ImageAttributes imageAttributes) {
        if (sourceImage == null) {
            throw new ArgumentNullException("sourceImage");
        }
        this.drawImage(sourceImage, new RectangleF(0.0f, 0.0f, sourceImage.getWidth(), sourceImage.getHeight()), rectDestination.Clone(), graphicsUnit, imageAttributes);
    }

    public void drawImage(Image sourceImage, Rectangle rectSource, Rectangle rectDestination, int graphicsUnit) {
        this.drawImage(sourceImage, RectangleF.to_RectangleF(rectSource).Clone(), RectangleF.to_RectangleF(rectDestination).Clone(), graphicsUnit, null);
    }

    public void drawImage(Image sourceImage, RectangleF rectSource, RectangleF rectDestination, int graphicsUnit) {
        this.drawImage(sourceImage, rectSource.Clone(), rectDestination.Clone(), graphicsUnit, null);
    }

    public void drawImage(Image sourceImage, Rectangle rectSource, Rectangle rectDestination, int graphicsUnit, ImageAttributes imageAttributes) {
        this.drawImage(sourceImage, RectangleF.to_RectangleF(rectSource).Clone(), RectangleF.to_RectangleF(rectDestination).Clone(), graphicsUnit, imageAttributes);
    }

    public void drawImage(Image sourceImage, RectangleF rectSource, RectangleF rectDestination, int graphicsUnit, ImageAttributes imageAttributes) {
        if (sourceImage == null) {
            throw new ArgumentNullException("sourceImage");
        }
        com.aspose.imaging.internal.dW.g g2 = new com.aspose.imaging.internal.dW.g();
        g2.b(sourceImage);
        g2.b(rectDestination.Clone());
        g2.a(rectSource.Clone());
        g2.e(graphicsUnit);
        g2.a(imageAttributes);
        this.b(g2);
    }

    public void drawImage(Image image, Point[] destPoints) {
        if (image == null) {
            throw new ArgumentNullException("image");
        }
        this.drawImage(image, destPoints, image.getBounds().Clone(), 2, null);
    }

    public void drawImage(Image image, Point[] destPoints, Rectangle srcRect) {
        this.drawImage(image, destPoints, srcRect.Clone(), 2, null);
    }

    public void drawImage(Image image, Point[] destPoints, Rectangle srcRect, int srcUnit) {
        this.drawImage(image, destPoints, srcRect.Clone(), srcUnit, null);
    }

    public void drawImage(Image image, Point[] destPoints, Rectangle srcRect, int srcUnit, ImageAttributes imageAttributes) {
        if (destPoints == null) {
            throw new ArgumentNullException("destPoints");
        }
        if (destPoints.length != 3) {
            throw new ArgumentOutOfRangeException("destPoints", "The array must contain exactly 3 points and represent the upper-left, upper-right, and lower-left corners of the parallelogram.");
        }
        PointF[] pointFArray = PointExtensions.toPointsArray(destPoints);
        this.drawImage(image, pointFArray, RectangleF.to_RectangleF(srcRect).Clone(), srcUnit, imageAttributes);
    }

    public void drawImage(Image image, PointF[] destPoints) {
        if (image == null) {
            throw new ArgumentNullException("image");
        }
        RectangleF rectangleF = new RectangleF(0.0f, 0.0f, image.getWidth(), image.getHeight());
        this.drawImage(image, destPoints, rectangleF.Clone(), 2, null);
    }

    public void drawImage(Image image, PointF[] destPoints, RectangleF srcRect) {
        this.drawImage(image, destPoints, srcRect.Clone(), 2, null);
    }

    public void drawImage(Image image, PointF[] destPoints, RectangleF srcRect, int srcUnit) {
        this.drawImage(image, destPoints, srcRect.Clone(), srcUnit, null);
    }

    public void drawImage(Image image, PointF[] destPoints, RectangleF srcRect, int srcUnit, ImageAttributes imageAttributes) {
        if (image == null) {
            throw new ArgumentNullException("image");
        }
        if (destPoints == null) {
            throw new ArgumentNullException("destPoints");
        }
        if (destPoints.length != 3) {
            throw new ArgumentOutOfRangeException("destPoints", "The array must contain exactly 3 points and represent the upper-left, upper-right, and lower-left corners of the parallelogram.");
        }
        com.aspose.imaging.internal.dW.h h2 = new com.aspose.imaging.internal.dW.h();
        h2.b(image);
        h2.a(destPoints);
        h2.a(srcRect.Clone());
        h2.e(srcUnit);
        h2.a(imageAttributes);
        this.b(h2);
    }

    public void drawImage(Image sourceImage, float x2, float y2, float width, float height) {
        this.drawImage(sourceImage, new RectangleF(x2, y2, width, height));
    }

    public void drawImage(Image sourceImage, Point point) {
        if (sourceImage == null) {
            throw new ArgumentNullException("sourceImage");
        }
        this.drawImage(sourceImage, new RectangleF(Point.to_PointF(point).Clone(), Size.to_SizeF(sourceImage.getSize()).Clone()));
    }

    public void drawImage(Image sourceImage, int x2, int y2) {
        if (sourceImage == null) {
            throw new ArgumentNullException("sourceImage");
        }
        this.drawImage(sourceImage, new RectangleF(x2, y2, sourceImage.getWidth(), sourceImage.getHeight()));
    }

    public void drawImage(Image sourceImage, Rectangle rect) {
        this.drawImage(sourceImage, RectangleF.to_RectangleF(rect).Clone());
    }

    public void drawImage(Image sourceImage, int x2, int y2, int width, int height) {
        this.drawImage(sourceImage, new RectangleF(x2, y2, width, height));
    }

    public void drawImageUnscaled(Image sourceImage, Point point) {
        if (sourceImage == null) {
            throw new ArgumentNullException("sourceImage");
        }
        this.drawImageUnscaled(sourceImage, new Rectangle(point.Clone(), sourceImage.getSize().Clone()));
    }

    public void drawImageUnscaled(Image sourceImage, int x2, int y2) {
        if (sourceImage == null) {
            throw new ArgumentNullException("sourceImage");
        }
        this.drawImageUnscaled(sourceImage, new Rectangle(x2, y2, sourceImage.getWidth(), sourceImage.getHeight()));
    }

    public void drawImageUnscaled(Image sourceImage, Rectangle rect) {
        if (sourceImage == null) {
            throw new ArgumentNullException("sourceImage");
        }
        i i2 = new i();
        i2.b(sourceImage);
        i2.b(RectangleF.to_RectangleF(rect).Clone());
        this.b(i2);
    }

    public void drawImageUnscaled(Image sourceImage, int x2, int y2, int width, int height) {
        this.drawImageUnscaled(sourceImage, new Rectangle(x2, y2, width, height));
    }

    public void drawImageUnscaledAndClipped(Image sourceImage, Rectangle rect) {
        if (sourceImage == null) {
            throw new ArgumentNullException("sourceImage");
        }
        j j2 = new j();
        j2.b(sourceImage);
        j2.b(RectangleF.to_RectangleF(rect).Clone());
        this.b(j2);
    }

    public void drawArc(Pen pen, float x2, float y2, float width, float height, float startAngle, float sweepAngle) {
        this.drawArc(pen, new RectangleF(x2, y2, width, height), startAngle, sweepAngle);
    }

    public void drawArc(Pen pen, RectangleF rect, float startAngle, float sweepAngle) {
        if (pen == null) {
            throw new ArgumentNullException("pen");
        }
        com.aspose.imaging.internal.dW.b b2 = new com.aspose.imaging.internal.dW.b();
        b2.a(pen);
        b2.a(rect.Clone());
        b2.a(startAngle);
        b2.b(sweepAngle);
        this.b(b2);
    }

    public void drawArc(Pen pen, int x2, int y2, int width, int height, int startAngle, int sweepAngle) {
        this.drawArc(pen, new RectangleF(x2, y2, width, height), (float)startAngle, (float)sweepAngle);
    }

    public void drawArc(Pen pen, Rectangle rect, float startAngle, float sweepAngle) {
        this.drawArc(pen, RectangleF.to_RectangleF(rect).Clone(), startAngle, sweepAngle);
    }

    public void drawPie(Pen pen, RectangleF rect, float startAngle, float sweepAngle) {
        if (pen == null) {
            throw new ArgumentNullException("pen");
        }
        m m2 = new m();
        m2.a(pen);
        m2.a(rect.Clone());
        m2.a(startAngle);
        m2.b(sweepAngle);
        this.b(m2);
    }

    public void drawPie(Pen pen, float x2, float y2, float width, float height, float startAngle, float sweepAngle) {
        this.drawPie(pen, new RectangleF(x2, y2, width, height), startAngle, sweepAngle);
    }

    public void drawPie(Pen pen, Rectangle rect, float startAngle, float sweepAngle) {
        this.drawPie(pen, RectangleF.to_RectangleF(rect).Clone(), startAngle, sweepAngle);
    }

    public void drawPie(Pen pen, int x2, int y2, int width, int height, int startAngle, int sweepAngle) {
        this.drawPie(pen, new RectangleF(x2, y2, width, height), (float)startAngle, (float)sweepAngle);
    }

    public void drawCurve(Pen pen, PointF[] points) {
        this.drawCurve(pen, points, 0.5f);
    }

    public void drawCurve(Pen pen, PointF[] points, float tension) {
        if (pen == null) {
            throw new ArgumentNullException("pen");
        }
        com.aspose.imaging.internal.dP.h.a(points, "points");
        com.aspose.imaging.internal.dW.e e2 = new com.aspose.imaging.internal.dW.e();
        e2.a(pen);
        e2.a(points);
        e2.a(tension);
        this.b(e2);
    }

    public void drawCurve(Pen pen, PointF[] points, int offset, int numberOfSegments) {
        this.drawCurve(pen, points, offset, numberOfSegments, 0.5f);
    }

    public void drawCurve(Pen pen, PointF[] points, int offset, int numberOfSegments, float tension) {
        if (pen == null) {
            throw new ArgumentNullException("pen");
        }
        com.aspose.imaging.internal.dP.h.a(com.aspose.imaging.internal.ap.g.a(points), offset, numberOfSegments, "points", "offset", "numberOfSegments");
        PointF[] pointFArray = (PointF[])com.aspose.imaging.internal.ap.g.a(com.aspose.imaging.internal.ap.g.a(com.aspose.imaging.internal.dO.d.a(PointF.class), numberOfSegments));
        com.aspose.imaging.internal.ap.g.b(com.aspose.imaging.internal.ap.g.a(points), offset, com.aspose.imaging.internal.ap.g.a(pointFArray), 0, numberOfSegments);
        this.drawCurve(pen, points, tension);
    }

    public void drawCurve(Pen pen, Point[] points) {
        this.drawCurve(pen, PointExtensions.toPointsArray(points));
    }

    public void drawCurve(Pen pen, Point[] points, float tension) {
        this.drawCurve(pen, PointExtensions.toPointsArray(points), tension);
    }

    public void drawCurve(Pen pen, Point[] points, int offset, int numberOfSegments, float tension) {
        this.drawCurve(pen, PointExtensions.toPointsArray(points), offset, numberOfSegments, tension);
    }

    public void drawClosedCurve(Pen pen, PointF[] points) {
        this.drawClosedCurve(pen, points, 0.5f);
    }

    public void drawClosedCurve(Pen pen, PointF[] points, float tension) {
        if (pen == null) {
            throw new ArgumentNullException("pen");
        }
        com.aspose.imaging.internal.dP.h.a(points, "points");
        com.aspose.imaging.internal.dW.d d2 = new com.aspose.imaging.internal.dW.d();
        d2.a(pen);
        d2.a(points);
        d2.a(tension);
        this.b(d2);
    }

    public void drawClosedCurve(Pen pen, Point[] points) {
        this.drawClosedCurve(pen, PointExtensions.toPointsArray(points));
    }

    public void drawClosedCurve(Pen pen, Point[] points, float tension) {
        this.drawClosedCurve(pen, PointExtensions.toPointsArray(points), tension);
    }

    public void drawBezier(Pen pen, float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        this.drawBezier(pen, new PointF(x1, y1), new PointF(x2, y2), new PointF(x3, y3), new PointF(x4, y4));
    }

    public void drawBezier(Pen pen, PointF pt1, PointF pt2, PointF pt3, PointF pt4) {
        if (pen == null) {
            throw new ArgumentNullException("pen");
        }
        c c2 = new c();
        c2.a(pen);
        c2.a(pt1.Clone());
        c2.c(pt2.Clone());
        c2.d(pt3.Clone());
        c2.b(pt4.Clone());
        this.b(c2);
    }

    public void drawBezier(Pen pen, Point pt1, Point pt2, Point pt3, Point pt4) {
        this.drawBezier(pen, Point.to_PointF(pt1).Clone(), Point.to_PointF(pt2).Clone(), Point.to_PointF(pt3).Clone(), Point.to_PointF(pt4).Clone());
    }

    public void drawBeziers(Pen pen, Point[] points) {
        if (pen == null) {
            throw new ArgumentNullException("pen");
        }
        if (points == null) {
            throw new ArgumentNullException("points");
        }
        if (points.length < 4) {
            throw new ArgumentOutOfRangeException("points", "The points array should contain at least 4 points.");
        }
        if ((points.length - 1) % 3 != 0) {
            throw new ArgumentOutOfRangeException("points", "The points array should be a multiple of 3 plus 1.");
        }
        int n2 = 0;
        while (n2 + 3 < points.length) {
            this.drawBezier(pen, Point.to_PointF(points[n2]).Clone(), Point.to_PointF(points[n2 + 1]).Clone(), Point.to_PointF(points[n2 + 2]).Clone(), Point.to_PointF(points[n2 + 3]).Clone());
            n2 += 3;
        }
    }

    public void drawBeziers(Pen pen, PointF[] points) {
        if (pen == null) {
            throw new ArgumentNullException("pen");
        }
        if (points == null) {
            throw new ArgumentNullException("points");
        }
        if (points.length < 4) {
            throw new ArgumentOutOfRangeException("points", "The points array should contain at least 4 points.");
        }
        if ((points.length - 1) % 3 != 0) {
            throw new ArgumentOutOfRangeException("points", "The points array should be a multiple of 3 plus 1.");
        }
        int n2 = 0;
        while (n2 + 3 < points.length) {
            this.drawBezier(pen, points[n2].Clone(), points[n2 + 1].Clone(), points[n2 + 2].Clone(), points[n2 + 3].Clone());
            n2 += 3;
        }
    }

    public void drawString(String s2, Font font, Brush brush, float x2, float y2) {
        this.drawString(s2, font, brush, new RectangleF(x2, y2, 0.0f, 0.0f), null);
    }

    public void drawString(String s2, Font font, Brush brush, PointF point) {
        this.drawString(s2, font, brush, new RectangleF(point.Clone(), SizeF.getEmpty()), null);
    }

    public void drawString(String s2, Font font, Brush brush, float x2, float y2, StringFormat format) {
        this.drawString(s2, font, brush, new RectangleF(x2, y2, 0.0f, 0.0f), format);
    }

    public void drawString(String s2, Font font, Brush brush, PointF point, StringFormat format) {
        this.drawString(s2, font, brush, new RectangleF(point.Clone(), SizeF.getEmpty()), format);
    }

    public void drawString(String s2, Font font, Brush brush, RectangleF layoutRectangle) {
        this.drawString(s2, font, brush, layoutRectangle.Clone(), null);
    }

    public void drawString(String s2, Font font, Brush brush, RectangleF layoutRectangle, StringFormat format) {
        if (s2 == null) {
            throw new ArgumentNullException("s");
        }
        if (font == null) {
            throw new ArgumentNullException("font");
        }
        if (brush == null) {
            throw new ArgumentNullException("brush");
        }
        p p2 = new p();
        p2.a(brush);
        p2.a(layoutRectangle.Clone());
        p2.a(format);
        p2.a(font);
        p2.a(s2);
        this.b(p2);
    }

    public void fillEllipse(Brush brush, RectangleF rect) {
        if (brush == null) {
            throw new ArgumentNullException("brush");
        }
        r r2 = new r();
        r2.a(brush);
        r2.a(rect.Clone());
        this.b(r2);
    }

    public void fillEllipse(Brush brush, float x2, float y2, float width, float height) {
        this.fillEllipse(brush, new RectangleF(x2, y2, width, height));
    }

    public void fillEllipse(Brush brush, Rectangle rect) {
        this.fillEllipse(brush, RectangleF.to_RectangleF(rect).Clone());
    }

    public void fillEllipse(Brush brush, int x2, int y2, int width, int height) {
        this.fillEllipse(brush, new RectangleF(x2, y2, width, height));
    }

    public void fillPie(Brush brush, Rectangle rect, float startAngle, float sweepAngle) {
        this.fillPie(brush, RectangleF.to_RectangleF(rect).Clone(), startAngle, sweepAngle);
    }

    public void fillPie(Brush brush, RectangleF rect, float startAngle, float sweepAngle) {
        if (brush == null) {
            throw new ArgumentNullException("brush");
        }
        t t2 = new t();
        t2.a(brush);
        t2.a(rect.Clone());
        t2.a(startAngle);
        t2.b(sweepAngle);
        this.b(t2);
    }

    public void fillPie(Brush brush, float x2, float y2, float width, float height, float startAngle, float sweepAngle) {
        this.fillPie(brush, new RectangleF(x2, y2, width, height), startAngle, sweepAngle);
    }

    public void fillPie(Brush brush, int x2, int y2, int width, int height, int startAngle, int sweepAngle) {
        this.fillPie(brush, new RectangleF(x2, y2, width, height), (float)startAngle, (float)sweepAngle);
    }

    public void fillPolygon(Brush brush, PointF[] points) {
        this.fillPolygon(brush, points, 0);
    }

    public void fillPolygon(Brush brush, PointF[] points, int fillMode) {
        if (brush == null) {
            throw new ArgumentNullException("brush");
        }
        if (points == null) {
            throw new ArgumentNullException("points");
        }
        u u2 = new u();
        u2.a(brush);
        u2.a(points);
        u2.e(fillMode);
        this.b(u2);
    }

    public void fillPolygon(Brush brush, Point[] points) {
        this.fillPolygon(brush, points, 0);
    }

    public void fillPolygon(Brush brush, Point[] points, int fillMode) {
        if (points == null) {
            throw new ArgumentNullException("points");
        }
        PointF[] pointFArray = (PointF[])com.aspose.imaging.internal.ap.g.a(com.aspose.imaging.internal.ap.g.a(com.aspose.imaging.internal.dO.d.a(PointF.class), points.length));
        for (int i2 = 0; i2 < points.length; ++i2) {
            Point.to_PointF(points[i2]).CloneTo(pointFArray[i2]);
        }
        this.fillPolygon(brush, pointFArray, fillMode);
    }

    public void fillClosedCurve(Brush brush, PointF[] points) {
        this.fillClosedCurve(brush, points, 0, 0.5f);
    }

    public void fillClosedCurve(Brush brush, PointF[] points, int fillmode) {
        this.fillClosedCurve(brush, points, fillmode, 0.5f);
    }

    public void fillClosedCurve(Brush brush, PointF[] points, int fillmode, float tension) {
        if (brush == null) {
            throw new ArgumentNullException("brush");
        }
        if (points == null) {
            throw new ArgumentNullException("points");
        }
        q q2 = new q();
        q2.a(brush);
        q2.e(fillmode);
        q2.a(points);
        q2.a(tension);
        this.b(q2);
    }

    public void fillClosedCurve(Brush brush, Point[] points) {
        this.fillClosedCurve(brush, points, 0, 0.5f);
    }

    public void fillClosedCurve(Brush brush, Point[] points, int fillmode) {
        this.fillClosedCurve(brush, points, fillmode, 0.5f);
    }

    public void fillClosedCurve(Brush brush, Point[] points, int fillmode, float tension) {
        if (points == null) {
            throw new ArgumentNullException("points");
        }
        PointF[] pointFArray = (PointF[])com.aspose.imaging.internal.ap.g.a(com.aspose.imaging.internal.ap.g.a(com.aspose.imaging.internal.dO.d.a(PointF.class), points.length));
        for (int i2 = 0; i2 < points.length; ++i2) {
            Point.to_PointF(points[i2]).CloneTo(pointFArray[i2]);
        }
        this.fillClosedCurve(brush, pointFArray, fillmode, tension);
    }

    public void drawPath(Pen pen, GraphicsPath path) {
        if (path == null) {
            throw new ArgumentNullException("path");
        }
        if (pen == null) {
            throw new ArgumentNullException("pen");
        }
        l l2 = new l();
        l2.a(path);
        l2.a(pen);
        this.b(l2);
    }

    public void fillPath(Brush brush, GraphicsPath path) {
        if (path == null) {
            throw new ArgumentNullException("path");
        }
        if (brush == null) {
            throw new ArgumentNullException("brush");
        }
        s s2 = new s();
        s2.a(path);
        s2.a(brush);
        this.b(s2);
    }

    public void fillRegion(Brush brush, Region region) {
        if (region == null) {
            throw new ArgumentNullException("region");
        }
        if (brush == null) {
            throw new ArgumentNullException("brush");
        }
        com.aspose.imaging.internal.dW.w w2 = new com.aspose.imaging.internal.dW.w();
        w2.a(brush);
        w2.a(region);
        this.b(w2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SizeF a(Font font, String string) {
        SizeF sizeF;
        o o2 = com.aspose.imaging.internal.eb.d.a(font);
        try {
            b b2 = new b(10, 10);
            try {
                w w2 = w.a(b2);
                try {
                    cB cB2 = w2.a(string, o2);
                    sizeF = new SizeF(cB2.b(), cB2.c());
                }
                finally {
                    w2.dispose();
                }
            }
            finally {
                b2.dispose();
            }
        }
        finally {
            o2.dispose();
        }
        return sizeF;
    }

    private void b(R r2) {
        if (this.b) {
            this.h.addItem(r2);
        } else {
            r2.b(this.d);
            r2.c(this.e);
            r2.d(this.g);
            r2.a(this.c);
            r2.a(this.f);
            a a2 = new a((RasterImage)((Object)com.aspose.imaging.internal.dO.d.a(this.getImage(), RasterImage.class)), new R[]{r2});
            aE.a(this.getImage().getBounds().Clone(), a2);
        }
    }

    private static class com.aspose.imaging.Graphics$a
    implements Z {
        private final RasterImage a;
        private final R[] b;

        com.aspose.imaging.Graphics$a(RasterImage rasterImage, R[] rArray) {
            if (rasterImage == null) {
                throw new ArgumentNullException("image");
            }
            if (rArray == null) {
                throw new ArgumentNullException("effects");
            }
            this.a = rasterImage;
            this.b = rArray;
        }

        @Override
        public void a(Rectangle rectangle) {
            a a2 = new a(this.a, this.b);
            av.a(this.a, rectangle.Clone(), a2);
        }

        private static class com.aspose.imaging.Graphics$a$a
        implements IPartialArgb32PixelLoader {
            private final RasterImage a;
            private final R[] b;

            com.aspose.imaging.Graphics$a$a(RasterImage rasterImage, R[] rArray) {
                this.a = rasterImage;
                this.b = rArray;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void process(Rectangle pixelsRectangle, int[] pixels, Point start, Point end) {
                b b2;
                try {
                    b2 = new b(pixelsRectangle.getWidth(), pixelsRectangle.getHeight());
                }
                catch (ArgumentException argumentException) {
                    throw new OutOfMemoryError();
                }
                b b3 = b2;
                try {
                    Object object;
                    int n2;
                    com.aspose.imaging.internal.ec.b.a(b3, pixels, new Rectangle(0, 0, pixelsRectangle.getWidth(), pixelsRectangle.getHeight()), this.a.getPalette());
                    w w2 = w.a(b3);
                    try {
                        for (n2 = 0; n2 < this.b.length; ++n2) {
                            object = this.b[n2];
                            N n3 = com.aspose.imaging.internal.eb.f.a(object.a());
                            if (n3 == null) {
                                n3 = new N();
                            }
                            n3.c(-pixelsRectangle.getLeft(), -pixelsRectangle.getTop());
                            w2.b(n3);
                            w2.c(object.c());
                            w2.d(object.d());
                            w2.g(object.b());
                            w2.i(object.e());
                            try {
                                object.a(this.a, b3, w2);
                                continue;
                            }
                            catch (OverflowException overflowException) {
                                throw new OutOfMemoryError();
                            }
                            catch (ArithmeticException arithmeticException) {
                                throw new OutOfMemoryError();
                            }
                        }
                    }
                    finally {
                        if (w2 != null) {
                            w2.dispose();
                        }
                    }
                    com.aspose.imaging.internal.ec.b.a(b3, pixels);
                    n2 = com.aspose.imaging.internal.gP.e.b(this.a);
                    if (n2 == 0 && ak.c() != al.b || n2 == 1) {
                        object = bp.a(this.a);
                        ((com.aspose.imaging.internal.gQ.a)object).b(pixelsRectangle.Clone(), pixels);
                    }
                    object = new a(this.a, pixelsRectangle.Clone(), pixels);
                    aE.a(pixelsRectangle.Clone(), (Z)object);
                }
                finally {
                    b3.dispose();
                }
            }

            private static class a
            implements Z {
                private final Rectangle a = new Rectangle();
                private final int[] b;
                private final RasterImage c;

                public a(RasterImage rasterImage, Rectangle rectangle, int[] nArray) {
                    this.c = rasterImage;
                    rectangle.CloneTo(this.a);
                    this.b = nArray;
                }

                @Override
                public void a(Rectangle rectangle) {
                    if (rectangle.getLeft() == this.a.getLeft() && rectangle.getTop() == this.a.getTop() && rectangle.getRight() == this.a.getRight() && rectangle.getBottom() == this.a.getBottom()) {
                        this.c.saveArgb32Pixels(rectangle.Clone(), this.b);
                    } else {
                        int[] nArray;
                        try {
                            nArray = new int[(int)((long)rectangle.getWidth() * (long)rectangle.getHeight())];
                        }
                        catch (OverflowException overflowException) {
                            throw new OutOfMemoryError();
                        }
                        catch (ArithmeticException arithmeticException) {
                            throw new OutOfMemoryError();
                        }
                        for (int i2 = rectangle.getTop(); i2 < rectangle.getBottom(); ++i2) {
                            int n2 = rectangle.getLeft() - this.a.getLeft();
                            int n3 = (i2 - this.a.getTop()) * this.a.getWidth();
                            int n4 = n2 + n3;
                            int n5 = (i2 - rectangle.getTop()) * rectangle.getWidth();
                            System.arraycopy(this.b, n4, nArray, n5, rectangle.getWidth());
                        }
                        this.c.saveArgb32Pixels(rectangle.Clone(), nArray);
                    }
                }
            }
        }
    }
}

