/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging;

import com.aspose.imaging.Color;
import com.aspose.imaging.DataStreamSupporter;
import com.aspose.imaging.F;
import com.aspose.imaging.FileStreamContainer;
import com.aspose.imaging.H;
import com.aspose.imaging.I;
import com.aspose.imaging.IColorPalette;
import com.aspose.imaging.IImageCreator;
import com.aspose.imaging.IImageLoader;
import com.aspose.imaging.IImageLoaderDescriptor;
import com.aspose.imaging.IObjectWithBounds;
import com.aspose.imaging.ImageCreatorsRegistry;
import com.aspose.imaging.ImageExportersRegistry;
import com.aspose.imaging.ImageLoadersRegistry;
import com.aspose.imaging.ImageOptionsBase;
import com.aspose.imaging.ImageResizeSettings;
import com.aspose.imaging.LoadOptions;
import com.aspose.imaging.Point;
import com.aspose.imaging.Rectangle;
import com.aspose.imaging.Size;
import com.aspose.imaging.StreamContainer;
import com.aspose.imaging.coreexceptions.FrameworkException;
import com.aspose.imaging.coreexceptions.ImageCreateException;
import com.aspose.imaging.coreexceptions.ImageException;
import com.aspose.imaging.coreexceptions.ImageLoadException;
import com.aspose.imaging.coreexceptions.ImageSaveException;
import com.aspose.imaging.fileformats.emf.MetaImage;
import com.aspose.imaging.fileformats.svg.SvgImage;
import com.aspose.imaging.imageoptions.PdfOptions;
import com.aspose.imaging.imageoptions.VectorRasterizationOptions;
import com.aspose.imaging.internal.Exceptions.ArgumentException;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.aE.k;
import com.aspose.imaging.internal.ap.aG;
import com.aspose.imaging.internal.ap.aY;
import com.aspose.imaging.internal.ap.bF;
import com.aspose.imaging.internal.dN.c;
import com.aspose.imaging.internal.dO.d;
import com.aspose.imaging.internal.dP.b;
import com.aspose.imaging.internal.dP.bg;
import com.aspose.imaging.internal.dP.bh;
import com.aspose.imaging.sources.StreamSource;
import com.aspose.imaging.system.Event;
import com.aspose.imaging.system.io.FileStream;
import com.aspose.imaging.system.io.Stream;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class Image
extends DataStreamSupporter
implements IObjectWithBounds {
    private Image e;
    private boolean f = true;
    private IColorPalette g;
    private Object h;
    private static b i;
    public static final Event<b> d;

    protected Image() {
    }

    protected Image(IColorPalette colorPalette) {
        this.g = colorPalette;
    }

    public abstract int getBitsPerPixel();

    @Override
    public Rectangle getBounds() {
        this.verifyNotDisposed();
        return new Rectangle(Point.getEmpty(), this.getSize().Clone());
    }

    public Image getContainer() {
        return this.e;
    }

    @Override
    public abstract int getHeight();

    public IColorPalette getPalette() {
        return this.g;
    }

    public void setPalette(IColorPalette value) {
        if (this.g != value) {
            IColorPalette iColorPalette = this.g;
            this.onPaletteChanging(iColorPalette, value);
            this.g = value;
            this.onPaletteChanged(iColorPalette, value);
        }
    }

    @Override
    public Size getSize() {
        this.verifyNotDisposed();
        return new Size(this.getWidth(), this.getHeight());
    }

    @Override
    public abstract int getWidth();

    public boolean hasBackgroundColor() {
        return false;
    }

    public void setBackgroundColor(boolean value) {
    }

    public Color getBackgroundColor() {
        return Color.getWhite();
    }

    public void setBackgroundColor(Color value) {
    }

    public static boolean canLoad(String filePath) {
        return Image.canLoad(filePath, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canLoad(String filePath, LoadOptions loadOptions) {
        Object object = SyncOperation;
        synchronized (object) {
            boolean bl2;
            block7: {
                FileStream fileStream = k.a(filePath, 3, 3, 3);
                try {
                    bl2 = Image.c(fileStream);
                    if (fileStream == null) break block7;
                    fileStream.dispose();
                }
                catch (Throwable throwable) {
                    if (fileStream != null) {
                        fileStream.dispose();
                    }
                    throw throwable;
                }
            }
            return bl2;
        }
    }

    public static boolean canLoad(InputStream stream) {
        return Image.c(Stream.fromJava(stream));
    }

    public static boolean c(Stream stream) {
        return Image.a(stream, null);
    }

    public static boolean canLoad(InputStream stream, LoadOptions loadOptions) {
        return Image.a(Stream.fromJava(stream), loadOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean a(Stream stream, LoadOptions loadOptions) {
        boolean bl2;
        bg bg2 = null;
        try {
            bg2 = bh.a().a(stream);
            bl2 = ImageLoadersRegistry.a(bg2, loadOptions) != null;
        }
        finally {
            bh.a().a(bg2);
        }
        return bl2;
    }

    public static Image create(ImageOptionsBase imageOptions, int width, int height) {
        if (imageOptions == null) {
            throw new ArgumentNullException("imageOptions");
        }
        if (imageOptions.getSource() == null) {
            throw new ArgumentNullException("imageOptions", "Please specify source for the image creation.");
        }
        if (width <= 0) {
            throw new ArgumentOutOfRangeException("width", "Expected positive width value.");
        }
        if (height <= 0) {
            throw new ArgumentOutOfRangeException("height", "Expected positive height value.");
        }
        return Image.a(imageOptions, width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getFileFormat(String filePath) {
        FileStream fileStream = k.a(filePath, 3, 1, 1);
        bg bg2 = bh.a().a(fileStream);
        Object object = bg2.getSyncRoot();
        synchronized (object) {
            long l2;
            block7: {
                try {
                    l2 = Image.d(bg2);
                    if (bg2.a() > 0) break block7;
                    bg2.dispose();
                }
                catch (Throwable throwable) {
                    if (bg2.a() <= 0) {
                        bg2.dispose();
                    }
                    throw throwable;
                }
            }
            return l2;
        }
    }

    public static long getFileFormat(InputStream stream) {
        return Image.d(Stream.fromJava(stream));
    }

    public static long d(Stream stream) {
        long l2 = 0L;
        IImageLoaderDescriptor iImageLoaderDescriptor = ImageLoadersRegistry.a(stream, null);
        if (iImageLoaderDescriptor != null) {
            l2 = iImageLoaderDescriptor.getSupportedFormat();
        }
        return l2;
    }

    public static Rectangle getFittingRectangle(Rectangle rectangle, int width, int height) {
        Rectangle rectangle2 = Rectangle.intersect(rectangle.Clone(), new Rectangle(new Point(), new Size(bF.a(width), bF.a(height)))).Clone();
        if (rectangle2.getWidth() <= 0 || rectangle2.getHeight() <= 0) {
            throw new ArgumentException("The rectangle has no common processing area. Cannot proceed.");
        }
        return rectangle2;
    }

    public static Rectangle getFittingRectangle(Rectangle rectangle, int[] pixels, int width, int height) {
        if (pixels == null) {
            throw new ArgumentNullException("pixels");
        }
        Rectangle rectangle2 = Image.getFittingRectangle(rectangle.Clone(), width, height).Clone();
        if (pixels.length < rectangle2.getWidth() * rectangle2.getHeight()) {
            String string = aY.a("The passed rectangle does not correspond to pixels array size. Expected: {0} pixels, passed: {1} pixels.", com.aspose.imaging.internal.dO.d.a(rectangle2.getWidth() * rectangle2.getHeight()), com.aspose.imaging.internal.dO.d.a(pixels.length));
            throw new ImageException(string);
        }
        return rectangle2;
    }

    public static Image load(String filePath, LoadOptions loadOptions) {
        return Image.a(FileStreamContainer.openFileStream(filePath), loadOptions);
    }

    public static Image load(String filePath) {
        return Image.a(FileStreamContainer.openFileStream(filePath), null);
    }

    public static Image load(InputStream stream, LoadOptions loadOptions) {
        return Image.b(Stream.fromJava(stream), loadOptions);
    }

    public static Image b(Stream stream, LoadOptions loadOptions) {
        StreamContainer streamContainer = new StreamContainer(stream, 0L, false);
        return Image.a(streamContainer, loadOptions);
    }

    public static Image load(InputStream stream) {
        return Image.e(Stream.fromJava(stream));
    }

    public static Image e(Stream stream) {
        return Image.b(stream, null);
    }

    public static Image a(Stream stream, long l2, LoadOptions loadOptions) {
        StreamContainer streamContainer = new StreamContainer(stream, l2, false);
        return Image.a(streamContainer, loadOptions);
    }

    public static Image a(Stream stream, long l2) {
        return Image.a(stream, l2, null);
    }

    public boolean canSave(ImageOptionsBase options) {
        if (options == null) {
            throw new ArgumentNullException("options");
        }
        this.verifyNotDisposed();
        return ImageExportersRegistry.getFirstSupportedDescriptor(this, options) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize(int newWidth, int newHeight) {
        Object object = this.b;
        synchronized (object) {
            try {
                this.b(true);
                this.resize(newWidth, newHeight, 7);
            }
            finally {
                this.c(true);
            }
        }
    }

    public abstract void resize(int var1, int var2, int var3);

    public abstract void resize(int var1, int var2, ImageResizeSettings var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resizeWidthProportionally(int newWidth) {
        Object object = this.b;
        synchronized (object) {
            try {
                this.c();
                this.resizeWidthProportionally(newWidth, 1);
            }
            finally {
                this.d();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resizeHeightProportionally(int newHeight) {
        Object object = this.b;
        synchronized (object) {
            try {
                this.c();
                this.resizeHeightProportionally(newHeight, 1);
            }
            finally {
                this.d();
            }
        }
    }

    public void resizeWidthProportionally(int newWidth, int resizeType) {
        int n2 = Image.getProportionalHeight(this.getWidth(), this.getHeight(), newWidth);
        this.resize(newWidth, n2, resizeType);
    }

    public void resizeHeightProportionally(int newHeight, int resizeType) {
        int n2 = Image.getProportionalWidth(this.getWidth(), this.getHeight(), newHeight);
        this.resize(n2, newHeight, resizeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resizeWidthProportionally(int newWidth, ImageResizeSettings settings) {
        Object object = this.b;
        synchronized (object) {
            try {
                this.c();
                int n2 = Image.getProportionalHeight(this.getWidth(), this.getHeight(), newWidth);
                this.resize(newWidth, n2, settings);
            }
            finally {
                this.d();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resizeHeightProportionally(int newHeight, ImageResizeSettings settings) {
        Object object = this.b;
        synchronized (object) {
            try {
                this.c();
                int n2 = Image.getProportionalWidth(this.getWidth(), this.getHeight(), newHeight);
                this.resize(n2, newHeight, settings);
            }
            finally {
                this.d();
            }
        }
    }

    public abstract void rotateFlip(int var1);

    @Override
    public final void save() {
        if (this.e != null) {
            throw new FrameworkException("The result of this method is unpredictable since the current image has Container defined. Use the parent Container's Save() method instead.");
        }
        super.save();
    }

    public void save(String filePath, ImageOptionsBase options) {
        this.save(filePath, options, Rectangle.getEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String filePath, ImageOptionsBase options, Rectangle boundsRectangle) {
        this.verifyNotDisposed();
        if (options == null) {
            throw new ArgumentNullException("options");
        }
        try {
            FileStream fileStream = k.b(filePath);
            try {
                this.a(fileStream, options, boundsRectangle.Clone());
                fileStream.flush();
            }
            finally {
                if (fileStream != null) {
                    fileStream.dispose();
                }
            }
        }
        catch (RuntimeException runtimeException) {
            throw new ImageSaveException("Image saving failed.", runtimeException);
        }
    }

    public void save(OutputStream stream, ImageOptionsBase optionsBase) {
        if (stream instanceof com.aspose.imaging.internal.cK.b) {
            this.a(((com.aspose.imaging.internal.cK.b)stream).a(), optionsBase, Rectangle.getEmpty());
        } else {
            com.aspose.imaging.internal.dN.c.a(new H(this, stream, optionsBase));
        }
    }

    public void save(OutputStream stream, ImageOptionsBase optionsBase, Rectangle boundsRectangle) {
        if (stream instanceof com.aspose.imaging.internal.cK.b) {
            this.a(((com.aspose.imaging.internal.cK.b)stream).a(), optionsBase, boundsRectangle);
        } else {
            com.aspose.imaging.internal.dN.c.a(new I(this, stream, optionsBase, boundsRectangle));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(Stream stream, ImageOptionsBase imageOptionsBase, Rectangle rectangle) {
        this.verifyNotDisposed();
        if (imageOptionsBase == null) {
            throw new ArgumentNullException("optionsBase");
        }
        if (!(rectangle.isEmpty() || rectangle.getWidth() > 0 && rectangle.getHeight() > 0)) {
            throw new ArgumentOutOfRangeException("boundsRectangle", "Rectangle should have positive width and height");
        }
        try {
            Object object;
            Object object2 = this.b;
            synchronized (object2) {
                this.MutuallyExclusiveOperationIsNotRunningEvent_internalized.C_();
                object = this.SyncNonExclusiveOperation_internalized;
                synchronized (object) {
                    if (this.NonExclusiveRunningOperationsCount_internalized.incrementAndGet() > 0) {
                        this.NonMutuallyExclusiveOperationIsNotRunningEvent_internalized.a();
                    }
                }
            }
            object2 = ImageExportersRegistry.createFirstSupportedExporter(this, imageOptionsBase);
            if (object2 == null) {
                object = "Cannot save to the specified format as it is not supported at the moment.";
                if (com.aspose.imaging.internal.dO.d.b((Object)this, MetaImage.class)) {
                    object = aY.a((String)object, aY.a(" Please sure that ", aG.a(imageOptionsBase).u(), ".", com.aspose.imaging.internal.dO.d.a(VectorRasterizationOptions.class).u(), " is correct."));
                }
                throw new ArgumentException((String)object, "optionsBase");
            }
            object = (SvgImage)((Object)com.aspose.imaging.internal.dO.d.a(this, SvgImage.class));
            Image image = object != null && !com.aspose.imaging.internal.dO.d.b((Object)imageOptionsBase, PdfOptions.class) ? ((SvgImage)object).f() : this;
            bg bg2 = null;
            try {
                bg2 = bh.a().a(stream);
                Object object3 = bg2.getSyncRoot();
                synchronized (object3) {
                    bg2.setPosition(0L);
                    object2.export(image, bg2.toOutputStream(), imageOptionsBase, rectangle.Clone());
                    this.b(bg2);
                }
            }
            finally {
                bh.a().a(bg2);
            }
        }
        catch (RuntimeException runtimeException) {
            throw new ImageSaveException("Image export failed.", runtimeException);
        }
        finally {
            Object object = this.SyncNonExclusiveOperation_internalized;
            synchronized (object) {
                if (this.NonExclusiveRunningOperationsCount_internalized.decrementAndGet() <= 0) {
                    this.NonMutuallyExclusiveOperationIsNotRunningEvent_internalized.b();
                }
            }
        }
    }

    public abstract void setPalette(IColorPalette var1, boolean var2);

    public static int getProportionalWidth(int width, int height, int newHeight) {
        double d2 = (double)newHeight / (double)height;
        int n2 = com.aspose.imaging.internal.dO.d.e((Object)(d2 * (double)width + 0.5), 14);
        return n2;
    }

    public static int getProportionalHeight(int width, int height, int newWidth) {
        double d2 = (double)newWidth / (double)width;
        int n2 = com.aspose.imaging.internal.dO.d.e((Object)(d2 * (double)height + 0.5), 14);
        return n2;
    }

    public void a(Object object) {
        this.h = object;
    }

    public Object e() {
        return this.h;
    }

    public void a(Image image) {
        this.e = image;
    }

    protected Rectangle getFitRectangle(Rectangle rectangle) {
        return Image.getFittingRectangle(rectangle.Clone(), this.getWidth(), this.getHeight());
    }

    protected Rectangle getFitRectangle(Rectangle rectangle, int[] pixels) {
        return Image.getFittingRectangle(rectangle.Clone(), pixels, this.getWidth(), this.getHeight());
    }

    protected void onPaletteChanged(IColorPalette oldPalette, IColorPalette newPalette) {
    }

    protected void onPaletteChanging(IColorPalette oldPalette, IColorPalette newPalette) {
    }

    @Override
    protected void releaseManagedResources() {
        this.e = null;
        this.g = null;
        super.releaseManagedResources();
    }

    protected static void doAfterLoad(long[] maximum, InputStream stream) {
        Image.a(maximum, Stream.fromJava(stream));
    }

    public static void a(long[] lArray, Stream stream) {
        if (i != null) {
            i.a(lArray, stream);
        }
    }

    private static Image a(ImageOptionsBase imageOptionsBase, int n2, int n3) {
        Object object;
        StreamSource streamSource = (StreamSource)((Object)com.aspose.imaging.internal.dO.d.a(imageOptionsBase.getSource(), StreamSource.class));
        Stream stream = streamSource != null ? streamSource.getStream() : null;
        Object object2 = object = bg.a(stream, new Object());
        synchronized (object2) {
            StreamContainer streamContainer = imageOptionsBase.getSource().getStreamContainer();
            try {
                IImageCreator iImageCreator = ImageCreatorsRegistry.createFirstSupportedCreator(imageOptionsBase);
                if (iImageCreator == null) {
                    throw new ImageLoadException("Cannot create a new image. The image file format may be not supported at the moment.");
                }
                Image image = iImageCreator.create(streamContainer, imageOptionsBase, n2, n3);
                image.a(streamContainer);
                return image;
            }
            catch (RuntimeException runtimeException) {
                streamContainer.dispose();
                throw new ImageCreateException("Image creation failed.", runtimeException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Image a(StreamContainer streamContainer, LoadOptions loadOptions) {
        try {
            Image image = null;
            Object object = streamContainer.getSyncRoot();
            synchronized (object) {
                IImageLoader iImageLoader = ImageLoadersRegistry.b(streamContainer.a(), loadOptions, false);
                if (iImageLoader == null) {
                    throw new ImageLoadException("Cannot open an image. The image file format may be not supported at the moment.");
                }
                image = iImageLoader.load(streamContainer, loadOptions);
                image.a(streamContainer);
                if (loadOptions == null || !loadOptions.b()) {
                    long[] lArray = new long[]{image.a};
                    Image.a(lArray, streamContainer.a());
                    image.a = lArray[0];
                }
                return image;
            }
        }
        catch (RuntimeException runtimeException) {
            streamContainer.dispose();
            throw new ImageLoadException("Image loading failed.", runtimeException);
        }
    }

    static /* synthetic */ b access$002(b x0) {
        i = x0;
        return i;
    }

    static {
        d = new F();
    }
}

