/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging;

import com.aspose.imaging.Brush;
import com.aspose.imaging.Color;
import com.aspose.imaging.CustomLineCap;
import com.aspose.imaging.Matrix;
import com.aspose.imaging.TransparencySupporter;
import com.aspose.imaging.brushes.HatchBrush;
import com.aspose.imaging.brushes.LinearGradientBrushBase;
import com.aspose.imaging.brushes.PathGradientBrushBase;
import com.aspose.imaging.brushes.SolidBrush;
import com.aspose.imaging.brushes.TextureBrush;
import com.aspose.imaging.internal.Exceptions.ArgumentException;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.NotImplementedException;
import com.aspose.imaging.internal.dO.d;
import com.aspose.imaging.system.SerializableAttribute;

@SerializableAttribute
public class Pen
extends TransparencySupporter {
    private Brush a;
    private float b;
    private int c;
    private int d;
    private int e;
    private int f;
    private CustomLineCap g;
    private CustomLineCap h;
    private float i = 10.0f;
    private int j;
    private Matrix k = new Matrix();
    private int l;
    private float m;
    private float[] n = null;
    private float[] o = new float[]{1.0f};

    public Pen(Color color) {
        this(color.Clone(), 1.0f);
    }

    public Pen(Color color, float width) {
        this(new SolidBrush(color.Clone()), width);
    }

    public Pen(Brush brush) {
        this(brush, 1.0f);
    }

    public Pen(Brush brush, float width) {
        this.a = brush;
        this.b = width;
    }

    public float getWidth() {
        return this.b;
    }

    public void setWidth(float value) {
        this.b = value;
    }

    public int getStartCap() {
        return this.c;
    }

    public void setStartCap(int value) {
        this.c = value;
    }

    public int getEndCap() {
        return this.d;
    }

    public void setEndCap(int value) {
        this.d = value;
    }

    public int getDashCap() {
        return this.e;
    }

    public void setDashCap(int value) {
        this.e = value;
    }

    public int getLineJoin() {
        return this.f;
    }

    public void setLineJoin(int value) {
        this.f = value;
    }

    public CustomLineCap getCustomStartCap() {
        return this.g;
    }

    public void setCustomStartCap(CustomLineCap value) {
        this.g = value;
    }

    public CustomLineCap getCustomEndCap() {
        return this.h;
    }

    public void setCustomEndCap(CustomLineCap value) {
        this.h = value;
    }

    public float getMiterLimit() {
        return this.i;
    }

    public void setMiterLimit(float value) {
        this.i = value;
    }

    public int getAlignment() {
        return this.j;
    }

    public void setAlignment(int value) {
        this.j = value;
    }

    public Matrix getTransform() {
        return this.k;
    }

    public void setTransform(Matrix value) {
        if (value == null) {
            throw new ArgumentNullException("value");
        }
        this.k = value;
    }

    public int getPenType() {
        if (com.aspose.imaging.internal.dO.d.b((Object)this.a, HatchBrush.class)) {
            return 1;
        }
        if (com.aspose.imaging.internal.dO.d.b((Object)this.a, LinearGradientBrushBase.class)) {
            return 4;
        }
        if (com.aspose.imaging.internal.dO.d.b((Object)this.a, PathGradientBrushBase.class)) {
            return 3;
        }
        if (com.aspose.imaging.internal.dO.d.b((Object)this.a, TextureBrush.class)) {
            return 2;
        }
        return 0;
    }

    public Color getColor() {
        SolidBrush solidBrush = (SolidBrush)((Object)com.aspose.imaging.internal.dO.d.a(this.a, SolidBrush.class));
        if (solidBrush != null) {
            return solidBrush.getColor();
        }
        throw new NotImplementedException("The Pen color can be determined for SolidBrush only.");
    }

    public void setColor(Color value) {
        SolidBrush solidBrush = (SolidBrush)((Object)com.aspose.imaging.internal.dO.d.a(this.a, SolidBrush.class));
        if (solidBrush == null) {
            throw new NotImplementedException("The Pen color can be changed for SolidBrush only.");
        }
        solidBrush.setColor(value.Clone());
    }

    public Brush getBrush() {
        return this.a;
    }

    public void setBrush(Brush value) {
        this.a = value;
    }

    public int getDashStyle() {
        return this.l;
    }

    public void setDashStyle(int value) {
        this.l = value;
    }

    public float getDashOffset() {
        return this.m;
    }

    public void setDashOffset(float value) {
        this.m = value;
    }

    public float[] getDashPattern() {
        return this.n;
    }

    public void setDashPattern(float[] value) {
        if (value == null) {
            throw new ArgumentNullException("value");
        }
        if (value.length == 0) {
            throw new ArgumentException("The dash pattern value should not be empty.");
        }
        this.n = value;
    }

    public float[] getCompoundArray() {
        return this.o;
    }

    public void setCompoundArray(float[] value) {
        this.o = value;
    }

    public void setLineCap(int startCap, int endCap, int dashCap) {
        this.c = startCap;
        this.d = endCap;
        this.e = dashCap;
    }

    public void resetTransform() {
        this.k.reset();
    }

    public void multiplyTransform(Matrix matrix) {
        this.k.multiply(matrix);
    }

    public void multiplyTransform(Matrix matrix, int order) {
        this.k.multiply(matrix, order);
    }

    public void translateTransform(float dx2, float dy2) {
        this.k.translate(dx2, dy2);
    }

    public void translateTransform(float dx2, float dy2, int order) {
        this.k.translate(dx2, dy2, order);
    }

    public void scaleTransform(float sx, float sy) {
        this.k.scale(sx, sy);
    }

    public void scaleTransform(float sx, float sy, int order) {
        this.k.scale(sx, sy, order);
    }

    public void rotateTransform(float angle) {
        this.k.rotate(angle);
    }

    public void rotateTransform(float angle, int order) {
        this.k.rotate(angle, order);
    }
}

