/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging;

import com.aspose.imaging.Color;
import com.aspose.imaging.ColorPalette;
import com.aspose.imaging.ColorPaletteHelper;
import com.aspose.imaging.DisposableObject;
import com.aspose.imaging.IColorPalette;
import com.aspose.imaging.IPartialArgb32PixelLoader;
import com.aspose.imaging.Image;
import com.aspose.imaging.ImageResizeSettings;
import com.aspose.imaging.Point;
import com.aspose.imaging.RasterImage;
import com.aspose.imaging.Rectangle;
import com.aspose.imaging.Size;
import com.aspose.imaging.StreamContainer;
import com.aspose.imaging.coreexceptions.ImageException;
import com.aspose.imaging.fileformats.png.PngImage;
import com.aspose.imaging.fileformats.tiff.TiffFrame;
import com.aspose.imaging.internal.Exceptions.ArgumentException;
import com.aspose.imaging.internal.ap.aG;
import com.aspose.imaging.internal.ap.bF;
import com.aspose.imaging.internal.ap.bf;
import com.aspose.imaging.internal.ap.v;
import com.aspose.imaging.internal.dP.Z;
import com.aspose.imaging.internal.dP.aD;
import com.aspose.imaging.internal.dP.aE;
import com.aspose.imaging.internal.dP.aS;
import com.aspose.imaging.internal.dP.ac;
import com.aspose.imaging.internal.dP.at;
import com.aspose.imaging.internal.dP.au;
import com.aspose.imaging.internal.dP.av;
import com.aspose.imaging.internal.dP.q;
import com.aspose.imaging.internal.dP.r;
import com.aspose.imaging.system.io.MemoryStream;

public abstract class RasterCachedImage
extends RasterImage {
    protected RasterCachedImage() {
    }

    protected RasterCachedImage(IColorPalette colorPalette) {
        super(colorPalette);
    }

    @Override
    public final boolean isCached() {
        return com.aspose.imaging.internal.dO.d.b((Object)this.getDataLoader(), com.aspose.imaging.internal.eY.a.class);
    }

    @Override
    public final void cacheData() {
        av.a(this, this.getBounds().Clone(), new aD(this));
    }

    @Override
    public void resize(int newWidth, int newHeight, int resizeType) {
        aS.a(this, newWidth, newHeight, resizeType);
        this.d(true);
    }

    @Override
    public void resize(int newWidth, int newHeight, ImageResizeSettings settings) {
        aS.a(this, newWidth, newHeight, settings);
        this.d(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void rotateFlip(int rotateFlipType) {
        if (rotateFlipType != 14 && rotateFlipType != 0) {
            DisposableObject disposableObject = null;
            try {
                switch (rotateFlipType) {
                    case 2: 
                    case 12: {
                        disposableObject = new i(this.getWidth(), this.getHeight());
                        break;
                    }
                    case 6: 
                    case 8: {
                        disposableObject = new j(this.getWidth(), this.getHeight());
                        break;
                    }
                    case 4: 
                    case 10: {
                        disposableObject = new h(this.getWidth(), this.getHeight());
                        break;
                    }
                    case 3: 
                    case 13: {
                        disposableObject = new f(this.getHeight(), this.getWidth());
                        break;
                    }
                    case 7: 
                    case 9: {
                        disposableObject = new g(this.getHeight(), this.getWidth());
                        break;
                    }
                    case 1: 
                    case 15: {
                        disposableObject = new d(this.getHeight(), this.getWidth());
                        break;
                    }
                    case 5: 
                    case 11: {
                        disposableObject = new e(this.getHeight(), this.getWidth());
                        break;
                    }
                    default: {
                        throw new ImageException("Unsupported rotate flip operation.");
                    }
                }
                au au2 = new au(this, (IPartialArgb32PixelLoader)((Object)disposableObject));
                this.a((IPartialArgb32PixelLoader)((Object)disposableObject));
                this.a(((l)disposableObject).d(), ((l)disposableObject).e(), (l)disposableObject);
            }
            finally {
                this.d(true);
                if (disposableObject != null) {
                    disposableObject.dispose();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rotate(float angle, boolean resizeProportionally, Color backgroundColor) {
        this.verifyNotDisposed();
        DisposableObject disposableObject = null;
        try {
            angle = com.aspose.imaging.RasterCachedImage$c.a(angle);
            if (angle < Float.MIN_VALUE) {
                return;
            }
            disposableObject = com.aspose.imaging.RasterCachedImage$c.a(this.getWidth(), this.getHeight(), angle, resizeProportionally, backgroundColor.toArgb());
            au au2 = new au(this, (IPartialArgb32PixelLoader)((Object)disposableObject));
            this.a((IPartialArgb32PixelLoader)((Object)disposableObject));
            this.a(((l)disposableObject).d(), ((l)disposableObject).e(), (l)disposableObject);
            this.d(true);
        }
        finally {
            if (disposableObject != null) {
                disposableObject.dispose();
            }
        }
    }

    @Override
    public void crop(Rectangle rectangle) {
        this.verifyNotDisposed();
        if (rectangle.isEmpty() || rectangle.getX() < 0 || rectangle.getY() < 0 || rectangle.getWidth() < 0 || rectangle.getHeight() < 0) {
            throw new ArgumentException("Rectangle incorrect.", "rectangle");
        }
        if (!this.getBounds().contains(rectangle.Clone())) {
            throw new ArgumentException("Rectangle must be contained in the image bounds.", "rectangle");
        }
        DisposableObject disposableObject = null;
        try {
            disposableObject = new com.aspose.imaging.internal.eY.a(this, rectangle.getWidth(), rectangle.getHeight());
            this.a(this, rectangle.Clone(), new b((com.aspose.imaging.internal.eY.a)disposableObject, new Point(-rectangle.getX(), -rectangle.getY())));
            this.d(true);
        }
        catch (RuntimeException runtimeException) {
            if (disposableObject != null) {
                disposableObject.dispose();
            }
            throw new ImageException("Can't clone cache image.", runtimeException);
        }
        this.a((com.aspose.imaging.internal.eY.a)disposableObject);
    }

    @Override
    public void dither(int ditheringMethod, int bitsCount, IColorPalette customPalette) {
        this.verifyNotDisposed();
        DisposableObject disposableObject = null;
        try {
            disposableObject = new com.aspose.imaging.internal.eY.a(this, this.getWidth(), this.getHeight());
            aD aD2 = new aD((RasterImage)disposableObject);
            au au2 = new au((RasterImage)disposableObject, aD2);
            com.aspose.imaging.internal.dV.b b2 = com.aspose.imaging.internal.dV.b.a(ditheringMethod, bitsCount, customPalette, this.getWidth(), this.getHeight(), this.getBounds().Clone(), au2);
            this.a(b2);
            this.d(true);
        }
        catch (RuntimeException runtimeException) {
            if (disposableObject != null) {
                disposableObject.dispose();
            }
            throw new ImageException("Can't perform dithering.", runtimeException);
        }
        this.a((com.aspose.imaging.internal.eY.a)disposableObject);
    }

    @Override
    public void grayscale() {
        this.verifyNotDisposed();
        try {
            Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
            av.a(this, rectangle.Clone(), new a(this));
            IColorPalette iColorPalette = this.f();
            if (iColorPalette != null) {
                int[] nArray = iColorPalette.getArgb32Entries();
                com.aspose.imaging.internal.eY.b.b(nArray);
                this.a(new ColorPalette(nArray));
            }
            this.d(true);
        }
        catch (RuntimeException runtimeException) {
            throw new ImageException("Can't make image grayscale.", runtimeException);
        }
    }

    @Override
    public void binarizeFixed(byte threshold) {
        this.verifyNotDisposed();
        try {
            Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
            int[] nArray = this.h();
            this.a(nArray, com.aspose.imaging.internal.dO.d.e((Object)threshold, 6));
            IColorPalette iColorPalette = this.f();
            if (iColorPalette != null) {
                int[] nArray2 = iColorPalette.getArgb32Entries();
                this.a(nArray2, com.aspose.imaging.internal.dO.d.e((Object)threshold, 6));
                this.a(new ColorPalette(nArray2));
            }
            this.saveArgb32Pixels(new Rectangle(Point.getEmpty(), rectangle.getSize().Clone()), nArray);
            this.d(true);
        }
        catch (RuntimeException runtimeException) {
            throw new ImageException("Can't binarize image.", runtimeException);
        }
    }

    @Override
    public void binarizeOtsu() {
        this.verifyNotDisposed();
        try {
            Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
            int[] nArray = this.h();
            byte by2 = com.aspose.imaging.internal.eY.b.a(nArray);
            this.a(nArray, com.aspose.imaging.internal.dO.d.e((Object)by2, 6));
            IColorPalette iColorPalette = this.f();
            if (iColorPalette != null) {
                int[] nArray2 = iColorPalette.getArgb32Entries();
                this.a(nArray2, com.aspose.imaging.internal.dO.d.e((Object)by2, 6));
                this.a(new ColorPalette(nArray2));
            }
            this.saveArgb32Pixels(new Rectangle(Point.getEmpty(), rectangle.getSize().Clone()), nArray);
            this.d(true);
        }
        catch (RuntimeException runtimeException) {
            throw new ImageException("Can't binarize image.", runtimeException);
        }
    }

    @Override
    public void binarizeBradley(double brightnessDifference) {
        this.verifyNotDisposed();
        try {
            Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
            int[] nArray = this.h();
            com.aspose.imaging.internal.eY.b.a(nArray, rectangle.getSize().Clone(), brightnessDifference);
            IColorPalette iColorPalette = this.f();
            if (iColorPalette != null) {
                iColorPalette = ColorPaletteHelper.createMonochrome();
                this.dither(0, this.getBitsPerPixel(), iColorPalette);
            }
            this.saveArgb32Pixels(new Rectangle(Point.getEmpty(), rectangle.getSize().Clone()), nArray);
            this.d(true);
        }
        catch (RuntimeException runtimeException) {
            throw new ImageException("Can't binarize image.", runtimeException);
        }
    }

    @Override
    public void adjustBrightness(int brightness) {
        this.verifyNotDisposed();
        try {
            Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
            int[] nArray = this.h();
            com.aspose.imaging.internal.eY.b.a(nArray, brightness);
            IColorPalette iColorPalette = this.f();
            if (iColorPalette != null) {
                int[] nArray2 = iColorPalette.getArgb32Entries();
                com.aspose.imaging.internal.eY.b.a(nArray2, brightness);
                this.a(new ColorPalette(nArray2));
            }
            this.saveArgb32Pixels(new Rectangle(Point.getEmpty(), rectangle.getSize().Clone()), nArray);
            this.d(true);
        }
        catch (RuntimeException runtimeException) {
            throw new ImageException("Can't change brigthness.", runtimeException);
        }
    }

    @Override
    public void adjustContrast(float contrast) {
        this.verifyNotDisposed();
        try {
            Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
            int[] nArray = this.h();
            com.aspose.imaging.internal.eY.b.a(nArray, contrast);
            IColorPalette iColorPalette = this.f();
            if (iColorPalette != null) {
                int[] nArray2 = iColorPalette.getArgb32Entries();
                com.aspose.imaging.internal.eY.b.a(nArray2, contrast);
                this.a(new ColorPalette(nArray2));
            }
            this.saveArgb32Pixels(new Rectangle(Point.getEmpty(), rectangle.getSize().Clone()), nArray);
            this.d(true);
        }
        catch (RuntimeException runtimeException) {
            throw new ImageException("Can't change contrast.", runtimeException);
        }
    }

    @Override
    public void adjustGamma(float gammaRed, float gammaGreen, float gammaBlue) {
        this.verifyNotDisposed();
        try {
            Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
            int[] nArray = this.h();
            com.aspose.imaging.internal.eY.b.a(nArray, gammaRed, gammaGreen, gammaBlue);
            IColorPalette iColorPalette = this.f();
            if (iColorPalette != null) {
                int[] nArray2 = iColorPalette.getArgb32Entries();
                com.aspose.imaging.internal.eY.b.a(nArray2, gammaRed, gammaGreen, gammaBlue);
                this.a(new ColorPalette(nArray2));
            }
            this.saveArgb32Pixels(new Rectangle(Point.getEmpty(), rectangle.getSize()), nArray);
            this.d(true);
        }
        catch (RuntimeException runtimeException) {
            throw new ImageException("Can't perform gamma-correction.", runtimeException);
        }
    }

    @Override
    public void adjustGamma(float gamma) {
        this.adjustGamma(gamma, gamma, gamma);
    }

    public ac a(int n2, int n3) {
        m m2 = new m(this, n2, n3);
        return m2;
    }

    public IColorPalette f() {
        if (this.getPalette() != null) {
            return this.getPalette();
        }
        bf bf2 = aG.a(this);
        if (bf2 == com.aspose.imaging.internal.dO.d.a(PngImage.class)) {
            return ((PngImage)((Object)com.aspose.imaging.internal.dO.d.a(this, PngImage.class))).h().k();
        }
        if (bf2 == com.aspose.imaging.internal.dO.d.a(TiffFrame.class)) {
            return ((TiffFrame)((Object)com.aspose.imaging.internal.dO.d.a(this, TiffFrame.class))).getFrameOptions().getPalette();
        }
        return null;
    }

    public void a(IColorPalette iColorPalette) {
        if (this.getPalette() != null) {
            this.setPalette(iColorPalette);
        } else {
            bf bf2 = aG.a(this);
            if (bf2 == com.aspose.imaging.internal.dO.d.a(PngImage.class)) {
                ((PngImage)((Object)com.aspose.imaging.internal.dO.d.a(this, PngImage.class))).h().a(iColorPalette);
            }
            if (bf2 == com.aspose.imaging.internal.dO.d.a(TiffFrame.class)) {
                ((TiffFrame)((Object)com.aspose.imaging.internal.dO.d.a(this, TiffFrame.class))).getFrameOptions().setPalette(iColorPalette);
            }
        }
    }

    protected abstract void updateDimensions(int var1, int var2);

    protected void onCached() {
    }

    @Override
    protected final void savePixelsInternal(Rectangle rectangle, int[] pixels) {
        if (!com.aspose.imaging.internal.dO.d.b((Object)this.getDataLoader(), com.aspose.imaging.internal.eY.a.class)) {
            DisposableObject disposableObject = null;
            try {
                disposableObject = new com.aspose.imaging.internal.eY.a(this, this.getWidth(), this.getHeight());
                ((Image)disposableObject).setPalette(this.getPalette());
                if (Rectangle.op_Equality(rectangle, this.getBounds())) {
                    ((RasterImage)disposableObject).saveArgb32Pixels(rectangle.Clone(), pixels);
                } else {
                    av.a(this, this.getBounds().Clone(), new aD((RasterImage)disposableObject));
                    ((RasterImage)disposableObject).saveArgb32Pixels(rectangle.Clone(), pixels);
                }
            }
            catch (RuntimeException runtimeException) {
                if (disposableObject != null) {
                    disposableObject.dispose();
                }
                throw runtimeException;
            }
            this.a((com.aspose.imaging.internal.eY.a)disposableObject);
        } else if (pixels != null) {
            ((com.aspose.imaging.internal.eY.a)((Object)com.aspose.imaging.internal.dO.d.a(this.getDataLoader(), com.aspose.imaging.internal.eY.a.class))).saveArgb32Pixels(rectangle.Clone(), pixels);
        }
    }

    @Override
    protected void onPaletteChanged(IColorPalette oldPalette, IColorPalette newPalette) {
        if (com.aspose.imaging.internal.dO.d.b((Object)this.getDataLoader(), com.aspose.imaging.internal.eY.a.class)) {
            ((com.aspose.imaging.internal.eY.a)((Object)com.aspose.imaging.internal.dO.d.a(this.getDataLoader(), com.aspose.imaging.internal.eY.a.class))).setPalette(newPalette);
        }
        super.onPaletteChanged(oldPalette, newPalette);
    }

    private int[] h() {
        at at2 = new at(this, this.getBounds().Clone());
        av.a(this, this.getBounds().Clone(), at2);
        int[] nArray = at2.a();
        return nArray;
    }

    private void a(IPartialArgb32PixelLoader iPartialArgb32PixelLoader) {
        this.a(this, iPartialArgb32PixelLoader);
    }

    private void a(RasterImage rasterImage, IPartialArgb32PixelLoader iPartialArgb32PixelLoader) {
        this.a(rasterImage, rasterImage.getBounds().Clone(), iPartialArgb32PixelLoader);
    }

    private void a(RasterImage rasterImage, Rectangle rectangle, IPartialArgb32PixelLoader iPartialArgb32PixelLoader) {
        au au2 = new au(rasterImage, iPartialArgb32PixelLoader);
        av.a(rasterImage, rectangle.Clone(), au2);
    }

    private void a(int[] nArray, int n2) {
        double d2 = 0.2126;
        double d3 = 0.7152;
        double d4 = 0.0722;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n3 = nArray[i2] >> 24 & 0xFF;
            int n4 = nArray[i2] >> 16 & 0xFF;
            int n5 = nArray[i2] >> 8 & 0xFF;
            int n6 = nArray[i2] & 0xFF;
            byte by2 = com.aspose.imaging.internal.dO.d.b((Object)(d2 * (double)n4 + d3 * (double)n5 + d4 * (double)n6), 14);
            by2 = com.aspose.imaging.internal.dO.d.e((Object)by2, 6) > n2 ? (byte)-1 : 0;
            nArray[i2] = n3 << 24 | com.aspose.imaging.internal.dO.d.e((Object)by2, 6) << 16 | com.aspose.imaging.internal.dO.d.e((Object)by2, 6) << 8 | com.aspose.imaging.internal.dO.d.e((Object)by2, 6);
        }
    }

    private void a(com.aspose.imaging.internal.eY.a a2) {
        this.setDataLoader(a2);
        if (a2 != null) {
            this.updateDimensions(a2.getWidth(), a2.getHeight());
        }
        this.onCached();
    }

    private void a(int n2, int n3, l l2) {
        com.aspose.imaging.internal.eY.a a2 = new com.aspose.imaging.internal.eY.a(this, n2, n3);
        try {
            a2.setPalette(this.getPalette());
            k k2 = new k(l2, a2);
            aE.a(new Rectangle(0, 0, n2, n3), k2);
        }
        catch (RuntimeException runtimeException) {
            a2.dispose();
            throw runtimeException;
        }
        this.a(a2);
    }

    private static class a
    implements IPartialArgb32PixelLoader {
        private final RasterImage a;

        public a(RasterImage rasterImage) {
            this.a = rasterImage;
        }

        @Override
        public void process(Rectangle pixelsRectangle, int[] pixels, Point start, Point end) {
            com.aspose.imaging.internal.eY.b.b(pixels);
            this.a.saveArgb32Pixels(pixelsRectangle.Clone(), pixels);
        }
    }

    private static class b
    implements IPartialArgb32PixelLoader {
        private final com.aspose.imaging.internal.eY.a a;
        private final Point b = new Point();

        public b(com.aspose.imaging.internal.eY.a a2, Point point) {
            this.a = a2;
            point.CloneTo(this.b);
        }

        @Override
        public void process(Rectangle pixelsRectangle, int[] pixels, Point start, Point end) {
            pixelsRectangle.offset(this.b.Clone());
            this.a.saveArgb32Pixels(pixelsRectangle.Clone(), pixels);
        }
    }

    private static class c
    extends l {
        private final float a;
        private final int b;

        private c(int n2, int n3, double d2, int n4) {
            super(n2, n3);
            this.a = (float)(d2 * Math.PI / 180.0);
            this.b = n4;
        }

        public static c a(int n2, int n3, float f2, boolean bl2, int n4) {
            if (bl2) {
                Size size = com.aspose.imaging.RasterCachedImage$c.a(n2, n3, f2).Clone();
                return new c(size.getWidth(), size.getHeight(), f2, n4);
            }
            return new c(n2, n3, f2, n4);
        }

        @Override
        public void process(Rectangle pixelsRectangle, int[] pixels, Point start, Point end) {
            int n2 = this.d();
            int n3 = this.e();
            int n4 = pixelsRectangle.getWidth();
            int n5 = pixelsRectangle.getHeight();
            int[] nArray = this.a();
            byte[] byArray = this.b();
            int[] nArray2 = com.aspose.imaging.RasterCachedImage$c.a(pixelsRectangle.getWidth(), pixelsRectangle.getHeight());
            int n6 = n2 / 2;
            int n7 = n3 / 2;
            int n8 = n4 / 2;
            int n9 = n5 / 2;
            double d2 = bF.g(-this.a);
            double d3 = bF.h(-this.a);
            if (nArray != null) {
                int n10 = 0;
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n11 = i2 - n7;
                    for (int i3 = 0; i3 < n2; ++i3) {
                        int n12 = i3 - n6;
                        int n13 = com.aspose.imaging.internal.dO.d.e((Object)bF.d(d3 * (double)n12 - d2 * (double)n11 + (double)n8), 14);
                        int n14 = com.aspose.imaging.internal.dO.d.e((Object)bF.d(d2 * (double)n12 + d3 * (double)n11 + (double)n9), 14);
                        nArray[n10++] = n13 >= 0 && n13 < n4 && n14 >= 0 && n14 < n5 ? pixels[nArray2[n14] + n13] : this.b;
                    }
                }
            } else if (byArray != null) {
                int n15 = 0;
                byte[] byArray2 = q.a(this.b);
                for (int i4 = 0; i4 < n3; ++i4) {
                    int n16 = i4 - n7;
                    for (int i5 = 0; i5 < n2; ++i5) {
                        int n17 = i5 - n6;
                        int n18 = com.aspose.imaging.internal.dO.d.e((Object)bF.d(d3 * (double)n17 - d2 * (double)n16 + (double)n8), 14);
                        int n19 = com.aspose.imaging.internal.dO.d.e((Object)bF.d(d2 * (double)n17 + d3 * (double)n16 + (double)n9), 14);
                        if (n18 >= 0 && n18 < n4 && n19 >= 0 && n19 < n5) {
                            int n20 = pixels[nArray2[n19] + n18];
                            q.a(n20, byArray, n15 << 2);
                        } else {
                            System.arraycopy(byArray2, 0, byArray, n15 << 2, 4);
                        }
                        ++n15;
                    }
                }
            } else {
                int n21 = 0;
                byte[] byArray3 = v.b(this.b);
                for (int i6 = 0; i6 < n3; ++i6) {
                    int n22 = i6 - n7;
                    for (int i7 = 0; i7 < n2; ++i7) {
                        int n23 = i7 - n6;
                        int n24 = com.aspose.imaging.internal.dO.d.e((Object)bF.d(d3 * (double)n23 - d2 * (double)n22 + (double)n8), 14);
                        int n25 = com.aspose.imaging.internal.dO.d.e((Object)bF.d(d2 * (double)n23 + d3 * (double)n22 + (double)n9), 14);
                        byte[] byArray4 = n24 >= 0 && n24 < n4 && n25 >= 0 && n25 < n5 ? v.b(pixels[nArray2[n25] + n24]) : byArray3;
                        this.c().seek(n21 << 2, 0);
                        this.c().write(byArray4, 0, 4);
                        ++n21;
                    }
                }
            }
        }

        public static float a(float f2) {
            if (f2 < 0.0f) {
                while ((f2 += 360.0f) < 0.0f) {
                }
            } else {
                while (f2 >= 360.0f) {
                    f2 -= 360.0f;
                }
            }
            return f2;
        }

        private static float b(float f2) {
            float f3 = f2 <= 180.0f ? f2 : 360.0f - f2;
            if (f3 > 90.0f) {
                f3 = 180.0f - f3;
            }
            return f3;
        }

        private static Size a(int n2, int n3, float f2) {
            f2 = (float)((double)com.aspose.imaging.RasterCachedImage$c.b(f2) * Math.PI / 180.0);
            int n4 = com.aspose.imaging.internal.dO.d.e((Object)bF.a((double)n2 * bF.g(f2) + (double)n3 * bF.h(f2)), 14);
            int n5 = com.aspose.imaging.internal.dO.d.e((Object)bF.a((double)n2 * bF.h(f2) + (double)n3 * bF.g(f2)), 14);
            return new Size(n5, n4);
        }

        private static int[] a(int n2, int n3) {
            int[] nArray = new int[n3];
            int n4 = 0;
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                nArray[i2] = n4;
                n4 += n2;
            }
            return nArray;
        }
    }

    private static class i
    extends l {
        public i(int n2, int n3) {
            super(n2, n3);
        }

        @Override
        public void process(Rectangle pixelsRectangle, int[] pixels, Point start, Point end) {
            int n2 = this.e();
            int n3 = this.d();
            int n4 = pixelsRectangle.getWidth();
            int n5 = pixelsRectangle.getHeight();
            int n6 = 0;
            int n7 = pixelsRectangle.getTop();
            int n8 = pixelsRectangle.getLeft();
            int[] nArray = this.a();
            byte[] byArray = this.b();
            if (nArray != null) {
                for (int i2 = 0; i2 < n5; ++i2) {
                    for (int i3 = 0; i3 < n4; ++i3) {
                        int n9 = n3 - (i3 + n8) - 1;
                        int n10 = (n2 - (i2 + n7) - 1) * n3;
                        nArray[n9 + n10] = pixels[n6++];
                    }
                }
            } else if (byArray != null) {
                for (int i4 = 0; i4 < n5; ++i4) {
                    for (int i5 = 0; i5 < n4; ++i5) {
                        int n11 = n3 - (i5 + n8) - 1;
                        int n12 = (n2 - (i4 + n7) - 1) * n3;
                        q.a(pixels[n6++], byArray, (n11 + n12) * 4);
                    }
                }
            } else {
                for (int i6 = 0; i6 < n5; ++i6) {
                    for (int i7 = 0; i7 < n4; ++i7) {
                        int n13 = n3 - (i7 + n8) - 1;
                        int n14 = (n2 - (i6 + n7) - 1) * n3;
                        int n15 = (n13 + n14) * 4;
                        this.c().seek(n15, 0);
                        this.c().write(v.b(pixels[n6++]), 0, 4);
                    }
                }
            }
        }
    }

    private static class j
    extends l {
        public j(int n2, int n3) {
            super(n2, n3);
        }

        @Override
        public void process(Rectangle pixelsRectangle, int[] pixels, Point start, Point end) {
            int n2 = this.e();
            int n3 = this.d();
            int n4 = pixelsRectangle.getWidth();
            int n5 = pixelsRectangle.getHeight();
            int n6 = 0;
            int n7 = pixelsRectangle.getTop();
            int n8 = pixelsRectangle.getLeft();
            int[] nArray = this.a();
            byte[] byArray = this.b();
            if (nArray != null) {
                for (int i2 = 0; i2 < n5; ++i2) {
                    for (int i3 = 0; i3 < n4; ++i3) {
                        int n9 = i3 + n8;
                        int n10 = (n2 - (i2 + n7) - 1) * n3;
                        nArray[n9 + n10] = pixels[n6++];
                    }
                }
            } else if (byArray != null) {
                for (int i4 = 0; i4 < n5; ++i4) {
                    for (int i5 = 0; i5 < n4; ++i5) {
                        int n11 = i5 + n8;
                        int n12 = (n2 - (i4 + n7) - 1) * n3;
                        q.a(pixels[n6++], byArray, (n11 + n12) * 4);
                    }
                }
            } else {
                for (int i6 = 0; i6 < n5; ++i6) {
                    for (int i7 = 0; i7 < n4; ++i7) {
                        int n13 = i7 + n8;
                        int n14 = (n2 - (i6 + n7) - 1) * n3;
                        int n15 = (n13 + n14) * 4;
                        this.c().seek(n15, 0);
                        this.c().write(v.b(pixels[n6++]), 0, 4);
                    }
                }
            }
        }
    }

    private static class h
    extends l {
        public h(int n2, int n3) {
            super(n2, n3);
        }

        @Override
        public void process(Rectangle pixelsRectangle, int[] pixels, Point start, Point end) {
            int n2 = this.e();
            int n3 = this.d();
            int n4 = pixelsRectangle.getWidth();
            int n5 = pixelsRectangle.getHeight();
            int n6 = 0;
            int n7 = pixelsRectangle.getTop();
            int n8 = pixelsRectangle.getLeft();
            int[] nArray = this.a();
            byte[] byArray = this.b();
            if (nArray != null) {
                for (int i2 = 0; i2 < n5; ++i2) {
                    for (int i3 = 0; i3 < n4; ++i3) {
                        int n9 = n3 - (i3 + n8) - 1;
                        int n10 = (i2 + n7) * n3;
                        nArray[n9 + n10] = pixels[n6++];
                    }
                }
            } else if (byArray != null) {
                for (int i4 = 0; i4 < n5; ++i4) {
                    for (int i5 = 0; i5 < n4; ++i5) {
                        int n11 = n3 - (i5 + n8) - 1;
                        int n12 = (i4 + n7) * n3;
                        q.a(pixels[n6++], byArray, (n11 + n12) * 4);
                    }
                }
            } else {
                for (int i6 = 0; i6 < n5; ++i6) {
                    for (int i7 = 0; i7 < n4; ++i7) {
                        int n13 = n3 - (i7 + n8) - 1;
                        int n14 = (i6 + n7) * n3;
                        int n15 = (n13 + n14) * 4;
                        this.c().seek(n15, 0);
                        this.c().write(v.b(pixels[n6++]), 0, 4);
                    }
                }
            }
        }
    }

    private static class f
    extends l {
        public f(int n2, int n3) {
            super(n2, n3);
        }

        @Override
        public void process(Rectangle pixelsRectangle, int[] pixels, Point start, Point end) {
            int n2 = this.e();
            int n3 = this.d();
            int n4 = pixelsRectangle.getWidth();
            int n5 = pixelsRectangle.getHeight();
            int n6 = 0;
            int n7 = pixelsRectangle.getTop();
            int n8 = pixelsRectangle.getLeft();
            int[] nArray = this.a();
            byte[] byArray = this.b();
            if (nArray != null) {
                for (int i2 = 0; i2 < n5; ++i2) {
                    for (int i3 = 0; i3 < n4; ++i3) {
                        int n9 = i2 + n7;
                        int n10 = (n2 - (i3 + n8) - 1) * n3;
                        nArray[n9 + n10] = pixels[n6++];
                    }
                }
            } else if (byArray != null) {
                for (int i4 = 0; i4 < n5; ++i4) {
                    for (int i5 = 0; i5 < n4; ++i5) {
                        int n11 = i4 + n7;
                        int n12 = (n2 - (i5 + n8) - 1) * n3;
                        q.a(pixels[n6++], byArray, (n11 + n12) * 4);
                    }
                }
            } else {
                for (int i6 = 0; i6 < n5; ++i6) {
                    for (int i7 = 0; i7 < n4; ++i7) {
                        int n13 = i6 + n7;
                        int n14 = (n2 - (i7 + n8) - 1) * n3;
                        int n15 = (n13 + n14) * 4;
                        this.c().seek(n15, 0);
                        this.c().write(v.b(pixels[n6++]), 0, 4);
                    }
                }
            }
        }
    }

    private static class g
    extends l {
        public g(int n2, int n3) {
            super(n2, n3);
        }

        @Override
        public void process(Rectangle pixelsRectangle, int[] pixels, Point start, Point end) {
            int n2 = this.e();
            int n3 = this.d();
            int n4 = pixelsRectangle.getWidth();
            int n5 = pixelsRectangle.getHeight();
            int n6 = 0;
            int n7 = pixelsRectangle.getTop();
            int n8 = pixelsRectangle.getLeft();
            int[] nArray = this.a();
            byte[] byArray = this.b();
            if (nArray != null) {
                for (int i2 = 0; i2 < n5; ++i2) {
                    for (int i3 = 0; i3 < n4; ++i3) {
                        int n9 = n3 - (i2 + n7) - 1;
                        int n10 = (n2 - (i3 + n8) - 1) * n3;
                        nArray[n9 + n10] = pixels[n6++];
                    }
                }
            } else if (byArray != null) {
                for (int i4 = 0; i4 < n5; ++i4) {
                    for (int i5 = 0; i5 < n4; ++i5) {
                        int n11 = n3 - (i4 + n7) - 1;
                        int n12 = (n2 - (i5 + n8) - 1) * n3;
                        q.a(pixels[n6++], byArray, (n11 + n12) * 4);
                    }
                }
            } else {
                for (int i6 = 0; i6 < n5; ++i6) {
                    for (int i7 = 0; i7 < n4; ++i7) {
                        int n13 = n3 - (i6 + n7) - 1;
                        int n14 = (n2 - (i7 + n8) - 1) * n3;
                        int n15 = (n13 + n14) * 4;
                        this.c().seek(n15, 0);
                        this.c().write(v.b(pixels[n6++]), 0, 4);
                    }
                }
            }
        }
    }

    private static class d
    extends l {
        public d(int n2, int n3) {
            super(n2, n3);
        }

        @Override
        public void process(Rectangle pixelsRectangle, int[] pixels, Point start, Point end) {
            int n2 = this.d();
            int n3 = pixelsRectangle.getWidth();
            int n4 = pixelsRectangle.getHeight();
            int n5 = 0;
            int n6 = pixelsRectangle.getTop();
            int n7 = pixelsRectangle.getLeft();
            int[] nArray = this.a();
            byte[] byArray = this.b();
            if (nArray != null) {
                for (int i2 = 0; i2 < n4; ++i2) {
                    for (int i3 = 0; i3 < n3; ++i3) {
                        int n8 = n2 - (i2 + n6) - 1;
                        int n9 = (i3 + n7) * n2;
                        nArray[n8 + n9] = pixels[n5++];
                    }
                }
            } else if (byArray != null) {
                for (int i4 = 0; i4 < n4; ++i4) {
                    for (int i5 = 0; i5 < n3; ++i5) {
                        int n10 = n2 - (i4 + n6) - 1;
                        int n11 = (i5 + n7) * n2;
                        q.a(pixels[n5++], byArray, (n10 + n11) * 4);
                    }
                }
            } else {
                for (int i6 = 0; i6 < n4; ++i6) {
                    for (int i7 = 0; i7 < n3; ++i7) {
                        int n12 = n2 - (i6 + n6) - 1;
                        int n13 = (i7 + n7) * n2;
                        int n14 = (n12 + n13) * 4;
                        this.c().seek(n14, 0);
                        this.c().write(v.b(pixels[n5++]), 0, 4);
                    }
                }
            }
        }
    }

    private static class e
    extends l {
        public e(int n2, int n3) {
            super(n2, n3);
        }

        @Override
        public void process(Rectangle pixelsRectangle, int[] pixels, Point start, Point end) {
            int n2 = this.d();
            int n3 = pixelsRectangle.getWidth();
            int n4 = pixelsRectangle.getHeight();
            int n5 = 0;
            int n6 = pixelsRectangle.getTop();
            int n7 = pixelsRectangle.getLeft();
            int[] nArray = this.a();
            byte[] byArray = this.b();
            if (nArray != null) {
                for (int i2 = 0; i2 < n4; ++i2) {
                    int n8 = i2 + n6;
                    for (int i3 = 0; i3 < n3; ++i3) {
                        int n9 = (i3 + n7) * n2;
                        nArray[n8 + n9] = pixels[n5++];
                    }
                }
            } else if (byArray != null) {
                for (int i4 = 0; i4 < n4; ++i4) {
                    int n10 = i4 + n6;
                    for (int i5 = 0; i5 < n3; ++i5) {
                        int n11 = (i5 + n7) * n2;
                        q.a(pixels[n5++], byArray, (n10 + n11) * 4);
                    }
                }
            } else {
                for (int i6 = 0; i6 < n4; ++i6) {
                    int n12 = i6 + n6;
                    for (int i7 = 0; i7 < n3; ++i7) {
                        int n13 = (i7 + n7) * n2;
                        int n14 = (n12 + n13) * 4;
                        this.c().seek(n14, 0);
                        this.c().write(v.b(pixels[n5++]), 0, 4);
                    }
                }
            }
        }
    }

    private static abstract class l
    extends DisposableObject
    implements IPartialArgb32PixelLoader {
        private StreamContainer a;
        private int[] b;
        private byte[] c;
        private final int d;
        private final int e;

        protected l(int n2, int n3) {
            this.d = n2;
            this.e = n3;
            int n4 = n2 * n3;
            this.b = l.a(n4);
            if (this.b == null) {
                int n5 = n4 * 4;
                this.c = l.b(n5);
                if (this.c == null) {
                    this.a = r.a((long)n5);
                    this.a.seekBegin();
                }
            }
        }

        public int[] a() {
            return this.b;
        }

        public byte[] b() {
            return this.c;
        }

        public StreamContainer c() {
            return this.a;
        }

        public int d() {
            return this.d;
        }

        public int e() {
            return this.e;
        }

        @Override
        public abstract void process(Rectangle var1, int[] var2, Point var3, Point var4);

        @Override
        protected void releaseManagedResources() {
            if (this.a != null) {
                this.a.dispose();
            }
            super.releaseManagedResources();
        }

        private static int[] a(int n2) {
            int[] nArray = null;
            try {
                nArray = new int[n2];
            }
            catch (OutOfMemoryError outOfMemoryError) {
                // empty catch block
            }
            return nArray;
        }

        private static byte[] b(int n2) {
            byte[] byArray = null;
            try {
                byArray = new byte[n2];
            }
            catch (OutOfMemoryError outOfMemoryError) {
                // empty catch block
            }
            return byArray;
        }
    }

    private static class m
    extends DisposableObject
    implements ac {
        private final RasterCachedImage a;
        private com.aspose.imaging.internal.eY.a b;

        public m(RasterCachedImage rasterCachedImage, int n2, int n3) {
            this.b = new com.aspose.imaging.internal.eY.a(rasterCachedImage, n2, n3);
            this.a = rasterCachedImage;
        }

        @Override
        public void a(int[] nArray, Rectangle rectangle, Point point, Point point2) {
            this.b.saveArgb32Pixels(rectangle.Clone(), nArray);
        }

        @Override
        public void a() {
            this.a.a(this.b);
            this.b = null;
        }

        @Override
        protected void releaseManagedResources() {
            if (this.b != null) {
                this.b.dispose();
            }
            super.releaseManagedResources();
        }
    }

    private static class k
    implements Z {
        private final l a;
        private final com.aspose.imaging.internal.eY.a b;

        public k(l l2, com.aspose.imaging.internal.eY.a a2) {
            this.a = l2;
            this.b = a2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void a(Rectangle rectangle) {
            int n2 = rectangle.getWidth();
            int n3 = rectangle.getHeight();
            int n4 = rectangle.getLeft();
            int n5 = rectangle.getTop();
            int n6 = this.b.getWidth();
            int n7 = this.b.getHeight();
            if (this.a.a() != null) {
                if (n4 == 0 && n5 == 0 && n2 == n6 && n3 == n7) {
                    this.b.saveArgb32Pixels(rectangle.Clone(), this.a.a());
                } else {
                    int[] nArray = new int[n2 * n3];
                    int[] nArray2 = this.a.a();
                    for (int i2 = 0; i2 < n3; ++i2) {
                        int n8 = i2 * n2;
                        int n9 = (i2 + n5) * n6;
                        for (int i3 = 0; i3 < n2; ++i3) {
                            int n10 = i3 + n4 + n9;
                            int n11 = i3 + n8;
                            nArray[n11] = nArray2[n10];
                        }
                    }
                    this.b.saveArgb32Pixels(rectangle.Clone(), nArray);
                }
            } else if (this.a.b() != null) {
                int[] nArray = new int[n2 * n3];
                byte[] byArray = this.a.b();
                for (int i4 = 0; i4 < n3; ++i4) {
                    int n12 = i4 * n2;
                    int n13 = (i4 + n5) * n6;
                    for (int i5 = 0; i5 < n2; ++i5) {
                        int n14 = (i5 + n4 + n13) * 4;
                        int n15 = i5 + n12;
                        nArray[n15] = q.c(byArray, n14);
                    }
                }
                this.b.saveArgb32Pixels(rectangle.Clone(), nArray);
            } else {
                byte[] byArray = new byte[4];
                int[] nArray = new int[n2 * n3];
                StreamContainer streamContainer = new StreamContainer(new MemoryStream(this.a.c().toBytes()), true);
                try {
                    for (int i6 = 0; i6 < n3; ++i6) {
                        int n16 = i6 * n2;
                        int n17 = (i6 + n5) * n6;
                        for (int i7 = 0; i7 < n2; ++i7) {
                            int n18 = (i7 + n4 + n17) * 4;
                            int n19 = i7 + n16;
                            streamContainer.seek(n18, 0);
                            if (streamContainer.read(byArray) != byArray.length) {
                                throw new ImageException("Cannot read color data. Unable to continue execution.");
                            }
                            nArray[n19] = v.e(byArray, 0);
                        }
                    }
                }
                finally {
                    if (streamContainer != null) {
                        streamContainer.dispose();
                    }
                }
                this.b.saveArgb32Pixels(rectangle.Clone(), nArray);
            }
        }
    }
}

