/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging;

import com.aspose.imaging.Point;
import com.aspose.imaging.RectangleF;
import com.aspose.imaging.Size;
import com.aspose.imaging.internal.ap.aY;
import com.aspose.imaging.internal.ap.bF;
import com.aspose.imaging.internal.dO.d;
import com.aspose.imaging.internal.dO.i;
import com.aspose.imaging.system.SerializableAttribute;

@SerializableAttribute
public class Rectangle
extends i<Rectangle> {
    static final String RectangleFormat = "{{X={0}, Y={1}, Width={2}, Height={3}}}";
    private static final Rectangle a = new Rectangle();
    private int b;
    private int c;
    private int d;
    private int e;

    public Rectangle() {
    }

    public Rectangle(int x2, int y2, int width, int height) {
        this.d = x2;
        this.e = y2;
        this.c = width;
        this.b = height;
    }

    public Rectangle(Point location, Size size) {
        this.d = location.getX();
        this.e = location.getY();
        this.c = size.getWidth();
        this.b = size.getHeight();
    }

    public static Rectangle getEmpty() {
        return a.Clone();
    }

    public Point getLocation() {
        return new Point(this.getX(), this.getY());
    }

    public void setLocation(Point value) {
        this.setX(value.getX());
        this.setY(value.getY());
    }

    public Size getSize() {
        return new Size(this.getWidth(), this.getHeight());
    }

    public void setSize(Size value) {
        this.setWidth(value.getWidth());
        this.setHeight(value.getHeight());
    }

    public int getX() {
        return this.d;
    }

    public void setX(int value) {
        this.d = value;
    }

    public int getY() {
        return this.e;
    }

    public void setY(int value) {
        this.e = value;
    }

    public int getWidth() {
        return this.c;
    }

    public void setWidth(int value) {
        this.c = value;
    }

    public int getHeight() {
        return this.b;
    }

    public void setHeight(int value) {
        this.b = value;
    }

    public int getLeft() {
        return this.d;
    }

    public void setLeft(int value) {
        int n2 = value - this.d;
        this.d = value;
        this.c -= n2;
    }

    public int getTop() {
        return this.e;
    }

    public void setTop(int value) {
        int n2 = value - this.e;
        this.e = value;
        this.b -= n2;
    }

    public int getRight() {
        return this.getX() + this.getWidth();
    }

    public void setRight(int value) {
        int n2 = value - this.getRight();
        this.c += n2;
    }

    public int getBottom() {
        return this.getY() + this.getHeight();
    }

    public void setBottom(int value) {
        int n2 = value - this.getBottom();
        this.b += n2;
    }

    public boolean isEmpty() {
        return this.b == 0 && this.c == 0 && this.d == 0 && this.e == 0;
    }

    public static Rectangle fromPoints(Point point1, Point point2) {
        int n2 = bF.d(point1.getX(), point2.getX());
        int n3 = bF.b(point1.getX(), point2.getX());
        int n4 = bF.d(point1.getY(), point2.getY());
        int n5 = bF.b(point1.getY(), point2.getY());
        return Rectangle.fromLeftTopRightBottom(n2, n4, n3, n5);
    }

    public static Rectangle ceiling(RectangleF value) {
        return new Rectangle((int)bF.b((double)value.getX()), (int)bF.b((double)value.getY()), (int)bF.b((double)value.getWidth()), (int)bF.b((double)value.getHeight()));
    }

    public static Rectangle truncate(RectangleF value) {
        return new Rectangle((int)value.getX(), (int)value.getY(), (int)value.getWidth(), (int)value.getHeight());
    }

    public static Rectangle round(RectangleF value) {
        return new Rectangle((int)bF.d(value.getX()), (int)bF.d(value.getY()), (int)bF.d(value.getWidth()), (int)bF.d(value.getHeight()));
    }

    public static Rectangle inflate(Rectangle rect, int x2, int y2) {
        Rectangle rectangle = rect.Clone();
        rectangle.inflate(x2, y2);
        return rectangle;
    }

    public static Rectangle intersect(Rectangle a2, Rectangle b2) {
        int n2 = bF.b(a2.getX(), b2.getX());
        int n3 = bF.d(a2.getX() + a2.getWidth(), b2.getX() + b2.getWidth());
        int n4 = bF.b(a2.getY(), b2.getY());
        int n5 = bF.d(a2.getY() + a2.getHeight(), b2.getY() + b2.getHeight());
        if (n3 >= n2 && n5 >= n4) {
            return new Rectangle(n2, n4, n3 - n2, n5 - n4);
        }
        return a.Clone();
    }

    public static Rectangle union(Rectangle a2, Rectangle b2) {
        int n2 = bF.d(a2.getX(), b2.getX());
        int n3 = bF.b(a2.getX() + a2.getWidth(), b2.getX() + b2.getWidth());
        int n4 = bF.d(a2.getY(), b2.getY());
        int n5 = bF.b(a2.getY() + a2.getHeight(), b2.getY() + b2.getHeight());
        return new Rectangle(n2, n4, n3 - n2, n5 - n4);
    }

    public static boolean op_Equality(Rectangle left, Rectangle right) {
        return left.getX() == right.getX() && left.getY() == right.getY() && left.getWidth() == right.getWidth() && left.getHeight() == right.getHeight();
    }

    public static boolean op_Inequality(Rectangle left, Rectangle right) {
        return !Rectangle.op_Equality(left, right);
    }

    public static Rectangle fromLeftTopRightBottom(int left, int top, int right, int bottom) {
        return new Rectangle(left, top, right - left, bottom - top);
    }

    public boolean contains(int x2, int y2) {
        return this.getX() <= x2 && x2 < this.getX() + this.getWidth() && this.getY() <= y2 && y2 < this.getY() + this.getHeight();
    }

    public boolean contains(Point point) {
        return this.contains(point.getX(), point.getY());
    }

    public boolean contains(Rectangle rect) {
        return this.getX() <= rect.getX() && rect.getX() + rect.getWidth() <= this.getX() + this.getWidth() && this.getY() <= rect.getY() && rect.getY() + rect.getHeight() <= this.getY() + this.getHeight();
    }

    public void inflate(int width, int height) {
        this.setX(this.getX() - width);
        this.setY(this.getY() - height);
        this.setWidth(this.getWidth() + 2 * width);
        this.setHeight(this.getHeight() + 2 * height);
    }

    public void inflate(Size size) {
        this.inflate(size.getWidth(), size.getHeight());
    }

    public void intersect(Rectangle rect) {
        Rectangle rectangle = Rectangle.intersect(rect.Clone(), this.Clone()).Clone();
        this.setX(rectangle.getX());
        this.setY(rectangle.getY());
        this.setWidth(rectangle.getWidth());
        this.setHeight(rectangle.getHeight());
    }

    public boolean intersectsWith(Rectangle rect) {
        return rect.getX() < this.getX() + this.getWidth() && this.getX() < rect.getX() + rect.getWidth() && rect.getY() < this.getY() + this.getHeight() && this.getY() < rect.getY() + rect.getHeight();
    }

    public void offset(Point pos) {
        this.offset(pos.getX(), pos.getY());
    }

    public void offset(int x2, int y2) {
        this.setX(this.getX() + x2);
        this.setY(this.getY() + y2);
    }

    public void normalize() {
        if (this.c < 0) {
            this.d += this.c;
            this.c = -this.c;
        }
        if (this.b < 0) {
            this.e += this.b;
            this.b = -this.b;
        }
    }

    public boolean equals(Object obj) {
        if (!com.aspose.imaging.internal.dO.d.b(obj, Rectangle.class)) {
            return false;
        }
        Rectangle rectangle = com.aspose.imaging.internal.dO.d.d(obj, Rectangle.class).Clone();
        return rectangle.getX() == this.getX() && rectangle.getY() == this.getY() && rectangle.getWidth() == this.getWidth() && rectangle.getHeight() == this.getHeight();
    }

    public int hashCode() {
        return this.getX() ^ (this.getY() << 13 | this.getY() >> 19) ^ (this.getWidth() << 26 | this.getWidth() >> 6) ^ (this.getHeight() << 7 | this.getHeight() >> 25);
    }

    public String toString() {
        return aY.a(com.aspose.imaging.internal.aD.i.h(), RectangleFormat, com.aspose.imaging.internal.dO.d.a(this.d), com.aspose.imaging.internal.dO.d.a(this.e), com.aspose.imaging.internal.dO.d.a(this.c), com.aspose.imaging.internal.dO.d.a(this.b));
    }

    @Override
    public void CloneTo(Rectangle that) {
        that.b = this.b;
        that.c = this.c;
        that.d = this.d;
        that.e = this.e;
    }

    @Override
    public Rectangle Clone() {
        Rectangle rectangle = new Rectangle();
        this.CloneTo(rectangle);
        return rectangle;
    }

    public Object clone() {
        return this.Clone();
    }

    public static boolean isEquals(Rectangle obj1, Rectangle obj2) {
        return obj1.equals(obj2);
    }
}

