/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging;

import com.aspose.imaging.PointF;
import com.aspose.imaging.Rectangle;
import com.aspose.imaging.SizeF;
import com.aspose.imaging.internal.ap.aY;
import com.aspose.imaging.internal.ap.bF;
import com.aspose.imaging.internal.dO.d;
import com.aspose.imaging.internal.dO.i;
import com.aspose.imaging.system.SerializableAttribute;

@SerializableAttribute
public class RectangleF
extends i<RectangleF> {
    private static final RectangleF a = new RectangleF();
    private float b;
    private float c;
    private float d;
    private float e;

    public RectangleF() {
        this.d = 0.0f;
        this.e = 0.0f;
        this.c = 0.0f;
        this.b = 0.0f;
    }

    public RectangleF(float x2, float y2, float width, float height) {
        this.d = x2;
        this.e = y2;
        this.c = width;
        this.b = height;
    }

    public RectangleF(PointF location, SizeF size) {
        this.d = location.getX();
        this.e = location.getY();
        this.c = size.getWidth();
        this.b = size.getHeight();
    }

    public static RectangleF getEmpty() {
        return a.Clone();
    }

    public PointF getLocation() {
        return new PointF(this.getX(), this.getY());
    }

    public void setLocation(PointF value) {
        this.setX(value.getX());
        this.setY(value.getY());
    }

    public SizeF getSize() {
        return new SizeF(this.getWidth(), this.getHeight());
    }

    public void setSize(SizeF value) {
        this.setWidth(value.getWidth());
        this.setHeight(value.getHeight());
    }

    public float getX() {
        return this.d;
    }

    public void setX(float value) {
        this.d = value;
    }

    public float getY() {
        return this.e;
    }

    public void setY(float value) {
        this.e = value;
    }

    public float getWidth() {
        return this.c;
    }

    public void setWidth(float value) {
        this.c = value;
    }

    public float getHeight() {
        return this.b;
    }

    public void setHeight(float value) {
        this.b = value;
    }

    public float getLeft() {
        return this.getX();
    }

    public void setLeft(float value) {
        float f2 = value - this.d;
        this.d = value;
        this.c -= f2;
    }

    public float getTop() {
        return this.getY();
    }

    public void setTop(float value) {
        float f2 = value - this.e;
        this.e = value;
        this.b -= f2;
    }

    public float getRight() {
        return this.getX() + this.getWidth();
    }

    public void setRight(float value) {
        float f2 = value - this.getRight();
        this.c += f2;
    }

    public float getBottom() {
        return this.getY() + this.getHeight();
    }

    public void setBottom(float value) {
        float f2 = value - this.getBottom();
        this.b += f2;
    }

    public boolean isEmpty() {
        if (this.getWidth() > 0.0f) {
            return this.getHeight() <= 0.0f;
        }
        return true;
    }

    public static RectangleF fromPoints(PointF point1, PointF point2) {
        float f2 = bF.b(point1.getX(), point2.getX());
        float f3 = bF.a(point1.getX(), point2.getX());
        float f4 = bF.b(point1.getY(), point2.getY());
        float f5 = bF.a(point1.getY(), point2.getY());
        return RectangleF.fromLeftTopRightBottom(f2, f4, f3, f5);
    }

    public static RectangleF inflate(RectangleF rect, float x2, float y2) {
        RectangleF rectangleF = rect.Clone();
        rectangleF.inflate(x2, y2);
        return rectangleF;
    }

    public static RectangleF intersect(RectangleF a2, RectangleF b2) {
        float f2 = bF.a(a2.getX(), b2.getX());
        float f3 = bF.b(a2.getX() + a2.getWidth(), b2.getX() + b2.getWidth());
        float f4 = bF.a(a2.getY(), b2.getY());
        float f5 = bF.b(a2.getY() + a2.getHeight(), b2.getY() + b2.getHeight());
        if (f3 >= f2 && f5 >= f4) {
            return new RectangleF(f2, f4, f3 - f2, f5 - f4);
        }
        return a.Clone();
    }

    public static RectangleF union(RectangleF a2, RectangleF b2) {
        float f2 = bF.b(a2.getX(), b2.getX());
        float f3 = bF.a(a2.getX() + a2.getWidth(), b2.getX() + b2.getWidth());
        float f4 = bF.b(a2.getY(), b2.getY());
        float f5 = bF.a(a2.getY() + a2.getHeight(), b2.getY() + b2.getHeight());
        return new RectangleF(f2, f4, f3 - f2, f5 - f4);
    }

    public static boolean op_Equality(RectangleF left, RectangleF right) {
        return left.getX() == right.getX() && left.getY() == right.getY() && left.getWidth() == right.getWidth() && left.getHeight() == right.getHeight();
    }

    public static boolean op_Inequality(RectangleF left, RectangleF right) {
        return !RectangleF.op_Equality(left, right);
    }

    public static RectangleF to_RectangleF(Rectangle rect) {
        return new RectangleF(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    public static RectangleF fromLeftTopRightBottom(float left, float top, float right, float bottom) {
        return new RectangleF(left, top, right - left, bottom - top);
    }

    public void normalize() {
        if (this.c < 0.0f) {
            this.d += this.c;
            this.c = -this.c;
        }
        if (this.b < 0.0f) {
            this.e += this.b;
            this.b = -this.b;
        }
    }

    public boolean contains(float x2, float y2) {
        return this.getX() <= x2 && x2 < this.getX() + this.getWidth() && this.getY() <= y2 && y2 < this.getY() + this.getHeight();
    }

    public boolean contains(PointF point) {
        return this.contains(point.getX(), point.getY());
    }

    public boolean contains(RectangleF rect) {
        return this.getX() <= rect.getX() && rect.getX() + rect.getWidth() <= this.getX() + this.getWidth() && this.getY() <= rect.getY() && rect.getY() + rect.getHeight() <= this.getY() + this.getHeight();
    }

    public void inflate(float x2, float y2) {
        this.setX(this.getX() - x2);
        this.setY(this.getY() - y2);
        this.setWidth(this.getWidth() + 2.0f * x2);
        this.setHeight(this.getHeight() + 2.0f * y2);
    }

    public void inflate(SizeF size) {
        this.inflate(size.getWidth(), size.getHeight());
    }

    public void intersect(RectangleF rect) {
        RectangleF rectangleF = RectangleF.intersect(rect.Clone(), this.Clone()).Clone();
        this.setX(rectangleF.getX());
        this.setY(rectangleF.getY());
        this.setWidth(rectangleF.getWidth());
        this.setHeight(rectangleF.getHeight());
    }

    public boolean intersectsWith(RectangleF rect) {
        return rect.getX() < this.getX() + this.getWidth() && this.getX() < rect.getX() + rect.getWidth() && rect.getY() < this.getY() + this.getHeight() && this.getY() < rect.getY() + rect.getHeight();
    }

    public void offset(PointF pos) {
        this.offset(pos.getX(), pos.getY());
    }

    public void offset(float x2, float y2) {
        this.setX(this.getX() + x2);
        this.setY(this.getY() + y2);
    }

    public boolean equals(Object obj) {
        if (!com.aspose.imaging.internal.dO.d.b(obj, RectangleF.class)) {
            return false;
        }
        RectangleF rectangleF = com.aspose.imaging.internal.dO.d.d(obj, RectangleF.class).Clone();
        return rectangleF.getX() == this.getX() && rectangleF.getY() == this.getY() && rectangleF.getWidth() == this.getWidth() && rectangleF.getHeight() == this.getHeight();
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public int hashCode() {
        return (int)((long)this.getX() ^ ((long)this.getY() << 13 | (long)this.getY() >> 19) ^ ((long)this.getWidth() << 26 | (long)this.getWidth() >> 6) ^ ((long)this.getHeight() << 7 | (long)this.getHeight() >> 25));
    }

    public String toString() {
        return aY.a(com.aspose.imaging.internal.aD.i.h(), "{{X={0}, Y={1}, Width={2}, Height={3}}}", com.aspose.imaging.internal.dO.d.a(Float.valueOf(this.d)), com.aspose.imaging.internal.dO.d.a(Float.valueOf(this.e)), com.aspose.imaging.internal.dO.d.a(Float.valueOf(this.c)), com.aspose.imaging.internal.dO.d.a(Float.valueOf(this.b)));
    }

    @Override
    public void CloneTo(RectangleF that) {
        that.b = this.b;
        that.c = this.c;
        that.d = this.d;
        that.e = this.e;
    }

    @Override
    public RectangleF Clone() {
        RectangleF rectangleF = new RectangleF();
        this.CloneTo(rectangleF);
        return rectangleF;
    }

    public static boolean isEquals(RectangleF obj1, RectangleF obj2) {
        return obj1.equals(obj2);
    }
}

