/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging;

import com.aspose.imaging.DisposableObject;
import com.aspose.imaging.af;
import com.aspose.imaging.ag;
import com.aspose.imaging.ah;
import com.aspose.imaging.ai;
import com.aspose.imaging.coreexceptions.FrameworkException;
import com.aspose.imaging.internal.Exceptions.ArgumentException;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.aE.k;
import com.aspose.imaging.internal.ap.aY;
import com.aspose.imaging.internal.ap.ay;
import com.aspose.imaging.internal.ap.bF;
import com.aspose.imaging.internal.cK.b;
import com.aspose.imaging.internal.dN.c;
import com.aspose.imaging.internal.dP.bg;
import com.aspose.imaging.internal.dP.bh;
import com.aspose.imaging.internal.gN.d;
import com.aspose.imaging.system.io.FileStream;
import com.aspose.imaging.system.io.MemoryStream;
import com.aspose.imaging.system.io.Stream;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamContainer
extends DisposableObject
implements d {
    public static final int READ_WRITE_BYTES_COUNT = 4096;
    protected final long startPosition;
    private Stream a;
    private final boolean b;
    private final Object c = new Object();
    private static Object d = new Object();

    public StreamContainer(InputStream stream) {
        this(Stream.fromJava(stream));
    }

    public StreamContainer(Stream stream) {
        this(stream, false);
    }

    public StreamContainer(InputStream stream, boolean disposeStream) {
        this(Stream.fromJava(stream), disposeStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamContainer(Stream stream, boolean disposeStream) {
        if (stream == null) {
            throw new ArgumentNullException("stream");
        }
        Object object = d;
        synchronized (object) {
            this.b = disposeStream;
            this.startPosition = stream.getPosition();
            this.a = com.aspose.imaging.internal.dO.d.b((Object)stream, d.class) ? stream : bh.a().a(stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StreamContainer(Stream stream, long startPosition, boolean disposeStream) {
        if (stream == null) {
            throw new ArgumentNullException("stream");
        }
        if (startPosition < 0L || startPosition != 0L && startPosition >= stream.getLength()) {
            throw new ArgumentOutOfRangeException("startPosition");
        }
        Object object = d;
        synchronized (object) {
            this.b = disposeStream;
            this.startPosition = startPosition;
            this.a = com.aspose.imaging.internal.dO.d.b((Object)stream, d.class) ? stream : bh.a().a(stream);
        }
    }

    public static Stream to_Stream(StreamContainer streamContainer) {
        Stream stream = null;
        if (streamContainer != null) {
            stream = streamContainer.a;
        }
        return stream;
    }

    @Override
    public Object getSyncRoot() {
        this.verifyNotDisposed();
        return bg.a(this.a(), this.c);
    }

    public long getPosition() {
        this.verifyNotDisposed();
        return this.a.getPosition() - this.startPosition;
    }

    public void setPosition(long value) {
        this.verifyNotDisposed();
        this.a.setPosition(value + this.startPosition);
    }

    public InputStream getStream() {
        return Stream.toJava(this.a());
    }

    public Stream a() {
        this.verifyNotDisposed();
        return this.a;
    }

    public boolean isStreamDisposedOnClose() {
        this.verifyNotDisposed();
        return this.b;
    }

    public long getLength() {
        this.verifyNotDisposed();
        return this.a.getLength() - this.startPosition;
    }

    public void setLength(long value) {
        this.verifyNotDisposed();
        this.a.setLength(value + this.startPosition);
    }

    public boolean canRead() {
        this.verifyNotDisposed();
        return this.a.canRead();
    }

    public boolean canSeek() {
        this.verifyNotDisposed();
        return this.a.canSeek();
    }

    public boolean canWrite() {
        this.verifyNotDisposed();
        return this.a.canWrite();
    }

    public void flush() {
        this.verifyNotDisposed();
        this.a.flush();
    }

    public void write(byte[] bytes) {
        this.verifyNotDisposed();
        if (bytes == null) {
            throw new ArgumentNullException("bytes");
        }
        this.a.write(bytes, 0, bytes.length);
    }

    public void writeByte(byte value) {
        this.verifyNotDisposed();
        this.a.writeByte(value);
    }

    public int read(byte[] bytes) {
        this.verifyNotDisposed();
        if (bytes == null) {
            throw new ArgumentNullException("bytes");
        }
        return this.a.read(bytes, 0, bytes.length);
    }

    public byte[] toBytes() {
        this.verifyNotDisposed();
        return this.toBytes(0L, this.getLength());
    }

    public byte[] toBytes(long position, long bytesCount) {
        this.verifyNotDisposed();
        if (position >= this.getLength() || position < 0L) {
            throw new ArgumentOutOfRangeException("position", "The starting position is out of stream bounds.");
        }
        if (bytesCount > this.getLength()) {
            throw new ArgumentOutOfRangeException("bytesCount", "The stream does not contain so many bytes.");
        }
        if (bytesCount + position > this.getLength() && bytesCount > 0L) {
            throw new ArgumentException("Reading so many bytes will cause passing the stream end.");
        }
        if (this.a.canSeek()) {
            this.setPosition(position);
        } else if (this.getPosition() != position) {
            throw new FrameworkException("Cannot seek to the desired position. The stream does not support seeking.");
        }
        byte[] byArray = new byte[(int)bytesCount];
        int n2 = 0;
        byte[] byArray2 = new byte[4096];
        while (bytesCount > 0L) {
            int n3 = (int)bF.d((long)byArray2.length, bytesCount);
            if (this.a.read(byArray2, 0, n3) != n3) {
                throw new FrameworkException(aY.a(new String[]{"Copy operation cannot complete. Cannot read ", ay.b(n3), " bytes."}));
            }
            System.arraycopy(byArray2, 0, byArray, n2, n3);
            n2 += n3;
            bytesCount -= (long)n3;
        }
        return byArray;
    }

    public int read(byte[] buffer, int offset, int count) {
        this.verifyNotDisposed();
        return this.a.read(buffer, offset, count);
    }

    public int readByte() {
        this.verifyNotDisposed();
        return this.a.readByte();
    }

    public long seek(long offset, int origin) {
        this.verifyNotDisposed();
        switch (origin) {
            case 0: {
                this.a.seek(offset + this.startPosition, 0);
                break;
            }
            case 1: {
                this.a.seek(offset, 1);
                break;
            }
            case 2: {
                this.a.seek(offset, 2);
            }
        }
        return this.getPosition();
    }

    public void seekBegin() {
        this.verifyNotDisposed();
        this.a.seek(this.startPosition, 0);
    }

    public void write(byte[] buffer, int offset, int count) {
        this.verifyNotDisposed();
        this.a.write(buffer, offset, count);
    }

    public void save(OutputStream destinationStream) {
        if (destinationStream instanceof b) {
            this.saveInternal(((b)destinationStream).a());
        } else {
            com.aspose.imaging.internal.dN.c.a(new af(this, destinationStream));
        }
    }

    void saveInternal(Stream destinationStream) {
        this.saveInternal(destinationStream, 4096, this.getLength());
    }

    public void save(OutputStream destinationStream, int bufferSize) {
        if (destinationStream instanceof b) {
            this.saveInternal(((b)destinationStream).a(), bufferSize);
        } else {
            com.aspose.imaging.internal.dN.c.a(new ag(this, destinationStream, bufferSize));
        }
    }

    void saveInternal(Stream destinationStream, int bufferSize) {
        this.saveInternal(destinationStream, bufferSize, this.getLength());
    }

    public void save(OutputStream destinationStream, int bufferSize, long length) {
        if (destinationStream instanceof b) {
            this.saveInternal(((b)destinationStream).a(), bufferSize, length);
        } else {
            com.aspose.imaging.internal.dN.c.a(new ah(this, destinationStream, bufferSize, length));
        }
    }

    void saveInternal(Stream destinationStream, int bufferSize, long length) {
        int n2;
        this.verifyNotDisposed();
        if (destinationStream == null) {
            throw new ArgumentNullException("destinationStream");
        }
        if (destinationStream == this.a) {
            throw new FrameworkException("Saving to the same stream is not allowed.");
        }
        if (bufferSize <= 0) {
            throw new ArgumentOutOfRangeException("bufferSize", "The buffer must be positive.");
        }
        this.beforeSave(destinationStream.toOutputStream());
        byte[] byArray = new byte[(int)bF.d((long)bufferSize, length)];
        while (length > 0L && (n2 = this.a.read(byArray, 0, (int)bF.d((long)byArray.length, length))) > 0) {
            destinationStream.write(byArray, 0, n2);
            length -= (long)n2;
        }
    }

    public void save(String filePath) {
        this.save(filePath, 4096, this.getLength());
    }

    public void save(String filePath, int bufferSize) {
        this.save(filePath, bufferSize, this.getLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String filePath, int bufferSize, long length) {
        this.verifyNotDisposed();
        if (filePath == null) {
            throw new ArgumentNullException("filePath");
        }
        this.a.setPosition(0L);
        FileStream fileStream = k.b(filePath);
        try {
            this.saveInternal(fileStream, bufferSize, length);
        }
        finally {
            if (fileStream != null) {
                fileStream.dispose();
            }
        }
    }

    public void writeTo(StreamContainer streamContainer) {
        long l2 = this.getLength() - this.getPosition();
        this.writeTo(streamContainer, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(StreamContainer streamContainer, long length) {
        MemoryStream memoryStream = new MemoryStream(this.toBytes());
        try {
            byte[] byArray = new byte[4096];
            while (length > 0L) {
                int n2 = (int)bF.d((long)byArray.length, length);
                if (((Stream)memoryStream).read(byArray, 0, n2) != n2) {
                    throw new FrameworkException(aY.a(new String[]{"Copy operation cannot complete. Cannot read ", ay.b(n2), " bytes."}));
                }
                length -= (long)n2;
                streamContainer.write(byArray, 0, n2);
            }
        }
        finally {
            if (memoryStream != null) {
                memoryStream.dispose();
            }
        }
    }

    protected void afterStreamDisposed() {
    }

    protected void beforeStreamDisposed() {
        if (this.a.canWrite()) {
            this.a.flush();
        }
    }

    void beforeSaveInternal(Stream destinationStream) {
    }

    protected void beforeSave(OutputStream destinationStream) {
        if (destinationStream instanceof b) {
            this.beforeSaveInternal(((b)destinationStream).a());
        } else {
            com.aspose.imaging.internal.dN.c.a(new ai(this, destinationStream));
        }
    }

    @Override
    protected void releaseManagedResources() {
        try {
            this.disposeStream();
        }
        finally {
            super.releaseManagedResources();
        }
    }

    protected void disposeStream() {
        if (this.b) {
            this.beforeStreamDisposed();
            try {
                bg bg2 = (bg)((Object)com.aspose.imaging.internal.dO.d.a(this.a, bg.class));
                if (bg2 != null && bg2.c()) {
                    return;
                }
                this.a.dispose();
            }
            finally {
                this.afterStreamDisposed();
            }
        }
    }
}

