/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.fileformats.bmp;

import com.aspose.imaging.IColorPalette;
import com.aspose.imaging.IPartialArgb32PixelLoader;
import com.aspose.imaging.IPartialRawDataLoader;
import com.aspose.imaging.LoadOptions;
import com.aspose.imaging.PixelDataFormat;
import com.aspose.imaging.Point;
import com.aspose.imaging.RasterCachedImage;
import com.aspose.imaging.RasterImage;
import com.aspose.imaging.RawDataSettings;
import com.aspose.imaging.Rectangle;
import com.aspose.imaging.StreamContainer;
import com.aspose.imaging.coreexceptions.imageformats.BmpImageException;
import com.aspose.imaging.fileformats.bmp.BitmapInfoHeader;
import com.aspose.imaging.fileformats.bmp.BitmapV4Header;
import com.aspose.imaging.fileformats.bmp.BitmapV5Header;
import com.aspose.imaging.internal.Exceptions.ArgumentException;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.Exceptions.NotImplementedException;
import com.aspose.imaging.internal.aQ.f;
import com.aspose.imaging.internal.ap.bF;
import com.aspose.imaging.internal.dO.d;
import com.aspose.imaging.internal.dP.aA;
import com.aspose.imaging.internal.dP.aE;
import com.aspose.imaging.internal.dP.aM;
import com.aspose.imaging.internal.dP.aa;
import com.aspose.imaging.internal.dP.az;
import com.aspose.imaging.internal.dP.bj;
import com.aspose.imaging.internal.dP.bm;
import com.aspose.imaging.internal.ed.e;
import com.aspose.imaging.internal.ed.g;
import com.aspose.imaging.internal.ed.h;
import com.aspose.imaging.internal.ed.i;
import com.aspose.imaging.internal.ed.k;
import com.aspose.imaging.system.io.Stream;
import java.io.InputStream;

public final class BmpImage
extends RasterCachedImage {
    private i e;

    public BmpImage(String path) {
        this(path, 32, 0L, 0.0, 0.0);
    }

    public BmpImage(String path, int bitsPerPixel, long compression, double horizontalResolution, double verticalResolution) {
        if (path == null) {
            throw new ArgumentNullException("path");
        }
        aM aM2 = new aM(path);
        if (com.aspose.imaging.internal.dO.d.b((Object)aM2.a(), BmpImage.class)) {
            BmpImage bmpImage = (BmpImage)aM2.a();
            this.a(aM2, bitsPerPixel, compression, horizontalResolution, verticalResolution, bmpImage.e.o());
        } else {
            this.a(aM2, bitsPerPixel, compression, horizontalResolution, verticalResolution, null);
        }
    }

    public BmpImage(InputStream stream) {
        this(Stream.fromJava(stream));
    }

    BmpImage(Stream stream) {
        this(stream, 32, 0L, 0.0, 0.0);
    }

    public BmpImage(InputStream stream, int bitsPerPixel, long compression, double horizontalResolution, double verticalResolution) {
        this(Stream.fromJava(stream), bitsPerPixel, compression, horizontalResolution, verticalResolution);
    }

    BmpImage(Stream stream, int bitsPerPixel, long compression, double horizontalResolution, double verticalResolution) {
        if (stream == null) {
            throw new ArgumentNullException("stream");
        }
        this.a(new aM(stream), bitsPerPixel, compression, horizontalResolution, verticalResolution, null);
    }

    public BmpImage(RasterImage rasterImage) {
        this(rasterImage, 32, 0L, 0.0, 0.0);
    }

    public BmpImage(RasterImage rasterImage, int bitsPerPixel, long compression, double horizontalResolution, double verticalResolution) {
        if (rasterImage == null) {
            throw new ArgumentNullException("rasterImage");
        }
        this.a(new aM(rasterImage), bitsPerPixel, compression, horizontalResolution, verticalResolution, null);
    }

    public BmpImage(int width, int height) {
        this(width, height, 32, null, 0L, 0.0, 0.0);
    }

    public BmpImage(int width, int height, int bitsPerPixel, IColorPalette palette) {
        this(width, height, bitsPerPixel, palette, 0L, 0.0, 0.0);
    }

    public BmpImage(int width, int height, int bitsPerPixel, IColorPalette palette, long compression, double horizontalResolution, double verticalResolution) {
        this.a(width, height, bitsPerPixel, palette, compression, horizontalResolution, verticalResolution, null);
    }

    private BmpImage(i bmpStreamHeader, IColorPalette colorPalette, e dataReader) {
        super(colorPalette);
        this.e = bmpStreamHeader;
        if (dataReader != null) {
            this.setDataLoader(dataReader);
        }
    }

    public BitmapInfoHeader getBitmapInfoHeader() {
        return this.e.o();
    }

    @Override
    public PixelDataFormat getRawDataFormat() {
        return this.e.n();
    }

    @Override
    public int getRawLineSize() {
        return this.e.m();
    }

    public long getCompression() {
        return this.e.g();
    }

    @Override
    public int getWidth() {
        return this.e.d();
    }

    @Override
    public int getHeight() {
        return bF.a(this.e.e());
    }

    @Override
    public int getBitsPerPixel() {
        return com.aspose.imaging.internal.dO.d.e((Object)this.e.f(), 8);
    }

    @Override
    public double getHorizontalResolution() {
        return bm.a(this.e.i());
    }

    @Override
    public void setHorizontalResolution(double value) {
        this.setResolution(value, this.getVerticalResolution());
    }

    @Override
    public double getVerticalResolution() {
        return bm.a(this.e.j());
    }

    @Override
    public void setVerticalResolution(double value) {
        this.setResolution(this.getHorizontalResolution(), value);
    }

    @Override
    public void setResolution(double dpiX, double dpiY) {
        this.e.e(com.aspose.imaging.internal.dO.d.e((Object)bF.d(bm.b(dpiX)), 14));
        this.e.f(com.aspose.imaging.internal.dO.d.e((Object)bF.d(bm.b(dpiY)), 14));
    }

    public static BmpImage a(i i2, IColorPalette iColorPalette, e e2) {
        return new BmpImage(i2, iColorPalette, e2);
    }

    public static void a(RasterImage rasterImage, StreamContainer streamContainer, i i2, IColorPalette iColorPalette, Rectangle rectangle) {
        i2.a(streamContainer);
        BmpImage.a(i2, iColorPalette, streamContainer);
        g g2 = h.a(streamContainer, i2, iColorPalette);
        RawDataSettings rawDataSettings = new RawDataSettings();
        rawDataSettings.setPixelDataFormat(i2.n());
        rawDataSettings.setColorPalette(iColorPalette);
        rawDataSettings.setCustomColorConverter(rasterImage.getRawCustomColorConverter());
        rawDataSettings.setFallbackIndex(rasterImage.getRawFallbackIndex());
        rawDataSettings.setIndexedColorConverter(rasterImage.getRawIndexedColorConverter());
        rawDataSettings.setLineSize(i2.m());
        a a2 = new a(rasterImage, g2, rawDataSettings, rectangle.Clone());
        aE.a(rasterImage.getBounds().Clone(), a2);
        if (!i2.p()) {
            streamContainer.setLength(com.aspose.imaging.internal.dO.d.g(i2.b(), 10));
        }
    }

    @Override
    protected void saveData(Stream stream) {
        if (this.getPalette() != null) {
            if (this.getPalette().isCompactPalette()) {
                this.e.c(com.aspose.imaging.internal.dO.d.f((Object)this.getPalette().getEntriesCount(), 9));
            } else {
                this.e.c(com.aspose.imaging.internal.dO.d.f((Object)(1 << this.getBitsPerPixel()), 9));
            }
            this.e.a(com.aspose.imaging.internal.dO.d.f((Object)(com.aspose.imaging.internal.dO.d.f((Object)this.e.c(), 10) + com.aspose.imaging.internal.dO.d.f((Object)(com.aspose.imaging.internal.dO.d.f((Object)this.e.k(), 10) * 4L), 10)), 10));
        }
        StreamContainer streamContainer = new StreamContainer(stream);
        try {
            BmpImage.a(this, streamContainer, this.e, this.getPalette(), this.getBounds().Clone());
        }
        finally {
            if (streamContainer != null) {
                streamContainer.dispose();
            }
        }
    }

    @Override
    protected void updateDimensions(int newWidth, int newHeight) {
        this.e.b(newWidth);
        this.e.c(newHeight);
    }

    @Override
    protected void onPaletteChanging(IColorPalette oldPalette, IColorPalette newPalette) {
        if (this.getBitsPerPixel() == 1 || this.getBitsPerPixel() == 4 || this.getBitsPerPixel() == 8) {
            if (newPalette == null) {
                throw new ArgumentNullException("newPalette", "The palette must present for 1,4 and 8 bits per pixel.");
            }
            if (newPalette.getEntriesCount() == 0) {
                throw new ArgumentOutOfRangeException("newPalette", "The palette entries count should be more than 0 for 1,4 and 8 bits per pixel.");
            }
        }
        super.onPaletteChanging(oldPalette, newPalette);
    }

    private static void a(i i2, IColorPalette iColorPalette, StreamContainer streamContainer) {
        if ((com.aspose.imaging.internal.dO.d.d((Object)i2.f(), 8) == 1 || com.aspose.imaging.internal.dO.d.d((Object)i2.f(), 8) == 4 || com.aspose.imaging.internal.dO.d.d((Object)i2.f(), 8) == 8) && iColorPalette == null) {
            throw new ArgumentNullException("palette", "The palette must present for 1,4 and 8 bits per pixel.");
        }
        if (iColorPalette != null) {
            byte[] byArray = new byte[4];
            for (int i3 = 0; i3 < iColorPalette.getEntriesCount(); ++i3) {
                byArray[3] = -1;
                int n2 = iColorPalette.getArgb32Color(i3);
                byte by2 = (byte)(n2 >> 16 & 0xFF);
                byte by3 = (byte)(n2 >> 8 & 0xFF);
                byte by4 = (byte)(n2 & 0xFF);
                byArray[2] = by2;
                byArray[1] = by3;
                byArray[0] = by4;
                streamContainer.write(byArray);
            }
        }
    }

    private void a(aM aM2, int n2, long l2, double d2, double d3, BitmapInfoHeader bitmapInfoHeader) {
        try {
            this.a(aM2.a().getWidth(), aM2.a().getHeight(), n2, aM2.a().getPalette(), l2, d2, d3, bitmapInfoHeader);
            this.setDataLoader(aM2);
        }
        catch (RuntimeException runtimeException) {
            aM2.dispose();
            throw runtimeException;
        }
    }

    private void a(int n2, int n3, int n4, IColorPalette iColorPalette, long l2, double d2, double d3, BitmapInfoHeader bitmapInfoHeader) {
        if (n3 < 0) {
            throw new BmpImageException("The height should be positive.");
        }
        if (com.aspose.imaging.internal.dO.d.d((Object)n4, 8) <= 8 && iColorPalette == null) {
            throw new ArgumentException("Palette should be specified for images with 8 bits per pixel or less.", "palette");
        }
        i i2 = new i(bitmapInfoHeader);
        i2.q();
        i2.c(n3);
        i2.b(n2);
        i2.d(n4);
        i2.b(l2);
        if (bitmapInfoHeader != null) {
            if (com.aspose.imaging.internal.dO.d.b((Object)bitmapInfoHeader, BitmapV4Header.class)) {
                ((BitmapV4Header)i2.o()).setRedMask(((BitmapV4Header)bitmapInfoHeader).getRedMask());
                ((BitmapV4Header)i2.o()).setGreenMask(((BitmapV4Header)bitmapInfoHeader).getGreenMask());
                ((BitmapV4Header)i2.o()).setBlueMask(((BitmapV4Header)bitmapInfoHeader).getBlueMask());
                ((BitmapV4Header)i2.o()).setAlphaMask(((BitmapV4Header)bitmapInfoHeader).getAlphaMask());
                ((BitmapV4Header)i2.o()).setCSType(((BitmapV4Header)bitmapInfoHeader).getCSType());
                ((BitmapV4Header)i2.o()).setEndpoints(((BitmapV4Header)bitmapInfoHeader).getEndpoints());
                ((BitmapV4Header)i2.o()).setGammaRed(((BitmapV4Header)bitmapInfoHeader).getGammaRed());
                ((BitmapV4Header)i2.o()).setGammaGreen(((BitmapV4Header)bitmapInfoHeader).getGammaGreen());
                ((BitmapV4Header)i2.o()).setGammaBlue(((BitmapV4Header)bitmapInfoHeader).getGammaBlue());
            }
            if (com.aspose.imaging.internal.dO.d.b((Object)bitmapInfoHeader, BitmapV5Header.class)) {
                ((BitmapV5Header)i2.o()).setIntent(((BitmapV5Header)bitmapInfoHeader).getIntent());
                ((BitmapV5Header)i2.o()).setProfileData(((BitmapV5Header)bitmapInfoHeader).getProfileData());
                ((BitmapV5Header)i2.o()).setProfileSize(((BitmapV5Header)bitmapInfoHeader).getProfileSize());
                ((BitmapV5Header)i2.o()).setReserved(((BitmapV5Header)bitmapInfoHeader).getReserved());
            }
        }
        i2.e(com.aspose.imaging.internal.dO.d.e((Object)bF.d(bm.b(d2)), 14));
        i2.f(com.aspose.imaging.internal.dO.d.e((Object)bF.d(bm.b(d3)), 14));
        this.e = i2;
        this.setPalette(iColorPalette);
    }

    private static class com.aspose.imaging.fileformats.bmp.BmpImage$a
    implements aa {
        private final RasterImage a;
        private final g b;
        private final RawDataSettings c;
        private final Rectangle d = new Rectangle();

        public com.aspose.imaging.fileformats.bmp.BmpImage$a(RasterImage rasterImage, g g2, RawDataSettings rawDataSettings, Rectangle rectangle) {
            this.a = rasterImage;
            this.b = g2;
            this.c = rawDataSettings;
            rectangle.CloneTo(this.d);
        }

        @Override
        public void a(Rectangle rectangle) {
            rectangle.intersect(this.d.Clone());
            if (rectangle.getWidth() > 0 && rectangle.getHeight() > 0) {
                a a2 = new a(this.b);
                if (this.a.isRawDataAvailable()) {
                    aA aA2 = new aA(this.a.getBounds().Clone(), this.d.Clone(), a2);
                    this.a.loadRawData(rectangle.Clone(), this.c, aA2);
                } else {
                    az az2 = new az(this.a.getBounds().Clone(), this.d.Clone(), a2);
                    if (this.a.hasTransparentColor()) {
                        bj bj2 = new bj(this.a.getTransparentColor().toArgb(), this.a.getBackgroundColor().toArgb(), az2);
                        this.a.loadPartialArgb32Pixels(rectangle.Clone(), bj2);
                    } else {
                        this.a.loadPartialArgb32Pixels(rectangle.Clone(), az2);
                    }
                }
            }
        }

        @Override
        public long b(Rectangle rectangle) {
            k k2 = this.b.a(rectangle.Clone()).a();
            return k2.c * rectangle.getHeight();
        }

        @Override
        public long c(Rectangle rectangle) {
            k k2 = this.b.a(rectangle.Clone()).a();
            return k2.c;
        }

        @Override
        public long a() {
            int n2 = 32;
            int n3 = f.a(Integer.TYPE) * 4 + f.a(Long.TYPE);
            return n2 + n3;
        }

        private static class a
        implements IPartialArgb32PixelLoader,
        IPartialRawDataLoader {
            private final g a;

            public a(g g2) {
                this.a = g2;
            }

            @Override
            public void process(Rectangle pixelsRectangle, int[] pixels, Point start, Point end) {
                this.a.a(pixelsRectangle.Clone(), pixels);
            }

            @Override
            public void process(Rectangle rectangle, byte[] data, Point start, Point end) {
                this.a.a(rectangle.Clone(), data, 0);
            }

            @Override
            public void process(Rectangle rectangle, byte[] data, Point start, Point end, LoadOptions loadOptions) {
                throw new NotImplementedException();
            }
        }
    }
}

