/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.fileformats.dicom;

import com.aspose.imaging.Color;
import com.aspose.imaging.IColorPalette;
import com.aspose.imaging.IPartialArgb32PixelLoader;
import com.aspose.imaging.IPartialRawDataLoader;
import com.aspose.imaging.IRasterImageArgb32PixelLoader;
import com.aspose.imaging.ImageOptionsBase;
import com.aspose.imaging.ImageResizeSettings;
import com.aspose.imaging.RasterImage;
import com.aspose.imaging.RawDataSettings;
import com.aspose.imaging.Rectangle;
import com.aspose.imaging.StreamContainer;
import com.aspose.imaging.coreexceptions.ImageException;
import com.aspose.imaging.coreexceptions.imageformats.DicomImageException;
import com.aspose.imaging.fileformats.dicom.DicomPage;
import com.aspose.imaging.fileformats.dicom.ReaderDicomFileInfo;
import com.aspose.imaging.imagefilters.filteroptions.FilterOptionsBase;
import com.aspose.imaging.internal.Exceptions.ArgumentException;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.NotImplementedException;
import com.aspose.imaging.internal.aE.k;
import com.aspose.imaging.internal.ap.aY;
import com.aspose.imaging.internal.ap.at;
import com.aspose.imaging.internal.ap.ay;
import com.aspose.imaging.internal.dO.d;
import com.aspose.imaging.internal.dP.ah;
import com.aspose.imaging.system.io.Stream;
import java.io.InputStream;
import java.io.OutputStream;

public class DicomImage
extends RasterImage {
    private int e;
    private int f;
    private ReaderDicomFileInfo g;
    private DicomPage[] h;
    private DicomPage i;

    public DicomImage(String path) {
        this.a(new StreamContainer(k.f(path), true));
        this.f();
        this.setDataLoader(new a(this));
        boolean bl2 = ah.a();
        if (!bl2) {
            long[] lArray = new long[]{this.a};
            DicomImage.a(lArray, this.getDataStreamContainer().a());
            this.a = lArray[0];
        }
    }

    public DicomImage(InputStream stream) {
        this(Stream.fromJava(stream));
    }

    DicomImage(Stream stream) {
        this.a(new StreamContainer(stream));
        this.f();
        this.setDataLoader(new a(this));
        boolean bl2 = ah.a();
        if (!bl2) {
            long[] lArray = new long[]{this.a};
            DicomImage.a(lArray, stream);
            this.a = lArray[0];
        }
    }

    @Override
    public final boolean isCached() {
        DicomPage[] dicomPageArray = this.getDicomPages();
        boolean bl2 = true;
        for (int i2 = 0; i2 < dicomPageArray.length && (bl2 = dicomPageArray[i2].isCached()); ++i2) {
        }
        return bl2;
    }

    public ReaderDicomFileInfo getFileInfo() {
        return this.g;
    }

    public DicomPage[] getDicomPages() {
        this.verifyNotDisposed();
        return (DicomPage[])this.h.clone();
    }

    public DicomPage getActivePage() {
        this.verifyNotDisposed();
        return this.i;
    }

    public void setActivePage(DicomPage value) {
        this.verifyNotDisposed();
        if (value == null) {
            throw new ArgumentNullException("ActivePage");
        }
        if (value.getContainer() != this) {
            throw new DicomImageException("The active page cannot be set as it belongs to another image.");
        }
        this.i = value;
    }

    public int getActivePageIndex() {
        this.verifyNotDisposed();
        return this.getActivePage().getIndex();
    }

    @Override
    public int getWidth() {
        this.verifyNotDisposed();
        return this.e;
    }

    @Override
    public int getHeight() {
        this.verifyNotDisposed();
        return this.f;
    }

    @Override
    public int getBitsPerPixel() {
        this.verifyNotDisposed();
        return this.getActivePage().getBitsPerPixel();
    }

    public void saveAll(String filePath, ImageOptionsBase options) {
        this.verifyNotDisposed();
        int n2 = 1;
        for (DicomPage dicomPage : this.getDicomPages()) {
            dicomPage.save(aY.a(new String[]{ay.b(n2), filePath}), options);
        }
        this.b(this.getDataStreamContainer().a());
    }

    @Override
    public void save(String filePath, ImageOptionsBase options) {
        this.verifyNotDisposed();
        this.getActivePage().save(filePath, options, Rectangle.getEmpty());
        this.b(this.getDataStreamContainer().a());
    }

    @Override
    public void dither(int ditheringMethod, int bitsCount, IColorPalette customPalette) {
        for (DicomPage dicomPage : this.h) {
            dicomPage.dither(ditheringMethod, bitsCount, customPalette);
        }
    }

    @Override
    public void setResolution(double dpiX, double dpiY) {
        throw new NotImplementedException("The method is not implemented");
    }

    @Override
    public final void cacheData() {
        DicomPage[] dicomPageArray = this.getDicomPages();
        for (int i2 = 0; i2 < dicomPageArray.length; ++i2) {
            dicomPageArray[i2].cacheData();
        }
    }

    @Override
    public void rotateFlip(int rotateFlipType) {
        this.verifyNotDisposed();
        this.getActivePage().rotateFlip(rotateFlipType);
    }

    public void rotateFlipAll(int rotateFlip) {
        this.verifyNotDisposed();
        for (DicomPage dicomPage : this.getDicomPages()) {
            dicomPage.rotateFlip(rotateFlip);
        }
    }

    @Override
    public void rotate(float angle, boolean resizeProportionally, Color backgroundColor) {
        this.verifyNotDisposed();
        for (DicomPage dicomPage : this.getDicomPages()) {
            dicomPage.rotate(angle, resizeProportionally, backgroundColor.Clone());
        }
    }

    @Override
    public void resize(int newWidth, int newHeight, int resizeType) {
        this.verifyNotDisposed();
        for (DicomPage dicomPage : this.getDicomPages()) {
            dicomPage.resize(newWidth, newHeight, resizeType);
        }
    }

    @Override
    public void resize(int newWidth, int newHeight, ImageResizeSettings settings) {
        this.verifyNotDisposed();
        for (DicomPage dicomPage : this.getDicomPages()) {
            dicomPage.resize(newWidth, newHeight, settings);
        }
    }

    @Override
    public void resizeWidthProportionally(int newWidth, int resizeType) {
        this.verifyNotDisposed();
        for (DicomPage dicomPage : this.getDicomPages()) {
            dicomPage.resizeWidthProportionally(newWidth, resizeType);
        }
    }

    @Override
    public void resizeHeightProportionally(int newHeight, int resizeType) {
        this.verifyNotDisposed();
        for (DicomPage dicomPage : this.getDicomPages()) {
            dicomPage.resizeHeightProportionally(newHeight, resizeType);
        }
    }

    public void resizeProportional(int newWidth, int newHeight, int resizeType) {
        this.verifyNotDisposed();
        double d2 = (double)newWidth / (double)this.getWidth();
        double d3 = (double)newHeight / (double)this.getHeight();
        for (DicomPage dicomPage : this.getDicomPages()) {
            int n2 = com.aspose.imaging.internal.dO.d.e((Object)(d2 * (double)dicomPage.getWidth() + 0.5), 14);
            int n3 = com.aspose.imaging.internal.dO.d.e((Object)(d3 * (double)dicomPage.getHeight() + 0.5), 14);
            dicomPage.resize(n2, n3, resizeType);
        }
    }

    @Override
    public void crop(Rectangle rectangle) {
        this.verifyNotDisposed();
        if (rectangle.isEmpty() || rectangle.getX() < 0 || rectangle.getY() < 0 || rectangle.getWidth() < 0 || rectangle.getHeight() < 0) {
            throw new ArgumentException("Rectangle incorrect.", "rectangle");
        }
        for (int i2 = 0; i2 < this.getDicomPages().length; ++i2) {
            try {
                this.getDicomPages()[i2].crop(rectangle.Clone());
                continue;
            }
            catch (RuntimeException runtimeException) {
                throw new ImageException(aY.a(new String[]{"Can't crop image. Frame index: ", ay.b(i2)}), runtimeException);
            }
        }
    }

    @Override
    public void grayscale() {
        this.verifyNotDisposed();
        for (int i2 = 0; i2 < this.getDicomPages().length; ++i2) {
            try {
                this.getDicomPages()[i2].grayscale();
                continue;
            }
            catch (RuntimeException runtimeException) {
                throw new ImageException(aY.a(new String[]{"Can't make image grayscale. Frame index: ", ay.b(i2)}), runtimeException);
            }
        }
    }

    @Override
    public void binarizeFixed(byte threshold) {
        this.verifyNotDisposed();
        for (int i2 = 0; i2 < this.getDicomPages().length; ++i2) {
            try {
                this.getDicomPages()[i2].binarizeFixed(threshold);
                continue;
            }
            catch (RuntimeException runtimeException) {
                throw new ImageException(aY.a(new String[]{"Can't make image black and white. Frame index: ", ay.b(i2)}), runtimeException);
            }
        }
    }

    @Override
    public void binarizeOtsu() {
        this.verifyNotDisposed();
        for (int i2 = 0; i2 < this.getDicomPages().length; ++i2) {
            try {
                this.getDicomPages()[i2].binarizeOtsu();
                continue;
            }
            catch (RuntimeException runtimeException) {
                throw new ImageException(aY.a(new String[]{"Can't make image black and white. Frame index: ", ay.b(i2)}), runtimeException);
            }
        }
    }

    @Override
    public void binarizeBradley(double brightnessDifference) {
        this.verifyNotDisposed();
        for (int i2 = 0; i2 < this.getDicomPages().length; ++i2) {
            try {
                this.getDicomPages()[i2].binarizeBradley(brightnessDifference);
                continue;
            }
            catch (RuntimeException runtimeException) {
                throw new ImageException(aY.a(new String[]{"Can't make image black and white. Frame index: ", ay.b(i2)}), runtimeException);
            }
        }
    }

    @Override
    public void crop(int leftShift, int rightShift, int topShift, int bottomShift) {
        this.verifyNotDisposed();
        for (int i2 = 0; i2 < this.getDicomPages().length; ++i2) {
            try {
                this.getDicomPages()[i2].crop(leftShift, rightShift, topShift, bottomShift);
                continue;
            }
            catch (RuntimeException runtimeException) {
                throw new ImageException(aY.a(new String[]{"Can't crop image. Frame index: ", ay.b(i2)}), runtimeException);
            }
        }
    }

    @Override
    public void adjustBrightness(int brightness) {
        this.verifyNotDisposed();
        for (int i2 = 0; i2 < this.getDicomPages().length; ++i2) {
            try {
                this.getDicomPages()[i2].adjustBrightness(brightness);
                continue;
            }
            catch (RuntimeException runtimeException) {
                throw new ImageException(aY.a(new String[]{"Can't change brightness. Frame index: ", ay.b(i2)}), runtimeException);
            }
        }
    }

    @Override
    public void adjustContrast(float contrast) {
        this.verifyNotDisposed();
        for (int i2 = 0; i2 < this.getDicomPages().length; ++i2) {
            try {
                this.getDicomPages()[i2].adjustContrast(contrast);
                continue;
            }
            catch (RuntimeException runtimeException) {
                throw new ImageException(aY.a(new String[]{"Can't change contrast. Frame index: ", ay.b(i2)}), runtimeException);
            }
        }
    }

    @Override
    public void adjustGamma(float gammaRed, float gammaGreen, float gammaBlue) {
        this.verifyNotDisposed();
        for (int i2 = 0; i2 < this.getDicomPages().length; ++i2) {
            try {
                this.getDicomPages()[i2].adjustGamma(gammaRed, gammaGreen, gammaBlue);
                continue;
            }
            catch (RuntimeException runtimeException) {
                throw new ImageException(aY.a(new String[]{"Can't change gamma. Frame index: ", ay.b(i2)}), runtimeException);
            }
        }
    }

    @Override
    public void filter(Rectangle rectangle, FilterOptionsBase options) {
        this.verifyNotDisposed();
        for (int i2 = 0; i2 < this.getDicomPages().length; ++i2) {
            try {
                this.getDicomPages()[i2].filter(rectangle.Clone(), options);
                continue;
            }
            catch (RuntimeException runtimeException) {
                throw new ImageException(aY.a(new String[]{"Can't change gamma. Frame index: ", ay.b(i2)}), runtimeException);
            }
        }
    }

    @Override
    public void adjustGamma(float gamma) {
        this.adjustGamma(gamma, gamma, gamma);
    }

    @Override
    protected void savePixelsInternal(Rectangle rectangle, int[] pixels) {
        this.verifyNotDisposed();
        this.getActivePage().saveArgb32Pixels(rectangle.Clone(), pixels);
    }

    @Override
    protected void saveData(OutputStream stream) {
        throw new NotImplementedException("The method is not implemented");
    }

    @Override
    protected void saveData(Stream stream) {
        throw new NotImplementedException("The method is not implemented");
    }

    @Override
    protected void releaseManagedResources() {
        if (this.h != null) {
            for (DicomPage dicomPage : this.h) {
                at at2 = (at)((Object)com.aspose.imaging.internal.dO.d.a(dicomPage, at.class));
                if (at2 == null) continue;
                at2.dispose();
            }
        }
        this.g.dispose();
        super.releaseManagedResources();
    }

    private void f() {
        if (this.getDataStreamContainer().a() == null) {
            throw new ArgumentNullException("The stream is null.");
        }
        if (this.g == null) {
            this.g = new ReaderDicomFileInfo(this.getDataStreamContainer().a());
            this.g.h();
        }
        this.f = this.getFileInfo().getHeight();
        this.e = this.getFileInfo().getWidth();
        int n2 = 1;
        if (this.g.getNumberOfFrames() > 0) {
            n2 = this.g.getNumberOfFrames();
        }
        this.h = new DicomPage[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.h[i2] = new DicomPage(this, i2);
        }
        this.i = this.h[0];
    }

    private static class a
    implements IRasterImageArgb32PixelLoader {
        private final DicomImage a;

        public a(DicomImage dicomImage) {
            this.a = dicomImage;
        }

        @Override
        public boolean isRawDataAvailable() {
            return this.a.getActivePage().isRawDataAvailable();
        }

        @Override
        public RawDataSettings getRawDataSettings() {
            return this.a.getActivePage().getRawDataSettings();
        }

        @Override
        public void loadPartialArgb32Pixels(Rectangle rectangle, IPartialArgb32PixelLoader partialLoader) {
            this.a.verifyNotDisposed();
            this.a.getActivePage().loadPartialArgb32Pixels(rectangle.Clone(), partialLoader);
        }

        @Override
        public void loadRawData(Rectangle rectangle, RawDataSettings rawDataSettings, IPartialRawDataLoader rawDataLoader) {
            this.a.verifyNotDisposed();
            this.a.getActivePage().loadRawData(rectangle.Clone(), rawDataSettings, rawDataLoader);
        }
    }
}

