/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.fileformats.gif;

import com.aspose.imaging.Color;
import com.aspose.imaging.ColorPalette;
import com.aspose.imaging.ColorPaletteHelper;
import com.aspose.imaging.DataStreamSupporter;
import com.aspose.imaging.IColorPalette;
import com.aspose.imaging.IPartialArgb32PixelLoader;
import com.aspose.imaging.IPartialRawDataLoader;
import com.aspose.imaging.IRasterImageArgb32PixelLoader;
import com.aspose.imaging.Image;
import com.aspose.imaging.ImageResizeSettings;
import com.aspose.imaging.Point;
import com.aspose.imaging.RasterImage;
import com.aspose.imaging.RawDataSettings;
import com.aspose.imaging.Rectangle;
import com.aspose.imaging.StreamContainer;
import com.aspose.imaging.coreexceptions.ImageException;
import com.aspose.imaging.coreexceptions.imageformats.GifImageException;
import com.aspose.imaging.fileformats.gif.IGifBlock;
import com.aspose.imaging.fileformats.gif.blocks.GifApplicationExtensionBlock;
import com.aspose.imaging.fileformats.gif.blocks.GifFrameBlock;
import com.aspose.imaging.fileformats.gif.blocks.GifGraphicsControlBlock;
import com.aspose.imaging.fileformats.gif.blocks.GifPlainTextRenderingBlock;
import com.aspose.imaging.fileformats.gif.c;
import com.aspose.imaging.fileformats.gif.d;
import com.aspose.imaging.fileformats.gif.e;
import com.aspose.imaging.fileformats.gif.f;
import com.aspose.imaging.fileformats.gif.g;
import com.aspose.imaging.imagefilters.filteroptions.FilterOptionsBase;
import com.aspose.imaging.internal.Exceptions.ArgumentException;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.ap.aY;
import com.aspose.imaging.internal.ap.ap;
import com.aspose.imaging.internal.ap.at;
import com.aspose.imaging.internal.ap.ay;
import com.aspose.imaging.internal.ap.n;
import com.aspose.imaging.internal.be.m;
import com.aspose.imaging.internal.dP.aV;
import com.aspose.imaging.internal.hg.j;
import com.aspose.imaging.system.MulticastDelegate;
import com.aspose.imaging.system.collections.Generic.IGenericEnumerator;
import com.aspose.imaging.system.collections.Generic.List;
import com.aspose.imaging.system.io.MemoryStream;
import com.aspose.imaging.system.io.Stream;
import com.aspose.imaging.xmp.XmpPacketWrapper;

public final class GifImage
extends RasterImage {
    private final com.aspose.imaging.internal.eV.b e;
    private final List<IGifBlock> f = new List();
    private GifFrameBlock g;
    private boolean h;
    private static final String i = "XMP Data";
    private static final String j = "XMP";
    private static final int k = 258;

    public GifImage(GifFrameBlock firstFrame, IColorPalette globalPalette) {
        this(firstFrame, globalPalette, false, 0, 0, 0, true);
    }

    public GifImage(GifFrameBlock firstFrame) {
        this(firstFrame, null);
    }

    public GifImage(GifFrameBlock firstFrame, IColorPalette globalPalette, boolean isPaletteSorted, byte paletteColorResolution, byte paletteBackgroundColorIndex, byte aspectRatio, boolean hasTrailer) {
        byte by2;
        int n2;
        if (firstFrame == null) {
            throw new ArgumentNullException("firstFrame");
        }
        if (firstFrame.getContainer() != null) {
            throw new ArgumentException("The first frame already belongs to some other image. Check the Container property.", "firstFrame");
        }
        IColorPalette iColorPalette = firstFrame.getPalette();
        int n3 = 0;
        if (globalPalette != null) {
            n3 = n2 = globalPalette.getEntriesCount();
            by2 = com.aspose.imaging.internal.eV.b.a(n2, true, isPaletteSorted, paletteColorResolution);
        } else if (iColorPalette == null) {
            iColorPalette = ColorPaletteHelper.create8Bit();
            n2 = iColorPalette.getEntriesCount();
            by2 = com.aspose.imaging.internal.eV.b.a(n2, true, false, (byte)0);
            n3 = n2;
            globalPalette = iColorPalette;
        } else {
            by2 = com.aspose.imaging.internal.eV.b.a(0, false, false, (byte)0);
        }
        com.aspose.imaging.internal.eV.b b2 = new com.aspose.imaging.internal.eV.b(com.aspose.imaging.internal.dO.d.d((Object)firstFrame.getWidth(), 9), com.aspose.imaging.internal.dO.d.d((Object)firstFrame.getHeight(), 9), by2, paletteBackgroundColorIndex, aspectRatio);
        if (b2.k() != n3 && n3 > 0) {
            throw new GifImageException("The palette specified should contain entries count equal to power of 2. Minimal palette size is 2, maximal is 256.");
        }
        this.e = b2;
        this.f.addItem(firstFrame);
        firstFrame.a(this);
        this.g = firstFrame;
        this.h = hasTrailer;
        this.setPalette(globalPalette);
        this.setDataLoader(new a(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GifImage(com.aspose.imaging.internal.eV.b gifHeader, IGifBlock[] blocks, IColorPalette colorPalette, boolean hasTrailer, GifFrameBlock activeFrame) {
        super(colorPalette);
        this.e = gifHeader;
        for (int i2 = 0; i2 < blocks.length; ++i2) {
            GifApplicationExtensionBlock gifApplicationExtensionBlock;
            IGifBlock iGifBlock = blocks[i2];
            Image image = (Image)((Object)com.aspose.imaging.internal.dO.d.a(iGifBlock, Image.class));
            if (image != null) {
                image.a(this);
            }
            if ((gifApplicationExtensionBlock = (GifApplicationExtensionBlock)((Object)com.aspose.imaging.internal.dO.d.a(iGifBlock, GifApplicationExtensionBlock.class))) == null) continue;
            try {
                byte[] byArray = gifApplicationExtensionBlock.getApplicationAuthenticationCode();
                byte[] byArray2 = m.u().c(j);
                if (!i.equals(gifApplicationExtensionBlock.getApplicationIdentifier()) || byArray == null || byArray.length != j.length() || com.aspose.imaging.internal.dO.d.e((Object)byArray[0], 6) != com.aspose.imaging.internal.dO.d.e((Object)byArray2[0], 6) || com.aspose.imaging.internal.dO.d.e((Object)byArray[1], 6) != com.aspose.imaging.internal.dO.d.e((Object)byArray2[1], 6) || com.aspose.imaging.internal.dO.d.e((Object)byArray[2], 6) != com.aspose.imaging.internal.dO.d.e((Object)byArray2[2], 6)) continue;
                com.aspose.imaging.internal.hf.a a2 = new com.aspose.imaging.internal.hf.a(m.y());
                MemoryStream memoryStream = new MemoryStream(gifApplicationExtensionBlock.getApplicationData());
                try {
                    String string = a2.b(memoryStream, gifApplicationExtensionBlock.getApplicationData().length - 257);
                    j j2 = new j(string);
                    this.xmpData = j2.a();
                    continue;
                }
                finally {
                    if (memoryStream != null) {
                        memoryStream.dispose();
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        this.f.addRange(com.aspose.imaging.internal.ap.g.a(blocks));
        this.h = hasTrailer;
        this.g = activeFrame;
        this.setDataLoader(new a(this));
    }

    @Override
    public XmpPacketWrapper getXmpData() {
        return this.xmpData;
    }

    @Override
    public void setXmpData(XmpPacketWrapper value) {
        this.xmpData = value;
    }

    public boolean hasTrailer() {
        return this.h;
    }

    public void setTrailer(boolean value) {
        this.h = value;
    }

    public boolean isPaletteSorted() {
        return this.e.i();
    }

    public void setPaletteSorted(boolean value) {
        this.e.b(value);
    }

    public byte getPaletteColorResolutionBits() {
        return this.e.j();
    }

    public void setPaletteColorResolutionBits(byte value) {
        this.e.c(value);
    }

    @Override
    public int getWidth() {
        return com.aspose.imaging.internal.dO.d.e((Object)this.e.e(), 8);
    }

    @Override
    public int getHeight() {
        return com.aspose.imaging.internal.dO.d.e((Object)this.e.f(), 8);
    }

    @Override
    public int getBitsPerPixel() {
        int n2 = 0;
        if (this.g != null) {
            n2 = this.g.getBitsPerPixel();
        }
        return n2;
    }

    public IGifBlock[] getBlocks() {
        return this.f.toArray((IGifBlock[])new IGifBlock[0]);
    }

    public GifFrameBlock getActiveFrame() {
        return this.g;
    }

    public void setActiveFrame(GifFrameBlock value) {
        if (value != null && (value.getContainer() == null || value.getContainer() != this)) {
            throw new GifImageException("The frame does not belong to the current GIF image.");
        }
        this.g = value;
    }

    @Override
    public Color getBackgroundColor() {
        Color color = Color.getEmpty();
        if (this.getPalette() != null && com.aspose.imaging.internal.dO.d.e((Object)this.e.b(), 6) < this.getPalette().getEntriesCount()) {
            this.getPalette().getColor(com.aspose.imaging.internal.dO.d.e((Object)this.e.b(), 6)).CloneTo(color);
        }
        return color;
    }

    @Override
    public void setBackgroundColor(Color value) {
        if (this.getPalette() != null) {
            this.e.a((byte)this.getPalette().getNearestColorIndex(value.Clone()));
        }
    }

    public byte getBackgroundColorIndex() {
        return this.e.b();
    }

    public void setBackgroundColorIndex(byte value) {
        this.e.a(value);
    }

    public byte getPixelAspectRatio() {
        return this.e.g();
    }

    public void setPixelAspectRatio(byte value) {
        this.e.b(value);
    }

    @Override
    public final boolean isCached() {
        IGifBlock[] iGifBlockArray = this.getBlocks();
        boolean bl2 = true;
        for (int i2 = 0; i2 < iGifBlockArray.length && (!com.aspose.imaging.internal.dO.d.b((Object)iGifBlockArray[i2], DataStreamSupporter.class) || (bl2 = ((DataStreamSupporter)((Object)com.aspose.imaging.internal.dO.d.a(iGifBlockArray[i2], DataStreamSupporter.class))).isCached())); ++i2) {
        }
        return bl2;
    }

    @Override
    public boolean hasTransparentColor() {
        return this.g.hasTransparentColor();
    }

    @Override
    public void setTransparentColor(boolean value) {
        this.g.setTransparentColor(value);
    }

    @Override
    public Color getTransparentColor() {
        return this.g.getTransparentColor();
    }

    @Override
    public boolean hasBackgroundColor() {
        return Color.op_Inequality(this.getBackgroundColor(), Color.getEmpty());
    }

    @Override
    public void dither(int ditheringMethod, int bitsCount, IColorPalette customPalette) {
        IGifBlock[] iGifBlockArray = this.getBlocks();
        for (int i2 = 0; i2 < iGifBlockArray.length; ++i2) {
            GifFrameBlock gifFrameBlock = (GifFrameBlock)((Object)com.aspose.imaging.internal.dO.d.a(iGifBlockArray[i2], GifFrameBlock.class));
            if (gifFrameBlock == null) continue;
            gifFrameBlock.dither(ditheringMethod, bitsCount, customPalette);
        }
    }

    @Override
    public final void cacheData() {
        IGifBlock[] iGifBlockArray = this.getBlocks();
        for (int i2 = 0; i2 < iGifBlockArray.length; ++i2) {
            if (!com.aspose.imaging.internal.dO.d.b((Object)iGifBlockArray[i2], DataStreamSupporter.class)) continue;
            ((DataStreamSupporter)((Object)com.aspose.imaging.internal.dO.d.a(iGifBlockArray[i2], DataStreamSupporter.class))).cacheData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rotateFlipAll(int rotateFlip) {
        this.verifyNotDisposed();
        IGenericEnumerator iGenericEnumerator = this.f.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                IGifBlock iGifBlock = (IGifBlock)iGenericEnumerator.next();
                if (!com.aspose.imaging.internal.dO.d.b((Object)iGifBlock, GifFrameBlock.class)) continue;
                ((GifFrameBlock)((Object)com.aspose.imaging.internal.dO.d.a(iGifBlock, GifFrameBlock.class))).rotateFlip(rotateFlip);
            }
        }
        finally {
            if (com.aspose.imaging.internal.dO.d.b((Object)iGenericEnumerator, at.class)) {
                ((at)iGenericEnumerator).dispose();
            }
        }
        this.e.a(com.aspose.imaging.internal.dO.d.d((Object)this.g.getWidth(), 9));
        this.e.b(com.aspose.imaging.internal.dO.d.d((Object)this.g.getHeight(), 9));
    }

    public void orderBlocks() {
        Object object;
        int n2;
        this.verifyNotDisposed();
        List list = new List();
        for (n2 = 0; n2 < this.f.size(); ++n2) {
            int n3;
            IGifBlock iGifBlock = this.f.get_Item(n2);
            if (!com.aspose.imaging.internal.dO.d.b((Object)iGifBlock, GifGraphicsControlBlock.class)) continue;
            object = new List();
            for (n3 = n2 + 1; n3 < this.f.size(); ++n3) {
                IGifBlock iGifBlock2 = this.f.get_Item(n3);
                if (com.aspose.imaging.internal.dO.d.b((Object)iGifBlock2, GifGraphicsControlBlock.class)) {
                    ((List)object).addItem(n3);
                    continue;
                }
                if (!com.aspose.imaging.internal.dO.d.b((Object)iGifBlock2, GifFrameBlock.class) && !com.aspose.imaging.internal.dO.d.b((Object)iGifBlock2, GifPlainTextRenderingBlock.class)) continue;
                list.addRange(object);
                n2 = n3;
                break;
            }
            if (n3 == this.f.size()) break;
        }
        for (n2 = list.size() - 1; n2 >= 0; --n2) {
            int n4 = (Integer)list.get_Item(n2);
            object = (Image)((Object)com.aspose.imaging.internal.dO.d.a(this.f.get_Item(n4), Image.class));
            if (object != null) {
                ((Image)object).a((Image)null);
            }
            this.f.removeAt(n4);
        }
    }

    public void clearBlocks() {
        this.verifyNotDisposed();
        this.f.clear();
        this.g = null;
    }

    public void insertBlock(int index, IGifBlock block) {
        this.verifyNotDisposed();
        if (block == null) {
            throw new ArgumentNullException("block");
        }
        Image image = (Image)((Object)com.aspose.imaging.internal.dO.d.a(block, Image.class));
        if (image != null && image.getContainer() != null && image.getContainer() != this) {
            throw new ArgumentOutOfRangeException("block", "The block belongs to other image and cannot be inserted into this GIF image.");
        }
        this.f.insertItem(index, block);
        if (image != null) {
            image.a(this);
        }
    }

    public void addBlock(IGifBlock block) {
        this.verifyNotDisposed();
        if (block == null) {
            throw new ArgumentNullException("block");
        }
        Image image = (Image)((Object)com.aspose.imaging.internal.dO.d.a(block, Image.class));
        if (image != null && image.getContainer() != null && image.getContainer() != this) {
            throw new ArgumentOutOfRangeException("block", "The block belongs to other image and cannot be added to this GIF image.");
        }
        this.f.addItem(block);
        if (image != null) {
            image.a(this);
        }
    }

    public void removeBlock(IGifBlock block) {
        this.verifyNotDisposed();
        if (block == null) {
            throw new ArgumentNullException("block");
        }
        Image image = (Image)((Object)com.aspose.imaging.internal.dO.d.a(block, Image.class));
        if (image != null && image.getContainer() != this) {
            throw new ArgumentOutOfRangeException("block", "The block does not belong to the current GIF image.");
        }
        this.f.removeItem(block);
        if (image != null) {
            image.a((Image)null);
        }
        if (this.g == block) {
            this.g = null;
        }
    }

    @Override
    public void rotateFlip(int rotateFlipType) {
        this.verifyNotDisposed();
        this.g.rotateFlip(rotateFlipType);
        this.e.a(com.aspose.imaging.internal.dO.d.d((Object)this.g.getWidth(), 9));
        this.e.b(com.aspose.imaging.internal.dO.d.d((Object)this.g.getHeight(), 9));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rotate(float angle, boolean resizeProportionally, Color backgroundColor) {
        this.verifyNotDisposed();
        IGenericEnumerator iGenericEnumerator = this.f.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                IGifBlock iGifBlock = (IGifBlock)iGenericEnumerator.next();
                if (!com.aspose.imaging.internal.dO.d.b((Object)iGifBlock, GifFrameBlock.class)) continue;
                ((GifFrameBlock)((Object)com.aspose.imaging.internal.dO.d.a(iGifBlock, GifFrameBlock.class))).rotate(angle, resizeProportionally, backgroundColor.Clone());
            }
        }
        finally {
            if (com.aspose.imaging.internal.dO.d.b((Object)iGenericEnumerator, at.class)) {
                ((at)iGenericEnumerator).dispose();
            }
        }
        this.e.a(com.aspose.imaging.internal.dO.d.d((Object)this.g.getWidth(), 9));
        this.e.b(com.aspose.imaging.internal.dO.d.d((Object)this.g.getHeight(), 9));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resize(int newWidth, int newHeight, int resizeType) {
        this.verifyNotDisposed();
        if (newWidth <= 0) {
            throw new ArgumentOutOfRangeException("newWidth", "The new width should be positive number and at least 1.");
        }
        if (newHeight <= 0) {
            throw new ArgumentOutOfRangeException("newHeight", "The new height should be positive number and at least 1.");
        }
        IGenericEnumerator iGenericEnumerator = this.f.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                IGifBlock iGifBlock = (IGifBlock)iGenericEnumerator.next();
                GifFrameBlock gifFrameBlock = (GifFrameBlock)((Object)com.aspose.imaging.internal.dO.d.a(iGifBlock, GifFrameBlock.class));
                if (gifFrameBlock == null) continue;
                gifFrameBlock.resize(newWidth, newHeight, resizeType);
            }
        }
        finally {
            if (com.aspose.imaging.internal.dO.d.b((Object)iGenericEnumerator, at.class)) {
                ((at)iGenericEnumerator).dispose();
            }
        }
        this.e.a(com.aspose.imaging.internal.dO.d.d((Object)newWidth, 9));
        this.e.b(com.aspose.imaging.internal.dO.d.d((Object)newHeight, 9));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resize(int newWidth, int newHeight, ImageResizeSettings settings) {
        this.verifyNotDisposed();
        if (newWidth <= 0) {
            throw new ArgumentOutOfRangeException("newWidth", "The new width should be positive number and at least 1.");
        }
        if (newHeight <= 0) {
            throw new ArgumentOutOfRangeException("newHeight", "The new height should be positive number and at least 1.");
        }
        IGenericEnumerator iGenericEnumerator = this.f.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                IGifBlock iGifBlock = (IGifBlock)iGenericEnumerator.next();
                GifFrameBlock gifFrameBlock = (GifFrameBlock)((Object)com.aspose.imaging.internal.dO.d.a(iGifBlock, GifFrameBlock.class));
                if (gifFrameBlock == null) continue;
                IColorPalette iColorPalette = gifFrameBlock.getPalette();
                gifFrameBlock.resize(newWidth, newHeight, settings);
            }
        }
        finally {
            if (com.aspose.imaging.internal.dO.d.b((Object)iGenericEnumerator, at.class)) {
                ((at)iGenericEnumerator).dispose();
            }
        }
        this.e.a(com.aspose.imaging.internal.dO.d.d((Object)newWidth, 9));
        this.e.b(com.aspose.imaging.internal.dO.d.d((Object)newHeight, 9));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resizeProportional(int newWidth, int newHeight, int resizeType) {
        this.verifyNotDisposed();
        double d2 = (double)newWidth / (double)this.getWidth();
        double d3 = (double)newHeight / (double)this.getHeight();
        IGenericEnumerator iGenericEnumerator = this.f.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                IGifBlock iGifBlock = (IGifBlock)iGenericEnumerator.next();
                GifFrameBlock gifFrameBlock = (GifFrameBlock)((Object)com.aspose.imaging.internal.dO.d.a(iGifBlock, GifFrameBlock.class));
                if (gifFrameBlock == null) continue;
                int n2 = com.aspose.imaging.internal.dO.d.e((Object)(d2 * (double)gifFrameBlock.getWidth() + 0.5), 14);
                int n3 = com.aspose.imaging.internal.dO.d.e((Object)(d3 * (double)gifFrameBlock.getHeight() + 0.5), 14);
                gifFrameBlock.resize(n2, n3, resizeType);
            }
        }
        finally {
            if (com.aspose.imaging.internal.dO.d.b((Object)iGenericEnumerator, at.class)) {
                ((at)iGenericEnumerator).dispose();
            }
        }
        this.e.a(com.aspose.imaging.internal.dO.d.d((Object)newWidth, 9));
        this.e.b(com.aspose.imaging.internal.dO.d.d((Object)newHeight, 9));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void crop(Rectangle rectangle) {
        this.verifyNotDisposed();
        if (rectangle.isEmpty() || rectangle.getX() < 0 || rectangle.getY() < 0 || rectangle.getWidth() < 0 || rectangle.getHeight() < 0) {
            throw new ArgumentException("Rectangle incorrect.", "rectangle");
        }
        if (!this.getBounds().contains(rectangle.Clone())) {
            throw new ArgumentException("Rectangle must be contained in the image bounds.", "rectangle");
        }
        int n2 = 0;
        IGenericEnumerator iGenericEnumerator = this.f.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                IGifBlock iGifBlock = (IGifBlock)iGenericEnumerator.next();
                GifFrameBlock gifFrameBlock = (GifFrameBlock)((Object)com.aspose.imaging.internal.dO.d.a(iGifBlock, GifFrameBlock.class));
                if (gifFrameBlock == null) continue;
                try {
                    gifFrameBlock.crop(rectangle.Clone());
                }
                catch (RuntimeException runtimeException) {
                    throw new ImageException(aY.a(new String[]{"Can't crop image. Frame index: ", ay.b(n2)}), runtimeException);
                }
                ++n2;
            }
        }
        finally {
            if (com.aspose.imaging.internal.dO.d.b((Object)iGenericEnumerator, at.class)) {
                ((at)iGenericEnumerator).dispose();
            }
        }
        this.e.a(com.aspose.imaging.internal.dO.d.d((Object)rectangle.getWidth(), 9));
        this.e.b(com.aspose.imaging.internal.dO.d.d((Object)rectangle.getHeight(), 9));
    }

    @Override
    public void grayscale() {
        this.a(new c(this));
    }

    @Override
    public void binarizeFixed(byte threshold) {
        this.a(new d(this, threshold));
    }

    @Override
    public void binarizeOtsu() {
        this.a(new e(this));
    }

    @Override
    public void binarizeBradley(double brightnessDifference) {
        Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        int[] nArray = this.loadArgb32Pixels(rectangle.Clone());
        com.aspose.imaging.internal.eY.b.a(nArray, rectangle.getSize().Clone(), brightnessDifference);
        GifImage gifImage = this;
        this.a(new f(this, gifImage));
        this.saveArgb32Pixels(new Rectangle(Point.getEmpty(), rectangle.getSize().Clone()), nArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adjustBrightness(int brightness) {
        this.verifyNotDisposed();
        int n2 = 0;
        boolean bl2 = false;
        IGenericEnumerator iGenericEnumerator = this.f.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                IGifBlock iGifBlock = (IGifBlock)iGenericEnumerator.next();
                GifFrameBlock gifFrameBlock = (GifFrameBlock)((Object)com.aspose.imaging.internal.dO.d.a(iGifBlock, GifFrameBlock.class));
                if (gifFrameBlock == null) continue;
                try {
                    int[] nArray = gifFrameBlock.getPalette() != null ? gifFrameBlock.getPalette().getArgb32Entries() : this.getPalette().getArgb32Entries();
                    com.aspose.imaging.internal.eY.b.a(nArray, brightness);
                    if (gifFrameBlock.getPalette() != null) {
                        gifFrameBlock.setPalette(new ColorPalette(nArray));
                    } else if (!bl2) {
                        this.setPalette(new ColorPalette(nArray));
                        bl2 = true;
                    }
                }
                catch (RuntimeException runtimeException) {
                    throw new ImageException(aY.a(new String[]{"Can't change brightness. Frame index: ", ay.b(n2)}), runtimeException);
                }
                ++n2;
            }
        }
        finally {
            if (com.aspose.imaging.internal.dO.d.b((Object)iGenericEnumerator, at.class)) {
                ((at)iGenericEnumerator).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adjustContrast(float contrast) {
        this.verifyNotDisposed();
        int n2 = 0;
        boolean bl2 = false;
        IGenericEnumerator iGenericEnumerator = this.f.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                IGifBlock iGifBlock = (IGifBlock)iGenericEnumerator.next();
                GifFrameBlock gifFrameBlock = (GifFrameBlock)((Object)com.aspose.imaging.internal.dO.d.a(iGifBlock, GifFrameBlock.class));
                if (gifFrameBlock == null) continue;
                try {
                    int[] nArray;
                    Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
                    int[] nArray2 = gifFrameBlock.loadArgb32Pixels(rectangle.Clone());
                    IColorPalette iColorPalette = gifFrameBlock.getPalette() != null ? gifFrameBlock.getPalette() : this.getPalette();
                    int[] nArray3 = iColorPalette.getArgb32Entries();
                    com.aspose.imaging.internal.eY.b.a(nArray3, contrast);
                    ColorPalette colorPalette = new ColorPalette(nArray3);
                    if (gifFrameBlock.getPalette() != null) {
                        gifFrameBlock.setPalette(colorPalette);
                        nArray = this.a(iColorPalette, colorPalette, nArray2);
                        gifFrameBlock.saveArgb32Pixels(rectangle.Clone(), nArray);
                    } else if (!bl2) {
                        this.setPalette(colorPalette);
                        nArray = this.a(iColorPalette, colorPalette, nArray2);
                        this.saveArgb32Pixels(rectangle.Clone(), nArray);
                        bl2 = true;
                    }
                }
                catch (RuntimeException runtimeException) {
                    throw new ImageException(aY.a(new String[]{"Can't change contrast. Frame index: ", ay.b(n2)}), runtimeException);
                }
                ++n2;
            }
        }
        finally {
            if (com.aspose.imaging.internal.dO.d.b((Object)iGenericEnumerator, at.class)) {
                ((at)iGenericEnumerator).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adjustGamma(float gammaRed, float gammaGreen, float gammaBlue) {
        this.verifyNotDisposed();
        int n2 = 0;
        boolean bl2 = false;
        IGenericEnumerator iGenericEnumerator = this.f.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                IGifBlock iGifBlock = (IGifBlock)iGenericEnumerator.next();
                GifFrameBlock gifFrameBlock = (GifFrameBlock)((Object)com.aspose.imaging.internal.dO.d.a(iGifBlock, GifFrameBlock.class));
                if (gifFrameBlock == null) continue;
                try {
                    int[] nArray;
                    Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
                    int[] nArray2 = gifFrameBlock.loadArgb32Pixels(rectangle.Clone());
                    IColorPalette iColorPalette = gifFrameBlock.getPalette() != null ? gifFrameBlock.getPalette() : this.getPalette();
                    int[] nArray3 = iColorPalette.getArgb32Entries();
                    com.aspose.imaging.internal.eY.b.a(nArray3, gammaRed, gammaGreen, gammaBlue);
                    ColorPalette colorPalette = new ColorPalette(nArray3);
                    if (gifFrameBlock.getPalette() != null) {
                        gifFrameBlock.setPalette(colorPalette);
                        nArray = this.a(iColorPalette, colorPalette, nArray2);
                        gifFrameBlock.saveArgb32Pixels(rectangle.Clone(), nArray);
                    } else if (!bl2) {
                        this.setPalette(colorPalette);
                        nArray = this.a(iColorPalette, colorPalette, nArray2);
                        this.saveArgb32Pixels(rectangle.Clone(), nArray);
                        bl2 = true;
                    }
                }
                catch (RuntimeException runtimeException) {
                    throw new ImageException(aY.a(new String[]{"Can't change gamma. Frame index: ", ay.b(n2)}), runtimeException);
                }
                ++n2;
            }
        }
        finally {
            if (com.aspose.imaging.internal.dO.d.b((Object)iGenericEnumerator, at.class)) {
                ((at)iGenericEnumerator).dispose();
            }
        }
    }

    @Override
    public void adjustGamma(float gamma) {
        this.adjustGamma(gamma, gamma, gamma);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void filter(Rectangle rectangle, FilterOptionsBase options) {
        Object object;
        this.verifyNotDisposed();
        IGenericEnumerator iGenericEnumerator = this.f.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                object = (IGifBlock)iGenericEnumerator.next();
                GifFrameBlock gifFrameBlock = (GifFrameBlock)((Object)com.aspose.imaging.internal.dO.d.a(object, GifFrameBlock.class));
                if (gifFrameBlock == null) continue;
                gifFrameBlock.filter(rectangle.Clone(), options);
            }
        }
        finally {
            if (com.aspose.imaging.internal.dO.d.b((Object)iGenericEnumerator, at.class)) {
                ((at)iGenericEnumerator).dispose();
            }
        }
        if (this.getPalette() != null && (object = com.aspose.imaging.internal.gW.a.a((RasterImage)this.getActiveFrame(), this.getPalette().getEntriesCount())) != null) {
            this.setPalette((IColorPalette)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void f() {
        Object object;
        Object object2;
        List<Object> list = new List<Object>();
        byte[] byArray = m.u().c(j);
        IGenericEnumerator iGenericEnumerator = this.f.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                object2 = (IGifBlock)iGenericEnumerator.next();
                object = (GifApplicationExtensionBlock)((Object)com.aspose.imaging.internal.dO.d.a(object2, GifApplicationExtensionBlock.class));
                if (object == null || !i.equals(((GifApplicationExtensionBlock)object).getApplicationIdentifier()) || ((GifApplicationExtensionBlock)object).getApplicationAuthenticationCode().length != j.length() || com.aspose.imaging.internal.dO.d.e((Object)((GifApplicationExtensionBlock)object).getApplicationAuthenticationCode()[0], 6) != com.aspose.imaging.internal.dO.d.e((Object)byArray[0], 6) || com.aspose.imaging.internal.dO.d.e((Object)((GifApplicationExtensionBlock)object).getApplicationAuthenticationCode()[1], 6) != com.aspose.imaging.internal.dO.d.e((Object)byArray[1], 6) || com.aspose.imaging.internal.dO.d.e((Object)((GifApplicationExtensionBlock)object).getApplicationAuthenticationCode()[2], 6) != com.aspose.imaging.internal.dO.d.e((Object)byArray[2], 6)) continue;
                list.addItem(object);
            }
        }
        finally {
            if (com.aspose.imaging.internal.dO.d.b((Object)iGenericEnumerator, at.class)) {
                ((at)iGenericEnumerator).dispose();
            }
        }
        object2 = list.iterator();
        try {
            while (object2.hasNext()) {
                object = (IGifBlock)object2.next();
                this.removeBlock((IGifBlock)object);
            }
        }
        finally {
            if (com.aspose.imaging.internal.dO.d.b(object2, at.class)) {
                ((at)object2).dispose();
            }
        }
        if (this.xmpData != null) {
            object = this.xmpData.b();
            byte[] byArray2 = m.y().c((String)object);
            GifApplicationExtensionBlock gifApplicationExtensionBlock = new GifApplicationExtensionBlock();
            gifApplicationExtensionBlock.setApplicationIdentifier(i);
            gifApplicationExtensionBlock.setApplicationAuthenticationCode(byArray);
            gifApplicationExtensionBlock.setApplicationData(byArray2);
            this.addBlock(gifApplicationExtensionBlock);
        }
    }

    private void a(int[] nArray, byte by2) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = nArray[i2];
            byte by3 = com.aspose.imaging.internal.dO.d.b((Object)(0.2126 * (double)(n2 >> 16 & 0xFF) + 0.7152 * (double)(n2 >> 8 & 0xFF) + 0.0722 * (double)(n2 & 0xFF)), 14);
            by3 = com.aspose.imaging.internal.dO.d.e((Object)by3, 6) > com.aspose.imaging.internal.dO.d.e((Object)by2, 6) ? (byte)-1 : 0;
            nArray[i2] = n2 & 0xFF000000 | com.aspose.imaging.internal.dO.d.e((Object)by3, 6) << 16 | com.aspose.imaging.internal.dO.d.e((Object)by3, 6) << 8 | com.aspose.imaging.internal.dO.d.e((Object)by3, 6);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(b b2) {
        this.verifyNotDisposed();
        int n2 = 0;
        IGenericEnumerator iGenericEnumerator = this.f.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                IGifBlock iGifBlock = (IGifBlock)iGenericEnumerator.next();
                GifFrameBlock gifFrameBlock = (GifFrameBlock)((Object)com.aspose.imaging.internal.dO.d.a(iGifBlock, GifFrameBlock.class));
                if (gifFrameBlock == null) continue;
                try {
                    IColorPalette iColorPalette;
                    int[] nArray;
                    if (gifFrameBlock.getPalette() != null) {
                        nArray = gifFrameBlock.getPalette().getArgb32Entries();
                        iColorPalette = gifFrameBlock.getPalette();
                    } else {
                        nArray = this.getPalette().getArgb32Entries();
                        iColorPalette = this.getPalette();
                    }
                    if (b2 != null) {
                        int[][] nArrayArray = new int[][]{nArray};
                        b2.a((int[][])nArrayArray, iColorPalette);
                        nArray = nArrayArray[0];
                    }
                    if (gifFrameBlock.getPalette() != null) {
                        gifFrameBlock.setPalette(new ColorPalette(nArray));
                    } else {
                        this.setPalette(new ColorPalette(nArray));
                    }
                }
                catch (RuntimeException runtimeException) {
                    throw new ImageException(aY.a(new String[]{"Can't make image grayscale. Frame index: ", ay.b(n2)}), runtimeException);
                }
                ++n2;
            }
        }
        finally {
            if (com.aspose.imaging.internal.dO.d.b((Object)iGenericEnumerator, at.class)) {
                ((at)iGenericEnumerator).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void saveData(Stream stream) {
        this.verifyNotDisposed();
        this.updateMetadata();
        StreamContainer streamContainer = new StreamContainer(stream);
        try {
            this.e.a(streamContainer);
            if (this.getPalette() != null) {
                com.aspose.imaging.internal.eV.c.a(streamContainer, this.getPalette());
            }
            this.f();
            IGenericEnumerator iGenericEnumerator = this.f.iterator();
            try {
                while (iGenericEnumerator.hasNext()) {
                    IGifBlock iGifBlock = (IGifBlock)iGenericEnumerator.next();
                    iGifBlock.a(streamContainer.a());
                }
            }
            finally {
                if (com.aspose.imaging.internal.dO.d.b((Object)iGenericEnumerator, at.class)) {
                    ((at)iGenericEnumerator).dispose();
                }
            }
            if (this.h) {
                streamContainer.writeByte((byte)59);
            }
            streamContainer.setLength(streamContainer.getPosition());
        }
        finally {
            if (streamContainer != null) {
                streamContainer.dispose();
            }
        }
    }

    @Override
    protected void savePixelsInternal(Rectangle rectangle, int[] pixels) {
        if (this.g == null) {
            throw new GifImageException("Cannot save pixels as no active GIF frame exists. Select an active frame first.");
        }
        this.g.saveArgb32Pixels(rectangle.Clone(), pixels);
    }

    @Override
    protected void onPaletteChanging(IColorPalette oldPalette, IColorPalette newPalette) {
        if (newPalette != null && newPalette.getEntriesCount() != 2 && newPalette.getEntriesCount() != 4 && newPalette.getEntriesCount() != 8 && newPalette.getEntriesCount() != 16 && newPalette.getEntriesCount() != 32 && newPalette.getEntriesCount() != 64 && newPalette.getEntriesCount() != 128 && newPalette.getEntriesCount() != 256) {
            throw new GifImageException("The color palette cannot be changed as palette specified should contain entries count equal to power of 2. Minimal palette size is 2, maximal is 256.");
        }
        super.onPaletteChanging(oldPalette, newPalette);
    }

    @Override
    protected void onPaletteChanged(IColorPalette oldPalette, IColorPalette newPalette) {
        this.e.a(newPalette != null);
        if (newPalette != null) {
            this.e.c(newPalette.getEntriesCount());
        }
        super.onPaletteChanged(oldPalette, newPalette);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void releaseManagedResources() {
        IGenericEnumerator iGenericEnumerator = this.f.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                IGifBlock iGifBlock = (IGifBlock)iGenericEnumerator.next();
                at at2 = (at)((Object)com.aspose.imaging.internal.dO.d.a(iGifBlock, at.class));
                if (at2 == null) continue;
                at2.dispose();
            }
        }
        finally {
            if (com.aspose.imaging.internal.dO.d.b((Object)iGenericEnumerator, at.class)) {
                ((at)iGenericEnumerator).dispose();
            }
        }
        this.f.clear();
        this.g = null;
        super.releaseManagedResources();
    }

    public static GifImage a(com.aspose.imaging.internal.eV.b b2, IGifBlock[] iGifBlockArray, IColorPalette iColorPalette, boolean bl2, GifFrameBlock gifFrameBlock) {
        return new GifImage(b2, iGifBlockArray, iColorPalette, bl2, gifFrameBlock);
    }

    private int[] a(IColorPalette iColorPalette, IColorPalette iColorPalette2, int[] nArray) {
        byte[] byArray = new byte[nArray.length];
        int[] nArray2 = new int[nArray.length];
        int n2 = -1;
        aV aV2 = new aV(iColorPalette);
        for (int n3 : nArray) {
            byte by2;
            byArray[++n2] = by2 = (byte)aV2.getNearestColorIndex(n3);
        }
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray2[i2] = iColorPalette2.getArgb32Entries()[com.aspose.imaging.internal.dO.d.e((Object)byArray[i2], 6)];
        }
        return nArray2;
    }

    static /* synthetic */ void access$100(GifImage x0, int[] x1, byte x2) {
        x0.a(x1, x2);
    }

    private static class a
    implements IRasterImageArgb32PixelLoader {
        private final GifImage a;

        public a(GifImage gifImage) {
            this.a = gifImage;
        }

        @Override
        public boolean isRawDataAvailable() {
            return this.a.g.isRawDataAvailable();
        }

        @Override
        public RawDataSettings getRawDataSettings() {
            return this.a.g.getRawDataSettings();
        }

        @Override
        public void loadPartialArgb32Pixels(Rectangle rectangle, IPartialArgb32PixelLoader partialLoader) {
            if (this.a.g == null) {
                throw new GifImageException("Cannot load pixels as no active GIF frame exists. Select an active frame first.");
            }
            this.a.g.loadPartialArgb32Pixels(rectangle.Clone(), partialLoader);
        }

        @Override
        public void loadRawData(Rectangle rectangle, RawDataSettings rawDataSettings, IPartialRawDataLoader rawDataLoader) {
            this.a.g.loadRawData(rectangle.Clone(), rawDataSettings, rawDataLoader);
        }
    }

    static abstract class b
    extends MulticastDelegate {
        b() {
        }

        public abstract void a(int[][] var1, IColorPalette var2);

        public final ap a(int[][] nArray, IColorPalette iColorPalette, n n2, Object object) {
            return com.aspose.imaging.internal.cO.a.a(new g(this, this, n2, object, nArray, iColorPalette));
        }

        public final void a(int[][] nArray, ap ap2) {
            com.aspose.imaging.internal.cO.a.a(this, ap2);
            nArray[0] = ((int[][])this.peekOutRefParam(0))[0];
        }

        static /* synthetic */ void a(b b2, Object[] objectArray) {
            b2.pushOutRefParams(objectArray);
        }
    }
}

