/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.fileformats.gif.blocks;

import com.aspose.imaging.Color;
import com.aspose.imaging.DisposableObject;
import com.aspose.imaging.IAdvancedBufferProcessor;
import com.aspose.imaging.IColorPalette;
import com.aspose.imaging.IPartialArgb32PixelLoader;
import com.aspose.imaging.IPartialRawDataLoader;
import com.aspose.imaging.LoadOptions;
import com.aspose.imaging.Point;
import com.aspose.imaging.RasterCachedImage;
import com.aspose.imaging.RasterImage;
import com.aspose.imaging.Rectangle;
import com.aspose.imaging.StreamContainer;
import com.aspose.imaging.coreexceptions.FrameworkException;
import com.aspose.imaging.coreexceptions.imageformats.GifImageException;
import com.aspose.imaging.fileformats.gif.GifImage;
import com.aspose.imaging.fileformats.gif.IGifBlock;
import com.aspose.imaging.fileformats.gif.blocks.GifGraphicsControlBlock;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.Exceptions.NotImplementedException;
import com.aspose.imaging.internal.ap.bF;
import com.aspose.imaging.internal.ap.v;
import com.aspose.imaging.internal.dO.d;
import com.aspose.imaging.internal.dP.Z;
import com.aspose.imaging.internal.dP.aE;
import com.aspose.imaging.internal.dP.aM;
import com.aspose.imaging.internal.dP.aV;
import com.aspose.imaging.internal.dP.az;
import com.aspose.imaging.internal.dP.l;
import com.aspose.imaging.internal.dS.m;
import com.aspose.imaging.internal.eV.c;
import com.aspose.imaging.system.io.Stream;
import java.io.InputStream;

public final class GifFrameBlock
extends RasterCachedImage
implements IGifBlock {
    public static final int EXTENSION_LABEL = 44;
    public static final int IMAGE_DESCRIPTOR_SIZE = 10;
    private byte e;
    private int f;
    private int g;
    private int h;
    private int i;
    private byte j;

    public GifFrameBlock(int width, int height) {
        this(0, 0, width, height);
    }

    public GifFrameBlock(int left, int top, int width, int height) {
        this(null, left, top, width, height, null, false, false, 8);
    }

    public GifFrameBlock(int left, int top, int width, int height, IColorPalette colorPalette, boolean isPaletteSorted, boolean isGifFrameInterlaced, byte bitsPerPixel) {
        this(null, left, top, width, height, colorPalette, isPaletteSorted, isGifFrameInterlaced, bitsPerPixel);
    }

    public GifFrameBlock(RasterImage image) {
        this(image, 0, 0, false, false, 8);
    }

    public GifFrameBlock(RasterImage image, int left, int top) {
        this(image, left, top, false, false, 8);
    }

    public GifFrameBlock(RasterImage image, int left, int top, boolean isPaletteSorted, boolean isGifFrameInterlaced, byte lzwCodeSize) {
        if (image == null) {
            throw new ArgumentNullException("image");
        }
        this.a(new aM(image), left, top, isPaletteSorted, isGifFrameInterlaced, lzwCodeSize);
    }

    public GifFrameBlock(InputStream stream) {
        this(Stream.fromJava(stream));
    }

    public GifFrameBlock(Stream stream) {
        this(stream, 0, 0, false, false, 8);
    }

    public GifFrameBlock(InputStream stream, int left, int top) {
        this(Stream.fromJava(stream), left, top);
    }

    GifFrameBlock(Stream stream, int left, int top) {
        this(stream, left, top, false, false, 8);
    }

    public GifFrameBlock(InputStream stream, int left, int top, boolean isPaletteSorted, boolean isGifFrameInterlaced, byte lzwCodeSize) {
        this(Stream.fromJava(stream), left, top, isPaletteSorted, isGifFrameInterlaced, lzwCodeSize);
    }

    GifFrameBlock(Stream stream, int left, int top, boolean isPaletteSorted, boolean isGifFrameInterlaced, byte lzwCodeSize) {
        if (stream == null) {
            throw new ArgumentNullException("stream");
        }
        this.a(new aM(stream), left, top, isPaletteSorted, isGifFrameInterlaced, lzwCodeSize);
    }

    public GifFrameBlock(String path) {
        this(path, 0, 0, false, false, 8);
    }

    public GifFrameBlock(String path, int left, int top) {
        this(path, left, top, false, false, 8);
    }

    public GifFrameBlock(String path, int left, int top, boolean isPaletteSorted, boolean isGifFrameInterlaced, byte lzwCodeSize) {
        if (path == null) {
            throw new ArgumentNullException("path");
        }
        this.a(new aM(path), left, top, isPaletteSorted, isGifFrameInterlaced, lzwCodeSize);
    }

    private GifFrameBlock(com.aspose.imaging.internal.eV.a dataReader, int left, int top, int width, int height, IColorPalette colorPalette, boolean isPaletteSorted, boolean isGifFrameInterlaced, byte lzwCodeSize) {
        super(colorPalette);
        this.a(colorPalette, left, top, com.aspose.imaging.internal.dO.d.e((Object)width, 8), com.aspose.imaging.internal.dO.d.e((Object)height, 8), isPaletteSorted, isGifFrameInterlaced, lzwCodeSize);
        if (dataReader != null) {
            this.setDataLoader(dataReader);
            dataReader.a(this);
        }
    }

    @Override
    public int getWidth() {
        return this.f;
    }

    @Override
    public int getHeight() {
        return this.g;
    }

    @Override
    public int getBitsPerPixel() {
        this.verifyNotDisposed();
        return com.aspose.imaging.internal.dO.d.e((Object)this.e, 6);
    }

    public boolean getInterlaced() {
        this.verifyNotDisposed();
        return (com.aspose.imaging.internal.dO.d.e((Object)this.j, 6) & 0x40) != 0;
    }

    public void setInterlaced(boolean value) {
        this.verifyNotDisposed();
        byte by2 = this.j;
        by2 = value ? (byte)(com.aspose.imaging.internal.dO.d.e((Object)by2, 6) | 0x40) : (byte)(com.aspose.imaging.internal.dO.d.e((Object)by2, 6) & 0xBF);
        this.j = by2;
    }

    public boolean isPaletteSorted() {
        this.verifyNotDisposed();
        return (com.aspose.imaging.internal.dO.d.e((Object)this.j, 6) & 0x20) != 0;
    }

    public void setPaletteSorted(boolean value) {
        this.verifyNotDisposed();
        byte by2 = this.j;
        by2 = value ? (byte)(com.aspose.imaging.internal.dO.d.e((Object)by2, 6) | 0x20) : (byte)(com.aspose.imaging.internal.dO.d.e((Object)by2, 6) & 0xDF);
        this.j = by2;
    }

    public byte getGifFrameBitsPerPixel() {
        this.verifyNotDisposed();
        return this.e;
    }

    public void setGifFrameBitsPerPixel(byte value) {
        this.verifyNotDisposed();
        if (com.aspose.imaging.internal.dO.d.e((Object)value, 6) > 8) {
            throw new ArgumentOutOfRangeException("value", "Too big bits per pixel. The maximal allowed is 8 bits.");
        }
        if (com.aspose.imaging.internal.dO.d.e((Object)value, 6) < 2) {
            throw new ArgumentOutOfRangeException("value", "Too small bits per pixel. The minimal allowed is 2 bits.");
        }
        this.e = value;
    }

    public int getLeft() {
        this.verifyNotDisposed();
        return this.h;
    }

    public void setLeft(int value) {
        this.verifyNotDisposed();
        this.h = value;
    }

    public int getTop() {
        this.verifyNotDisposed();
        return this.i;
    }

    public void setTop(int value) {
        this.verifyNotDisposed();
        this.i = value;
    }

    public byte getFlags() {
        this.verifyNotDisposed();
        return this.j;
    }

    public void setFlags(byte value) {
        this.verifyNotDisposed();
        if (com.aspose.imaging.internal.dO.d.e((Object)this.j, 6) != com.aspose.imaging.internal.dO.d.e((Object)value, 6)) {
            if ((com.aspose.imaging.internal.dO.d.e((Object)value, 6) & 0x80) > 0 && this.getPalette() == null) {
                throw new ArgumentOutOfRangeException("value", "The flags are incorrect since palette is not present but flags indicate it is.");
            }
            if ((com.aspose.imaging.internal.dO.d.e((Object)value, 6) & 0x80) == 0 && this.getPalette() != null) {
                throw new ArgumentOutOfRangeException("value", "The flags are incorrect since palette is present but flags indicate it is not.");
            }
            if (this.getPalette() != null && this.getPalette().getEntriesCount() != 2 << (com.aspose.imaging.internal.dO.d.e((Object)value, 6) & 7)) {
                throw new ArgumentOutOfRangeException("value", "The flags are incorrect since palette entries count do not correspond to flags entries count.");
            }
            this.j = value;
        }
    }

    public GifGraphicsControlBlock getControlBlock() {
        GifGraphicsControlBlock gifGraphicsControlBlock = null;
        if (com.aspose.imaging.internal.dO.d.b((Object)this.getContainer(), GifImage.class)) {
            IGifBlock[] iGifBlockArray = ((GifImage)((Object)com.aspose.imaging.internal.dO.d.a(this.getContainer(), GifImage.class))).getBlocks();
            for (int i2 = 0; i2 < iGifBlockArray.length; ++i2) {
                IGifBlock iGifBlock;
                if (iGifBlockArray[i2] != this) continue;
                if (i2 <= 0 || !com.aspose.imaging.internal.dO.d.b((Object)(iGifBlock = iGifBlockArray[i2 - 1]), GifGraphicsControlBlock.class)) break;
                gifGraphicsControlBlock = (GifGraphicsControlBlock)iGifBlock;
                break;
            }
        }
        return gifGraphicsControlBlock;
    }

    @Override
    public boolean hasTransparentColor() {
        GifGraphicsControlBlock gifGraphicsControlBlock = this.getControlBlock();
        if (gifGraphicsControlBlock == null) {
            return false;
        }
        return gifGraphicsControlBlock.hasTransparentColor();
    }

    @Override
    public void setTransparentColor(boolean value) {
        if (this.getControlBlock() != null) {
            this.getControlBlock().setTransparentColor(value);
        } else if (com.aspose.imaging.internal.dO.d.b((Object)this.getContainer(), GifImage.class)) {
            IGifBlock[] iGifBlockArray = ((GifImage)((Object)com.aspose.imaging.internal.dO.d.a(this.getContainer(), GifImage.class))).getBlocks();
            for (int i2 = 0; i2 < iGifBlockArray.length; ++i2) {
                if (iGifBlockArray[i2] != this) continue;
                GifImage gifImage = (GifImage)((Object)com.aspose.imaging.internal.dO.d.a(this.getContainer(), GifImage.class));
                GifGraphicsControlBlock gifGraphicsControlBlock = new GifGraphicsControlBlock();
                gifGraphicsControlBlock.setTransparentColor(value);
                gifImage.insertBlock(i2, gifGraphicsControlBlock);
            }
        } else {
            throw new FrameworkException("The block does not belong to any image and transparent color could not be set.");
        }
    }

    @Override
    public Color getTransparentColor() {
        GifGraphicsControlBlock gifGraphicsControlBlock = this.getControlBlock();
        if (gifGraphicsControlBlock == null) {
            return Color.getEmpty();
        }
        IColorPalette iColorPalette = this.h();
        if (iColorPalette != null && com.aspose.imaging.internal.dO.d.e((Object)gifGraphicsControlBlock.getTransparentColorIndex(), 6) < iColorPalette.getEntriesCount()) {
            return Color.fromArgb(iColorPalette.getArgb32Color(com.aspose.imaging.internal.dO.d.e((Object)gifGraphicsControlBlock.getTransparentColorIndex(), 6)));
        }
        return Color.getEmpty();
    }

    @Override
    public void setTransparentColor(Color value) {
        GifGraphicsControlBlock gifGraphicsControlBlock = this.getControlBlock();
        IColorPalette iColorPalette = this.h();
        int n2 = value.toArgb();
        if (gifGraphicsControlBlock == null) {
            if (com.aspose.imaging.internal.dO.d.b((Object)this.getContainer(), GifImage.class)) {
                IGifBlock[] iGifBlockArray = ((GifImage)((Object)com.aspose.imaging.internal.dO.d.a(this.getContainer(), GifImage.class))).getBlocks();
                for (int i2 = 0; i2 < iGifBlockArray.length; ++i2) {
                    if (iGifBlockArray[i2] != this) continue;
                    GifImage gifImage = (GifImage)((Object)com.aspose.imaging.internal.dO.d.a(this.getContainer(), GifImage.class));
                    GifGraphicsControlBlock gifGraphicsControlBlock2 = new GifGraphicsControlBlock();
                    gifGraphicsControlBlock2.setTransparentColorIndex((byte)iColorPalette.getNearestColorIndex(n2));
                    gifGraphicsControlBlock2.setTransparentColor(true);
                    gifImage.insertBlock(i2, gifGraphicsControlBlock2);
                    return;
                }
            } else {
                throw new FrameworkException("The block does not belong to any image and transparent color could not be set.");
            }
        }
        if (iColorPalette != null) {
            gifGraphicsControlBlock.setTransparentColorIndex((byte)iColorPalette.getNearestColorIndex(n2));
        }
    }

    public static IColorPalette getColorPalette(IColorPalette framePalette, IColorPalette containerPalette) {
        IColorPalette iColorPalette = null;
        if (framePalette != null) {
            iColorPalette = framePalette;
        } else if (containerPalette != null) {
            iColorPalette = containerPalette;
        }
        if (iColorPalette == null) {
            throw new GifImageException("Cannot work with GIF frame pixels since palette is not present neither in GIF image nor in GIF frame. Tip: setup color palette first.");
        }
        return iColorPalette;
    }

    public static byte createFlags(IColorPalette colorPalette, boolean isPaletteSorted, boolean isGifFrameInterlaced) {
        byte by2 = 0;
        if (colorPalette != null) {
            if (colorPalette.getEntriesCount() == 1) {
                throw new ArgumentOutOfRangeException("colorPalette", "The color palette must contain entries count equal to the power of 2. Minimal entries count are 2 and maximal 256.");
            }
            byte by3 = 0;
            int n2 = colorPalette.getEntriesCount();
            while (n2 > 2) {
                if ((n2 & 1) == 1) {
                    throw new ArgumentOutOfRangeException("colorPalette", "The color palette must contain entries count equal to the power of 2. Minimal entries count are 2 and maximal 256.");
                }
                n2 >>= 1;
                by3 = (byte)(by3 + 1);
            }
            by2 = (byte)(com.aspose.imaging.internal.dO.d.e((Object)by2, 6) | com.aspose.imaging.internal.dO.d.e((Object)by3, 6));
            by2 = (byte)(com.aspose.imaging.internal.dO.d.e((Object)by2, 6) | 0x80);
        }
        if (isPaletteSorted) {
            by2 = (byte)(com.aspose.imaging.internal.dO.d.e((Object)by2, 6) | 0x20);
        }
        if (isGifFrameInterlaced) {
            by2 = (byte)(com.aspose.imaging.internal.dO.d.e((Object)by2, 6) | 0x40);
        }
        return by2;
    }

    public static GifFrameBlock a(com.aspose.imaging.internal.eV.a a2, int n2, int n3, int n4, int n5, IColorPalette iColorPalette, boolean bl2, boolean bl3, byte by2) {
        return new GifFrameBlock(a2, n2, n3, n4, n5, iColorPalette, bl2, bl3, by2);
    }

    public static void a(StreamContainer streamContainer, Rectangle rectangle, byte by2) {
        streamContainer.writeByte((byte)44);
        streamContainer.write(v.a(com.aspose.imaging.internal.dO.d.d((Object)rectangle.getLeft(), 9)));
        streamContainer.write(v.a(com.aspose.imaging.internal.dO.d.d((Object)rectangle.getTop(), 9)));
        streamContainer.write(v.a(com.aspose.imaging.internal.dO.d.d((Object)rectangle.getWidth(), 9)));
        streamContainer.write(v.a(com.aspose.imaging.internal.dO.d.d((Object)rectangle.getHeight(), 9)));
        streamContainer.writeByte(by2);
    }

    public static void a(RasterImage rasterImage, StreamContainer streamContainer, IColorPalette iColorPalette, byte by2, boolean bl2, Rectangle rectangle) {
        if (iColorPalette == null) {
            throw new ArgumentNullException("palette");
        }
        streamContainer.writeByte(by2);
        GifFrameBlock.b(rasterImage, streamContainer, iColorPalette, by2, bl2, rectangle.Clone());
    }

    @Override
    public void b(Stream stream) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void saveData(Stream stream) {
        this.verifyNotDisposed();
        StreamContainer streamContainer = new StreamContainer(stream);
        try {
            GifFrameBlock.a(streamContainer, new Rectangle(com.aspose.imaging.internal.dO.d.e((Object)this.h, 8), com.aspose.imaging.internal.dO.d.e((Object)this.i, 8), this.f, this.g), this.j);
            IColorPalette iColorPalette = this.getPalette();
            if (iColorPalette != null) {
                com.aspose.imaging.internal.eV.c.a(streamContainer, iColorPalette);
            }
            GifFrameBlock.a(this, streamContainer, this.h(), this.e, this.getInterlaced(), this.getBounds().Clone());
        }
        finally {
            if (streamContainer != null) {
                streamContainer.dispose();
            }
        }
    }

    @Override
    protected void updateDimensions(int newWidth, int newHeight) {
        this.f = newWidth;
        this.g = newHeight;
    }

    @Override
    protected void onPaletteChanged(IColorPalette oldPalette, IColorPalette newPalette) {
        this.j = GifFrameBlock.createFlags(newPalette, (com.aspose.imaging.internal.dO.d.e((Object)this.j, 6) & 0x20) > 0, (com.aspose.imaging.internal.dO.d.e((Object)this.j, 6) & 0x40) > 0);
        super.onPaletteChanged(oldPalette, newPalette);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void b(RasterImage rasterImage, StreamContainer streamContainer, IColorPalette iColorPalette, byte by2, boolean bl2, Rectangle rectangle) {
        a a2 = new a(rasterImage, streamContainer, iColorPalette, com.aspose.imaging.internal.dO.d.e((Object)by2, 6), rectangle.Clone());
        try {
            Rectangle rectangle2 = Rectangle.intersect(rasterImage.getBounds().Clone(), rectangle.Clone()).Clone();
            if (rectangle2.getWidth() > 0 && rectangle2.getHeight() > 0) {
                if (bl2) {
                    aE.a(rectangle2.Clone(), rasterImage.getWidth(), rasterImage.getHeight(), a2);
                } else {
                    aE.a(rectangle2.Clone(), a2);
                }
            }
            a2.a(true);
        }
        finally {
            if (a2 != null) {
                a2.dispose();
            }
        }
    }

    private IColorPalette h() {
        IColorPalette iColorPalette = null;
        if (this.getContainer() != null) {
            iColorPalette = this.getContainer().getPalette();
        }
        return GifFrameBlock.getColorPalette(this.getPalette(), iColorPalette);
    }

    private void a(IColorPalette iColorPalette, int n2, int n3, int n4, int n5, boolean bl2, boolean bl3, byte by2) {
        this.j = GifFrameBlock.createFlags(iColorPalette, bl2, bl3);
        this.h = n2;
        this.i = n3;
        this.e = com.aspose.imaging.internal.dO.d.e((Object)by2, 6) > 8 ? (byte)8 : (com.aspose.imaging.internal.dO.d.e((Object)by2, 6) < 2 ? (byte)2 : by2);
        this.f = n4;
        this.g = n5;
    }

    private void a(aM aM2, int n2, int n3, boolean bl2, boolean bl3, byte by2) {
        try {
            this.a(aM2.a().getPalette(), n2, n3, aM2.a().getWidth(), aM2.a().getHeight(), bl2, bl3, by2);
            this.setPalette(aM2.a().getPalette());
            this.setDataLoader(aM2);
        }
        catch (RuntimeException runtimeException) {
            aM2.dispose();
            throw runtimeException;
        }
    }

    private static class a
    extends DisposableObject
    implements IAdvancedBufferProcessor,
    IPartialArgb32PixelLoader,
    IPartialRawDataLoader,
    Z {
        private final StreamContainer a;
        private final IColorPalette b;
        private final aV c;
        private final m d;
        private final Rectangle e = new Rectangle();
        private final byte[] f;
        private final RasterImage g;
        private int h;
        private int i;
        private az j = null;

        public a(RasterImage rasterImage, StreamContainer streamContainer, IColorPalette iColorPalette, int n2, Rectangle rectangle) {
            this.g = rasterImage;
            this.b = iColorPalette;
            this.c = new aV(iColorPalette);
            this.a = new StreamContainer(streamContainer.a());
            this.a.seekBegin();
            this.d = new m(this, n2);
            this.d.e();
            rectangle.CloneTo(this.e);
            this.i = rectangle.getWidth() * rectangle.getHeight();
            this.f = l.a((long)(rectangle.getWidth() * rectangle.getHeight()));
            this.j = new az(this.g.getBounds().Clone(), this.e.Clone(), this, true);
        }

        @Override
        public void process(Rectangle pixelsRectangle, int[] pixels, Point start, Point end) {
            int n2 = bF.d(this.f.length - this.h, pixels.length);
            int n3 = 0;
            int n4 = -1;
            GifFrameBlock gifFrameBlock = (GifFrameBlock)((Object)com.aspose.imaging.internal.dO.d.a(this.g, GifFrameBlock.class));
            if (gifFrameBlock != null && gifFrameBlock.getControlBlock() != null) {
                n4 = com.aspose.imaging.internal.dO.d.e((Object)gifFrameBlock.getControlBlock().getTransparentColorIndex(), 6);
            }
            do {
                for (int i2 = 0; i2 < n2; ++i2) {
                    int n5;
                    this.f[this.h++] = (n5 = pixels[n3++]) == 0 && n4 != -1 ? (byte)n4 : (byte)this.c.getNearestColorIndex(n5);
                }
                if (this.f.length - this.h != 0) continue;
                this.d.a(this.f, this.h);
                this.h = 0;
            } while ((n2 = bF.d(this.f.length - this.h, pixels.length - n3)) > 0);
            this.i -= pixels.length;
            if (this.i == 0) {
                this.a(false);
            }
        }

        @Override
        public void process(Rectangle rectangle, byte[] data, Point start, Point end) {
            this.d.a(data, data.length);
            this.i -= data.length;
            if (this.i == 0) {
                this.d.a(this.e.getHeight());
            }
        }

        @Override
        public void process(Rectangle rectangle, byte[] data, Point start, Point end, LoadOptions loadOptions) {
            throw new NotImplementedException();
        }

        @Override
        public void processBuffer(byte[] buffer, int bufferLength) {
            this.a.write(buffer, 0, bufferLength);
        }

        @Override
        public void finishRow() {
        }

        @Override
        public void finishRows(int rowsCount) {
        }

        @Override
        public void a(Rectangle rectangle) {
            this.g.loadPartialArgb32Pixels(rectangle.Clone(), this.j);
        }

        public void a(boolean bl2) {
            if (!bl2 || bl2 && this.i > 0) {
                this.j.a();
                this.d.a(this.f, this.h);
                this.d.a(this.e.getHeight());
            }
        }

        @Override
        protected void releaseManagedResources() {
            this.a.dispose();
            super.releaseManagedResources();
        }
    }
}

