/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.fileformats.gif.blocks;

import com.aspose.imaging.fileformats.gif.GifBlock;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.ap.v;
import com.aspose.imaging.system.io.Stream;

public class GifGraphicsControlBlock
extends GifBlock {
    public static final int BLOCK_HEADER_SIZE = 8;
    public static final byte EXTENSION_LABEL = -7;
    public static final byte SUB_BLOCK_SIZE = 4;
    private int a;
    private byte b;
    private byte c;

    public GifGraphicsControlBlock() {
    }

    public GifGraphicsControlBlock(byte flags, int delayTime, byte transparentColorIndex) {
        this.b = flags;
        this.a = delayTime;
        this.c = transparentColorIndex;
    }

    public GifGraphicsControlBlock(int delayTime, boolean hasTransparentColor, byte transparentColorIndex, boolean requiresUserInput, int disposalMethod) {
        this.b = GifGraphicsControlBlock.createFlags(hasTransparentColor, requiresUserInput, disposalMethod);
        this.a = delayTime;
        this.c = transparentColorIndex;
    }

    public int getDelayTime() {
        return this.a;
    }

    public void setDelayTime(int value) {
        if (this.a != value) {
            this.a = value;
            this.setChanged(true);
        }
    }

    public byte getFlags() {
        return this.b;
    }

    public void setFlags(byte value) {
        if ((this.b & 0xFF) != (value & 0xFF)) {
            this.b = value;
            this.setChanged(true);
        }
    }

    public byte getTransparentColorIndex() {
        return this.c;
    }

    public void setTransparentColorIndex(byte value) {
        if ((value & 0xFF) != (this.c & 0xFF)) {
            this.c = value;
            this.setChanged(true);
        }
    }

    public int getDisposalMethod() {
        return (this.b & 0xFF & 0x1C) >> 2;
    }

    public void setDisposalMethod(int value) {
        int n2 = value;
        if (n2 > 7) {
            throw new ArgumentOutOfRangeException("value", "The value must be between 0 and 7");
        }
        this.b = (byte)(this.b & 0xFF & 0xE3);
        int n3 = this.b & 0xFF;
        if (this.b != (byte)(n3 |= n2 << 2)) {
            this.b = (byte)n3;
            this.setChanged(true);
        }
    }

    public boolean getUserInputExpected() {
        int n2 = this.b & 0xFF & 2;
        return n2 > 0;
    }

    public void setUserInputExpected(boolean value) {
        byte by2 = this.b;
        by2 = value ? (byte)(by2 & 0xFF | 2) : (byte)(by2 & 0xFF & 0xFD);
        if ((this.b & 0xFF) != (by2 & 0xFF)) {
            this.b = by2;
            this.setChanged(true);
        }
    }

    public boolean hasTransparentColor() {
        int n2 = this.b & 0xFF & 1;
        return n2 > 0;
    }

    public void setTransparentColor(boolean value) {
        byte by2 = this.b;
        by2 = value ? (byte)(by2 & 0xFF | 1) : (byte)(by2 & 0xFF & 0xFE);
        if ((this.b & 0xFF) != (by2 & 0xFF)) {
            this.b = by2;
            this.setChanged(true);
        }
    }

    public static byte createFlags(boolean hasTransparentColor, boolean requiresUserInput, int disposalMethod) {
        byte by2;
        byte by3 = 0;
        if (hasTransparentColor) {
            by3 = 1;
        }
        if (requiresUserInput) {
            by3 = (byte)(by3 & 0xFF | 2);
        }
        if (((by2 = (byte)disposalMethod) & 0xFF) > 7) {
            throw new ArgumentOutOfRangeException("disposalMethod", "The disposal method value is not supported.");
        }
        by3 = (byte)(by3 & 0xFF | (byte)((by2 & 0xFF) << 2) & 0xFF);
        return by3;
    }

    @Override
    public void a(Stream stream) {
        if (stream == null) {
            throw new ArgumentNullException("stream");
        }
        stream.writeByte((byte)33);
        stream.writeByte((byte)-7);
        stream.writeByte((byte)4);
        stream.writeByte(this.b);
        byte[] byArray = v.a(this.a);
        stream.write(byArray, 0, byArray.length);
        stream.writeByte(this.c);
        stream.writeByte((byte)0);
    }
}

