/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.fileformats.jpeg;

import com.aspose.imaging.Color;
import com.aspose.imaging.IPartialArgb32PixelLoader;
import com.aspose.imaging.IRasterImageArgb32PixelLoader;
import com.aspose.imaging.Image;
import com.aspose.imaging.PixelDataFormat;
import com.aspose.imaging.RasterCachedImage;
import com.aspose.imaging.RasterImage;
import com.aspose.imaging.RawDataSettings;
import com.aspose.imaging.Rectangle;
import com.aspose.imaging.StreamContainer;
import com.aspose.imaging.coreexceptions.FrameworkException;
import com.aspose.imaging.coreexceptions.imageformats.JpegException;
import com.aspose.imaging.exif.JpegExifData;
import com.aspose.imaging.fileformats.jpeg.JFIFData;
import com.aspose.imaging.fileformats.jpeg.d;
import com.aspose.imaging.fileformats.tiff.TiffRational;
import com.aspose.imaging.fileformats.tiff.filemanagement.TiffBigEndianStreamWriter;
import com.aspose.imaging.imageoptions.JpegOptions;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.ap.S;
import com.aspose.imaging.internal.ap.aY;
import com.aspose.imaging.internal.ap.at;
import com.aspose.imaging.internal.ap.ay;
import com.aspose.imaging.internal.be.m;
import com.aspose.imaging.internal.dP.aA;
import com.aspose.imaging.internal.dP.aM;
import com.aspose.imaging.internal.dP.ad;
import com.aspose.imaging.internal.dP.az;
import com.aspose.imaging.internal.dP.bj;
import com.aspose.imaging.internal.dP.f;
import com.aspose.imaging.internal.eZ.a;
import com.aspose.imaging.internal.eZ.e;
import com.aspose.imaging.internal.eZ.i;
import com.aspose.imaging.internal.eZ.o;
import com.aspose.imaging.internal.eZ.w;
import com.aspose.imaging.internal.fd.b;
import com.aspose.imaging.internal.fg.c;
import com.aspose.imaging.sources.StreamSource;
import com.aspose.imaging.system.collections.Generic.IGenericEnumerator;
import com.aspose.imaging.system.collections.Generic.List;
import com.aspose.imaging.system.io.MemoryStream;
import com.aspose.imaging.system.io.Stream;
import com.aspose.imaging.xmp.XmpPacketWrapper;
import java.io.InputStream;
import java.util.Date;

public final class JpegImage
extends RasterCachedImage {
    private int e;
    private JpegOptions f;
    private int g;
    private boolean h;
    private StreamSource i;
    private StreamSource j;
    private List<Image> k = new List();

    public JpegImage(String path) {
        if (path == null) {
            throw new ArgumentNullException("path");
        }
        this.a(new aM(path));
    }

    public JpegImage(InputStream stream) {
        this(Stream.fromJava(stream));
    }

    JpegImage(Stream stream) {
        if (stream == null) {
            throw new ArgumentNullException("stream");
        }
        this.a(new aM(stream));
    }

    public JpegImage(RasterImage rasterImage) {
        if (rasterImage == null) {
            throw new ArgumentNullException("rasterImage");
        }
        this.a(new aM(rasterImage), rasterImage.getWidth(), rasterImage.getHeight());
    }

    public JpegImage(int width, int height) {
        this(new JpegOptions(), width, height);
    }

    public JpegImage(JpegOptions jpegOptions, int width, int height) {
        this.f = jpegOptions;
        this.g = width;
        this.e = height;
    }

    private JpegImage(int width, int height, int pixelFormat, IRasterImageArgb32PixelLoader jpegDataReader) {
        this.a(jpegDataReader, width, height);
        switch (pixelFormat) {
            case 0: {
                this.f.setColorType(0);
                break;
            }
            case 1: {
                this.f.setColorType(4);
                break;
            }
            case 3: {
                this.f.setColorType(1);
                break;
            }
            case 4: {
                this.f.setColorType(2);
                break;
            }
            case 5: {
                this.f.setColorType(3);
                break;
            }
            default: {
                throw new ArgumentOutOfRangeException("pixelFormat");
            }
        }
    }

    public JpegOptions getJpegOptions() {
        return this.f;
    }

    @Override
    public int getBitsPerPixel() {
        return 8 * this.getRawDataFormat().getChannelsCount();
    }

    public String getComment() {
        return this.f.getComment();
    }

    public void setComment(String value) {
        this.f.setComment(value);
    }

    public JpegExifData getExifData() {
        return this.f.getExifData();
    }

    public void setExifData(JpegExifData value) {
        if (this.f != null && this.f.getExifData() != null && this.f.getExifData().getThumbnail() != null) {
            this.k.addItem(this.f.getExifData().getThumbnail());
        }
        this.f.setExifData(value);
    }

    @Override
    public XmpPacketWrapper getXmpData() {
        return this.f.getXmpData();
    }

    @Override
    public void setXmpData(XmpPacketWrapper value) {
        this.f.setXmpData(value);
    }

    @Override
    public int getHeight() {
        return this.e;
    }

    @Override
    public double getHorizontalResolution() {
        if (this.getExifData() != null && this.getExifData().getXResolution() != null && this.getExifData().getYResolution() != null) {
            return this.getExifData().getXResolution().getValueD();
        }
        return this.getJfif() != null ? (double)this.getJfif().getXDensity() : 72.0;
    }

    @Override
    public void setHorizontalResolution(double value) {
        if (this.getExifData() == null) {
            this.setExifData(new JpegExifData());
        }
        this.getExifData().setResolutionUnit(2);
        this.getExifData().setXResolution(new TiffRational(com.aspose.imaging.internal.dO.d.f((Object)value, 14)));
        if (this.getJfif() == null) {
            this.setJfif(new JFIFData());
        }
        this.getJfif().setDensityUnits((byte)1);
        this.getJfif().setXDensity(com.aspose.imaging.internal.dO.d.c((Object)value, 14));
    }

    public JFIFData getJfif() {
        return this.f.getJfif();
    }

    public void setJfif(JFIFData value) {
        if (this.f != null && this.f.getJfif() != null && this.f.getJfif().getThumbnail() != null) {
            this.k.addItem(this.f.getJfif().getThumbnail());
        }
        this.f.setJfif(value);
    }

    @Override
    public PixelDataFormat getRawDataFormat() {
        return JpegImage.a(this.f.getColorType());
    }

    @Override
    public double getVerticalResolution() {
        if (this.getExifData() != null && this.getExifData().getXResolution() != null && this.getExifData().getYResolution() != null) {
            return this.getExifData().getYResolution().getValueD();
        }
        return this.getJfif() != null ? (double)this.getJfif().getYDensity() : 72.0;
    }

    @Override
    public void setVerticalResolution(double value) {
        if (this.getExifData() == null) {
            this.setExifData(new JpegExifData());
        }
        this.getExifData().setResolutionUnit(2);
        this.getExifData().setYResolution(new TiffRational(com.aspose.imaging.internal.dO.d.f((Object)value, 14)));
        if (this.getJfif() == null) {
            this.setJfif(new JFIFData());
        }
        this.getJfif().setDensityUnits((byte)1);
        this.getJfif().setYDensity(com.aspose.imaging.internal.dO.d.c((Object)value, 14));
    }

    @Override
    public int getWidth() {
        return this.g;
    }

    public StreamSource getRgbColorProfile() {
        return this.i;
    }

    public void setRgbColorProfile(StreamSource value) {
        this.i = value;
    }

    public StreamSource getCmykColorProfile() {
        return this.j;
    }

    public void setCmykColorProfile(StreamSource value) {
        this.j = value;
    }

    public StreamSource getDestinationRgbColorProfile() {
        return this.f.getRgbColorProfile();
    }

    public void setDestinationRgbColorProfile(StreamSource value) {
        this.f.setRgbColorProfile(value);
    }

    public StreamSource getDestinationCmykColorProfile() {
        return this.f.getCmykColorProfile();
    }

    public void setDestinationCmykColorProfile(StreamSource value) {
        this.f.setCmykColorProfile(value);
    }

    public boolean getIgnoreEmbeddedColorProfile() {
        return this.h;
    }

    public void setIgnoreEmbeddedColorProfile(boolean value) {
        this.setIgnoreEmbeddedColorProfile(value);
    }

    @Override
    public Date getModifyDate(boolean useDefault) {
        return S.d(this.e(useDefault));
    }

    @Override
    public S e(boolean bl2) {
        if (!bl2 && this.getExifData() != null && !aY.b(this.getExifData().getDateTime())) {
            String[] stringArray = aY.a(this.getExifData().getDateTime(), ' ');
            if (stringArray.length != 2) {
                throw new FrameworkException(aY.a("Can't parse Exif date {0}", new Object[]{this.getExifData().getDateTime()}));
            }
            String[] stringArray2 = aY.a(stringArray[0], ':');
            if (stringArray2.length != 3) {
                throw new FrameworkException(aY.a("Can't parse Exif date {0}", new Object[]{this.getExifData().getDateTime()}));
            }
            String[] stringArray3 = aY.a(stringArray[1], ':');
            if (stringArray3.length != 3) {
                throw new FrameworkException(aY.a("Can't parse Exif date {0}", new Object[]{this.getExifData().getDateTime()}));
            }
            return new S(ay.a(stringArray2[0]), ay.a(stringArray2[1]), ay.a(stringArray2[2]), ay.a(stringArray3[0]), ay.a(stringArray3[1]), ay.a(stringArray3[2]));
        }
        return super.e(bl2);
    }

    @Override
    public void setResolution(double dpiX, double dpiY) {
        this.setHorizontalResolution(dpiX);
        this.setVerticalResolution(dpiY);
    }

    public void autoRotate() {
        if (this.getExifData() != null) {
            switch (this.getExifData().getOrientation()) {
                case 1: {
                    break;
                }
                case 2: {
                    this.rotateFlip(4);
                    break;
                }
                case 3: {
                    this.rotateFlip(12);
                    break;
                }
                case 4: {
                    this.rotateFlip(8);
                    break;
                }
                case 5: {
                    this.rotateFlip(5);
                    break;
                }
                case 6: {
                    this.rotateFlip(1);
                    break;
                }
                case 7: {
                    this.rotateFlip(9);
                    break;
                }
                case 8: {
                    this.rotateFlip(13);
                    break;
                }
                default: {
                    throw new ArgumentOutOfRangeException();
                }
            }
            this.getExifData().setOrientation(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void releaseManagedResources() {
        if (this.getExifData() != null && this.getExifData().getThumbnail() != null) {
            this.k.addItem(this.getExifData().getThumbnail());
            this.getExifData().setThumbnail(null);
        }
        if (this.getJfif() != null && this.getJfif().getThumbnail() != null) {
            this.k.addItem(this.getJfif().getThumbnail());
            this.getJfif().setThumbnail(null);
        }
        IGenericEnumerator iGenericEnumerator = this.k.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                Image image = (Image)iGenericEnumerator.next();
                at at2 = (at)((Object)com.aspose.imaging.internal.dO.d.a(image, at.class));
                if (at2 == null) continue;
                at2.dispose();
            }
        }
        finally {
            if (com.aspose.imaging.internal.dO.d.b((Object)iGenericEnumerator, at.class)) {
                ((at)iGenericEnumerator).dispose();
            }
        }
        super.releaseManagedResources();
    }

    @Override
    protected void updateMetadata() {
        if (this.getUpdateXmpData()) {
            try {
                JpegExifData jpegExifData = this.getExifData();
                if (jpegExifData == null) {
                    jpegExifData = new JpegExifData();
                }
                JpegExifData jpegExifData2 = jpegExifData;
                S s2 = S.n().H();
                String string = aY.a("{0:D4}:{1:D2}:{2:D2} {3:D2}:{4:D2}:{5:D2}", com.aspose.imaging.internal.dO.d.a(s2.u()), com.aspose.imaging.internal.dO.d.a(s2.m()), com.aspose.imaging.internal.dO.d.a(s2.f()), com.aspose.imaging.internal.dO.d.a(s2.i()), com.aspose.imaging.internal.dO.d.a(s2.l()), com.aspose.imaging.internal.dO.d.a(s2.q()));
                jpegExifData2.setDateTime(string);
                this.setExifData(jpegExifData2);
            }
            catch (RuntimeException runtimeException) {
                com.aspose.imaging.internal.aw.a.d(aY.a(new String[]{"Exception on WaveletMap.Duplicate: ", runtimeException.toString()}));
            }
        }
        super.updateMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] a(JpegExifData jpegExifData) {
        byte[] byArray;
        byte[] byArray2 = jpegExifData.serializeExifData();
        if (byArray2.length > 65528) {
            throw new JpegException("Exif segment is excessively big to be stored in jpeg file. Consider JpegExifData.SerializeExifData() method for result data size estimation.");
        }
        StreamContainer streamContainer = new StreamContainer(new MemoryStream(), true);
        try {
            TiffBigEndianStreamWriter tiffBigEndianStreamWriter = new TiffBigEndianStreamWriter(streamContainer);
            byte[] byArray3 = new byte[]{-1, -31};
            tiffBigEndianStreamWriter.write(byArray3);
            tiffBigEndianStreamWriter.writeUShort(com.aspose.imaging.internal.dO.d.d((Object)(byArray2.length + 8), 9));
            byte[] byArray4 = new byte[]{69, 120, 105, 102, 0, 0};
            tiffBigEndianStreamWriter.write(byArray4);
            tiffBigEndianStreamWriter.write(byArray2);
            byArray = streamContainer.toBytes();
        }
        finally {
            if (streamContainer != null) {
                streamContainer.dispose();
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] a(XmpPacketWrapper xmpPacketWrapper) {
        byte[] byArray;
        int n2;
        int n3;
        if (xmpPacketWrapper == null) {
            throw new ArgumentNullException("xmpData");
        }
        String string = xmpPacketWrapper.b();
        byte[] byArray2 = m.y().c(string);
        int n4 = byArray2.length + 2 + (n3 = "http://ns.adobe.com/xap/1.0/".length() + 1);
        if (n4 > (n2 = com.aspose.imaging.internal.dO.d.e((Object)65535, 8) - 2 - n3)) {
            throw new JpegException(aY.a("XMP could not be grater than {0} bytes", new Object[]{com.aspose.imaging.internal.dO.d.a(n2)}));
        }
        int n5 = com.aspose.imaging.internal.dO.d.d((Object)n4, 9);
        String string2 = aY.a(new Object[]{"http://ns.adobe.com/xap/1.0/", com.aspose.imaging.internal.dO.d.a(Character.valueOf('\u0000'))});
        byte[] byArray3 = m.y().c(string2);
        StreamContainer streamContainer = new StreamContainer(new MemoryStream(), true);
        try {
            TiffBigEndianStreamWriter tiffBigEndianStreamWriter = new TiffBigEndianStreamWriter(streamContainer);
            byte[] byArray4 = new byte[]{-1, -31};
            tiffBigEndianStreamWriter.write(byArray4);
            tiffBigEndianStreamWriter.writeUShort(com.aspose.imaging.internal.dO.d.d((Object)n5, 8));
            tiffBigEndianStreamWriter.write(byArray3);
            tiffBigEndianStreamWriter.write(byArray2);
            byArray = streamContainer.toBytes();
        }
        finally {
            if (streamContainer != null) {
                streamContainer.dispose();
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void a(RasterImage rasterImage, Stream stream, JFIFData jFIFData, JpegExifData jpegExifData, XmpPacketWrapper xmpPacketWrapper, JpegOptions jpegOptions, Rectangle rectangle) {
        Object object;
        Object object2;
        w w2 = new w(stream);
        JpegImage.b(w2);
        if (jpegOptions.getResolutionSettings() != null) {
            if (jpegExifData != null) {
                jpegExifData.setXResolution(new TiffRational(com.aspose.imaging.internal.dO.d.f((Object)jpegOptions.getResolutionSettings().getHorizontalResolution(), 14), 1L));
                jpegExifData.setYResolution(new TiffRational(com.aspose.imaging.internal.dO.d.f((Object)jpegOptions.getResolutionSettings().getVerticalResolution(), 14), 1L));
                jpegExifData.setResolutionUnit(2);
            } else {
                if (jFIFData == null) {
                    jFIFData = new JFIFData();
                }
                jFIFData.setXDensity(com.aspose.imaging.internal.dO.d.c((Object)jpegOptions.getResolutionSettings().getHorizontalResolution(), 14));
                jFIFData.setYDensity(com.aspose.imaging.internal.dO.d.c((Object)jpegOptions.getResolutionSettings().getVerticalResolution(), 14));
            }
        }
        if (jFIFData != null) {
            JFIFData.write(jFIFData, w2);
        }
        JpegImage.a((StreamContainer)w2, jpegExifData);
        JpegImage.a((StreamContainer)w2, xmpPacketWrapper);
        if (jpegOptions != null && !aY.b(jpegOptions.getComment())) {
            JpegImage.a((StreamContainer)w2, jpegOptions.getComment());
        }
        if (jpegOptions.getColorType() == 3) {
            object = jpegOptions.getCmykColorProfile() != null ? jpegOptions.getCmykColorProfile().getStream() : ((object2 = (JpegImage)((Object)com.aspose.imaging.internal.dO.d.a(rasterImage, JpegImage.class))) != null && ((JpegImage)object2).getCmykColorProfile() != null ? ((JpegImage)object2).getCmykColorProfile().getStream() : ad.a().getStream());
            com.aspose.imaging.internal.eZ.i.a((Stream)object, stream);
            object2 = new a();
            ((a)object2).c(100);
            ((a)object2).a(0);
            ((a)object2).b(0);
            ((a)object2).a((byte)2);
            com.aspose.imaging.internal.eZ.a.a(stream, (a)object2);
            jpegOptions.setCmykColorProfile(new StreamSource((Stream)object));
            if (jpegOptions.getRgbColorProfile() == null) {
                jpegOptions.setRgbColorProfile(ad.b());
            }
        }
        if (jpegOptions.getColorType() == 4) {
            object = new a();
            ((a)object).c(100);
            ((a)object).a(0);
            ((a)object).b(0);
            ((a)object).a((byte)0);
            com.aspose.imaging.internal.eZ.a.a(stream, (a)object);
        }
        object = new RawDataSettings();
        object2 = JpegImage.a(jpegOptions.getColorType());
        Rectangle rectangle2 = new Rectangle(0, 0, rectangle.getWidth(), rectangle.getHeight());
        List<e[]> list = null;
        c c2 = null;
        int n2 = 2;
        boolean bl2 = true;
        while (bl2) {
            d d2;
            b b2;
            b b3 = b2 = new b(rectangle2.Clone(), jpegOptions, w2, (PixelDataFormat)object2, n2, list);
            try {
                d2 = new d(w2, jpegOptions, rectangle2.Clone(), (PixelDataFormat)object2, b3, n2, c2);
                ((RawDataSettings)object).setPixelDataFormat((PixelDataFormat)object2);
                Rectangle rectangle3 = Rectangle.intersect(rasterImage.getBounds().Clone(), rectangle.Clone()).Clone();
                if (rectangle3.getWidth() > 0 && rectangle3.getHeight() > 0) {
                    if (rasterImage.isRawDataAvailable() && ((RawDataSettings)object).getPixelDataFormat().getBitsPerPixel() == rasterImage.getRawDataFormat().getBitsPerPixel() && jpegOptions.getColorType() != 3) {
                        ((RawDataSettings)object).setColorPalette(null);
                        ((RawDataSettings)object).setCustomColorConverter(rasterImage.getRawCustomColorConverter());
                        ((RawDataSettings)object).setFallbackIndex(rasterImage.getRawFallbackIndex());
                        ((RawDataSettings)object).setIndexedColorConverter(rasterImage.getRawIndexedColorConverter());
                        ((RawDataSettings)object).setLineSize(rasterImage.getWidth() * ((RawDataSettings)object).getPixelDataFormat().getChannelsCount());
                        aA aA2 = new aA(rasterImage.getBounds().Clone(), rectangle.Clone(), d2);
                        rasterImage.loadRawData(rectangle3.Clone(), (RawDataSettings)object, aA2);
                    } else {
                        IPartialArgb32PixelLoader iPartialArgb32PixelLoader;
                        az az2;
                        o o2 = o.a(d2, jpegOptions);
                        IPartialArgb32PixelLoader iPartialArgb32PixelLoader2 = az2 = new az(rasterImage.getBounds().Clone(), rectangle.Clone(), o2);
                        if (rasterImage.hasTransparentColor()) {
                            iPartialArgb32PixelLoader = new bj(rasterImage.getTransparentColor().toArgb(), rasterImage.getBackgroundColor().toArgb(), iPartialArgb32PixelLoader2);
                            iPartialArgb32PixelLoader2 = iPartialArgb32PixelLoader;
                        }
                        if (rasterImage.hasAlpha()) {
                            iPartialArgb32PixelLoader = new f(Color.getWhite().toArgb(), iPartialArgb32PixelLoader2);
                            iPartialArgb32PixelLoader2 = iPartialArgb32PixelLoader;
                        }
                        rasterImage.loadPartialArgb32Pixels(rectangle3.Clone(), iPartialArgb32PixelLoader2);
                    }
                }
                if (d2 != null) {
                    d2.a(true);
                    n2 = d2.b();
                }
                if (n2 == 2) {
                    c2 = d2.a();
                    boolean bl3 = com.aspose.imaging.internal.fd.b.a(jpegOptions);
                    n2 = bl3 ? 0 : 1;
                } else if (n2 == 0) {
                    list = b3.a();
                    n2 = 1;
                } else if (n2 == 1) {
                    bl2 = false;
                }
            }
            finally {
                if (b3 != null) {
                    b3.dispose();
                }
            }
            b2 = null;
            d2 = null;
        }
        JpegImage.a(w2);
    }

    private static PixelDataFormat a(int n2) {
        PixelDataFormat pixelDataFormat;
        switch (n2) {
            case 0: {
                pixelDataFormat = PixelDataFormat.getGrayscale();
                break;
            }
            case 1: {
                pixelDataFormat = PixelDataFormat.getYCbCr();
                break;
            }
            case 2: {
                pixelDataFormat = PixelDataFormat.getCmyk();
                break;
            }
            case 4: {
                pixelDataFormat = PixelDataFormat.getRgb24Bpp();
                break;
            }
            case 3: {
                pixelDataFormat = PixelDataFormat.getYcck();
                break;
            }
            default: {
                throw new ArgumentOutOfRangeException("colorType");
            }
        }
        return pixelDataFormat;
    }

    @Override
    protected void saveData(Stream stream) {
        this.updateMetadata();
        JpegImage.a(this, stream, this.getJfif(), this.getExifData(), this.getXmpData(), this.f, this.getBounds().Clone());
    }

    @Override
    protected void updateDimensions(int newWidth, int newHeight) {
        this.g = newWidth;
        this.e = newHeight;
    }

    private static void a(StreamContainer streamContainer, JpegExifData jpegExifData) {
        if (jpegExifData == null) {
            return;
        }
        byte[] byArray = JpegImage.a(jpegExifData);
        streamContainer.write(byArray, 0, byArray.length);
    }

    private static void a(StreamContainer streamContainer, XmpPacketWrapper xmpPacketWrapper) {
        if (xmpPacketWrapper == null) {
            return;
        }
        byte[] byArray = JpegImage.a(xmpPacketWrapper);
        streamContainer.write(byArray, 0, byArray.length);
    }

    private static void b(StreamContainer streamContainer) {
        streamContainer.writeByte((byte)-1);
        streamContainer.writeByte((byte)-40);
    }

    private static void a(w w2) {
        w2.writeByte((byte)-1);
        w2.writeByte((byte)-39);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a(StreamContainer streamContainer, String string) {
        byte[] byArray;
        if (aY.b(string)) {
            return;
        }
        byte[] byArray2 = m.y().c(string);
        StreamContainer streamContainer2 = new StreamContainer(new MemoryStream(), true);
        try {
            TiffBigEndianStreamWriter tiffBigEndianStreamWriter = new TiffBigEndianStreamWriter(streamContainer2);
            byte[] byArray3 = new byte[]{-1, -2};
            tiffBigEndianStreamWriter.write(byArray3);
            tiffBigEndianStreamWriter.writeUShort(com.aspose.imaging.internal.dO.d.d((Object)(byArray2.length + 2), 9));
            tiffBigEndianStreamWriter.write(byArray2);
            byArray = streamContainer2.toBytes();
        }
        finally {
            if (streamContainer2 != null) {
                streamContainer2.dispose();
            }
        }
        streamContainer.write(byArray, 0, byArray.length);
    }

    private void a(aM aM2) {
        this.a(aM2, aM2.a().getWidth(), aM2.a().getHeight());
    }

    private void a(IRasterImageArgb32PixelLoader iRasterImageArgb32PixelLoader, int n2, int n3) {
        JpegImage jpegImage;
        this.setDataLoader(iRasterImageArgb32PixelLoader);
        this.g = n2;
        this.e = n3;
        this.f = new JpegOptions();
        aM aM2 = (aM)((Object)com.aspose.imaging.internal.dO.d.a(iRasterImageArgb32PixelLoader, aM.class));
        if (aM2 != null && aM2.a() != null && (jpegImage = (JpegImage)((Object)com.aspose.imaging.internal.dO.d.a(aM2.a(), JpegImage.class))) != null) {
            this.f.setExifData(jpegImage.getExifData());
            this.f.setComment(jpegImage.getComment());
            this.f.setJfif(jpegImage.getJfif());
            this.f.setXmpData(jpegImage.getXmpData());
        }
    }

    public static JpegImage a(int n2, int n3, int n4, IRasterImageArgb32PixelLoader iRasterImageArgb32PixelLoader) {
        return new JpegImage(n2, n3, n4, iRasterImageArgb32PixelLoader);
    }
}

