/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.fileformats.jpeg2000;

import com.aspose.imaging.IRasterImageArgb32PixelLoader;
import com.aspose.imaging.PixelDataFormat;
import com.aspose.imaging.Point;
import com.aspose.imaging.RasterCachedImage;
import com.aspose.imaging.RasterImage;
import com.aspose.imaging.Rectangle;
import com.aspose.imaging.StreamContainer;
import com.aspose.imaging.coreexceptions.imageformats.Jpeg2000Exception;
import com.aspose.imaging.imageoptions.Jpeg2000Options;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.ap.S;
import com.aspose.imaging.internal.dP.aM;
import com.aspose.imaging.internal.fl.a;
import com.aspose.imaging.internal.fl.d;
import com.aspose.imaging.internal.fm.i;
import com.aspose.imaging.internal.fw.at;
import com.aspose.imaging.internal.fw.ay;
import com.aspose.imaging.internal.fx.e;
import com.aspose.imaging.internal.fx.h;
import com.aspose.imaging.internal.fx.o;
import com.aspose.imaging.system.io.Stream;
import com.aspose.imaging.xmp.XmpPacketWrapper;
import java.io.InputStream;

public final class Jpeg2000Image
extends RasterCachedImage {
    private static final int e = 24;
    private int f;
    private int g;
    private ay h = new ay();
    private d i = new d();
    private at j;
    private S k = new S();

    public Jpeg2000Image(String path) {
        this(path, 24);
    }

    public Jpeg2000Image(String path, int bitsPerPixel) {
        if (path == null) {
            throw new ArgumentNullException("path");
        }
        aM aM2 = new aM(path);
        this.a(aM2, aM2.a().getWidth(), aM2.a().getHeight(), bitsPerPixel);
    }

    public Jpeg2000Image(InputStream stream) {
        this(Stream.fromJava(stream));
    }

    Jpeg2000Image(Stream stream) {
        this(stream, 24);
    }

    public Jpeg2000Image(InputStream stream, int bitsPerPixel) {
        this(Stream.fromJava(stream), bitsPerPixel);
    }

    Jpeg2000Image(Stream stream, int bitsPerPixel) {
        if (stream == null) {
            throw new ArgumentNullException("stream");
        }
        aM aM2 = new aM(stream);
        this.a(aM2, aM2.a().getWidth(), aM2.a().getHeight(), bitsPerPixel);
    }

    public Jpeg2000Image(int width, int height) {
        this(width, height, 24);
    }

    public Jpeg2000Image(int width, int height, Jpeg2000Options options) {
        this(width, height, 24);
        this.i.a(options.getComments());
        this.i.a(options.getCodec());
        this.i.a(options.getResolutionSettings());
        this.i.a(options.getXmpData());
    }

    public Jpeg2000Image(int width, int height, int bitsCount) {
        if (bitsCount != 24) {
            throw new Jpeg2000Exception("Only 24 bits per pixel is supported at the moment.");
        }
        this.f = width;
        this.g = height;
        this.i.b(bitsCount);
    }

    public Jpeg2000Image(RasterImage image) {
        this(image, 24);
    }

    public Jpeg2000Image(RasterImage rasterImage, int bitsPerPixel) {
        if (rasterImage == null) {
            throw new ArgumentNullException("rasterImage");
        }
        this.a(rasterImage, rasterImage.getWidth(), rasterImage.getHeight(), bitsPerPixel);
    }

    private Jpeg2000Image(int imgWidth, int imgHeight, IRasterImageArgb32PixelLoader reader, int depth, String[] comments, XmpPacketWrapper xmpData) {
        this.a(reader, imgWidth, imgHeight, depth);
        this.i.a(comments);
        this.i.a(xmpData);
    }

    private Jpeg2000Image(ay imageData, String[] comments, int codec, XmpPacketWrapper xmpData, at decoder, IRasterImageArgb32PixelLoader reader) {
        int n2 = com.aspose.imaging.internal.dO.d.e((Object)(com.aspose.imaging.internal.dO.d.f((Object)imageData.g().get_Item(0).h(), 10) * com.aspose.imaging.internal.dO.d.f((Object)imageData.e(), 10)), 10);
        int n3 = com.aspose.imaging.internal.dO.d.e((Object)imageData.g().get_Item(0).d(), 10);
        int n4 = com.aspose.imaging.internal.dO.d.e((Object)imageData.g().get_Item(0).e(), 10);
        this.j = decoder;
        this.i.a(comments);
        this.i.a(codec);
        this.i.a(decoder.b().i());
        this.i.a(xmpData);
        this.a(reader, n3, n4, n2);
    }

    @Override
    public XmpPacketWrapper getXmpData() {
        return this.i.a();
    }

    @Override
    public void setXmpData(XmpPacketWrapper value) {
        this.i.a(value);
    }

    @Override
    public PixelDataFormat getRawDataFormat() {
        PixelDataFormat pixelDataFormat = PixelDataFormat.getRgb24Bpp();
        switch (this.i.g()) {
            case 24: {
                pixelDataFormat = PixelDataFormat.getRgb24Bpp();
                break;
            }
            case 32: {
                pixelDataFormat = PixelDataFormat.getRgb32Bpp();
                break;
            }
            case 16: {
                pixelDataFormat = PixelDataFormat.getRgb16Bpp555();
            }
        }
        return pixelDataFormat;
    }

    @Override
    public int getRawLineSize() {
        return this.f * (this.i.g() / 8);
    }

    @Override
    public int getWidth() {
        return this.f;
    }

    @Override
    public int getHeight() {
        return this.g;
    }

    @Override
    public int getBitsPerPixel() {
        return this.i.g();
    }

    @Override
    public double getHorizontalResolution() {
        if (this.i != null) {
            return this.i.c();
        }
        return 72.0;
    }

    @Override
    public void setHorizontalResolution(double value) {
        this.i.a(true);
        this.i.b(value);
    }

    @Override
    public double getVerticalResolution() {
        if (this.i != null) {
            return this.i.b();
        }
        return 72.0;
    }

    @Override
    public void setVerticalResolution(double value) {
        this.i.a(true);
        this.i.a(value);
    }

    public String[] getComments() {
        return this.i.e();
    }

    public void setComments(String[] value) {
        this.i.a(value);
    }

    public S h() {
        return this.k;
    }

    public void a(S s2) {
        s2.f(this.k);
    }

    public ay i() {
        return this.h;
    }

    public void a(ay ay2) {
        this.h = ay2;
    }

    public int j() {
        return this.i.f();
    }

    public at k() {
        return this.j;
    }

    public static Jpeg2000Image a(int n2, int n3, IRasterImageArgb32PixelLoader iRasterImageArgb32PixelLoader, int n4, String[] stringArray, XmpPacketWrapper xmpPacketWrapper) {
        return new Jpeg2000Image(n2, n3, iRasterImageArgb32PixelLoader, n4, stringArray, xmpPacketWrapper);
    }

    public static Jpeg2000Image a(ay ay2, String[] stringArray, XmpPacketWrapper xmpPacketWrapper, int n2, at at2, IRasterImageArgb32PixelLoader iRasterImageArgb32PixelLoader) {
        return new Jpeg2000Image(ay2, stringArray, n2, xmpPacketWrapper, at2, iRasterImageArgb32PixelLoader);
    }

    public static void a(RasterImage rasterImage, Stream stream, d d2, Rectangle rectangle) {
        e e2 = com.aspose.imaging.internal.fx.e.R();
        o o2 = Jpeg2000Image.a(rasterImage, rectangle.Clone());
        e2.a((byte)(com.aspose.imaging.internal.dO.d.f((Object)o2.e(), 10) >= 3L ? 1 : 0));
        e2.a(d2.e());
        e2.f(d2.d());
        e2.a(d2.h());
        switch (d2.f()) {
            case 0: {
                com.aspose.imaging.internal.fx.d d3 = com.aspose.imaging.internal.fl.a.a(0);
                com.aspose.imaging.internal.ft.a.a(d3.c(), e2, o2);
                com.aspose.imaging.internal.ft.a.a(d3.c(), o2, stream);
                com.aspose.imaging.internal.ft.a.a(d3.c(), stream);
                com.aspose.imaging.internal.ft.a.b(d3.c(), stream);
                break;
            }
            case 1: {
                com.aspose.imaging.internal.fx.d d4 = com.aspose.imaging.internal.fl.a.a(2);
                com.aspose.imaging.internal.fu.a.a(d4.b(), e2, o2);
                com.aspose.imaging.internal.fu.a.a(d4.b(), o2, stream);
                com.aspose.imaging.internal.ft.a.a(d4.b().a(), stream);
                com.aspose.imaging.internal.fu.a.b(d4.b(), stream);
            }
        }
        if (d2.a() != null && d2.f() == 0) {
            i i2 = new i(d2.a());
            i2.a(stream, true);
        }
    }

    @Override
    protected void updateDimensions(int newWidth, int newHeight) {
        this.f = newWidth;
        this.g = newHeight;
    }

    @Override
    protected void saveData(Stream stream) {
        this.updateMetadata();
        StreamContainer streamContainer = new StreamContainer(stream);
        try {
            Jpeg2000Image.a(this, streamContainer.a(), this.i, this.getBounds());
        }
        finally {
            if (streamContainer != null) {
                streamContainer.dispose();
            }
        }
    }

    private static o a(RasterImage rasterImage, Rectangle rectangle) {
        int n2 = 3;
        int n3 = 1;
        h[] hArray = new h[3];
        for (int i2 = 0; i2 < 3; ++i2) {
            hArray[i2] = new h();
            hArray[i2].g(8L);
            hArray[i2].h(8L);
            hArray[i2].i(0L);
            hArray[i2].a(1L);
            hArray[i2].b(1L);
            hArray[i2].c(com.aspose.imaging.internal.dO.d.f((Object)rectangle.getWidth(), 9));
            hArray[i2].d(com.aspose.imaging.internal.dO.d.f((Object)rectangle.getHeight(), 9));
        }
        o o2 = o.a(com.aspose.imaging.internal.dO.d.f((Object)3, 9), hArray, n3);
        o2.a(0L);
        o2.b(0L);
        o2.c(com.aspose.imaging.internal.dO.d.f((Object)rectangle.getWidth(), 9));
        o2.d(com.aspose.imaging.internal.dO.d.f((Object)rectangle.getHeight(), 9));
        Rectangle rectangle2 = Rectangle.intersect(rectangle.Clone(), rasterImage.getBounds().Clone()).Clone();
        if (rectangle2.getWidth() > 0 && rectangle2.getHeight() > 0) {
            Point point = new Point(rasterImage.getBounds().getX() - rectangle.getX(), rasterImage.getBounds().getY() - rectangle.getY());
            int[] nArray = rasterImage.loadArgb32Pixels(rectangle2.Clone());
            rectangle2.setX(rectangle2.getX() + point.getX());
            rectangle2.setY(rectangle2.getY() + point.getY());
            int n4 = rectangle2.getY() * rectangle.getWidth();
            int n5 = 0;
            for (int i3 = 0; i3 < rectangle2.getHeight(); ++i3) {
                int n6 = n4 + rectangle2.getX();
                for (int i4 = 0; i4 < rectangle2.getWidth(); ++i4) {
                    int n7 = nArray[n5];
                    int n8 = n7 >> 16 & 0xFF;
                    int n9 = n7 >> 8 & 0xFF;
                    int n10 = n7 & 0xFF;
                    o2.g()[0].l()[n6] = n8;
                    o2.g()[1].l()[n6] = n9;
                    o2.g()[2].l()[n6] = n10;
                    ++n5;
                    ++n6;
                }
                n4 += rectangle.getWidth();
            }
        }
        return o2;
    }

    private void a(IRasterImageArgb32PixelLoader iRasterImageArgb32PixelLoader, int n2, int n3, int n4) {
        this.setDataLoader(iRasterImageArgb32PixelLoader);
        this.f = n2;
        this.g = n3;
        this.i.b(n4);
    }
}

