/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.fileformats.metafile;

import com.aspose.imaging.coreexceptions.imageformats.MetafilesException;
import com.aspose.imaging.fileformats.metafile.ct;
import java.awt.Color;
import java.awt.RenderingHints;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class ColorMap {
    public static RenderingHints.Key KEY_METAFILES_COLOR_MAP;
    public static RenderingHints.Key METAFILES_COLOR_MAP;
    private HashMap a = new HashMap();
    private HashMap b = null;

    public ColorMap(int initialSize) {
    }

    public ColorMap(Map colorMap) throws MetafilesException {
        this(16);
        this.putAll(colorMap);
    }

    public void putAll(Map colorMap) throws MetafilesException {
        for (Map.Entry entry : colorMap.entrySet()) {
            if (entry.getKey() instanceof Color && entry.getValue() instanceof Color) {
                this.put((Color)entry.getKey(), (Color)entry.getValue());
                continue;
            }
            throw new MetafilesException("colorMap must contain Color to Color entries only.");
        }
    }

    public void put(Color key, Color value) throws MetafilesException {
        if (key == null) {
            throw new MetafilesException("key can't be null");
        }
        if (value == null) {
            throw new MetafilesException("value can't be null");
        }
        if (key.equals(value)) {
            this.a.remove(key);
        } else {
            this.a.put(key, value);
        }
    }

    public Color mapColor(Color color) {
        Color color2 = (Color)this.a.get(color);
        if (color2 != null) {
            return color2;
        }
        return color;
    }

    HashMap getRGBMap() {
        if (this.b != null) {
            return this.b;
        }
        Iterator iterator = this.a.entrySet().iterator();
        this.b = new HashMap(256, 0.5f);
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            int n2 = ((Color)entry.getKey()).getRGB() & 0xFFFFFF;
            int n3 = ((Color)entry.getValue()).getRGB() & 0xFFFFFF;
            this.b.put(new Integer(n2), new Integer(n3));
        }
        return this.b;
    }

    public boolean isEmpty() {
        return this.a.size() == 0;
    }

    static {
        METAFILES_COLOR_MAP = KEY_METAFILES_COLOR_MAP = new ct(1, "");
    }
}

