/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.fileformats.metafile;

import com.aspose.imaging.IColorPalette;
import com.aspose.imaging.Image;
import com.aspose.imaging.ImageResizeSettings;
import com.aspose.imaging.Rectangle;
import com.aspose.imaging.coreexceptions.FrameworkException;
import com.aspose.imaging.coreexceptions.imageformats.MetafilesException;
import com.aspose.imaging.fileformats.metafile.MetafileComment;
import com.aspose.imaging.fileformats.metafile.c;
import com.aspose.imaging.fileformats.metafile.cF;
import com.aspose.imaging.fileformats.metafile.cq;
import com.aspose.imaging.fileformats.metafile.cr;
import com.aspose.imaging.fileformats.metafile.ct;
import com.aspose.imaging.fileformats.metafile.y;
import com.aspose.imaging.system.io.Stream;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public abstract class MetafileImage
extends Image
implements Cloneable {
    static final boolean debug = false;
    static RenderingHints.Key KEY_METAFILES_COMPOSE_WITH_DISCRETE_ALPHA = new ct(3, "");
    RenderingHints m_defaultRenderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    Rectangle2D.Float m_frame;
    cF[] m_textOutOps = null;
    int m_minimumPixelCount = 0;
    int m_maximumPixelCount = 10000000;
    Color m_bgColor;
    y[] m_embeddedBitmaps = null;
    cq m_watermark = null;
    int[] m_customWatermarkPositions = null;
    Rectangle m_croppingRectangle;

    MetafileImage() {
        this.m_defaultRenderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HBGR);
        if (System.getProperty("os.name").toLowerCase().indexOf("win") >= 0) {
            this.m_defaultRenderingHints.put(RenderingHints.KEY_TEXT_LCD_CONTRAST, (Object)150);
        } else {
            this.m_defaultRenderingHints.put(RenderingHints.KEY_TEXT_LCD_CONTRAST, (Object)140);
        }
    }

    @Override
    public abstract Rectangle getBounds();

    public abstract void playMetafile(Graphics2D var1) throws MetafilesException;

    public abstract void playMetafile(Graphics2D var1, AffineTransform var2) throws MetafilesException;

    public Vector getSources() {
        return null;
    }

    public float getMinX() {
        return this.m_frame.x;
    }

    public float getMinY() {
        return this.m_frame.y;
    }

    @Override
    public int getWidth() {
        return Math.round(this.m_frame.width);
    }

    @Override
    public void resize(int newWidth, int newHeight, ImageResizeSettings settings) {
        throw new MetafilesException("This format does not support resizing!");
    }

    @Override
    public int getHeight() {
        return Math.round(this.m_frame.height);
    }

    public boolean isDynamic() {
        return false;
    }

    public String[] getPropertyNames() {
        return new String[0];
    }

    public Object getProperty(String name) {
        return java.awt.Image.UndefinedProperty;
    }

    private RenderedImage a(int n2, int n3, RenderingHints renderingHints, AffineTransform affineTransform) {
        Color color;
        RenderingHints renderingHints2 = new RenderingHints(new HashMap());
        if (this.m_defaultRenderingHints != null) {
            renderingHints2.add(this.m_defaultRenderingHints);
        }
        if (renderingHints != null) {
            renderingHints2.add(renderingHints);
        }
        boolean bl2 = (color = this.m_bgColor) == null || color.getAlpha() < 255;
        BufferedImage bufferedImage = new BufferedImage(n2, n3, bl2 ? 2 : 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.addRenderingHints(renderingHints2);
        try {
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.Clear);
            graphics2D.fillRect(-1, -1, n2 + 2, n3 + 2);
            if (color != null && color.getAlpha() > 0) {
                graphics2D.setComposite(AlphaComposite.SrcOver);
                graphics2D.setPaint(color);
                graphics2D.fillRect(-1, -1, n2 + 2, n3 + 2);
            }
            graphics2D.setComposite(composite);
            this.playMetafile(graphics2D, affineTransform);
        }
        catch (MetafilesException metafilesException) {
            return null;
        }
        return bufferedImage;
    }

    public RenderedImage createScaledRendering(int w2, int h2, RenderingHints hints) {
        if (w2 == 0 && h2 == 0) {
            throw new IllegalArgumentException("width and height cannot be zero both");
        }
        if (w2 == 0) {
            w2 = Math.round((float)h2 * ((float)this.getWidth() / (float)this.getHeight()));
        }
        if (h2 == 0) {
            h2 = Math.round((float)w2 * ((float)this.getHeight() / (float)this.getWidth()));
        }
        AffineTransform affineTransform = AffineTransform.getScaleInstance((double)w2 / (double)this.getWidth(), (double)h2 / (double)this.getHeight());
        affineTransform.translate(-this.getMinX(), -this.getMinY());
        return this.a(w2, h2, hints, affineTransform);
    }

    public RenderedImage createDefaultRendering() {
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        float f2 = -this.getMinX();
        float f3 = -this.getMinY();
        double d2 = (double)n2 * (double)n3;
        float f4 = 1.0f;
        if (d2 != 0.0) {
            if (d2 > 2.147483647E8) {
                this.m_maximumPixelCount = 0xCCCCCCC;
            }
            if (d2 < (double)this.m_minimumPixelCount) {
                f4 = (float)Math.sqrt((double)this.m_minimumPixelCount / d2);
            } else if (d2 > (double)this.m_maximumPixelCount) {
                f4 = (float)Math.sqrt((double)this.m_maximumPixelCount / d2);
            }
        }
        AffineTransform affineTransform = AffineTransform.getScaleInstance(f4, f4);
        affineTransform.translate(f2, f3);
        return this.a(Math.round((float)n2 * f4), Math.round((float)n3 * f4), null, affineTransform);
    }

    public void setDefaultRenderingHints(RenderingHints rh) {
        this.m_defaultRenderingHints = rh;
    }

    public RenderingHints getDefaultRenderingHints() {
        return this.m_defaultRenderingHints;
    }

    public cF[] getTextOutOperations() throws MetafilesException {
        this.f();
        return (cF[])this.m_textOutOps.clone();
    }

    public String[] getTextStrings() throws MetafilesException {
        this.f();
        String[] stringArray = new String[this.m_textOutOps.length];
        for (int i2 = 0; i2 < this.m_textOutOps.length; ++i2) {
            stringArray[i2] = this.m_textOutOps[i2].c;
        }
        return stringArray;
    }

    private void f() throws MetafilesException {
        if (this.m_textOutOps != null) {
            return;
        }
        this.playMetafile(new cr());
    }

    public void crop(int leftShift, int rightShift, int topShift, int bottomShift) {
        if (leftShift < 0 || rightShift < 0 || topShift < 0 || bottomShift < 0) {
            throw new FrameworkException("Parameters must be positive!");
        }
        if (leftShift == 0 && rightShift == 0 && topShift == 0 && bottomShift == 0) {
            this.crop(null);
        } else {
            this.crop(new Rectangle(leftShift, topShift, (int)Math.ceil(this.m_frame.getWidth() - (double)leftShift - (double)rightShift), (int)Math.ceil(this.m_frame.getHeight() - (double)topShift - (double)bottomShift)));
        }
    }

    public void crop(Rectangle rectangle) {
        this.m_croppingRectangle = rectangle == null || rectangle.isEmpty() ? null : rectangle.Clone();
    }

    public Rectangle getCroppingRectangle() {
        if (this.m_croppingRectangle != null) {
            return this.m_croppingRectangle.Clone();
        }
        return null;
    }

    public int getMinPixelCount() {
        return this.m_minimumPixelCount;
    }

    public void setMinPixelCount(int value) {
        if (value < 0) {
            value = 0;
        }
        this.m_minimumPixelCount = value;
        if (value > this.m_maximumPixelCount) {
            this.m_maximumPixelCount = value;
        }
    }

    public int getMaxPixelCount() {
        return this.m_maximumPixelCount;
    }

    public void setMaxPixelCount(int value) {
        if (value < 1) {
            value = 1;
        }
        this.m_maximumPixelCount = value;
        if (value < this.m_minimumPixelCount) {
            this.m_minimumPixelCount = value;
        }
    }

    public Color getRenderableBackgroundColor() {
        return this.m_bgColor;
    }

    public void setRenderableBackgroundColor(Color color) {
        this.m_bgColor = color;
    }

    public abstract MetafileComment[] getComments();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public y[] getEmbeddedBitmaps() {
        MetafileImage metafileImage = this;
        synchronized (metafileImage) {
            if (this.m_embeddedBitmaps == null) {
                this.createEmbeddedBitmapsArray();
            }
        }
        return (y[])this.m_embeddedBitmaps.clone();
    }

    abstract void createEmbeddedBitmapsArray();

    void addBitmapData(ArrayList arrayList, c bmp) {
        if (bmp != null && bmp.l != null) {
            arrayList.add(new y(bmp.l, bmp.k));
        }
    }

    public Object clone() {
        MetafileImage metafileImage = null;
        try {
            metafileImage = (MetafileImage)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        if (this.m_defaultRenderingHints != null) {
            metafileImage.m_defaultRenderingHints = (RenderingHints)metafileImage.m_defaultRenderingHints.clone();
        }
        return metafileImage;
    }

    @Override
    public boolean isCached() {
        return true;
    }

    @Override
    public void cacheData() {
        throw new UnsupportedOperationException("This method is not applicable for this implementation.");
    }

    @Override
    public void a(Stream stream) {
        this.verifyNotDisposed();
        this.saveData(stream);
    }

    @Override
    protected void saveData(Stream stream) {
        this.a(stream);
    }

    @Override
    public void resize(int newWidth, int newHeight, int resizeType) {
        throw new UnsupportedOperationException("This method is not applicable for this implementation.");
    }

    @Override
    public void rotateFlip(int rotateFlipType) {
    }

    @Override
    public void setPalette(IColorPalette palette, boolean updateColors) {
        this.setPalette(palette);
    }

    @Override
    public int getBitsPerPixel() {
        throw new UnsupportedOperationException("This method is not applicable for this implementation.");
    }

    public abstract cq getWatermarkDrawer();

    public abstract String[] getUsedFonts();

    public abstract String[] getMissedFonts();

    abstract boolean detectCustomWatermark();
}

