/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.fileformats.png;

import com.aspose.imaging.Color;
import com.aspose.imaging.IColorPalette;
import com.aspose.imaging.IRasterImageArgb32PixelLoader;
import com.aspose.imaging.PixelDataFormat;
import com.aspose.imaging.RasterCachedImage;
import com.aspose.imaging.RasterImage;
import com.aspose.imaging.RawDataSettings;
import com.aspose.imaging.Rectangle;
import com.aspose.imaging.ResolutionSetting;
import com.aspose.imaging.coreexceptions.FrameworkException;
import com.aspose.imaging.coreexceptions.imageformats.PngImageException;
import com.aspose.imaging.imageoptions.PngOptions;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.ap.S;
import com.aspose.imaging.internal.ap.aY;
import com.aspose.imaging.internal.dP.aA;
import com.aspose.imaging.internal.dP.aM;
import com.aspose.imaging.internal.dP.az;
import com.aspose.imaging.internal.fC.b;
import com.aspose.imaging.internal.fD.h;
import com.aspose.imaging.internal.fD.j;
import com.aspose.imaging.internal.fD.k;
import com.aspose.imaging.internal.fD.m;
import com.aspose.imaging.internal.fD.r;
import com.aspose.imaging.internal.fD.s;
import com.aspose.imaging.internal.fD.t;
import com.aspose.imaging.internal.fF.d;
import com.aspose.imaging.internal.fF.n;
import com.aspose.imaging.internal.fG.a;
import com.aspose.imaging.internal.fG.c;
import com.aspose.imaging.internal.fG.e;
import com.aspose.imaging.internal.fG.g;
import com.aspose.imaging.internal.fG.i;
import com.aspose.imaging.internal.fG.l;
import com.aspose.imaging.internal.gS.w;
import com.aspose.imaging.system.io.Stream;
import com.aspose.imaging.xmp.XmpPacketWrapper;
import java.io.InputStream;
import java.util.Date;

public class PngImage
extends RasterCachedImage {
    private com.aspose.imaging.internal.fC.a e;

    public PngImage(int width, int height) {
        this(width, height, 2);
    }

    public PngImage(String path) {
        this(path, 2);
    }

    public PngImage(RasterImage rasterImage) {
        this(rasterImage, 2);
    }

    public PngImage(String path, int colorType) {
        if (path == null) {
            throw new ArgumentNullException("path");
        }
        aM aM2 = new aM(path);
        if (com.aspose.imaging.internal.dO.d.b((Object)aM2.a(), PngImage.class)) {
            if (((PngImage)aM2.a()).h().e() == 3) {
                this.a(aM2, aM2.a().getWidth(), aM2.a().getHeight(), 3);
            } else {
                this.a(aM2, aM2.a().getWidth(), aM2.a().getHeight(), colorType);
            }
        } else {
            this.a(aM2, aM2.a().getWidth(), aM2.a().getHeight(), colorType);
        }
    }

    public PngImage(RasterImage rasterImage, int colorType) {
        aM aM2 = new aM(rasterImage);
        this.a(aM2, rasterImage.getWidth(), rasterImage.getHeight(), colorType);
    }

    public PngImage(InputStream stream) {
        this(Stream.fromJava(stream));
    }

    PngImage(Stream stream) {
        aM aM2 = new aM(stream);
        this.a(aM2, aM2.a().getWidth(), aM2.a().getHeight(), 2);
    }

    public PngImage(int width, int height, int colorType) {
        this.a(width, height, colorType);
    }

    public PngImage(PngOptions pngOptions, int width, int height) {
        this.a(new com.aspose.imaging.internal.fC.a(pngOptions));
        this.h().b(com.aspose.imaging.internal.dO.d.f((Object)width, 9));
        this.h().a(com.aspose.imaging.internal.dO.d.f((Object)height, 9));
        this.b(this.h());
    }

    private PngImage(com.aspose.imaging.internal.fC.a fileSettings, IRasterImageArgb32PixelLoader loader) {
        this.setDataLoader(loader);
        this.b(fileSettings);
    }

    public static PngImage a(com.aspose.imaging.internal.fC.a a2, IRasterImageArgb32PixelLoader iRasterImageArgb32PixelLoader) {
        return new PngImage(a2, iRasterImageArgb32PixelLoader);
    }

    public static void a(Stream stream, RasterImage rasterImage, PngOptions pngOptions, Rectangle rectangle, String string) {
        int n2;
        Object object;
        Object object2;
        pngOptions.a();
        com.aspose.imaging.internal.fC.a a2 = new com.aspose.imaging.internal.fC.a(pngOptions);
        a2.c(rasterImage.hasTransparentColor());
        if (a2.q()) {
            a2.b(Color.getEmpty());
        }
        a2.a(rasterImage.hasBackgroundColor());
        if (a2.g()) {
            a2.a(rasterImage.getBackgroundColor().Clone());
        }
        a2.b(com.aspose.imaging.internal.dO.d.f((Object)rectangle.getWidth(), 9));
        a2.a(com.aspose.imaging.internal.dO.d.f((Object)rectangle.getHeight(), 9));
        b b2 = new b(stream);
        byte[] byArray = w.a();
        b2.write(byArray, 0, byArray.length);
        h h2 = new h(a2);
        h2.a(b2);
        if (a2.b() != null) {
            object2 = new t();
            ((t)object2).a(a2.b().b());
            ((m)object2).a(b2);
        }
        if (!aY.b(string)) {
            object2 = S.c(string).H();
            object = new r();
            ((r)object).a(((S)object2).H());
            ((m)object).a(b2);
        }
        if (a2.e() == 3) {
            PngImage.a(b2, a2);
        }
        if (a2.p()) {
            object2 = new com.aspose.imaging.internal.fD.l();
            double d2 = 39.3701;
            ((com.aspose.imaging.internal.fD.l)object2).a(com.aspose.imaging.internal.dO.d.e((Object)(a2.i() * 39.3701), 14));
            ((com.aspose.imaging.internal.fD.l)object2).b(com.aspose.imaging.internal.dO.d.e((Object)(a2.n() * 39.3701), 14));
            ((com.aspose.imaging.internal.fD.l)object2).c(1);
            ((m)object2).a(b2);
        }
        if (a2.q() && (a2.e() == 0 || a2.e() == 2)) {
            object2 = new s();
            object = null;
            n2 = a2.m().toArgb();
            byte by2 = (byte)(n2 >> 16 & 0xFF);
            byte by3 = (byte)(n2 >> 8 & 0xFF);
            byte by4 = (byte)(n2 & 0xFF);
            if (a2.e() == 0) {
                object = new byte[2];
                object[0] = false;
                object[1] = (byte)((com.aspose.imaging.internal.dO.d.e((Object)by2, 6) + com.aspose.imaging.internal.dO.d.e((Object)by3, 6) + com.aspose.imaging.internal.dO.d.e((Object)by4, 6)) / 3);
            }
            if (a2.e() == 2) {
                object = new byte[6];
                object[1] = by2;
                object[3] = by3;
                object[5] = by4;
            }
            ((s)object2).a((byte[])object);
            ((m)object2).a(b2);
        }
        if (a2.g()) {
            object2 = null;
            switch (a2.e()) {
                case 0: 
                case 4: {
                    object = new com.aspose.imaging.internal.fD.g();
                    n2 = a2.c().toArgb();
                    ((com.aspose.imaging.internal.fD.g)object).a(com.aspose.imaging.internal.dO.d.d((Object)((n2 >> 16 & 255 + (n2 >> 8) & 255 + n2 & 0xFF) / 3), 9));
                    object2 = object;
                    break;
                }
                case 2: 
                case 6: {
                    com.aspose.imaging.internal.fD.c c2 = new com.aspose.imaging.internal.fD.c();
                    c2.a(a2.c().toArgb());
                    object2 = c2;
                    break;
                }
                case 3: {
                    j j2 = new j();
                    IColorPalette iColorPalette = a2.k();
                    if (iColorPalette == null) {
                        throw new FrameworkException(aY.a, new PngImageException("You need to specify color palette."));
                    }
                    j2.a(iColorPalette.getNearestColorIndex(a2.c().toArgb()));
                    object2 = j2;
                    break;
                }
                default: {
                    throw new ArgumentOutOfRangeException();
                }
            }
            ((m)object2).a(b2);
        }
        PngImage.a(b2, rasterImage, a2, rectangle.Clone());
        object2 = new com.aspose.imaging.internal.fD.e();
        ((m)object2).a(b2);
    }

    public static void a(Stream stream, RasterImage rasterImage, PngOptions pngOptions, Rectangle rectangle) {
        PngImage.a(stream, rasterImage, pngOptions, rectangle.Clone(), null);
    }

    private static void a(b b2, com.aspose.imaging.internal.fC.a a2) {
        IColorPalette iColorPalette = a2.k();
        if (iColorPalette == null) {
            throw new FrameworkException(aY.a, new PngImageException("You need to specify color palette."));
        }
        k k2 = new k(iColorPalette);
        k2.a(b2);
        byte[] byArray = new byte[iColorPalette.getEntriesCount()];
        for (int i2 = 0; i2 < iColorPalette.getEntriesCount(); ++i2) {
            byte by2;
            int n2 = iColorPalette.getArgb32Entries()[i2];
            byArray[i2] = by2 = (byte)(n2 >> 24 & 0xFF);
        }
        s s2 = new s(byArray);
        s2.a(b2);
    }

    private static void a(b b2, RasterImage rasterImage, com.aspose.imaging.internal.fC.a a2, Rectangle rectangle) {
        n n2 = new n(b2, a2);
        Rectangle rectangle2 = Rectangle.intersect(rasterImage.getBounds().Clone(), rectangle.Clone()).Clone();
        if (rasterImage.isRawDataAvailable()) {
            RawDataSettings rawDataSettings = new RawDataSettings();
            switch (a2.e()) {
                case 0: {
                    rawDataSettings.setPixelDataFormat(PixelDataFormat.getGrayscale());
                    break;
                }
                case 2: {
                    rawDataSettings.setPixelDataFormat(PixelDataFormat.getRgb24BppPng());
                    break;
                }
                case 3: {
                    rawDataSettings.setPixelDataFormat(PixelDataFormat.getRgbIndexed8Bpp());
                    rawDataSettings.setColorPalette(a2.k());
                    break;
                }
                case 4: {
                    rawDataSettings.setPixelDataFormat(PixelDataFormat.getGrayscaleAlpha());
                    break;
                }
                case 6: {
                    rawDataSettings.setPixelDataFormat(PixelDataFormat.getRgba32Bpp());
                    break;
                }
                default: {
                    throw new ArgumentOutOfRangeException();
                }
            }
            rawDataSettings.setCustomColorConverter(rasterImage.getRawDataSettings().getCustomColorConverter());
            rawDataSettings.setDitheringMethod(rasterImage.getRawDataSettings().getDitheringMethod());
            rawDataSettings.setFallbackIndex(rasterImage.getRawDataSettings().getFallbackIndex());
            rawDataSettings.setLineSize(rasterImage.getWidth() * rawDataSettings.getPixelDataFormat().getBitsPerPixel() / 8);
            d d2 = new d(a2, n2);
            aA aA2 = new aA(rasterImage.getBounds().Clone(), rectangle.Clone(), d2, true);
            if (rectangle2.getWidth() > 0 && rectangle2.getHeight() > 0) {
                rasterImage.loadRawData(rectangle2.Clone(), rawDataSettings, aA2);
            }
            aA2.a();
        } else {
            g g2;
            d d3 = new d(a2, n2);
            switch (a2.e()) {
                case 0: {
                    g2 = new c(d3);
                    break;
                }
                case 2: {
                    g2 = new i(d3);
                    break;
                }
                case 3: {
                    g2 = new e(d3, a2.k());
                    break;
                }
                case 4: {
                    g2 = new a(d3);
                    break;
                }
                case 6: {
                    g2 = new l(d3);
                    break;
                }
                default: {
                    throw new ArgumentOutOfRangeException();
                }
            }
            az az2 = new az(rasterImage.getBounds().Clone(), rectangle.Clone(), g2, true);
            if (rectangle2.getWidth() > 0 && rectangle2.getHeight() > 0) {
                rasterImage.loadPartialArgb32Pixels(rectangle2.Clone(), az2);
            }
            az2.a();
        }
        n2.d();
    }

    @Override
    public int getBitsPerPixel() {
        switch (this.e.e()) {
            case 2: {
                return com.aspose.imaging.internal.dO.d.e((Object)this.h().d(), 6) * 3;
            }
            case 4: {
                return com.aspose.imaging.internal.dO.d.e((Object)this.h().d(), 6) * 2;
            }
            case 6: {
                return com.aspose.imaging.internal.dO.d.e((Object)this.h().d(), 6) * 4;
            }
        }
        return com.aspose.imaging.internal.dO.d.e((Object)this.h().d(), 6);
    }

    @Override
    public int getHeight() {
        return com.aspose.imaging.internal.dO.d.e((Object)this.h().h(), 10);
    }

    @Override
    public double getHorizontalResolution() {
        if (this.h().p()) {
            return this.h().i();
        }
        return super.getHorizontalResolution();
    }

    @Override
    public void setHorizontalResolution(double value) {
        this.h().a(value);
        this.h().b(true);
    }

    @Override
    public PixelDataFormat getRawDataFormat() {
        switch (this.h().e()) {
            case 0: {
                return PixelDataFormat.getGrayscale();
            }
            case 2: {
                return PixelDataFormat.getRgb24BppPng();
            }
            case 3: {
                return PixelDataFormat.getRgbIndexed8Bpp();
            }
            case 4: {
                return PixelDataFormat.getGrayscaleAlpha();
            }
            case 6: {
                return PixelDataFormat.getRgba32Bpp();
            }
        }
        throw new ArgumentOutOfRangeException();
    }

    @Override
    public double getVerticalResolution() {
        return this.h().p() ? this.h().n() : super.getVerticalResolution();
    }

    @Override
    public void setVerticalResolution(double value) {
        this.h().b(value);
        this.h().b(true);
    }

    @Override
    public int getWidth() {
        return com.aspose.imaging.internal.dO.d.e((Object)this.h().o(), 10);
    }

    @Override
    public boolean hasTransparentColor() {
        return this.e.q();
    }

    @Override
    public void setTransparentColor(boolean value) {
        this.e.c(value);
    }

    @Override
    public boolean hasAlpha() {
        return this.e.e() == 6 || this.e.e() == 4;
    }

    @Override
    public Color getTransparentColor() {
        return this.e.m();
    }

    @Override
    public void setTransparentColor(Color value) {
        this.e.b(value.Clone());
    }

    @Override
    public boolean hasBackgroundColor() {
        return this.e.g();
    }

    @Override
    public void setBackgroundColor(boolean value) {
        this.e.a(value);
    }

    @Override
    public Color getBackgroundColor() {
        return this.e.c();
    }

    @Override
    public void setBackgroundColor(Color value) {
        this.e.a(value.Clone());
    }

    @Override
    public XmpPacketWrapper getXmpData() {
        return this.e.b();
    }

    @Override
    public void setXmpData(XmpPacketWrapper value) {
        this.e.a(value);
    }

    public com.aspose.imaging.internal.fC.a h() {
        return this.e;
    }

    public void a(com.aspose.imaging.internal.fC.a a2) {
        this.e = a2;
        this.setPalette(this.e.k());
    }

    @Override
    public Date getModifyDate(boolean useDefault) {
        return S.d(this.e(useDefault));
    }

    @Override
    public S e(boolean bl2) {
        if (!bl2 && !aY.b(this.h().a())) {
            return S.c(this.h().a());
        }
        return super.e(bl2);
    }

    @Override
    protected void updateMetadata() {
        if (this.getUpdateXmpData()) {
            try {
                String string = "G";
                String string2 = !aY.b(this.h().a()) ? this.h().a() : S.n().b(string);
                this.h().a(string2);
            }
            catch (RuntimeException runtimeException) {
                com.aspose.imaging.internal.aw.a.d(aY.a(new String[]{"Exception on PngImage.UpdateMetadata: ", runtimeException.toString()}));
            }
        }
        super.updateMetadata();
    }

    @Override
    protected void saveData(Stream stream) {
        this.updateMetadata();
        PngOptions pngOptions = new PngOptions();
        pngOptions.setColorType(this.h().e());
        pngOptions.setXmpData(this.h().b());
        if (this.h().p()) {
            pngOptions.setResolutionSettings(new ResolutionSetting(this.h().i(), this.h().n()));
        }
        pngOptions.setProgressive(com.aspose.imaging.internal.dO.d.e((Object)this.h().j(), 6) == 1);
        if (pngOptions.getColorType() == 3) {
            pngOptions.setPalette(this.h().k());
        }
        PngImage.a(stream, this, pngOptions, this.getBounds().Clone(), this.h().a());
    }

    @Override
    protected void updateDimensions(int newWidth, int newHeight) {
        this.h().a(com.aspose.imaging.internal.dO.d.f((Object)newHeight, 9));
        this.h().b(com.aspose.imaging.internal.dO.d.f((Object)newWidth, 9));
    }

    private void a(IRasterImageArgb32PixelLoader iRasterImageArgb32PixelLoader, int n2, int n3, int n4) {
        this.setDataLoader(iRasterImageArgb32PixelLoader);
        if (iRasterImageArgb32PixelLoader != null && com.aspose.imaging.internal.dO.d.b((Object)iRasterImageArgb32PixelLoader, com.aspose.imaging.internal.fF.h.class)) {
            this.a(((com.aspose.imaging.internal.fF.h)iRasterImageArgb32PixelLoader).a());
        } else if (n4 == 3) {
            this.a(((PngImage)((aM)iRasterImageArgb32PixelLoader).a()).h());
            this.a(n2, n3, n4);
        } else {
            this.a(n2, n3, n4);
        }
    }

    private void a(int n2, int n3, int n4) {
        if (n3 <= 0) {
            throw new PngImageException("The height should be positive.");
        }
        if (n2 <= 0) {
            throw new PngImageException("The width should be positive.");
        }
        if (n4 == 3) {
            this.b(this.h());
        } else {
            this.a(new com.aspose.imaging.internal.fC.a());
            this.h().a(n4);
            this.h().a(com.aspose.imaging.internal.dO.d.f((Object)n3, 9));
            this.h().b(com.aspose.imaging.internal.dO.d.f((Object)n2, 9));
            this.h().a((byte)8);
            this.b(this.h());
        }
    }

    private void b(com.aspose.imaging.internal.fC.a a2) {
        this.a(a2);
    }
}

