/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.fileformats.psd;

import com.aspose.imaging.Color;
import com.aspose.imaging.IColorPalette;
import com.aspose.imaging.IPsdColorPalette;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.dO.d;
import com.aspose.imaging.internal.dP.g;
import com.aspose.imaging.internal.dP.w;

public class PsdColorPalette
implements IPsdColorPalette {
    private final byte[] a;
    private short b;
    private boolean c;
    private final w d;
    private final boolean e;

    public PsdColorPalette(IColorPalette colorPalette) {
        if (colorPalette == null) {
            throw new ArgumentNullException("colorPalette");
        }
        int[] nArray = colorPalette.getArgb32Entries();
        this.a = PsdColorPalette.a(nArray);
        IPsdColorPalette iPsdColorPalette = (IPsdColorPalette)((Object)com.aspose.imaging.internal.dO.d.a(colorPalette, IPsdColorPalette.class));
        if (iPsdColorPalette != null && iPsdColorPalette.hasTransparentColor()) {
            this.b = iPsdColorPalette.getTransparentIndex();
            this.c = true;
        }
        this.d = new w(nArray);
        this.e = colorPalette.isCompactPalette();
    }

    public PsdColorPalette(IColorPalette colorPalette, short transparentIndex) {
        this(colorPalette);
        if (PsdColorPalette.a(transparentIndex, this.a)) {
            this.b = transparentIndex;
            this.c = true;
        }
    }

    public PsdColorPalette(byte[] rawEntriesData, boolean isCompactPalette) {
        if (rawEntriesData == null) {
            throw new ArgumentNullException("rawEntriesData");
        }
        this.a = rawEntriesData;
        this.d = new w(this.getArgb32Entries());
        this.e = isCompactPalette;
    }

    public PsdColorPalette(byte[] rawEntriesData) {
        this(rawEntriesData, false);
    }

    public PsdColorPalette(byte[] rawEntriesData, short transparentIndex, boolean useCompactPalette) {
        this(rawEntriesData, useCompactPalette);
        if (PsdColorPalette.a(transparentIndex, this.a)) {
            this.b = transparentIndex;
            this.c = true;
        }
    }

    public PsdColorPalette(byte[] rawEntriesData, short transparentIndex) {
        this(rawEntriesData, transparentIndex, false);
    }

    public PsdColorPalette(int[] colorPaletteArgb32Entries, boolean isCompactPalette) {
        if (colorPaletteArgb32Entries == null) {
            throw new ArgumentNullException("colorPaletteArgb32Entries");
        }
        this.a = PsdColorPalette.a(colorPaletteArgb32Entries);
        this.d = new w(colorPaletteArgb32Entries);
        this.e = isCompactPalette;
    }

    public PsdColorPalette(Color[] colorPaletteEntries, boolean isCompactPalette) {
        this(g.a(colorPaletteEntries), isCompactPalette);
    }

    public PsdColorPalette(Color[] colorPaletteEntries) {
        this(colorPaletteEntries, false);
    }

    public PsdColorPalette(Color[] colorPaletteEntries, short transparentIndex, boolean useCompactPalette) {
        this(colorPaletteEntries, useCompactPalette);
        if (PsdColorPalette.a(transparentIndex, this.a)) {
            this.b = transparentIndex;
            this.c = true;
        }
    }

    public PsdColorPalette(Color[] colorPaletteEntries, short transparentIndex) {
        this(colorPaletteEntries, transparentIndex, false);
    }

    @Override
    public int getRawEntriesCount() {
        return this.a.length;
    }

    @Override
    public int getEntriesCount() {
        return this.a.length / 3;
    }

    @Override
    public int[] getArgb32Entries() {
        int n2 = this.a.length / 3;
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = 0xFF000000 | com.aspose.imaging.internal.dO.d.e((Object)this.a[i2], 6) << 16 | com.aspose.imaging.internal.dO.d.e((Object)this.a[n2 + i2], 6) << 8 | com.aspose.imaging.internal.dO.d.e((Object)this.a[n2 * 2 + i2], 6);
        }
        return nArray;
    }

    @Override
    public Color[] getEntries() {
        int n2 = this.a.length / 3;
        Color[] colorArray = (Color[])com.aspose.imaging.internal.ap.g.a(com.aspose.imaging.internal.ap.g.a(com.aspose.imaging.internal.dO.d.a(Color.class), n2));
        for (int i2 = 0; i2 < n2; ++i2) {
            Color color = Color.fromArgb(com.aspose.imaging.internal.dO.d.e((Object)this.a[i2], 6), com.aspose.imaging.internal.dO.d.e((Object)this.a[n2 + i2], 6), com.aspose.imaging.internal.dO.d.e((Object)this.a[n2 * 2 + i2], 6)).Clone();
            color.CloneTo(colorArray[i2]);
        }
        return colorArray;
    }

    @Override
    public short getTransparentIndex() {
        return this.b;
    }

    @Override
    public boolean hasTransparentColor() {
        return this.c;
    }

    @Override
    public Color getTransparentColor() {
        Color color = Color.getEmpty();
        if (this.c) {
            int n2 = this.a.length / 3;
            Color.fromArgb(com.aspose.imaging.internal.dO.d.e((Object)this.a[this.b], 6), com.aspose.imaging.internal.dO.d.e((Object)this.a[n2 + this.b], 6), com.aspose.imaging.internal.dO.d.e((Object)this.a[n2 * 2 + this.b], 6)).CloneTo(color);
        }
        return color;
    }

    @Override
    public byte[] getRawEntries() {
        return this.a;
    }

    @Override
    public boolean isCompactPalette() {
        return this.e;
    }

    public static PsdColorPalette copyPalette(IColorPalette colorPalette, boolean useCompactPalette) {
        PsdColorPalette psdColorPalette = null;
        if (com.aspose.imaging.internal.dO.d.b((Object)colorPalette, IPsdColorPalette.class)) {
            IPsdColorPalette iPsdColorPalette = (IPsdColorPalette)((Object)com.aspose.imaging.internal.dO.d.a(colorPalette, IPsdColorPalette.class));
            byte[] byArray = new byte[iPsdColorPalette.getRawEntriesCount()];
            com.aspose.imaging.internal.ap.g.a((Object)iPsdColorPalette.getRawEntries()).copyTo(com.aspose.imaging.internal.ap.g.a((Object)byArray), 0);
            psdColorPalette = iPsdColorPalette.hasTransparentColor() ? new PsdColorPalette(byArray, iPsdColorPalette.getTransparentIndex(), useCompactPalette) : new PsdColorPalette(byArray, useCompactPalette);
        } else if (colorPalette != null) {
            int[] nArray = new int[colorPalette.getEntriesCount()];
            com.aspose.imaging.internal.ap.g.a((Object)colorPalette.getArgb32Entries()).copyTo(com.aspose.imaging.internal.ap.g.a((Object)nArray), 0);
            psdColorPalette = new PsdColorPalette(nArray, useCompactPalette);
        }
        return psdColorPalette;
    }

    public static PsdColorPalette copyPalette(IColorPalette colorPalette) {
        return PsdColorPalette.copyPalette(colorPalette, colorPalette != null ? colorPalette.isCompactPalette() : false);
    }

    @Override
    public int getNearestColorIndex(int argb32Color) {
        int n2 = this.c && argb32Color == 0 ? this.b : this.d.a(argb32Color);
        return n2;
    }

    @Override
    public int getNearestColorIndex(Color color) {
        return this.getNearestColorIndex(color.toArgb());
    }

    @Override
    public int getArgb32Color(int index) {
        int n2 = this.a.length / 3;
        if (index >= n2 || index < 0) {
            throw new ArgumentOutOfRangeException("index", "The specified index lies out of the entries length.");
        }
        int n3 = !this.c || this.b != index ? 0xFF000000 | com.aspose.imaging.internal.dO.d.e((Object)this.a[index], 6) << 16 | com.aspose.imaging.internal.dO.d.e((Object)this.a[n2 + index], 6) << 8 | com.aspose.imaging.internal.dO.d.e((Object)this.a[n2 * 2 + index], 6) : 0;
        return n3;
    }

    @Override
    public Color getColor(int index) {
        return Color.fromArgb(this.getArgb32Color(index));
    }

    @Override
    public int getTransparentArgbColor() {
        int n2 = 0;
        if (this.c) {
            int n3 = this.a.length / 3;
            n2 = 0xFF000000 | (256 + this.a[this.b] & 0xFF) << 16 | (256 + this.a[n3 + this.b] & 0xFF) << 8 | 256 + this.a[n3 * 2 + this.b] & 0xFF;
        }
        return n2;
    }

    private static boolean a(short s2, byte[] byArray) {
        int n2 = byArray.length / 3;
        return s2 >= 0 && s2 < n2;
    }

    private static byte[] a(int[] nArray) {
        int n2 = nArray.length * 3;
        byte[] byArray = new byte[n2];
        int n3 = nArray.length;
        int n4 = n3 * 2;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n5 = nArray[i2];
            byte by2 = (byte)(n5 >> 16 & 0xFF);
            byte by3 = (byte)(n5 >> 8 & 0xFF);
            byte by4 = (byte)(n5 & 0xFF);
            byArray[i2] = by2;
            byArray[i2 + n3] = by3;
            byArray[i2 + n4] = by4;
        }
        return byArray;
    }
}

