/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.fileformats.psd;

import com.aspose.imaging.Color;
import com.aspose.imaging.IColorPalette;
import com.aspose.imaging.IPsdColorPalette;
import com.aspose.imaging.ImageResizeSettings;
import com.aspose.imaging.LoadOptions;
import com.aspose.imaging.RasterCachedImage;
import com.aspose.imaging.RasterImage;
import com.aspose.imaging.Rectangle;
import com.aspose.imaging.StreamContainer;
import com.aspose.imaging.coreexceptions.imageformats.PsdImageException;
import com.aspose.imaging.fileformats.psd.ResourceBlock;
import com.aspose.imaging.fileformats.psd.layers.GlobalLayerMaskInfo;
import com.aspose.imaging.fileformats.psd.layers.Layer;
import com.aspose.imaging.fileformats.psd.layers.LayerResource;
import com.aspose.imaging.fileformats.psd.layers.layerresources.Txt2Resource;
import com.aspose.imaging.fileformats.psd.resources.FixedPointDecimal;
import com.aspose.imaging.fileformats.psd.resources.IccProfileResource;
import com.aspose.imaging.fileformats.psd.resources.ResolutionInfoResource;
import com.aspose.imaging.fileformats.psd.resources.XmpResource;
import com.aspose.imaging.imagefilters.filteroptions.FilterOptionsBase;
import com.aspose.imaging.imageoptions.PsdOptions;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.NullReferenceException;
import com.aspose.imaging.internal.ap.bF;
import com.aspose.imaging.internal.dP.aL;
import com.aspose.imaging.internal.dP.aM;
import com.aspose.imaging.internal.dP.ad;
import com.aspose.imaging.internal.dU.k;
import com.aspose.imaging.internal.ea.E;
import com.aspose.imaging.internal.fI.d;
import com.aspose.imaging.internal.fI.h;
import com.aspose.imaging.internal.fI.w;
import com.aspose.imaging.internal.fI.x;
import com.aspose.imaging.internal.fS.a;
import com.aspose.imaging.internal.fS.b;
import com.aspose.imaging.internal.fS.c;
import com.aspose.imaging.internal.fS.g;
import com.aspose.imaging.sources.StreamSource;
import com.aspose.imaging.system.collections.Generic.List;
import com.aspose.imaging.system.io.Stream;
import com.aspose.imaging.xmp.XmpPacketWrapper;
import java.io.InputStream;

public final class PsdImage
extends RasterCachedImage {
    public static final int DEFAULT_VERSION = 6;
    private g e;
    private a f;
    private c g;
    private com.aspose.imaging.internal.fS.d h;
    private b i;
    private int j;
    private boolean k;
    private Layer l;
    private StreamSource m;
    private StreamSource n;

    public PsdImage(String path) {
        this(path, 3, 8, 4, 6, 0);
    }

    public PsdImage(String path, short colorMode, short channelBitDepth, short channels, int psdVersion, short compression) {
        this.a(new aM(path), colorMode, channelBitDepth, channels, psdVersion, compression);
    }

    public PsdImage(InputStream stream) {
        this(Stream.fromJava(stream));
    }

    PsdImage(Stream stream) {
        this(stream, 3, 8, 4, 6, 0);
    }

    public PsdImage(InputStream stream, short colorMode, short channelBitDepth, short channels, int psdVersion, short compression) {
        this(Stream.fromJava(stream), colorMode, channelBitDepth, channels, psdVersion, compression);
    }

    PsdImage(Stream stream, short colorMode, short channelBitDepth, short channels, int psdVersion, short compression) {
        this.a(new aM(stream), colorMode, channelBitDepth, channels, psdVersion, compression);
    }

    public PsdImage(RasterImage rasterImage) {
        this(rasterImage, 3, 8, 4, 6, 0);
    }

    public PsdImage(RasterImage rasterImage, short colorMode, short channelBitDepth, short channels, int psdVersion, short compression) {
        this.a(new aM(rasterImage), colorMode, channelBitDepth, channels, psdVersion, compression);
    }

    public PsdImage(int width, int height) {
        this(width, height, null, 3, 8, 4, 6, 0);
    }

    public PsdImage(int width, int height, IColorPalette colorPalette, short colorMode, short channelBitDepth, short channels, int psdVersion, short compression) {
        this.a(width, height, colorPalette, colorMode, channelBitDepth, channels, psdVersion, compression);
    }

    private PsdImage(g psdHeader, a colorData, c imageResources, com.aspose.imaging.internal.fS.d layerAndMaskInfo, b imageData, IColorPalette colorPalette, int version, LoadOptions loadOptions, boolean noLayerLoad) {
        super(colorPalette);
        if (psdHeader == null) {
            throw new ArgumentNullException("psdHeader");
        }
        if (colorData == null) {
            throw new ArgumentNullException("colorData");
        }
        if (imageResources == null) {
            throw new ArgumentNullException("imageResources");
        }
        if (layerAndMaskInfo == null) {
            throw new ArgumentNullException("layerAndMaskInfo");
        }
        if (imageData == null) {
            throw new ArgumentNullException("imageData");
        }
        this.a(psdHeader);
        this.f = colorData;
        this.g = imageResources;
        this.h = layerAndMaskInfo;
        this.i = imageData;
        this.j = version;
        if (this.h.d().length > 0) {
            for (int i2 = 0; i2 < this.h.d().length; ++i2) {
                this.h.d()[i2].a(this);
            }
            this.setActiveLayer(this.h.d()[0]);
        }
        if (this.g != null && this.g.b() != null) {
            for (ResourceBlock resourceBlock : this.g.b()) {
                Object object;
                IccProfileResource iccProfileResource = (IccProfileResource)((Object)com.aspose.imaging.internal.dO.d.a(resourceBlock, IccProfileResource.class));
                if (iccProfileResource != null) {
                    object = iccProfileResource.a();
                    if (this.i().i() == 4 && aL.a((Stream)object)) {
                        this.n = new StreamSource((Stream)object);
                        this.m = ad.b();
                        continue;
                    }
                    if (this.i().i() != 3 || !aL.b((Stream)object)) continue;
                    this.m = new StreamSource((Stream)object);
                    this.n = ad.a();
                    continue;
                }
                object = (XmpResource)((Object)com.aspose.imaging.internal.dO.d.a(resourceBlock, XmpResource.class));
                if (object == null) continue;
                this.xmpData = ((XmpResource)object).getXmpData();
            }
        }
        d d2 = this.i.a(this.n, this.m, loadOptions);
        if (noLayerLoad) {
            if (d2 != null) {
                this.setDataLoader(d2);
            }
        } else if (d2 != null) {
            this.setDataLoader(new E.b(this));
        }
    }

    @Override
    public XmpPacketWrapper getXmpData() {
        return this.xmpData;
    }

    @Override
    public void setXmpData(XmpPacketWrapper value) {
        this.xmpData = value;
    }

    @Override
    public double getVerticalResolution() {
        ResolutionInfoResource resolutionInfoResource = this.l();
        if (resolutionInfoResource != null) {
            return resolutionInfoResource.getVDpi().toDouble();
        }
        throw new PsdImageException("ResolutionInfo resource not found and can not get proper resolution");
    }

    @Override
    public void setVerticalResolution(double value) {
        ResolutionInfoResource resolutionInfoResource = this.l();
        if (resolutionInfoResource == null) {
            throw new PsdImageException("ResolutionInfo resource not found and can not set proper resolution");
        }
        resolutionInfoResource.setVDpi(new FixedPointDecimal(value));
    }

    @Override
    public double getHorizontalResolution() {
        ResolutionInfoResource resolutionInfoResource = this.l();
        if (resolutionInfoResource != null) {
            return resolutionInfoResource.getHDpi().toDouble();
        }
        throw new PsdImageException("ResolutionInfo resource not found and can not get proper resolution");
    }

    @Override
    public void setHorizontalResolution(double value) {
        ResolutionInfoResource resolutionInfoResource = this.l();
        if (resolutionInfoResource == null) {
            throw new PsdImageException("ResolutionInfo resource not found and can not set proper resolution");
        }
        resolutionInfoResource.setHDpi(new FixedPointDecimal(value));
    }

    public StreamSource getRgbColorProfile() {
        return this.m;
    }

    public void setRgbColorProfile(StreamSource value) {
        this.m = value;
    }

    public StreamSource getCmykColorProfile() {
        return this.n;
    }

    public void setCmykColorProfile(StreamSource value) {
        this.n = value;
    }

    public short getColorMode() {
        return this.i().i();
    }

    public void setColorMode(short value) {
        this.i().c(value);
    }

    public short getCompression() {
        return this.i.a();
    }

    public int getChannelsCount() {
        return this.i().e();
    }

    public int getBitsPerChannel() {
        return this.i().h();
    }

    public ResourceBlock[] getImageResources() {
        return this.g.b();
    }

    public void setImageResources(ResourceBlock[] value) {
        this.g.a(value);
    }

    public int getVersion() {
        return this.j;
    }

    public void setVersion(int value) {
        this.j = value;
    }

    @Override
    public int getWidth() {
        return this.i().g();
    }

    @Override
    public int getHeight() {
        return this.i().f();
    }

    @Override
    public int getBitsPerPixel() {
        return bF.d(this.i().e() * this.i().h(), 32);
    }

    public Layer[] getLayers() {
        return this.h.d();
    }

    public void setLayers(Layer[] value) {
        this.h.a(value);
        if (value == null) {
            this.setDataLoader(this.i.a(this.n, this.m, null));
        }
    }

    public LayerResource[] getGlobalLayerResources() {
        return this.h.e();
    }

    public void setGlobalLayerResources(LayerResource[] value) {
        this.h.a(value);
    }

    public GlobalLayerMaskInfo getGlobalLayerMaskInfo() {
        return this.h.f();
    }

    public boolean hasTransparencyData() {
        return this.h.g();
    }

    public void setTransparencyData(boolean value) {
        this.h.a(value);
    }

    public Layer getActiveLayer() {
        this.verifyNotDisposed();
        if (this.l == null) {
            if (this.h.d().length > 0) {
                this.l = this.h.d()[0];
            } else {
                throw new PsdImageException("There is no active layer and no layers in image. Please note: indexed and duatone psd images do not conatin layers at all.");
            }
        }
        return this.l;
    }

    public void setActiveLayer(Layer value) {
        this.verifyNotDisposed();
        if (value != null && value.getContainer() != this) {
            throw new PsdImageException("The active layer cannot be set as it belongs to another image.");
        }
        this.l = value;
    }

    public boolean isFlatten() {
        if (this.getLayers() != null) {
            return this.getLayers().length == 1 || this.getLayers().length == 0;
        }
        return false;
    }

    public com.aspose.imaging.internal.fS.d h() {
        return this.h;
    }

    public g i() {
        return this.e;
    }

    public void a(g g2) {
        this.e = g2;
    }

    @Override
    public void rotate(float angle) {
        this.verifyNotDisposed();
        if (this.getLayers() != null && this.getLayers().length > 0) {
            int n2 = this.e.g();
            int n3 = this.e.f();
            for (int i2 = 0; i2 < this.getLayers().length; ++i2) {
                this.getLayers()[i2].rotate(angle);
                if (this.getLayers()[i2].getWidth() > n2) {
                    n2 = this.getLayers()[i2].getWidth();
                }
                if (this.getLayers()[i2].getHeight() <= n3) continue;
                n3 = this.getLayers()[i2].getHeight();
            }
            this.b(n2, n3);
        }
    }

    @Override
    public void rotate(float angle, boolean resizeProportionally, Color backgroundColor) {
        this.verifyNotDisposed();
        if (this.getLayers() != null && this.getLayers().length > 0) {
            int n2 = this.e.g();
            int n3 = this.e.f();
            for (int i2 = 0; i2 < this.getLayers().length; ++i2) {
                this.getLayers()[i2].rotate(angle, resizeProportionally, backgroundColor.Clone());
                if (this.getLayers()[i2].getWidth() > n2) {
                    n2 = this.getLayers()[i2].getWidth();
                }
                if (this.getLayers()[i2].getHeight() <= n3) continue;
                n3 = this.getLayers()[i2].getHeight();
            }
            this.b(n2, n3);
        }
    }

    @Override
    public void crop(Rectangle rectangle) {
        this.verifyNotDisposed();
        if (this.getLayers() != null && this.getLayers().length > 0) {
            for (int i2 = 0; i2 < this.getLayers().length; ++i2) {
                this.getLayers()[i2].crop(rectangle.Clone());
            }
            this.b(rectangle.getWidth(), rectangle.getHeight());
        }
    }

    @Override
    public void resizeHeightProportionally(int newHeight, ImageResizeSettings settings) {
        this.verifyNotDisposed();
        if (this.getLayers() != null && this.getLayers().length > 0) {
            int n2 = this.e.g();
            for (int i2 = 0; i2 < this.getLayers().length; ++i2) {
                this.getLayers()[i2].resizeHeightProportionally(newHeight, settings);
                if (this.getLayers()[i2].getWidth() <= n2) continue;
                n2 = this.getLayers()[i2].getWidth();
            }
            this.b(n2, newHeight);
        }
    }

    @Override
    public void resizeHeightProportionally(int newHeight, int resizeType) {
        this.verifyNotDisposed();
        if (this.getLayers() != null && this.getLayers().length > 0) {
            int n2 = this.e.g();
            for (int i2 = 0; i2 < this.getLayers().length; ++i2) {
                this.getLayers()[i2].resizeHeightProportionally(newHeight, resizeType);
                if (this.getLayers()[i2].getWidth() <= n2) continue;
                n2 = this.getLayers()[i2].getWidth();
            }
            this.b(n2, newHeight);
        }
    }

    @Override
    public void resizeWidthProportionally(int newWidth, ImageResizeSettings settings) {
        this.verifyNotDisposed();
        if (this.getLayers() != null && this.getLayers().length > 0) {
            int n2 = this.e.f();
            for (int i2 = 0; i2 < this.getLayers().length; ++i2) {
                this.getLayers()[i2].resizeWidthProportionally(newWidth, settings);
                if (this.getLayers()[i2].getHeight() <= n2) continue;
                n2 = this.getLayers()[i2].getHeight();
            }
            this.b(newWidth, n2);
        }
    }

    @Override
    public void resizeWidthProportionally(int newWidth, int resizeType) {
        this.verifyNotDisposed();
        if (this.getLayers() != null && this.getLayers().length > 0) {
            int n2 = this.e.f();
            for (int i2 = 0; i2 < this.getLayers().length; ++i2) {
                this.getLayers()[i2].resizeWidthProportionally(newWidth, resizeType);
                if (this.getLayers()[i2].getHeight() <= n2) continue;
                n2 = this.getLayers()[i2].getHeight();
            }
            this.b(newWidth, n2);
        }
    }

    @Override
    public void dither(int ditheringMethod, int bitsCount, IColorPalette customPalette) {
        this.verifyNotDisposed();
        if (this.e.i() == 2 || this.e.i() == 8 || this.getLayers().length == 0) {
            super.dither(ditheringMethod, bitsCount);
            return;
        }
        Layer[] layerArray = this.getLayers();
        for (int i2 = 0; i2 < layerArray.length; ++i2) {
            layerArray[i2].dither(ditheringMethod, bitsCount, customPalette);
        }
    }

    @Override
    public void binarizeOtsu() {
        this.verifyNotDisposed();
        if (this.e.i() == 2 || this.e.i() == 8 || this.getLayers().length == 0) {
            super.binarizeOtsu();
            return;
        }
        Layer[] layerArray = this.getLayers();
        for (int i2 = 0; i2 < layerArray.length; ++i2) {
            layerArray[i2].binarizeOtsu();
        }
    }

    @Override
    public void binarizeBradley(double brightnessDifference) {
        this.verifyNotDisposed();
        if (this.e.i() == 2 || this.e.i() == 8 || this.getLayers().length == 0) {
            super.binarizeBradley(brightnessDifference);
            return;
        }
        Layer[] layerArray = this.getLayers();
        for (int i2 = 0; i2 < layerArray.length; ++i2) {
            layerArray[i2].binarizeBradley(brightnessDifference);
        }
    }

    @Override
    public void adjustBrightness(int brightness) {
        Layer[] layerArray;
        this.verifyNotDisposed();
        if (this.e.i() == 2 || this.e.i() == 8 || this.getLayers().length == 0) {
            super.adjustBrightness(brightness);
            return;
        }
        for (Layer layer : layerArray = this.getLayers()) {
            layer.adjustBrightness(brightness);
        }
    }

    @Override
    public void adjustGamma(float gamma) {
        Layer[] layerArray;
        this.verifyNotDisposed();
        if (this.e.i() == 2 || this.e.i() == 8 || this.getLayers().length == 0) {
            super.adjustGamma(gamma);
            return;
        }
        for (Layer layer : layerArray = this.getLayers()) {
            layer.adjustGamma(gamma);
        }
    }

    @Override
    public void adjustContrast(float contrast) {
        Layer[] layerArray;
        this.verifyNotDisposed();
        if (this.e.i() == 2 || this.e.i() == 8 || this.getLayers().length == 0) {
            super.adjustContrast(contrast);
            return;
        }
        for (Layer layer : layerArray = this.getLayers()) {
            layer.adjustContrast(contrast);
        }
    }

    @Override
    public void adjustGamma(float gammaRed, float gammaGreen, float gammaBlue) {
        Layer[] layerArray;
        this.verifyNotDisposed();
        if (this.e.i() == 2 || this.e.i() == 8 || this.getLayers().length == 0) {
            super.adjustGamma(gammaRed, gammaGreen, gammaBlue);
            return;
        }
        for (Layer layer : layerArray = this.getLayers()) {
            layer.adjustGamma(gammaRed, gammaGreen, gammaBlue);
        }
    }

    @Override
    public void binarizeFixed(byte threshold) {
        Layer[] layerArray;
        this.verifyNotDisposed();
        if (this.e.i() == 2 || this.e.i() == 8 || this.getLayers().length == 0) {
            super.binarizeFixed(threshold);
            return;
        }
        for (Layer layer : layerArray = this.getLayers()) {
            layer.binarizeFixed(threshold);
        }
    }

    @Override
    public void grayscale() {
        Layer[] layerArray;
        this.verifyNotDisposed();
        if (this.e.i() == 2 || this.e.i() == 8 || this.getLayers().length == 0) {
            super.grayscale();
            return;
        }
        for (Layer layer : layerArray = this.getLayers()) {
            layer.grayscale();
        }
    }

    @Override
    public void filter(Rectangle rectangle, FilterOptionsBase options) {
        Layer[] layerArray;
        this.verifyNotDisposed();
        if (this.e.i() == 2 || this.e.i() == 8 || this.getLayers().length == 0) {
            super.filter(rectangle.Clone(), options);
            return;
        }
        for (Layer layer : layerArray = this.getLayers()) {
            layer.filter(rectangle.Clone(), options);
        }
    }

    public void j() {
        if (this.getGlobalLayerResources() != null) {
            int n2 = -1;
            for (int i2 = 0; i2 < this.getGlobalLayerResources().length; ++i2) {
                if (!com.aspose.imaging.internal.dO.d.b((Object)this.getGlobalLayerResources()[i2], Txt2Resource.class)) continue;
                n2 = i2;
            }
            if (n2 != -1) {
                LayerResource[] layerResourceArray = new LayerResource[this.getGlobalLayerResources().length - 1];
                int n3 = 0;
                for (int i3 = 0; i3 < this.getGlobalLayerResources().length; ++i3) {
                    if (i3 == n2) continue;
                    layerResourceArray[n3++] = this.getGlobalLayerResources()[i3];
                }
                this.setGlobalLayerResources(layerResourceArray);
            } else {
                throw new PsdImageException("Can not remove txt2 resource, because it is not presented in Global layer resources");
            }
        }
    }

    public static PsdImage a(g g2, a a2, c c2, com.aspose.imaging.internal.fS.d d2, b b2, IColorPalette iColorPalette, int n2, LoadOptions loadOptions, boolean bl2) {
        return new PsdImage(g2, a2, c2, d2, b2, iColorPalette, n2, loadOptions, bl2);
    }

    public PsdOptions k() {
        PsdOptions psdOptions = new PsdOptions();
        psdOptions.setPalette(this.getPalette());
        if (this.e == null) {
            throw new NullReferenceException("Can not get correct options, as header is not initialized");
        }
        psdOptions.setChannelBitsCount(this.e.h());
        psdOptions.setChannelsCount(this.e.e());
        psdOptions.setColorMode(this.e.i());
        psdOptions.setVersion(this.e.a());
        psdOptions.setCompressionMethod(this.getCompression());
        psdOptions.setResources(this.getImageResources());
        return psdOptions;
    }

    @Override
    protected void releaseManagedResources() {
        this.f = null;
        this.a((g)null);
        this.g = null;
        this.h = null;
        this.i = null;
        super.releaseManagedResources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void saveData(Stream stream) {
        this.updateMetadata();
        StreamContainer streamContainer = new StreamContainer(stream);
        try {
            Object object;
            IColorPalette iColorPalette = this.getPalette();
            if (iColorPalette != null && this.k != iColorPalette.isCompactPalette()) {
                this.b(iColorPalette);
            }
            if (this.xmpData != null) {
                object = new XmpResource();
                ((XmpResource)object).setXmpData(this.xmpData);
                this.setImageResources(PsdImage.a(this.getImageResources(), (ResourceBlock)object, true));
            }
            this.i().c(streamContainer);
            this.f.b(streamContainer);
            this.g.a(streamContainer, this.j);
            this.h.a(streamContainer, this.j, this.i().h(), iColorPalette, this.i());
            this.i.a(streamContainer);
            object = new x(this.i().i(), this.i.a(), this.i().h());
            h h2 = w.a((x)object, streamContainer, streamContainer.getPosition(), this.i(), this.getPalette());
            try {
                E.d d2 = new E.d(this, h2);
                this.loadPartialArgb32Pixels(this.getBounds().Clone(), d2);
                streamContainer.setLength(h2.c());
            }
            finally {
                if (h2 != null) {
                    h2.dispose();
                }
            }
        }
        finally {
            if (streamContainer != null) {
                streamContainer.dispose();
            }
        }
    }

    @Override
    protected void updateDimensions(int newWidth, int newHeight) {
        this.e.b(newWidth);
        this.e.a(newHeight);
    }

    @Override
    protected void onPaletteChanged(IColorPalette oldPalette, IColorPalette newPalette) {
        this.b(newPalette);
        super.onPaletteChanged(oldPalette, newPalette);
    }

    public static ResourceBlock[] a(ResourceBlock[] resourceBlockArray, ResourceBlock resourceBlock, boolean bl2) {
        if (resourceBlockArray == null) {
            throw new ArgumentNullException("resources");
        }
        List<ResourceBlock> list = new List<ResourceBlock>();
        if (resourceBlock != null) {
            for (ResourceBlock resourceBlock2 : resourceBlockArray) {
                if (bl2 && resourceBlock.getID() == resourceBlock2.getID()) continue;
                list.addItem(resourceBlock2);
            }
            list.addItem(resourceBlock);
        }
        return list.toArray(new ResourceBlock[0]);
    }

    private void a(aM aM2, short s2, short s3, short s4, int n2, short s5) {
        try {
            IColorPalette iColorPalette = aM2.a().getPalette();
            if ((s2 == 2 || s2 == 8) && iColorPalette == null) {
                throw new PsdImageException("Cannot create a new indexed or duotone PSD image while palette is not specified.");
            }
            this.a(new g());
            this.i().b(s3);
            this.i().a(s4);
            this.i().c(s2);
            this.i().a(aM2.a().getHeight());
            this.i().b(aM2.a().getWidth());
            this.i().j();
            this.f = new a();
            if (s2 == 2 || s2 == 8) {
                IPsdColorPalette iPsdColorPalette = com.aspose.imaging.internal.dU.k.a(iColorPalette);
                this.f.a(iPsdColorPalette.getRawEntries());
                iColorPalette = iPsdColorPalette;
            }
            this.g = new c();
            this.g.a(com.aspose.imaging.internal.dU.k.a(this.g.b(), iColorPalette, n2).toArray((ResourceBlock[])new ResourceBlock[0]));
            this.h = new com.aspose.imaging.internal.fS.d();
            this.i = new b();
            this.i.a(s5);
            this.j = n2;
            this.setDataLoader(aM2);
            this.setPalette(aM2.a().getPalette());
        }
        catch (RuntimeException runtimeException) {
            aM2.dispose();
            throw runtimeException;
        }
    }

    private void b(int n2, int n3) {
        this.e.b(n2);
        this.e.a(n3);
        this.setDataLoader(new E.b(this));
    }

    private void a(int n2, int n3, IColorPalette iColorPalette, short s2, short s3, short s4, int n4, short s5) {
        if ((s2 == 2 || s2 == 8) && iColorPalette == null) {
            throw new PsdImageException("Cannot create a new indexed or duotone PSD image while palette is not specified.");
        }
        IColorPalette iColorPalette2 = iColorPalette;
        this.a(new g());
        this.i().b(s3);
        this.i().a(s4);
        this.i().c(s2);
        this.i().a(n3);
        this.i().b(n2);
        this.i().j();
        this.f = new a();
        if (s2 == 2 || s2 == 8) {
            IPsdColorPalette iPsdColorPalette = com.aspose.imaging.internal.dU.k.a(iColorPalette);
            this.f.a(iPsdColorPalette.getRawEntries());
            iColorPalette2 = iPsdColorPalette;
        }
        this.g = new c();
        this.g.a(com.aspose.imaging.internal.dU.k.a(this.g.b(), iColorPalette2, n4).toArray((ResourceBlock[])new ResourceBlock[0]));
        this.h = new com.aspose.imaging.internal.fS.d();
        this.i = new b();
        this.i.a(s5);
        this.j = n4;
    }

    private ResolutionInfoResource l() {
        ResolutionInfoResource resolutionInfoResource = null;
        for (ResourceBlock resourceBlock : this.g.b()) {
            if (!com.aspose.imaging.internal.dO.d.b((Object)resourceBlock, ResolutionInfoResource.class)) continue;
            resolutionInfoResource = (ResolutionInfoResource)resourceBlock;
            break;
        }
        return resolutionInfoResource;
    }

    private void b(IColorPalette iColorPalette) {
        IPsdColorPalette iPsdColorPalette = null;
        if (iColorPalette != null) {
            iPsdColorPalette = com.aspose.imaging.internal.dU.k.a(iColorPalette);
            this.k = iColorPalette.isCompactPalette();
        }
        List<ResourceBlock> list = com.aspose.imaging.internal.dU.k.a(this.g.b(), iPsdColorPalette, this.j);
        byte[] byArray = iPsdColorPalette == null ? new byte[]{} : iPsdColorPalette.getRawEntries();
        this.g.a(list.toArray((ResourceBlock[])new ResourceBlock[0]));
        this.f.a(byArray);
    }
}

