/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.fileformats.tiff;

import com.aspose.imaging.coreexceptions.ImageSaveException;
import com.aspose.imaging.coreexceptions.imageformats.TiffImageException;
import com.aspose.imaging.fileformats.tiff.enums.TiffDataTypes;
import com.aspose.imaging.fileformats.tiff.enums.TiffTags;
import com.aspose.imaging.fileformats.tiff.filemanagement.TiffStreamReader;
import com.aspose.imaging.fileformats.tiff.filemanagement.TiffStreamWriter;
import com.aspose.imaging.fileformats.tiff.instancefactory.TiffTagFactory;
import com.aspose.imaging.fileformats.tiff.tifftagtypes.TiffUnknownType;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.ap.aY;
import com.aspose.imaging.internal.ap.bj;
import com.aspose.imaging.internal.ap.g;
import com.aspose.imaging.internal.be.A;
import com.aspose.imaging.internal.dO.d;
import com.aspose.imaging.internal.dP.as;
import com.aspose.imaging.system.Enum;

public abstract class TiffDataType
implements Comparable<TiffDataType> {
    private int a;

    protected TiffDataType(int tagId) {
        this.a = tagId;
    }

    public abstract long getCount();

    public int getId() {
        return this.a;
    }

    public int getTagId() {
        return d.e((Object)this.a, 8);
    }

    public abstract int getTagType();

    public long getAlignedDataSize() {
        return as.a(this.getDataSize());
    }

    public abstract long getDataSize();

    public abstract Object getValue();

    public abstract void setValue(Object var1);

    public boolean isValid() {
        return d.f((Object)this.getCount(), 10) > 0L;
    }

    public boolean a() {
        return d.d((Object)this.a, 8) > 32768;
    }

    public static TiffDataType readTag(TiffStreamReader dataStream, long position) {
        if (dataStream == null) {
            throw new ArgumentNullException("dataStream");
        }
        int[] nArray = dataStream.readUShortArray(position, 2L);
        int n2 = nArray[0];
        int n3 = nArray[1];
        long l2 = dataStream.readULong(position += 4L);
        position += 4L;
        TiffDataType tiffDataType = TiffTagFactory.createInstance(n3, n2);
        if (tiffDataType == null) {
            long l3 = dataStream.readULong(position);
            tiffDataType = new TiffUnknownType(dataStream, n3, n2, l2, l3);
        }
        tiffDataType.a = n2;
        if (!d.b((Object)tiffDataType, TiffUnknownType.class)) {
            tiffDataType.readData(dataStream, position, d.g(l2, 10));
        }
        return tiffDataType;
    }

    @Override
    public int compareTo(TiffDataType obj) {
        if (!d.b((Object)obj, TiffDataType.class)) {
            throw new TiffImageException("Expected TiffDataType type.");
        }
        TiffDataType tiffDataType = obj;
        return d.e((Object)this.a, 8) - d.e((Object)tiffDataType.a, 8);
    }

    public int hashCode() {
        return this.a;
    }

    public boolean equals(Object obj) {
        if (!d.b(obj, TiffDataType.class)) {
            throw new TiffImageException("Expected TiffDataType type.");
        }
        TiffDataType tiffDataType = (TiffDataType)obj;
        return this.a == tiffDataType.a;
    }

    public TiffDataType deepClone() {
        TiffDataType tiffDataType = this.createInstance();
        this.copyInstanceData(tiffDataType);
        return tiffDataType;
    }

    public void writeTag(TiffStreamWriter dataStream, long additionalDataOffset) {
        if (dataStream == null) {
            throw new ArgumentNullException("dataStream");
        }
        try {
            dataStream.writeUShort(this.a);
            dataStream.writeUShort(this.getTagType());
            long l2 = this.getCount();
            dataStream.writeULong(l2);
            this.writeTagValueOrOffset(dataStream, additionalDataOffset);
        }
        catch (RuntimeException runtimeException) {
            throw new ImageSaveException(aY.a("Unable to Write values for ", Enum.getName(TiffDataTypes.class, this.getTagType()), " Message : ", runtimeException.getMessage()));
        }
    }

    public abstract long writeAdditionalData(TiffStreamWriter var1);

    public String toString() {
        String string = null;
        Object object = this.getValue();
        if (d.b(object, g.class)) {
            A a2 = new A();
            a2.a('{');
            g g2 = (g)((Object)d.a(object, g.class));
            for (int i2 = 0; i2 < g2.g(); ++i2) {
                if (i2 < g2.g() - 1) {
                    a2.a("{0}, ", g2.c(i2));
                    continue;
                }
                a2.a(g2.c(i2));
                a2.a('}');
            }
            string = a2.toString();
        } else if (this.getValue() != null) {
            string = this.getValue().toString();
        }
        return aY.a("Tag: ", Enum.getName(TiffTags.class, this.getTagId()), " Type: ", Enum.getName(TiffDataTypes.class, this.getTagType()), " Count: ", bj.b(this.getCount()), " Value: ", string);
    }

    protected abstract void readData(TiffStreamReader var1, long var2, long var4);

    protected abstract void writeTagValueOrOffset(TiffStreamWriter var1, long var2);

    protected void copyInstanceData(TiffDataType clonedType) {
        clonedType.a = this.a;
    }

    protected abstract TiffDataType createInstance();
}

