/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.fileformats.tiff;

import com.aspose.imaging.Color;
import com.aspose.imaging.IAdvancedBufferProcessor;
import com.aspose.imaging.IPartialArgb32PixelLoader;
import com.aspose.imaging.IRasterImageArgb32PixelLoader;
import com.aspose.imaging.Point;
import com.aspose.imaging.RasterCachedImage;
import com.aspose.imaging.RasterImage;
import com.aspose.imaging.Rectangle;
import com.aspose.imaging.StreamContainer;
import com.aspose.imaging.coreexceptions.FrameworkException;
import com.aspose.imaging.exif.ExifData;
import com.aspose.imaging.fileformats.jpeg.JpegImage;
import com.aspose.imaging.fileformats.tiff.TiffDataType;
import com.aspose.imaging.fileformats.tiff.TiffImage;
import com.aspose.imaging.fileformats.tiff.TiffRational;
import com.aspose.imaging.fileformats.tiff.filemanagement.TiffStreamFactory;
import com.aspose.imaging.fileformats.tiff.filemanagement.TiffStreamWriter;
import com.aspose.imaging.fileformats.tiff.tifftagtypes.TiffCommonArrayType;
import com.aspose.imaging.fileformats.tiff.tifftagtypes.TiffLongType;
import com.aspose.imaging.fileformats.tiff.tifftagtypes.TiffSShortType;
import com.aspose.imaging.fileformats.tiff.tifftagtypes.TiffShortType;
import com.aspose.imaging.fileformats.tiff.tifftagtypes.TiffUndefinedType;
import com.aspose.imaging.imageoptions.TiffOptions;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.be.m;
import com.aspose.imaging.internal.dP.aD;
import com.aspose.imaging.internal.dP.aM;
import com.aspose.imaging.internal.dP.az;
import com.aspose.imaging.internal.dP.bh;
import com.aspose.imaging.internal.dP.bj;
import com.aspose.imaging.internal.dP.f;
import com.aspose.imaging.internal.gS.r;
import com.aspose.imaging.system.collections.Generic.Dictionary;
import com.aspose.imaging.system.collections.Generic.List;
import com.aspose.imaging.system.io.MemoryStream;
import com.aspose.imaging.system.io.Stream;
import com.aspose.imaging.xmp.XmpPacketWrapper;
import java.io.InputStream;

public final class TiffFrame
extends RasterCachedImage {
    private TiffOptions e;
    private int f;
    private int g;
    private ExifData h;
    private XmpPacketWrapper i;

    public TiffFrame(InputStream stream) {
        this(Stream.fromJava(stream), new TiffOptions(0));
    }

    public static TiffFrame f(Stream stream) {
        return new TiffFrame(stream, new TiffOptions(0));
    }

    public TiffFrame(InputStream stream, TiffOptions options) {
        this(Stream.fromJava(stream), options);
    }

    TiffFrame(Stream stream, TiffOptions options) {
        if (options == null) {
            throw new ArgumentNullException("options");
        }
        this.a(new aM(stream), options);
    }

    public TiffFrame(String path) {
        this(path, new TiffOptions(0));
    }

    public TiffFrame(String path, TiffOptions options) {
        if (options == null) {
            throw new ArgumentNullException("options");
        }
        this.a(new aM(path), options);
    }

    public TiffFrame(RasterImage image) {
        this(image, new TiffOptions(0));
    }

    public TiffFrame(RasterImage image, TiffOptions options) {
        if (options == null) {
            throw new ArgumentNullException("options");
        }
        this.a(new aM(image), options);
    }

    public TiffFrame(TiffOptions options, int width, int height) {
        if (options == null) {
            throw new ArgumentNullException("options");
        }
        this.e = options;
        this.g = width;
        this.f = height;
    }

    private TiffFrame(TiffOptions options, int width, int height, IRasterImageArgb32PixelLoader dataReader) {
        if (options == null) {
            throw new ArgumentNullException("options");
        }
        this.e = options;
        this.g = width;
        this.f = height;
        if (dataReader != null) {
            this.setDataLoader(dataReader);
        }
    }

    @Override
    public Color getBackgroundColor() {
        return this.getFrameOptions().a();
    }

    @Override
    public void setBackgroundColor(Color value) {
        this.getFrameOptions().a(value.Clone());
    }

    @Override
    public boolean hasAlpha() {
        return this.getFrameOptions().isExtraSamplesPresent() && this.getFrameOptions().getAlphaStorage() == 1;
    }

    @Override
    public boolean hasTransparentColor() {
        return this.getFrameOptions().isExtraSamplesPresent() && this.getFrameOptions().getAlphaStorage() == 1;
    }

    @Override
    public void setTransparentColor(boolean value) {
    }

    @Override
    public XmpPacketWrapper getXmpData() {
        return this.i;
    }

    @Override
    public void setXmpData(XmpPacketWrapper value) {
        this.i = value;
    }

    @Override
    public int getBitsPerPixel() {
        this.verifyNotDisposed();
        return this.getFrameOptions().getBitsPerPixel();
    }

    public TiffOptions getFrameOptions() {
        this.verifyNotDisposed();
        return this.e;
    }

    @Override
    public int getHeight() {
        return this.f;
    }

    @Override
    public int getWidth() {
        return this.g;
    }

    public ExifData getExifData() {
        return this.h;
    }

    public void setExifData(ExifData value) {
        this.h = value;
    }

    @Override
    public double getHorizontalResolution() {
        TiffRational tiffRational = null;
        if (this.e != null) {
            tiffRational = this.e.getYresolution();
        }
        if (tiffRational != null) {
            return tiffRational.getValueD();
        }
        return super.getHorizontalResolution();
    }

    @Override
    public void setHorizontalResolution(double value) {
        if (this.e != null) {
            this.e.setXresolution(TiffRational.approximateFraction(value));
        } else {
            super.setHorizontalResolution(value);
        }
    }

    @Override
    public double getVerticalResolution() {
        TiffRational tiffRational = null;
        if (this.e != null) {
            tiffRational = this.e.getYresolution();
        }
        if (tiffRational != null) {
            return tiffRational.getValueD();
        }
        return super.getVerticalResolution();
    }

    @Override
    public void setVerticalResolution(double value) {
        if (this.e != null) {
            this.e.setYresolution(TiffRational.approximateFraction(value));
        } else {
            super.setVerticalResolution(value);
        }
    }

    public void alignResolutions() {
        TiffFrame tiffFrame = this;
        TiffDataType tiffDataType = tiffFrame.getFrameOptions().getTagByType(282);
        TiffDataType tiffDataType2 = tiffFrame.getFrameOptions().getTagByType(283);
        if (tiffDataType != null && tiffDataType2 != null) {
            TiffRational tiffRational = com.aspose.imaging.internal.dO.d.c(tiffDataType.getValue(), TiffRational[].class)[0];
            TiffRational tiffRational2 = com.aspose.imaging.internal.dO.d.c(tiffDataType2.getValue(), TiffRational[].class)[0];
            if (com.aspose.imaging.internal.dO.d.f((Object)tiffRational.getNominator(), 10) != com.aspose.imaging.internal.dO.d.f((Object)tiffRational2.getNominator(), 10) || com.aspose.imaging.internal.dO.d.f((Object)tiffRational.getDenominator(), 10) != com.aspose.imaging.internal.dO.d.f((Object)tiffRational2.getDenominator(), 10)) {
                if (tiffRational.getValue() > tiffRational2.getValue()) {
                    double d2 = tiffRational.getValueD() / tiffRational2.getValueD();
                    int n2 = tiffFrame.getWidth();
                    int n3 = com.aspose.imaging.internal.dO.d.e((Object)((double)tiffFrame.getHeight() * d2), 14);
                    tiffFrame.resize(n2, n3, 6);
                } else {
                    double d3 = tiffRational2.getValueD() / tiffRational.getValueD();
                    int n4 = com.aspose.imaging.internal.dO.d.e((Object)((double)tiffFrame.getWidth() * d3), 14);
                    int n5 = tiffFrame.getHeight();
                    tiffFrame.resize(n4, n5, 6);
                }
            }
        }
    }

    public static TiffFrame copyFrame(TiffFrame tiffFrame) {
        if (tiffFrame == null) {
            throw new ArgumentNullException("tiffFrame");
        }
        TiffOptions tiffOptions = new TiffOptions(tiffFrame.e);
        TiffFrame tiffFrame2 = new TiffFrame(tiffOptions, tiffFrame.g, tiffFrame.f);
        if (tiffFrame.getDataLoader() != null) {
            tiffFrame2.setDataLoader(tiffFrame.getDataLoader());
        } else {
            tiffFrame.loadPartialArgb32Pixels(tiffFrame.getBounds().Clone(), new aD(tiffFrame2));
        }
        return tiffFrame2;
    }

    public static TiffFrame createFrameFrom(TiffFrame tiffFrame, TiffOptions options) {
        if (tiffFrame == null) {
            throw new ArgumentNullException("tiffFrame");
        }
        if (options == null) {
            throw new ArgumentNullException("options");
        }
        TiffFrame tiffFrame2 = new TiffFrame(options, tiffFrame.g, tiffFrame.f);
        tiffFrame.loadPartialArgb32Pixels(tiffFrame.getBounds().Clone(), new aD(tiffFrame2));
        return tiffFrame2;
    }

    public void h() {
        com.aspose.imaging.internal.fV.d d2 = (com.aspose.imaging.internal.fV.d)((Object)com.aspose.imaging.internal.dO.d.a(this.getDataLoader(), com.aspose.imaging.internal.fV.d.class));
        if (d2 != null) {
            d2.a(new TiffOptions(this.getFrameOptions()));
        }
    }

    public static TiffFrame a(TiffOptions tiffOptions, int n2, int n3, IRasterImageArgb32PixelLoader iRasterImageArgb32PixelLoader) {
        return new TiffFrame(tiffOptions, n2, n3, iRasterImageArgb32PixelLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void a(RasterImage rasterImage, TiffStreamWriter tiffStreamWriter, boolean bl2, TiffOptions tiffDataTypeArray, ExifData exifData, XmpPacketWrapper xmpPacketWrapper, Rectangle rectangle) {
        TiffDataType[] tiffDataTypeArray2 = tiffDataTypeArray;
        synchronized (tiffDataTypeArray) {
            Object object;
            Object object2;
            Object object3;
            TiffCommonArrayType tiffCommonArrayType;
            TiffCommonArrayType tiffCommonArrayType2;
            tiffDataTypeArray.validate();
            if (rectangle.isEmpty()) {
                rasterImage.getBounds().CloneTo(rectangle);
            }
            tiffDataTypeArray.setImageWidth(com.aspose.imaging.internal.dO.d.f((Object)rectangle.getWidth(), 9));
            tiffDataTypeArray.setImageLength(com.aspose.imaging.internal.dO.d.f((Object)rectangle.getHeight(), 9));
            if (tiffDataTypeArray.getCompression() == 7) {
                tiffDataTypeArray.setRowsPerStrip(com.aspose.imaging.internal.dO.d.f((Object)rectangle.getHeight(), 9));
                tiffCommonArrayType2 = new TiffSShortType(530);
                ((TiffSShortType)tiffCommonArrayType2).setValues(new short[]{2, 2});
                tiffCommonArrayType = new TiffShortType(284);
                ((TiffShortType)tiffCommonArrayType).setValues(new int[]{1});
                tiffDataTypeArray.addTag(tiffCommonArrayType2);
                tiffDataTypeArray.addTag(tiffCommonArrayType);
            }
            if (tiffDataTypeArray.getCompression() == 6) {
                tiffDataTypeArray.setRowsPerStrip(com.aspose.imaging.internal.dO.d.f((Object)rectangle.getHeight(), 9));
                tiffCommonArrayType2 = new TiffLongType(513);
                ((TiffLongType)tiffCommonArrayType2).setValues(new long[]{0L});
                tiffDataTypeArray.addTag(tiffCommonArrayType2);
                tiffCommonArrayType = new TiffLongType(514);
                ((TiffLongType)tiffCommonArrayType).setValues(new long[]{0L});
                tiffDataTypeArray.addTag(tiffCommonArrayType);
            }
            if (tiffDataTypeArray.getPhotometric() == 6 && !tiffDataTypeArray.isTagPresent(530)) {
                tiffDataTypeArray.setYCbCrSubsampling(new int[]{2, 2});
            }
            tiffDataTypeArray.setStripByteCounts(new long[]{0L});
            tiffDataTypeArray.setStripOffsets(new long[]{0L});
            if (!tiffDataTypeArray.isTagPresent(278)) {
                tiffDataTypeArray.setRowsPerStrip(0xFFFFFFFFL);
            }
            // ** MonitorExit[var7_7] (shouldn't be in output)
            tiffDataTypeArray2 = null;
            tiffCommonArrayType2 = null;
            if (exifData != null) {
                tiffDataTypeArray2 = exifData.getExifTags();
                tiffCommonArrayType2 = exifData.getGPSTags();
            }
            tiffCommonArrayType = null;
            if (xmpPacketWrapper != null) {
                object3 = new TiffUndefinedType(700);
                String string = xmpPacketWrapper.b();
                byte[] byArray = m.y().c(string);
                ((TiffUndefinedType)object3).setData(byArray);
                tiffCommonArrayType = new TiffDataType[]{object3};
            }
            object3 = new com.aspose.imaging.internal.fV.f(tiffDataTypeArray.getTags(), tiffDataTypeArray2, (TiffDataType[])tiffCommonArrayType2, (TiffDataType[])tiffCommonArrayType);
            long l2 = tiffStreamWriter.getPosition();
            long l3 = ((com.aspose.imaging.internal.fV.f)object3).b();
            a a2 = TiffFrame.a((TiffOptions)tiffDataTypeArray, com.aspose.imaging.internal.dO.d.f((Object)(l2 + l3), 11), tiffStreamWriter, rectangle.getWidth(), rectangle.getHeight());
            Rectangle rectangle2 = Rectangle.intersect(rectangle.Clone(), rasterImage.getBounds().Clone()).Clone();
            TiffDataType[] tiffDataTypeArray3 = new az(rasterImage.getBounds().Clone(), rectangle.Clone(), a2, true);
            if (rectangle2.getWidth() > 0 && rectangle2.getHeight() > 0) {
                object2 = tiffDataTypeArray3;
                if (rasterImage.hasTransparentColor()) {
                    object = new bj(rasterImage.getTransparentColor().toArgb(), rasterImage.getBackgroundColor().toArgb(), (IPartialArgb32PixelLoader)object2);
                    object2 = object;
                }
                if (rasterImage.hasAlpha()) {
                    object = new f(Color.getWhite().toArgb(), (IPartialArgb32PixelLoader)object2);
                    object2 = object;
                }
                rasterImage.loadPartialArgb32Pixels(rectangle2.Clone(), (IPartialArgb32PixelLoader)object2);
            }
            tiffDataTypeArray3.a();
            object2 = tiffDataTypeArray;
            synchronized (tiffDataTypeArray) {
                tiffDataTypeArray.setStripByteCounts(a2.b());
                tiffDataTypeArray.setStripOffsets(a2.a());
                tiffDataTypeArray.setRowsPerStrip(a2.c().c());
                object = new List();
                ((List)object).addItem(tiffDataTypeArray.getTagByType(278));
                ((List)object).addItem(tiffDataTypeArray.getTagByType(279));
                ((List)object).addItem(tiffDataTypeArray.getTagByType(273));
                if (tiffDataTypeArray.getCompression() == 6) {
                    TiffLongType tiffLongType;
                    long l4 = com.aspose.imaging.internal.dO.d.f((Object)(l2 + l3), 11);
                    TiffLongType tiffLongType2 = (TiffLongType)((Object)com.aspose.imaging.internal.dO.d.a(tiffDataTypeArray.getTagByType(513), TiffLongType.class));
                    if (tiffLongType2 != null && tiffLongType2.getValues() != null) {
                        tiffLongType2.getValues()[0] = l4;
                    }
                    if ((tiffLongType = (TiffLongType)((Object)com.aspose.imaging.internal.dO.d.a(tiffDataTypeArray.getTagByType(514), TiffLongType.class))) != null && tiffLongType.getValues() != null) {
                        tiffLongType.getValues()[0] = com.aspose.imaging.internal.dO.d.f((Object)(com.aspose.imaging.internal.dO.d.f((Object)(com.aspose.imaging.internal.dO.d.f((Object)tiffDataTypeArray.getStripOffsets()[0], 10) - com.aspose.imaging.internal.dO.d.f((Object)l4, 10)), 10) + com.aspose.imaging.internal.dO.d.f((Object)tiffDataTypeArray.getStripByteCounts()[0], 10)), 10);
                    }
                    ((List)object).addItem(tiffLongType2);
                    ((List)object).addItem(tiffLongType);
                }
                ((com.aspose.imaging.internal.fV.f)object3).a(((List)object).toArray(new TiffDataType[0]));
                // ** MonitorExit[var20_19 /* !! */ ] (shouldn't be in output)
                long l5 = a2.c().d();
                Object object4 = tiffStreamWriter.getSyncRoot();
                synchronized (object4) {
                    tiffStreamWriter.setPosition(l2);
                    ((com.aspose.imaging.internal.fV.f)object3).a(tiffStreamWriter, com.aspose.imaging.internal.dO.d.g(l5, 10), bl2);
                }
                return;
            }
        }
    }

    @Override
    protected void releaseManagedResources() {
        this.e = null;
        super.releaseManagedResources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void saveData(Stream stream) {
        this.verifyNotDisposed();
        int n2 = 18761;
        if (com.aspose.imaging.internal.dO.d.b((Object)this.getContainer(), TiffImage.class)) {
            n2 = ((TiffImage)((Object)com.aspose.imaging.internal.dO.d.a(this.getContainer(), TiffImage.class))).getByteOrder();
        }
        StreamContainer streamContainer = new StreamContainer(stream);
        try {
            TiffStreamWriter tiffStreamWriter = TiffStreamFactory.getTiffWriter(streamContainer, n2);
            TiffFrame.a(this, tiffStreamWriter, true, this.e, this.h, this.getXmpData(), this.getBounds().Clone());
        }
        finally {
            if (streamContainer != null) {
                streamContainer.dispose();
            }
        }
    }

    @Override
    protected void updateDimensions(int newWidth, int newHeight) {
        this.g = newWidth;
        this.f = newHeight;
    }

    private void a(aM aM2, TiffOptions tiffOptions) {
        this.setDataLoader(aM2);
        this.e = tiffOptions;
        this.g = aM2.a().getWidth();
        this.f = aM2.a().getHeight();
        this.setPalette(aM2.a().getPalette());
        TiffImage tiffImage = (TiffImage)((Object)com.aspose.imaging.internal.dO.d.a(aM2.a(), TiffImage.class));
        if (tiffImage != null) {
            this.setExifData(tiffImage.getExifData());
            this.setXmpData(tiffImage.getXmpData());
        }
    }

    private static a a(TiffOptions tiffOptions, long l2, TiffStreamWriter tiffStreamWriter, int n2, int n3) {
        a a2;
        switch (tiffOptions.getCompression()) {
            case 6: {
                a2 = new c(tiffOptions, l2, tiffStreamWriter, n2, n3);
                break;
            }
            default: {
                a2 = new a(tiffOptions, l2, tiffStreamWriter, n2, n3);
            }
        }
        return a2;
    }

    private static class c
    extends a {
        private boolean a = false;
        private int b = -1;
        private static final int c = -1;

        public c(TiffOptions tiffOptions, long l2, TiffStreamWriter tiffStreamWriter, int n2, int n3) {
            super(tiffOptions, l2, tiffStreamWriter, n2, n3);
        }

        @Override
        public long[] a() {
            long[] lArray = new long[this.c().a().length];
            System.arraycopy(this.c().a(), 0, lArray, 0, lArray.length);
            lArray[0] = com.aspose.imaging.internal.dO.d.f((Object)(com.aspose.imaging.internal.dO.d.f((Object)lArray[0], 10) + com.aspose.imaging.internal.dO.d.f((Object)com.aspose.imaging.internal.dO.d.f((Object)this.d(), 9), 10)), 10);
            return lArray;
        }

        @Override
        public long[] b() {
            long[] lArray = new long[this.c().b().length];
            System.arraycopy(this.c().b(), 0, lArray, 0, lArray.length);
            lArray[0] = com.aspose.imaging.internal.dO.d.f((Object)(com.aspose.imaging.internal.dO.d.f((Object)lArray[0], 10) - com.aspose.imaging.internal.dO.d.f((Object)com.aspose.imaging.internal.dO.d.f((Object)this.d(), 9), 10)), 10);
            return lArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int d() {
            block11: {
                if (!this.a) {
                    try {
                        Object object;
                        d d2 = (d)((Object)com.aspose.imaging.internal.dO.d.a(this.c(), d.class));
                        if (d2 == null) break block11;
                        r r2 = new r();
                        d2.e().setPosition(0L);
                        StreamContainer streamContainer = null;
                        try {
                            streamContainer = new StreamContainer(d2.e());
                            object = (JpegImage)r2.load(streamContainer, null);
                            try {
                                Dictionary<Byte, List<Integer>> dictionary = r2.a();
                                List<Integer> list = r.a((byte)-38, dictionary);
                                if (list != null && list.size() != 0) {
                                    this.b = list.get_Item(0);
                                    this.a = true;
                                }
                            }
                            finally {
                                if (object != null) {
                                    object.dispose();
                                }
                            }
                        }
                        finally {
                            object = (bh)bh.a();
                            ((bh)object).a(streamContainer);
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw new FrameworkException("Failed to load JPEG image with old-style compression", runtimeException);
                    }
                }
            }
            return this.b;
        }
    }

    private static class a
    implements IPartialArgb32PixelLoader {
        private final b a;
        private final com.aspose.imaging.internal.fV.c b;

        public a(TiffOptions tiffOptions, long l2, TiffStreamWriter tiffStreamWriter, int n2, int n3) {
            this.b = com.aspose.imaging.fileformats.tiff.a.a(tiffOptions, n2, n3);
            long l3 = tiffOptions.getRowsPerStrip();
            this.a = com.aspose.imaging.fileformats.tiff.TiffFrame$b.a(tiffOptions, tiffStreamWriter, l2, com.aspose.imaging.internal.dO.d.f((Object)this.b.c(), 9), l3, this.b.d().getFillOrder() == 2);
        }

        public long[] a() {
            return this.a.a();
        }

        public long[] b() {
            return this.a.b();
        }

        public b c() {
            return this.a;
        }

        @Override
        public void process(Rectangle pixelsRectangle, int[] pixels, Point start, Point end) {
            try {
                this.b.a(pixels, pixelsRectangle.Clone(), this.a);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw new FrameworkException("Fatal error", outOfMemoryError);
            }
        }
    }

    private static class d
    extends b
    implements IAdvancedBufferProcessor {
        private final MemoryStream a = new MemoryStream();

        public d(TiffOptions tiffOptions, TiffStreamWriter tiffStreamWriter, long l2, long l3, long l4, boolean bl2) {
            super(tiffOptions, tiffStreamWriter, l2, l3, l4, bl2);
        }

        public Stream e() {
            return this.a;
        }

        @Override
        public void processBuffer(byte[] buffer, int bufferLength) {
            super.processBuffer(buffer, bufferLength);
            this.a.write(buffer, 0, bufferLength);
        }
    }

    private static class b
    implements IAdvancedBufferProcessor {
        private final TiffStreamWriter a;
        private final long b;
        private final long[] c;
        private final long[] d;
        private final long e;
        private final boolean f;
        private long g;
        private long h;
        private long i;
        private long j;

        public b(TiffOptions tiffOptions, TiffStreamWriter tiffStreamWriter, long l2, long l3, long l4, boolean bl2) {
            this.f = bl2;
            this.a = tiffStreamWriter;
            this.g = l2;
            if (com.aspose.imaging.internal.dO.d.f((Object)l4, 10) == 0L) {
                l4 = l3;
            }
            this.b = l4;
            long l5 = com.aspose.imaging.internal.dO.d.f((Object)(com.aspose.imaging.internal.dO.d.f((Object)l3, 10) / com.aspose.imaging.internal.dO.d.f((Object)l4, 10)), 10);
            if (com.aspose.imaging.internal.dO.d.f((Object)(com.aspose.imaging.internal.dO.d.f((Object)l3, 10) % com.aspose.imaging.internal.dO.d.f((Object)l4, 10)), 10) != 0L) {
                ++l5;
            }
            l5 = tiffOptions.getPlanarConfiguration() == 1 ? l5 : com.aspose.imaging.internal.dO.d.f((Object)(com.aspose.imaging.internal.dO.d.f((Object)l5, 10) * com.aspose.imaging.internal.dO.d.f((Object)tiffOptions.getSamplesPerPixel(), 8)), 10);
            this.c = new long[(int)com.aspose.imaging.internal.dO.d.f((Object)l5, 10)];
            this.d = new long[(int)com.aspose.imaging.internal.dO.d.f((Object)l5, 10)];
            this.c[0] = l2;
            this.e = l3;
        }

        public long[] a() {
            return this.c;
        }

        public long[] b() {
            return this.d;
        }

        public long c() {
            return this.b;
        }

        public long d() {
            return this.g;
        }

        public static b a(TiffOptions tiffOptions, TiffStreamWriter tiffStreamWriter, long l2, long l3, long l4, boolean bl2) {
            b b2;
            switch (tiffOptions.getCompression()) {
                case 6: {
                    b2 = new d(tiffOptions, tiffStreamWriter, l2, l3, l4, bl2);
                    break;
                }
                default: {
                    b2 = new b(tiffOptions, tiffStreamWriter, l2, l3, l4, bl2);
                }
            }
            return b2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processBuffer(byte[] buffer, int bufferLength) {
            if (this.f) {
                com.aspose.imaging.internal.fV.a.a(buffer, 0, bufferLength);
            }
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                this.a.setPosition(com.aspose.imaging.internal.dO.d.g(this.g, 10));
                this.a.write(buffer, 0, bufferLength);
            }
            this.g = com.aspose.imaging.internal.dO.d.f((Object)(com.aspose.imaging.internal.dO.d.f((Object)this.g, 10) + com.aspose.imaging.internal.dO.d.f((Object)com.aspose.imaging.internal.dO.d.f((Object)bufferLength, 9), 10)), 10);
            this.j = com.aspose.imaging.internal.dO.d.f((Object)(com.aspose.imaging.internal.dO.d.f((Object)this.j, 10) + com.aspose.imaging.internal.dO.d.f((Object)com.aspose.imaging.internal.dO.d.f((Object)bufferLength, 9), 10)), 10);
        }

        @Override
        public void finishRow() {
            ++this.h;
            if (com.aspose.imaging.internal.dO.d.f((Object)(com.aspose.imaging.internal.dO.d.f((Object)this.h, 10) % com.aspose.imaging.internal.dO.d.f((Object)this.b, 10)), 10) == 0L || com.aspose.imaging.internal.dO.d.f((Object)(com.aspose.imaging.internal.dO.d.f((Object)this.h, 10) % com.aspose.imaging.internal.dO.d.f((Object)this.e, 10)), 10) == 0L) {
                this.d[(int)this.i++] = this.j;
                if (com.aspose.imaging.internal.dO.d.f((Object)this.i, 10) < (long)this.c.length) {
                    this.c[(int)this.i] = this.g;
                }
                this.j = 0L;
            }
        }

        @Override
        public void finishRows(int rowsCount) {
            this.h = com.aspose.imaging.internal.dO.d.f((Object)(com.aspose.imaging.internal.dO.d.f((Object)this.h, 10) + com.aspose.imaging.internal.dO.d.f((Object)com.aspose.imaging.internal.dO.d.f((Object)rowsCount, 9), 10)), 10);
            if (com.aspose.imaging.internal.dO.d.f((Object)(com.aspose.imaging.internal.dO.d.f((Object)this.h, 10) % com.aspose.imaging.internal.dO.d.f((Object)this.b, 10)), 10) == 0L || com.aspose.imaging.internal.dO.d.f((Object)(com.aspose.imaging.internal.dO.d.f((Object)this.h, 10) % com.aspose.imaging.internal.dO.d.f((Object)this.e, 10)), 10) == 0L) {
                this.d[(int)this.i++] = this.j;
                if (com.aspose.imaging.internal.dO.d.f((Object)this.i, 10) < (long)this.c.length) {
                    this.c[(int)this.i] = this.g;
                }
                this.j = 0L;
            }
        }
    }
}

