/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.fileformats.tiff;

import com.aspose.imaging.Color;
import com.aspose.imaging.IColorPalette;
import com.aspose.imaging.IPartialArgb32PixelLoader;
import com.aspose.imaging.IPartialRawDataLoader;
import com.aspose.imaging.IRasterImageArgb32PixelLoader;
import com.aspose.imaging.ImageResizeSettings;
import com.aspose.imaging.RasterImage;
import com.aspose.imaging.RawDataSettings;
import com.aspose.imaging.Rectangle;
import com.aspose.imaging.StreamContainer;
import com.aspose.imaging.coreexceptions.ImageException;
import com.aspose.imaging.coreexceptions.imageformats.TiffImageException;
import com.aspose.imaging.exif.ExifData;
import com.aspose.imaging.fileformats.tiff.TiffFrame;
import com.aspose.imaging.fileformats.tiff.TiffRational;
import com.aspose.imaging.fileformats.tiff.filemanagement.TiffStreamFactory;
import com.aspose.imaging.fileformats.tiff.filemanagement.TiffStreamWriter;
import com.aspose.imaging.imagefilters.filteroptions.FilterOptionsBase;
import com.aspose.imaging.internal.Exceptions.ArgumentException;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.ap.K;
import com.aspose.imaging.internal.ap.aY;
import com.aspose.imaging.internal.ap.at;
import com.aspose.imaging.internal.ap.ay;
import com.aspose.imaging.internal.ap.g;
import com.aspose.imaging.internal.dO.d;
import com.aspose.imaging.internal.fV.f;
import com.aspose.imaging.system.collections.Generic.IGenericEnumerator;
import com.aspose.imaging.system.collections.Generic.List;
import com.aspose.imaging.system.io.Stream;
import com.aspose.imaging.xmp.XmpPacketWrapper;

public final class TiffImage
extends RasterImage {
    private final List<TiffFrame> e = new List();
    private int f = 18761;
    private TiffFrame g;

    public TiffImage(TiffFrame frame) {
        if (frame == null) {
            throw new ArgumentNullException("frame");
        }
        this.addFrame(frame);
        this.f = frame.getFrameOptions().getByteOrder();
        this.setActiveFrame(frame);
        this.setDataLoader(new a(this));
    }

    public TiffImage(TiffFrame[] frames) {
        if (frames == null) {
            throw new ArgumentNullException("frames");
        }
        if (frames.length > 0) {
            this.addFrames(frames);
            this.setActiveFrame(frames[0]);
            this.f = this.getActiveFrame().getFrameOptions().getByteOrder();
        }
        this.setDataLoader(new a(this));
    }

    @Override
    public boolean hasAlpha() {
        return this.getActiveFrame().hasAlpha();
    }

    @Override
    public boolean hasTransparentColor() {
        return this.getActiveFrame().hasTransparentColor();
    }

    @Override
    public void setTransparentColor(boolean value) {
    }

    @Override
    public boolean getPremultiplyComponents() {
        return this.getActiveFrame().getFrameOptions().getPremultiplyComponents();
    }

    @Override
    public void setPremultiplyComponents(boolean value) {
        this.getActiveFrame().getFrameOptions().setPremultiplyComponents(value);
        this.getActiveFrame().h();
    }

    public int getByteOrder() {
        this.verifyNotDisposed();
        return this.f;
    }

    public void setByteOrder(int value) {
        this.verifyNotDisposed();
        this.f = value;
    }

    @Override
    public double getHorizontalResolution() {
        if (this.getActiveFrame().getFrameOptions().getXresolution() == null) {
            return super.getHorizontalResolution();
        }
        return this.getActiveFrame().getFrameOptions().getXresolution().getValue();
    }

    @Override
    public void setHorizontalResolution(double value) {
        if (this.getActiveFrame().getFrameOptions().getYresolution() == null) {
            this.setResolution(value, super.getVerticalResolution());
        } else {
            this.setResolution(value, this.getActiveFrame().getFrameOptions().getYresolution().getValue());
        }
    }

    @Override
    public double getVerticalResolution() {
        if (this.getActiveFrame().getFrameOptions().getYresolution() == null) {
            return super.getVerticalResolution();
        }
        return this.getActiveFrame().getFrameOptions().getYresolution().getValue();
    }

    @Override
    public void setVerticalResolution(double value) {
        if (this.getActiveFrame().getFrameOptions().getXresolution() == null) {
            this.setResolution(super.getHorizontalResolution(), value);
        } else {
            this.setResolution(this.getActiveFrame().getFrameOptions().getXresolution().getValue(), value);
        }
    }

    @Override
    public Color getBackgroundColor() {
        return this.getActiveFrame().getBackgroundColor();
    }

    @Override
    public void setBackgroundColor(Color value) {
        this.getActiveFrame().setBackgroundColor(value.Clone());
    }

    @Override
    public int getBitsPerPixel() {
        this.verifyNotDisposed();
        return this.getActiveFrame().getBitsPerPixel();
    }

    public TiffFrame getActiveFrame() {
        this.verifyNotDisposed();
        if (this.g == null) {
            throw new TiffImageException("There is no active frame selected.");
        }
        return this.g;
    }

    public void setActiveFrame(TiffFrame value) {
        this.verifyNotDisposed();
        if (value != null && value.getContainer() != this) {
            throw new TiffImageException("The active frame cannot be set as it belongs to another image.");
        }
        this.g = value;
    }

    public TiffFrame[] getFrames() {
        this.verifyNotDisposed();
        TiffFrame[] tiffFrameArray = new TiffFrame[this.e.size()];
        this.e.copyToTArray((TiffFrame[])tiffFrameArray, 0);
        return tiffFrameArray;
    }

    @Override
    public int getHeight() {
        this.verifyNotDisposed();
        return this.getActiveFrame().getHeight();
    }

    @Override
    public int getWidth() {
        this.verifyNotDisposed();
        return this.getActiveFrame().getWidth();
    }

    @Override
    public final boolean isCached() {
        TiffFrame[] tiffFrameArray = this.getFrames();
        boolean bl2 = true;
        for (int i2 = 0; i2 < tiffFrameArray.length && (bl2 = tiffFrameArray[i2].isCached()); ++i2) {
        }
        return bl2;
    }

    public ExifData getExifData() {
        return this.g.getExifData();
    }

    public void setExifData(ExifData value) {
        this.g.setExifData(value);
    }

    @Override
    public XmpPacketWrapper getXmpData() {
        return this.g.getXmpData();
    }

    @Override
    public void setXmpData(XmpPacketWrapper value) {
        this.g.setXmpData(value);
    }

    public void alignResolutions() {
        for (TiffFrame tiffFrame : this.getFrames()) {
            tiffFrame.alignResolutions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dither(int ditheringMethod, int bitsCount, IColorPalette customPalette) {
        Object object = this.b;
        synchronized (object) {
            try {
                this.c();
                IGenericEnumerator iGenericEnumerator = this.e.iterator();
                try {
                    while (iGenericEnumerator.hasNext()) {
                        TiffFrame tiffFrame = (TiffFrame)iGenericEnumerator.next();
                        tiffFrame.dither(ditheringMethod, bitsCount, customPalette);
                    }
                }
                finally {
                    if (com.aspose.imaging.internal.dO.d.b((Object)iGenericEnumerator, at.class)) {
                        ((at)iGenericEnumerator).dispose();
                    }
                }
            }
            finally {
                this.d();
            }
        }
    }

    @Override
    public void setResolution(double dpiX, double dpiY) {
        this.getActiveFrame().getFrameOptions().setXresolution(new TiffRational(K.h(dpiX)));
        this.getActiveFrame().getFrameOptions().setYresolution(new TiffRational(K.h(dpiY)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void cacheData() {
        Object object = this.b;
        synchronized (object) {
            try {
                this.c();
                TiffFrame[] tiffFrameArray = this.getFrames();
                for (int i2 = 0; i2 < tiffFrameArray.length; ++i2) {
                    tiffFrameArray[i2].cacheData();
                }
            }
            finally {
                this.d();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rotateFlip(int rotateFlipType) {
        Object object = this.b;
        synchronized (object) {
            try {
                this.c();
                this.getActiveFrame().rotateFlip(rotateFlipType);
            }
            finally {
                this.d();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rotateFlipAll(int rotateFlip) {
        Object object = this.b;
        synchronized (object) {
            try {
                this.c();
                for (TiffFrame tiffFrame : this.getFrames()) {
                    tiffFrame.rotateFlip(rotateFlip);
                }
            }
            finally {
                this.d();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rotate(float angle, boolean resizeProportionally, Color backgroundColor) {
        Object object = this.b;
        synchronized (object) {
            try {
                this.c();
                for (TiffFrame tiffFrame : this.getFrames()) {
                    tiffFrame.rotate(angle, resizeProportionally, backgroundColor.Clone());
                }
            }
            finally {
                this.d();
            }
        }
    }

    public void addFrame(TiffFrame frame) {
        this.verifyNotDisposed();
        if (frame.getContainer() != null && frame.getContainer() != this) {
            throw new TiffImageException("Frame belongs to other image");
        }
        frame.a(this);
        this.e.addItem(frame);
    }

    public void add(TiffImage image) {
        int n2 = image.e.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            TiffFrame tiffFrame = image.e.get_Item(i2);
            if (tiffFrame == null) continue;
            TiffFrame tiffFrame2 = TiffFrame.copyFrame(tiffFrame);
            this.addFrame(tiffFrame2);
        }
    }

    public void addFrames(TiffFrame[] frames) {
        this.verifyNotDisposed();
        if (frames == null) {
            throw new TiffImageException("Frames parameter is null");
        }
        for (int i2 = 0; i2 < frames.length; ++i2) {
            if (frames[i2] == null) {
                throw new TiffImageException("Frame is null or not TiffFrame type");
            }
            if (frames[i2].getContainer() == this || frames[i2].getContainer() == null) continue;
            throw new TiffImageException("Frame belongs to other image");
        }
        for (TiffFrame tiffFrame : frames) {
            tiffFrame.a(this);
        }
        this.e.addRange(com.aspose.imaging.internal.ap.g.a(frames));
    }

    public void insertFrame(int index, TiffFrame frameToInsert) {
        this.verifyNotDisposed();
        if (frameToInsert == null) {
            throw new TiffImageException("Frame Is NULL");
        }
        if (frameToInsert.getContainer() != this && frameToInsert.getContainer() != null) {
            throw new TiffImageException("Frame belongs to other image");
        }
        if (this.e.size() <= index || index < 0) {
            throw new TiffImageException("Invalid index or Frame is null");
        }
        this.e.insertItem(index, frameToInsert);
    }

    public TiffFrame removeFrame(int index) {
        TiffFrame tiffFrame;
        this.verifyNotDisposed();
        if (index >= 0 && index < this.e.size()) {
            tiffFrame = this.e.get_Item(index);
            if (this.getActiveFrame() == tiffFrame) {
                throw new TiffImageException("Unable to remove current frame");
            }
            if (this.e.size() <= 1) {
                throw new TiffImageException("Unable to remove last frame");
            }
        } else {
            throw new TiffImageException("Invalid index");
        }
        this.e.removeAt(index);
        return tiffFrame;
    }

    public void removeFrame(TiffFrame frame) {
        this.verifyNotDisposed();
        if (frame == null) {
            throw new ArgumentNullException("frame");
        }
        if (frame.getContainer() != this) {
            throw new ArgumentOutOfRangeException("frame", "The frame does not belong to the current TIFF image.");
        }
        if (this.getActiveFrame() == frame) {
            throw new TiffImageException("Unable to remove current frame");
        }
        if (this.e.size() <= 1) {
            throw new TiffImageException("Unable to remove last frame");
        }
        this.e.removeItem(frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resize(int newWidth, int newHeight, int resizeType) {
        this.verifyNotDisposed();
        IGenericEnumerator iGenericEnumerator = this.e.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                TiffFrame tiffFrame = (TiffFrame)iGenericEnumerator.next();
                tiffFrame.resize(newWidth, newHeight, resizeType);
            }
        }
        finally {
            if (com.aspose.imaging.internal.dO.d.b((Object)iGenericEnumerator, at.class)) {
                ((at)iGenericEnumerator).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resize(int newWidth, int newHeight, ImageResizeSettings settings) {
        this.verifyNotDisposed();
        IGenericEnumerator iGenericEnumerator = this.e.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                TiffFrame tiffFrame = (TiffFrame)iGenericEnumerator.next();
                tiffFrame.resize(newWidth, newHeight, settings);
            }
        }
        finally {
            if (com.aspose.imaging.internal.dO.d.b((Object)iGenericEnumerator, at.class)) {
                ((at)iGenericEnumerator).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resizeWidthProportionally(int newWidth, int resizeType) {
        this.verifyNotDisposed();
        IGenericEnumerator iGenericEnumerator = this.e.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                TiffFrame tiffFrame = (TiffFrame)iGenericEnumerator.next();
                tiffFrame.resizeWidthProportionally(newWidth, resizeType);
            }
        }
        finally {
            if (com.aspose.imaging.internal.dO.d.b((Object)iGenericEnumerator, at.class)) {
                ((at)iGenericEnumerator).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resizeHeightProportionally(int newHeight, int resizeType) {
        this.verifyNotDisposed();
        IGenericEnumerator iGenericEnumerator = this.e.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                TiffFrame tiffFrame = (TiffFrame)iGenericEnumerator.next();
                tiffFrame.resizeHeightProportionally(newHeight, resizeType);
            }
        }
        finally {
            if (com.aspose.imaging.internal.dO.d.b((Object)iGenericEnumerator, at.class)) {
                ((at)iGenericEnumerator).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resizeProportional(int newWidth, int newHeight, int resizeType) {
        double d2 = (double)newWidth / (double)this.getWidth();
        double d3 = (double)newHeight / (double)this.getHeight();
        IGenericEnumerator iGenericEnumerator = this.e.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                TiffFrame tiffFrame = (TiffFrame)iGenericEnumerator.next();
                int n2 = com.aspose.imaging.internal.dO.d.e((Object)(d2 * (double)tiffFrame.getWidth() + 0.5), 14);
                int n3 = com.aspose.imaging.internal.dO.d.e((Object)(d3 * (double)tiffFrame.getHeight() + 0.5), 14);
                tiffFrame.resize(n2, n3, resizeType);
            }
        }
        finally {
            if (com.aspose.imaging.internal.dO.d.b((Object)iGenericEnumerator, at.class)) {
                ((at)iGenericEnumerator).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void crop(Rectangle rectangle) {
        Object object = this.b;
        synchronized (object) {
            try {
                this.c();
                this.verifyNotDisposed();
                if (rectangle.isEmpty() || rectangle.getX() < 0 || rectangle.getY() < 0 || rectangle.getWidth() < 0 || rectangle.getHeight() < 0) {
                    throw new ArgumentException("Rectangle incorrect.", "rectangle");
                }
                for (int i2 = 0; i2 < this.e.size(); ++i2) {
                    try {
                        this.e.get_Item(i2).crop(rectangle.Clone());
                        continue;
                    }
                    catch (RuntimeException runtimeException) {
                        throw new ImageException(aY.a(new String[]{"Can't crop image. Frame index: ", ay.b(i2)}), runtimeException);
                    }
                }
            }
            finally {
                this.d();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grayscale() {
        Object object = this.b;
        synchronized (object) {
            try {
                this.c();
                this.verifyNotDisposed();
                for (int i2 = 0; i2 < this.e.size(); ++i2) {
                    try {
                        this.e.get_Item(i2).grayscale();
                        continue;
                    }
                    catch (RuntimeException runtimeException) {
                        throw new ImageException(aY.a(new String[]{"Can't make image grayscale. Frame index: ", ay.b(i2)}), runtimeException);
                    }
                }
            }
            finally {
                this.d();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void binarizeFixed(byte threshold) {
        Object object = this.b;
        synchronized (object) {
            try {
                this.c();
                this.verifyNotDisposed();
                for (int i2 = 0; i2 < this.e.size(); ++i2) {
                    try {
                        this.e.get_Item(i2).binarizeFixed(threshold);
                        continue;
                    }
                    catch (RuntimeException runtimeException) {
                        throw new ImageException(aY.a(new String[]{"Can't make image black and white. Frame index: ", ay.b(i2)}), runtimeException);
                    }
                }
            }
            finally {
                this.d();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void binarizeOtsu() {
        Object object = this.b;
        synchronized (object) {
            try {
                this.c();
                this.verifyNotDisposed();
                for (int i2 = 0; i2 < this.e.size(); ++i2) {
                    try {
                        this.e.get_Item(i2).binarizeOtsu();
                        continue;
                    }
                    catch (RuntimeException runtimeException) {
                        throw new ImageException(aY.a(new String[]{"Can't make image black and white. Frame index: ", ay.b(i2)}), runtimeException);
                    }
                }
            }
            finally {
                this.d();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void binarizeBradley(double brightnessDifference) {
        Object object = this.b;
        synchronized (object) {
            try {
                this.c();
                this.verifyNotDisposed();
                for (int i2 = 0; i2 < this.e.size(); ++i2) {
                    try {
                        this.e.get_Item(i2).binarizeBradley(brightnessDifference);
                        continue;
                    }
                    catch (RuntimeException runtimeException) {
                        throw new ImageException(aY.a(new String[]{"Can't make image black and white. Frame index: ", ay.b(i2)}), runtimeException);
                    }
                }
            }
            finally {
                this.d();
            }
        }
    }

    @Override
    public void crop(int leftShift, int rightShift, int topShift, int bottomShift) {
        this.verifyNotDisposed();
        for (int i2 = 0; i2 < this.e.size(); ++i2) {
            try {
                this.e.get_Item(i2).crop(leftShift, rightShift, topShift, bottomShift);
                continue;
            }
            catch (RuntimeException runtimeException) {
                throw new ImageException(aY.a(new String[]{"Can't crop image. Frame index: ", ay.b(i2)}), runtimeException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adjustBrightness(int brightness) {
        Object object = this.b;
        synchronized (object) {
            try {
                this.c();
                this.verifyNotDisposed();
                for (int i2 = 0; i2 < this.e.size(); ++i2) {
                    try {
                        this.e.get_Item(i2).adjustBrightness(brightness);
                        continue;
                    }
                    catch (RuntimeException runtimeException) {
                        throw new ImageException(aY.a(new String[]{"Can't change brightness. Frame index: ", ay.b(i2)}), runtimeException);
                    }
                }
            }
            finally {
                this.d();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adjustContrast(float contrast) {
        Object object = this.b;
        synchronized (object) {
            try {
                this.c();
                this.verifyNotDisposed();
                for (int i2 = 0; i2 < this.e.size(); ++i2) {
                    try {
                        this.e.get_Item(i2).adjustContrast(contrast);
                        continue;
                    }
                    catch (RuntimeException runtimeException) {
                        throw new ImageException(aY.a(new String[]{"Can't change contrast. Frame index: ", ay.b(i2)}), runtimeException);
                    }
                }
            }
            finally {
                this.d();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adjustGamma(float gammaRed, float gammaGreen, float gammaBlue) {
        Object object = this.b;
        synchronized (object) {
            try {
                this.c();
                this.verifyNotDisposed();
                for (int i2 = 0; i2 < this.e.size(); ++i2) {
                    try {
                        this.e.get_Item(i2).adjustGamma(gammaRed, gammaGreen, gammaBlue);
                        continue;
                    }
                    catch (RuntimeException runtimeException) {
                        throw new ImageException(aY.a(new String[]{"Can't change gamma. Frame index: ", ay.b(i2)}), runtimeException);
                    }
                }
            }
            finally {
                this.d();
            }
        }
    }

    @Override
    public void adjustGamma(float gamma) {
        this.adjustGamma(gamma, gamma, gamma);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void filter(Rectangle rectangle, FilterOptionsBase options) {
        Object object = this.b;
        synchronized (object) {
            try {
                this.c();
                for (TiffFrame tiffFrame : this.getFrames()) {
                    tiffFrame.filter(rectangle.Clone(), options);
                }
            }
            finally {
                this.d();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void saveData(Stream stream) {
        this.verifyNotDisposed();
        this.updateMetadata();
        StreamContainer streamContainer = new StreamContainer(stream);
        try {
            TiffStreamWriter tiffStreamWriter = TiffStreamFactory.getTiffWriter(streamContainer, this.f);
            this.a(tiffStreamWriter);
        }
        finally {
            if (streamContainer != null) {
                streamContainer.dispose();
            }
        }
    }

    @Override
    protected void releaseManagedResources() {
        this.verifyNotDisposed();
        IGenericEnumerator iGenericEnumerator = this.e.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                TiffFrame tiffFrame = (TiffFrame)iGenericEnumerator.next();
                tiffFrame.dispose();
            }
        }
        finally {
            if (com.aspose.imaging.internal.dO.d.b((Object)iGenericEnumerator, at.class)) {
                ((at)iGenericEnumerator).dispose();
            }
        }
        this.e.clear();
        this.g = null;
        super.releaseManagedResources();
    }

    @Override
    protected void savePixelsInternal(Rectangle rectangle, int[] pixels) {
        this.verifyNotDisposed();
        this.getActiveFrame().saveArgb32Pixels(rectangle.Clone(), pixels);
    }

    private void a(TiffStreamWriter tiffStreamWriter) {
        this.verifyNotDisposed();
        tiffStreamWriter.setPosition(0L);
        com.aspose.imaging.internal.fV.f.a(tiffStreamWriter);
        for (int i2 = 0; i2 < this.e.size(); ++i2) {
            TiffFrame tiffFrame = this.e.get_Item(i2);
            TiffFrame.a(tiffFrame, tiffStreamWriter, i2 == this.e.size() - 1, tiffFrame.getFrameOptions(), tiffFrame.getExifData(), tiffFrame.getXmpData(), tiffFrame.getBounds().Clone());
        }
    }

    private static class a
    implements IRasterImageArgb32PixelLoader {
        private final TiffImage a;

        public a(TiffImage tiffImage) {
            this.a = tiffImage;
        }

        @Override
        public boolean isRawDataAvailable() {
            return this.a.g.isRawDataAvailable();
        }

        @Override
        public RawDataSettings getRawDataSettings() {
            return this.a.g.getRawDataSettings();
        }

        @Override
        public void loadPartialArgb32Pixels(Rectangle rectangle, IPartialArgb32PixelLoader partialLoader) {
            this.a.verifyNotDisposed();
            this.a.getActiveFrame().loadPartialArgb32Pixels(rectangle.Clone(), partialLoader);
        }

        @Override
        public void loadRawData(Rectangle rectangle, RawDataSettings rawDataSettings, IPartialRawDataLoader rawDataLoader) {
            this.a.verifyNotDisposed();
            this.a.g.loadRawData(rectangle.Clone(), rawDataSettings, rawDataLoader);
        }
    }
}

