/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.fileformats.tiff;

import com.aspose.imaging.internal.ap.aG;
import com.aspose.imaging.internal.ap.aY;
import com.aspose.imaging.internal.ap.ac;
import com.aspose.imaging.internal.ap.bF;
import com.aspose.imaging.internal.ap.bj;
import com.aspose.imaging.internal.dO.d;

public class TiffRational {
    public static final double EPSILON = 1.0E-6;
    private long a;
    private long b;

    public TiffRational() {
    }

    public TiffRational(long value) {
        this.b = value;
        this.a = 1L;
    }

    public TiffRational(long nominator, long denominator) {
        this.b = nominator;
        this.a = denominator;
    }

    public long getDenominator() {
        return this.a;
    }

    public long getNominator() {
        return this.b;
    }

    public float getValue() {
        return (float)this.b / (float)this.a;
    }

    public double getValueD() {
        return (double)this.b / (double)this.a;
    }

    public static TiffRational approximateFraction(double value, double epsilon) {
        long l2 = 1L;
        long l3 = 1L;
        double d2 = (l2 & 0xFFFFFFFFL) / (l3 & 0xFFFFFFFFL);
        while (bF.a(d2 - value) > epsilon) {
            l2 = d2 < value ? ++l2 : (long)bF.d(value * (double)(++l3));
            d2 = (double)l2 / (double)l3;
        }
        return new TiffRational(l2, l3);
    }

    public static TiffRational approximateFraction(double value) {
        return TiffRational.approximateFraction(value, 1.0E-6);
    }

    public static TiffRational approximateFraction(float value, double epsilon) {
        long l2 = 1L;
        long l3 = 1L;
        double d2 = (l2 & 0xFFFFFFFFL) / (l3 & 0xFFFFFFFFL);
        while (bF.a(d2 - (double)value) > epsilon) {
            l2 = d2 < (double)value ? ++l2 : (long)bF.d(value * (float)(++l3));
            d2 = (double)l2 / (double)l3;
        }
        return new TiffRational(l2, l3);
    }

    public static TiffRational approximateFraction(float value) {
        return TiffRational.approximateFraction(value, 1.0E-6);
    }

    public String toString() {
        return aY.a(new Object[]{ac.a(this.getValueD(), "F2"), " (", bj.b(this.b), "/", bj.b(this.a), d.a(Character.valueOf(')'))});
    }

    public static boolean op_Equality(TiffRational rational1, TiffRational rational2) {
        boolean bl2 = !aG.b(rational1, null) && !aG.b(rational2, null) ? (rational1.b & 0xFFFFFFFFL) == (rational2.b & 0xFFFFFFFFL) && (rational1.a & 0xFFFFFFFFL) == (rational2.a & 0xFFFFFFFFL) : aG.b(rational1, null) && aG.b(rational2, null);
        return bl2;
    }

    public static boolean op_Inequality(TiffRational rational1, TiffRational rational2) {
        return !TiffRational.op_Equality(rational1, rational2);
    }

    public boolean equals(Object obj) {
        return TiffRational.op_Equality(this, (TiffRational)((Object)d.a(obj, TiffRational.class)));
    }

    public int hashCode() {
        return (int)(this.b & 0xFFFFFFFFL ^ this.a & 0xFFFFFFFFL);
    }
}

