/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.fileformats.tiff;

import com.aspose.imaging.internal.ap.aG;
import com.aspose.imaging.internal.ap.aY;
import com.aspose.imaging.internal.ap.ac;
import com.aspose.imaging.internal.ap.ay;
import com.aspose.imaging.internal.ap.bF;
import com.aspose.imaging.internal.dO.d;

public class TiffSRational {
    public static final double EPSILON = 1.0E-6;
    private int a = 0;
    private int b = 0;

    public TiffSRational() {
    }

    public TiffSRational(int value) {
        this.b = value;
        this.a = 1;
    }

    public TiffSRational(int nominator, int denominator) {
        this.b = nominator;
        this.a = denominator;
    }

    public int getDenominator() {
        return this.a;
    }

    public int getNominator() {
        return this.b;
    }

    public float getValue() {
        return (float)this.b / (float)this.a;
    }

    public double getValueD() {
        return (double)this.b / (double)this.a;
    }

    public static TiffSRational approximateFraction(double value, double epsilon) {
        int n2 = 1;
        int n3 = 1;
        double d2 = n2 / n3;
        while (bF.a(d2 - value) > epsilon) {
            n2 = d2 < value ? ++n2 : (int)bF.d(value * (double)(++n3));
            d2 = (double)n2 / (double)n3;
        }
        return new TiffSRational(n2, n3);
    }

    public static TiffSRational approximateFraction(double value) {
        return TiffSRational.approximateFraction(value, 1.0E-6);
    }

    public static TiffSRational approximateFraction(float value, double epsilon) {
        int n2 = 1;
        int n3 = 1;
        double d2 = n2 / n3;
        while (bF.a(d2 - (double)value) > epsilon) {
            n2 = d2 < (double)value ? ++n2 : (int)bF.d(value * (float)(++n3));
            d2 = (double)n2 / (double)n3;
        }
        return new TiffSRational(n2, n3);
    }

    public static TiffSRational approximateFraction(float value) {
        return TiffSRational.approximateFraction(value, 1.0E-6);
    }

    public String toString() {
        return aY.a(new Object[]{ac.a(this.getValueD(), "F2"), " (", ay.b(this.b), "/", ay.b(this.a), d.a(Character.valueOf(')'))});
    }

    public static boolean op_Equality(TiffSRational rational1, TiffSRational rational2) {
        boolean bl2 = !aG.b(rational1, null) && !aG.b(rational2, null) ? rational1.b == rational2.b && rational1.a == rational2.a : aG.b(rational1, null) && aG.b(rational2, null);
        return bl2;
    }

    public static boolean op_Inequality(TiffSRational rational1, TiffSRational rational2) {
        return !TiffSRational.op_Equality(rational1, rational2);
    }

    public boolean equals(Object obj) {
        return TiffSRational.op_Equality(this, (TiffSRational)((Object)d.a(obj, TiffSRational.class)));
    }

    public int hashCode() {
        return this.b ^ this.a;
    }
}

